/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import com.ibm.jms.MQObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

public class JMSObjectMessage
extends JMSMessage
implements ObjectMessage {
    static final long serialVersionUID = -9160649637541619341L;
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2001     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/jms/JMSObjectMessage.java, jms, j521, j521-L020126 02/01/25 15:38:11 @(#) 1.7.1.1";
    byte[] messageBytes = null;
    int dataStart;
    boolean readOnly = false;

    public JMSObjectMessage(JMSStringResources jMSStringResources) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "constructor");
            JMSMessage.trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_object";
        this.jmsStrings = jMSStringResources;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "constructor");
        }
    }

    public JMSObjectMessage(JMSStringResources jMSStringResources, Serializable serializable) throws JMSException {
        this(jMSStringResources);
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "constructor with Object");
            JMSMessage.trace.trace(2, this, sccsid);
        }
        this.setObject(serializable);
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "constructor with Object");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_exportBody");
        }
        byte[] byArray = null;
        if (this.messageBytes != null) {
            if (this.dataStart == 0) {
                byArray = this.messageBytes;
            } else {
                int n2 = this.messageBytes.length - this.dataStart;
                byArray = new byte[n2];
                System.arraycopy(this.messageBytes, this.dataStart, byArray, 0, n2);
            }
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "_exportBody");
        }
        return this.messageBytes;
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_importBody");
        }
        this.messageBytes = byArray;
        this.dataStart = n;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "_importBody");
        }
    }

    public void clearBody() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.messageBytes = null;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "clearBody");
        }
    }

    public Serializable getObject() throws JMSException {
        Serializable serializable = null;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getObject");
        }
        try {
            if (this.messageBytes != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                MQObjectInputStream mQObjectInputStream = new MQObjectInputStream(byteArrayInputStream, classLoader);
                serializable = (Serializable)mQObjectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
            JMSException jMSException = this.newMessageFormatException(1024);
            jMSException.setLinkedException((Exception)iOException);
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getObject, via Exception");
            }
            throw jMSException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            JMSException jMSException = this.newMessageFormatException(1024);
            jMSException.setLinkedException((Exception)classNotFoundException);
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getObject, via Exception");
            }
            throw jMSException;
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "getObject");
        }
        return serializable;
    }

    public void setObject(Serializable serializable) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setObject");
        }
        if (this.readOnly) {
            throw this.newMessageNotWriteableException();
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            this.messageBytes = byteArrayOutputStream.toByteArray();
            this.dataStart = 0;
            serializable = null;
        }
        catch (IOException iOException) {
            JMSException jMSException = this.newMessageFormatException(1023);
            jMSException.setLinkedException((Exception)iOException);
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setObject, via Exception");
            }
            throw jMSException;
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "setObject");
        }
    }

    public String toString() {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        try {
            Serializable serializable = this.getObject();
            if (serializable == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append(serializable.getClass());
            }
        }
        catch (JMSException jMSException) {
            stringBuffer.append(this.jmsStrings.getMessage(1025, (Object)jMSException));
            stringBuffer.append(">");
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "toString");
        }
        return stringBuffer.toString();
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }
}

