/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSAcknowledgePoint;
import com.ibm.jms.JMSDestination;
import com.ibm.jms.JMSDestinationFactory;
import com.ibm.jms.JMSNullMessage;
import com.ibm.jms.JMSStringResources;
import com.ibm.jms.JMSTrace;
import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;

public abstract class JMSMessage
implements Message,
Serializable {
    static final long serialVersionUID = -4436266789041169376L;
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/jms/JMSMessage.java, jms, j521, j521-L020426 02/04/25 14:01:37 @(#) 1.40.1.7";
    String messageClass = "jms_none";
    public static final String CLASS_NONE = "jms_none";
    public static final String CLASS_TEXT = "jms_text";
    public static final String CLASS_OBJECT = "jms_object";
    public static final String CLASS_MAP = "jms_map";
    public static final String CLASS_STREAM = "jms_stream";
    public static final String CLASS_BYTES = "jms_bytes";
    private static final String MCD_CLASS_NONE = "<mcd><Msd>jms_none</Msd></mcd>";
    private static final String MCD_CLASS_TEXT = "<mcd><Msd>jms_text</Msd></mcd>";
    private static final String MCD_CLASS_OBJECT = "<mcd><Msd>jms_object</Msd></mcd>";
    private static final String MCD_CLASS_MAP = "<mcd><Msd>jms_map</Msd></mcd>";
    private static final String MCD_CLASS_STREAM = "<mcd><Msd>jms_stream</Msd></mcd>";
    private static final String MCD_CLASS_BYTES = "<mcd><Msd>jms_bytes</Msd></mcd>";
    private static final byte[] OPEN_MCDMSD = "<mcd><Msd>".getBytes();
    private static final byte[] CLOSE_MSDMCD = "</Msd></mcd>".getBytes();
    private static final byte[] BYTES_NONE = "jms_none".getBytes();
    private static final byte[] BYTES_TEXT = "jms_text".getBytes();
    private static final byte[] BYTES_BYTES = "jms_bytes".getBytes();
    private static final byte[] BYTES_MAP = "jms_map".getBytes();
    private static final byte[] BYTES_STREAM = "jms_stream".getBytes();
    private static final byte[] BYTES_OBJECT = "jms_object".getBytes();
    static final StringBuffer NULL = new StringBuffer("<null>");
    public static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    public static final String CHARSET_PROPERTY = "JMS_IBM_Character_Set";
    private static final char[] BIN2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private transient JMSAcknowledgePoint session = null;
    static JMSTrace trace = null;
    transient JMSStringResources jmsStrings = null;
    private String jmsStringResourcesClassName;
    boolean propertiesReadOnly = false;
    private Hashtable properties = new Hashtable();
    private String correlationId = null;
    private byte[] nativeCorrelId = null;
    private boolean correlIdisNative = false;
    private int deliveryMode = 2;
    private static final int NO_DELIVERY_MODE = -2;
    private static final int DELIVERY_MODE_UNKNOWN = -3;
    private boolean hideDeliveryMode = false;
    private Destination destination = null;
    private String destString = "";
    private long expiration = 0L;
    private long timeToLive = 0L;
    private String messageId = null;
    private int priority = 4;
    private boolean redelivered = false;
    private Destination replyTo = null;
    private String replyToString = "";
    private long timestamp = 0L;
    private String type = null;
    private String msDomain = null;
    private String msFormat = null;
    private String msSet = null;
    private String msType = null;
    private String psTopic = null;
    private String psConnID = null;
    private static Integer HELD_INTERNAL = new Integer(0);
    private byte[] userIDAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private byte[] putApplNameAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private byte[] putDateAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private byte[] putTimeAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private int deliveryCountAsInt;
    private int msgTypeAsInt;
    private int groupSeqAsInt;
    private int putApplTypeAsInt;
    private int feedbackAsInt;
    private int reportExceptionAsInt;
    private int reportExpirationAsInt;
    private int reportCOAAsInt;
    private int reportCODAsInt;
    private int reportPANAsInt;
    private int reportNANAsInt;
    private int passCorrelIDAsInt;
    private int reportMsgIDAsInt;
    private int reportDiscardAsInt;
    private boolean lastMsgInGroupAsBool;
    private int ccsidForStrings;
    private boolean ccsidForStringsIsAscii;
    private boolean stringsNeedCcsidConversion;
    private String cachedCcsidAsStr = null;
    private int cachedCcsid;

    private String convertBytesToString(byte[] byArray, boolean bl) throws JMSException {
        String string = null;
        boolean bl2 = false;
        if (this.stringsNeedCcsidConversion) {
            if (this.ccsidForStringsIsAscii) {
                if (bl) {
                    bl2 = true;
                } else {
                    bl2 = true;
                    int n = 0;
                    while (n < byArray.length && bl2) {
                        bl2 = byArray[n] >= 0;
                        ++n;
                    }
                }
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            char[] cArray = new char[byArray.length];
            int n = 0;
            while (n < cArray.length) {
                cArray[n] = (char)byArray[n];
                ++n;
            }
            string = new String(cArray);
        } else {
            if (this.cachedCcsidAsStr == null) {
                String string2 = String.valueOf(this.ccsidForStrings);
                this.cachedCcsidAsStr = MQCcsidTable.lookup((String)string2);
                if (this.cachedCcsidAsStr == null) {
                    this.cachedCcsidAsStr = string2;
                }
                this.cachedCcsid = this.ccsidForStrings;
            }
            try {
                string = new String(byArray, this.cachedCcsidAsStr);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.cachedCcsidAsStr = null;
                throw this.newJMSException(1001);
            }
        }
        return string;
    }

    public void _setCcsidForStrings(int n, boolean bl, boolean bl2) {
        this.ccsidForStrings = n;
        this.ccsidForStringsIsAscii = bl;
        this.stringsNeedCcsidConversion = bl2;
    }

    private Object getInternalPropForName(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getInternalPropForName");
        }
        Object object = null;
        if (string.equals("JMSXUserID")) {
            object = this.convertBytesToString(this.userIDAsBytes, false);
        } else if (string.equals("JMSXAppID")) {
            object = this.convertBytesToString(this.putApplNameAsBytes, false);
        } else if (string.equals("JMS_IBM_PutDate")) {
            object = this.convertBytesToString(this.putDateAsBytes, true);
        } else if (string.equals("JMS_IBM_PutTime")) {
            object = this.convertBytesToString(this.putTimeAsBytes, true);
        } else if (string.equals("JMSXDeliveryCount")) {
            object = new Integer(this.deliveryCountAsInt);
        } else if (string.equals("JMS_IBM_MsgType")) {
            object = new Integer(this.msgTypeAsInt);
        } else if (string.equals("JMSXGroupSeq")) {
            object = new Integer(this.groupSeqAsInt);
        } else if (string.equals("JMS_IBM_PutApplType")) {
            object = new Integer(this.putApplTypeAsInt);
        } else if (string.equals("JMS_IBM_Feedback")) {
            object = new Integer(this.feedbackAsInt);
        } else if (string.equals("JMS_IBM_Report_Exception")) {
            object = new Integer(this.reportExceptionAsInt);
        } else if (string.equals("JMS_IBM_Report_Expiration")) {
            object = new Integer(this.reportExpirationAsInt);
        } else if (string.equals("JMS_IBM_Report_COA")) {
            object = new Integer(this.reportCOAAsInt);
        } else if (string.equals("JMS_IBM_Report_COD")) {
            object = new Integer(this.reportCODAsInt);
        } else if (string.equals("JMS_IBM_Report_PAN")) {
            object = new Integer(this.reportPANAsInt);
        } else if (string.equals("JMS_IBM_Report_NAN")) {
            object = new Integer(this.reportNANAsInt);
        } else if (string.equals("JMS_IBM_Report_Pass_Correl_ID")) {
            object = new Integer(this.passCorrelIDAsInt);
        } else if (string.equals("JMS_IBM_Report_Pass_Msg_ID")) {
            object = new Integer(this.reportMsgIDAsInt);
        } else if (string.equals("JMS_IBM_Report_Discard_Msg")) {
            object = new Integer(this.reportDiscardAsInt);
        } else if (string.equals("JMS_IBM_Last_Msg_In_Group")) {
            object = new Boolean(this.lastMsgInGroupAsBool);
        } else {
            if (trace != null) {
                trace.exit(this, "getInternalPropForName via Exception");
            }
            throw this.newJMSException(1001);
        }
        if (trace != null) {
            trace.exit(this, "getInternalPropForName");
        }
        return object;
    }

    public void _setJMSXUserIDFromBytes(byte[] byArray) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_setJMSXUserIDFromBytes");
        }
        if (byArray.length != 12) {
            if (trace != null) {
                trace.exit(this, "_setJMSXUserIDFromBytes via Exception");
            }
            throw this.newJMSException(1001);
        }
        System.arraycopy(byArray, 0, this.userIDAsBytes, 0, 12);
        this.properties.put("JMSXUserID", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSXUserIDFromBytes");
        }
    }

    public void _setJMSXPutAppIDFromBytes(byte[] byArray) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_setJMSXPutAppIDFromBytes");
        }
        if (byArray.length != 28) {
            if (trace != null) {
                trace.exit(this, "_setJMSXPutAppIDFromBytes via Exception");
            }
            throw this.newJMSException(1001);
        }
        System.arraycopy(byArray, 0, this.putApplNameAsBytes, 0, 28);
        this.properties.put("JMSXAppID", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSPutAppIDFromBytes");
        }
    }

    public void _setJMSXDeliveryCountFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSXDeliveryCountFromInt");
        }
        this.deliveryCountAsInt = n;
        this.properties.put("JMSXDeliveryCount", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSXDeliveryCountFromInt");
        }
    }

    public void _setJMSIBMMsgTypeFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMMsgTypeFromInt");
        }
        this.msgTypeAsInt = n;
        this.properties.put("JMS_IBM_MsgType", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMMsgTypeFromInt");
        }
    }

    public int _getJMSIBMMsgTypeAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMMsgTypeAsInt");
        }
        int n = this.properties.get("JMS_IBM_MsgType") == HELD_INTERNAL ? this.msgTypeAsInt : this.getIntProperty("JMS_IBM_MsgType");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMMsgTypeAsInt");
        }
        return n;
    }

    public void _setJMSXGroupSeqFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSXGroupSeqFromInt");
        }
        this.groupSeqAsInt = n;
        this.properties.put("JMSXGroupSeq", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSXGroupSeqFromInt");
        }
    }

    public int _getJMSXGroupSeqAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSXGroupSeqAsInt");
        }
        int n = this.properties.get("JMSXGroupSeq") == HELD_INTERNAL ? this.groupSeqAsInt : this.getIntProperty("JMSXGroupSeq");
        if (trace != null) {
            trace.exit(this, "_getJMSXGroupSeqAsInt");
        }
        return n;
    }

    public void _setJMSIBMPutDateFromBytes(byte[] byArray) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMPutDateFromBytes");
        }
        if (byArray.length != 8) {
            if (trace != null) {
                trace.exit(this, "_setJMSIBMPutDateFromBytes via Exception");
            }
            throw this.newJMSException(1001);
        }
        System.arraycopy(byArray, 0, this.putDateAsBytes, 0, 8);
        this.properties.put("JMS_IBM_PutDate", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMPutDateFromBytes");
        }
    }

    public void _setJMSIBMPutTimeFromBytes(byte[] byArray) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMPutTimeFromBytes");
        }
        if (byArray.length != 8) {
            if (trace != null) {
                trace.exit(this, "_setJMSIBMPutTimeFromBytes");
            }
            throw this.newJMSException(1001);
        }
        System.arraycopy(byArray, 0, this.putTimeAsBytes, 0, 8);
        this.properties.put("JMS_IBM_PutTime", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMPutTimeFromBytes");
        }
    }

    public void _setJMSIBMPutApplTypeFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMPutApplTypeFromInt");
        }
        this.putApplTypeAsInt = n;
        this.properties.put("JMS_IBM_PutApplType", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMPutApplTypeFromInt");
        }
    }

    public void _setJMSIBMFeedbackFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMFeedbackFromInt");
        }
        this.feedbackAsInt = n;
        this.properties.put("JMS_IBM_Feedback", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMFeedbackFromInt");
        }
    }

    public int _getJMSIBMFeedbackAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMFeedbackAsInt");
        }
        int n = this.properties.get("JMS_IBM_Feedback") == HELD_INTERNAL ? this.feedbackAsInt : this.getIntProperty("JMS_IBM_Feedback");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMFeedbackAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportExceptionFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMReportExceptionFromInt");
        }
        this.reportExceptionAsInt = n;
        this.properties.put("JMS_IBM_Report_Exception", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMReportExceptionFromInt");
        }
    }

    public int _getJMSIBMReportExceptionAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportExceptionAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Exception") == HELD_INTERNAL ? this.reportExceptionAsInt : this.getIntProperty("JMS_IBM_Report_Exception");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMReportExceptionAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportExpirationFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMReportExpirationFromInt");
        }
        this.reportExpirationAsInt = n;
        this.properties.put("JMS_IBM_Report_Expiration", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMReportExpirationFromInt");
        }
    }

    public int _getJMSIBMReportExpirationAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportExpirationAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Expiration") == HELD_INTERNAL ? this.reportExpirationAsInt : this.getIntProperty("JMS_IBM_Report_Expiration");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMReportExpirationAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportCOAFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMReportCOAFromInt");
        }
        this.reportCOAAsInt = n;
        this.properties.put("JMS_IBM_Report_COA", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMReportCOAFromInt");
        }
    }

    public int _getJMSIBMReportCOAAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportCOAAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_COA") == HELD_INTERNAL ? this.reportCOAAsInt : this.getIntProperty("JMS_IBM_Report_COA");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMReportCOAAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportCODFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMReportCODFromInt");
        }
        this.reportCODAsInt = n;
        this.properties.put("JMS_IBM_Report_COD", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMReportCODFromInt");
        }
    }

    public int _getJMSIBMReportCODAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportCODAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_COD") == HELD_INTERNAL ? this.reportCODAsInt : this.getIntProperty("JMS_IBM_Report_COD");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMReportCODAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportPANFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMReportPANFromInt");
        }
        this.reportPANAsInt = n;
        this.properties.put("JMS_IBM_Report_PAN", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMReportPANFromInt");
        }
    }

    public int _getJMSIBMReportPANAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportPANAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_PAN") == HELD_INTERNAL ? this.reportPANAsInt : this.getIntProperty("JMS_IBM_Report_PAN");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMReportPANAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportNANFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMReportNANFromInt");
        }
        this.reportNANAsInt = n;
        this.properties.put("JMS_IBM_Report_NAN", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMReportNANFromInt");
        }
    }

    public int _getJMSIBMReportNANAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportNANAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_NAN") == HELD_INTERNAL ? this.reportNANAsInt : this.getIntProperty("JMS_IBM_Report_NAN");
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportNANAsInt");
        }
        return n;
    }

    public void _setJMSIBMPassCorrelIDFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMPassCorrelIDFromInt");
        }
        this.passCorrelIDAsInt = n;
        this.properties.put("JMS_IBM_Report_Pass_Correl_ID", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMPassCorrelIDFromInt");
        }
    }

    public int _getJMSIBMPassCorrelIDAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMPassCorrelIDAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Pass_Correl_ID") == HELD_INTERNAL ? this.passCorrelIDAsInt : this.getIntProperty("JMS_IBM_Report_Pass_Correl_ID");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMPassCorrelIDAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportMsgIDFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMReportMsgIDFromInt");
        }
        this.reportMsgIDAsInt = n;
        this.properties.put("JMS_IBM_Report_Pass_Msg_ID", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMReportMsgIDFromInt");
        }
    }

    public int _getJMSIBMReportMsgIDAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportMsgIDAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Pass_Msg_ID") == HELD_INTERNAL ? this.reportMsgIDAsInt : this.getIntProperty("JMS_IBM_Report_Pass_Msg_ID");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMReportMsgIDAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportDiscardFromInt(int n) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMReportDiscardFromInt");
        }
        this.reportDiscardAsInt = n;
        this.properties.put("JMS_IBM_Report_Discard_Msg", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMReportDiscardFromInt");
        }
    }

    public int _getJMSIBMReportDiscardAsInt() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMReportDiscardAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Discard_Msg") == HELD_INTERNAL ? this.reportDiscardAsInt : this.getIntProperty("JMS_IBM_Report_Discard_Msg");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMReportDiscardAsInt");
        }
        return n;
    }

    public void _setJMSIBMLastMsgInGroupFromBool(boolean bl) {
        if (trace != null) {
            trace.entry(this, "_setJMSIBMLastMsgInGroupFromBool");
        }
        this.lastMsgInGroupAsBool = bl;
        this.properties.put("JMS_IBM_Last_Msg_In_Group", HELD_INTERNAL);
        if (trace != null) {
            trace.exit(this, "_setJMSIBMLastMsgInGroupFromBool");
        }
    }

    public boolean _getJMSIBMLastMsgInGroupAsBool() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getJMSIBMLastMsgInGroupAsBool");
        }
        boolean bl = this.properties.get("JMS_IBM_Last_Msg_In_Group") == HELD_INTERNAL ? this.lastMsgInGroupAsBool : this.getBooleanProperty("JMS_IBM_Last_Msg_In_Group");
        if (trace != null) {
            trace.exit(this, "_getJMSIBMLastMsgInGroupAsBool");
        }
        return bl;
    }

    public JMSMessage() {
        if (trace != null) {
            trace.entry(this, "constructor");
            trace.trace(2, this, sccsid);
            trace.exit(this, "constructor");
        }
    }

    public static JMSMessage _copyFromMessage(Session session, Message message) throws JMSException {
        Object object;
        Object object2;
        JMSMessage jMSMessage = null;
        if (trace != null) {
            trace.entry("com.ibm.jms.JMSMessage", "_copyFromMessage");
        }
        if (message instanceof TextMessage) {
            object2 = session.createTextMessage();
            object2.setText(((TextMessage)message).getText());
            jMSMessage = (JMSMessage)object2;
        } else if (message instanceof BytesMessage) {
            int n;
            object2 = session.createBytesMessage();
            ((BytesMessage)message).reset();
            object = new byte[4000];
            while ((n = ((BytesMessage)message).readBytes((byte[])object)) >= 0) {
                object2.writeBytes((byte[])object, 0, n);
            }
            jMSMessage = (JMSMessage)object2;
        } else if (message instanceof MapMessage) {
            object2 = session.createMapMessage();
            object = ((MapMessage)message).getMapNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                object2.setObject(string, ((MapMessage)message).getObject(string));
            }
            jMSMessage = (JMSMessage)object2;
        } else if (message instanceof StreamMessage) {
            object2 = session.createStreamMessage();
            ((StreamMessage)message).reset();
            try {
                while (true) {
                    object2.writeObject(((StreamMessage)message).readObject());
                }
            }
            catch (MessageEOFException messageEOFException) {
                jMSMessage = (JMSMessage)object2;
            }
        } else if (message instanceof ObjectMessage) {
            object2 = session.createObjectMessage();
            object2.setObject(((ObjectMessage)message).getObject());
            jMSMessage = (JMSMessage)object2;
        } else {
            jMSMessage = (JMSMessage)session.createMessage();
        }
        jMSMessage.setJMSType(message.getJMSType());
        jMSMessage.setJMSCorrelationID(message.getJMSCorrelationID());
        object2 = message.getPropertyNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (((String)object).startsWith("JMS")) continue;
            jMSMessage.setObjectProperty((String)object, message.getObjectProperty((String)object));
        }
        if (trace != null) {
            trace.exit("com.ibm.jms.JMSMessage", "_copyFromMessage");
        }
        return jMSMessage;
    }

    public abstract byte[] _exportBody(int var1, String var2) throws JMSException;

    public String _getJmsFolder(boolean bl) throws JMSException {
        StringBuffer stringBuffer = new StringBuffer(40);
        if (trace != null) {
            trace.entry(this, "_getJMSFolder");
        }
        stringBuffer.append("<jms>");
        if (this.destination == null) {
            if (trace != null) {
                trace.exit(this, "getJMSFolder via Exception");
            }
            throw this.newJMSException(1001);
        }
        this.formatElement("Dst", this.destination.toString(), stringBuffer);
        if (this.replyTo != null) {
            this.formatElement("Rto", this.replyTo.toString(), stringBuffer);
        }
        if (this.timestamp != 0L) {
            stringBuffer.append("<Tms>");
            stringBuffer.append(String.valueOf(this.timestamp));
            stringBuffer.append("</Tms>");
        }
        if (this.expiration != 0L) {
            stringBuffer.append("<Exp>");
            stringBuffer.append(String.valueOf(this.expiration));
            stringBuffer.append("</Exp>");
        }
        if (!this.correlIdisNative && this.correlationId != null) {
            this.formatElement("Cid", this.correlationId, stringBuffer);
        }
        if (this.priority != 4) {
            stringBuffer.append("<Pri>");
            stringBuffer.append(this.priority);
            stringBuffer.append("</Pri>");
        }
        if (!bl && !this.hideDeliveryMode || bl && this.deliveryMode != 2) {
            stringBuffer.append("<Dlv>");
            stringBuffer.append(this.deliveryMode);
            stringBuffer.append("</Dlv>");
        }
        if (this.destination instanceof Topic) {
            Object object;
            Object object2 = this.getObjectProperty("JMSXGroupID");
            if (object2 instanceof String) {
                this.formatElement("Gid", object2, stringBuffer);
            }
            if ((object = this.getObjectProperty("JMSXGroupSeq")) instanceof Integer) {
                this.formatElement("Seq", "", object.toString(), stringBuffer);
            }
        }
        stringBuffer.append("</jms>");
        if (trace != null) {
            trace.exit(this, "_getJMSFolder");
        }
        return stringBuffer.toString();
    }

    public String _getMcdFolder() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getMcdFolder");
        }
        if (this.msDomain == null && this.type == null) {
            if (this.messageClass == CLASS_TEXT) {
                return MCD_CLASS_TEXT;
            }
            if (this.messageClass == CLASS_BYTES) {
                return MCD_CLASS_BYTES;
            }
            if (this.messageClass == CLASS_NONE) {
                return MCD_CLASS_NONE;
            }
            if (this.messageClass == CLASS_OBJECT) {
                return MCD_CLASS_OBJECT;
            }
            if (this.messageClass == CLASS_MAP) {
                return MCD_CLASS_MAP;
            }
            if (this.messageClass == CLASS_STREAM) {
                return MCD_CLASS_STREAM;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("<mcd><Msd>");
        if (this.msDomain != null) {
            stringBuffer.append(this.msDomain);
            stringBuffer.append("</Msd>");
            if (this.msSet != null && this.msSet.length() > 0) {
                this.formatElement("Set", this.msSet, stringBuffer);
            }
            if (this.msType != null && this.msType.length() > 0) {
                this.formatElement("Type", this.msType, stringBuffer);
            }
            if (this.msFormat != null && this.msFormat.length() > 0) {
                this.formatElement("Fmt", this.msFormat, stringBuffer);
            }
        } else {
            stringBuffer.append(this.messageClass);
            stringBuffer.append("</Msd>");
            if (this.type != null) {
                this.formatElement("Type", this.type, stringBuffer);
            }
        }
        stringBuffer.append("</mcd>");
        if (trace != null) {
            trace.exit(this, "_getMcdFolder");
        }
        return stringBuffer.toString();
    }

    public String _getPscFolder() throws JMSException {
        if (trace != null) {
            trace.entry(this, "_getPscFolder");
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.psTopic == null || this.psConnID == null) {
            stringBuffer.append("<psc></psc>");
        } else {
            stringBuffer.append("<psc><Command>Publish</Command><PubOpt>None</PubOpt>");
            stringBuffer.append("<Topic>" + this.backReference(this.psTopic) + "</Topic>");
            stringBuffer.append("<UNIQUE_CONNECTION_ID>" + this.psConnID + "</UNIQUE_CONNECTION_ID></psc>");
        }
        if (trace != null) {
            trace.exit(this, "_getPscFolder");
        }
        return stringBuffer.toString();
    }

    public long _getTimeToLive() {
        if (trace != null) {
            trace.entry(this, "_getTimeToLive");
            trace.exit(this, "_getTimeToLive");
        }
        return this.timeToLive;
    }

    public String _getUsrFolder() throws JMSException {
        StringBuffer stringBuffer = new StringBuffer(40);
        if (trace != null) {
            trace.entry(this, "_getUsrFolder");
        }
        Enumeration enumeration = this.properties.keys();
        stringBuffer.append("<usr>");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("JMS")) continue;
            Object object = this.getObjectProperty(string);
            this.formatElement(string, object, stringBuffer);
        }
        stringBuffer.append("</usr>");
        if (trace != null) {
            trace.exit(this, "_getUsrFolder");
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String _idToString(byte[] byArray) {
        String string;
        block8: {
            String string2;
            block7: {
                if (trace != null) {
                    trace.entry("com.ibm.jms.JMSMessage", "idToString");
                }
                try {
                    if (byArray == null) {
                        String string3 = null;
                        Object var10_2 = null;
                        if (trace == null) return string3;
                        trace.exit("com.ibm.jms.JMSMessage", "idToString");
                        return string3;
                    }
                    int n = byArray.length;
                    char[] cArray = new char[3 + 2 * n];
                    cArray[0] = 73;
                    cArray[1] = 68;
                    cArray[2] = 58;
                    int n2 = 0;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n) {
                            if (n2 != 0) break;
                            string2 = null;
                            break block7;
                        }
                        int n4 = byArray[n3];
                        if (n4 < 0) {
                            n4 += 256;
                        }
                        n2 += n4;
                        cArray[2 * n3 + 3] = BIN2HEX[n4 / 16];
                        cArray[2 * n3 + 4] = BIN2HEX[n4 % 16];
                        ++n3;
                    }
                    string = new String(cArray);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var10_5 = null;
                    if (trace == null) throw throwable;
                    trace.exit("com.ibm.jms.JMSMessage", "idToString");
                    throw throwable;
                }
            }
            Object var10_3 = null;
            if (trace == null) return string2;
            trace.exit("com.ibm.jms.JMSMessage", "idToString");
            return string2;
        }
        Object var10_4 = null;
        if (trace == null) return string;
        trace.exit("com.ibm.jms.JMSMessage", "idToString");
        return string;
    }

    public abstract void _importBody(byte[] var1, int var2, int var3, String var4) throws JMSException;

    public void _parseJmsFolder(JMSDestinationFactory jMSDestinationFactory, String string, boolean bl) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_parseJmsFolder");
        }
        this.deliveryMode = -2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
        if (!stringTokenizer.nextToken().equals("jms")) {
            throw this.newJMSException(1001);
        }
        String string2 = stringTokenizer.nextToken();
        while (!string2.equals("/jms")) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            String string5 = string4.charAt(0) == '/' ? "" : string4;
            if (string2.equals("Cid")) {
                this.setJMSCorrelationID((String)this.deformatElement("'string'", string5));
            } else if (string2.equals("Tms")) {
                this.timestamp = Long.parseLong(string5);
            } else if (string2.equals("Exp")) {
                this.expiration = Long.parseLong(string5);
            } else if (string2.equals("Rto")) {
                string3 = (String)this.deformatElement("'string'", string5);
                this.replyTo = jMSDestinationFactory.createDestination(string3);
            } else if (string2.equals("Dst")) {
                string3 = (String)this.deformatElement("'string'", string5);
                this.destination = jMSDestinationFactory.createDestination(string3);
            } else if (!bl && string2.equals("Dlv")) {
                this.deliveryMode = Integer.parseInt(string5);
            } else if (string2.equals("Gid")) {
                this.setObjectProperty("JMSXGroupID", this.deformatElement("'string'", string5));
            } else if (string2.equals("Seq")) {
                this.setObjectProperty("JMSXGroupSeq", this.deformatElement("'i4'", string5));
            }
            if (string4.charAt(0) != '/') {
                string4 = stringTokenizer.nextToken();
            }
            if (string4.charAt(0) != '/') {
                throw this.newMessageFormatException(1012);
            }
            string2 = stringTokenizer.nextToken();
        }
        if (trace != null) {
            trace.exit(this, "_parseJmsFolder");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void _parseJmsFolderUtf8(byte[] var1_1, int var2_2, int var3_3, JMSDestinationFactory var4_4, boolean var5_5) throws JMSException {
        try {
            if (JMSMessage.trace != null) {
                JMSMessage.trace.entry(this, "_parseJmsFolderUtf8");
            }
            this.deliveryMode = -2;
            while (var1_1[var2_2 + (var3_3 - 1)] != 62) {
                --var3_3;
            }
            var6_6 = new byte[]{60, 106, 109, 115, 62};
            var7_8 = new byte[]{60, 47, 106, 109, 115, 62};
            var8_9 = 0;
            while (var8_9 < var6_6.length) {
                if (var1_1[var2_2 + var8_9] != var6_6[var8_9]) {
                    JMSMessage.trace.exit(this, "_parseJmsFolderUtf8 (via exception)");
                    throw this.newMessageFormatException(1012);
                }
                ++var8_9;
            }
            var9_10 = var2_2 + var3_3 - var7_8.length;
            var10_11 = 0;
            while (var10_11 < var7_8.length) {
                if (var1_1[var9_10] != var7_8[var10_11]) {
                    JMSMessage.trace.exit(this, "_parseJmsFolderUtf8 (via exception)");
                    throw this.newMessageFormatException(1012);
                }
                ++var9_10;
                ++var10_11;
            }
            var20_12 = var2_2 + var6_6.length;
            var21_13 = var2_2 + var3_3 - var7_8.length;
            ** GOTO lbl90
            {
                ++var20_12;
                block17: do {
                    if (var1_1[var20_12] != 60) continue block16;
                    ++var20_12;
                    var22_14 = 0;
                    while (var1_1[var20_12] != 62) {
                        var23_15 = (char)var1_1[var20_12];
                        if (var23_15 < 0) {
                            var23_15 = (char)(var23_15 + 256);
                        }
                        var22_14 = (var22_14 << 8) + var23_15;
                        ++var20_12;
                    }
                    var23_15 = ++var20_12;
                    while (var1_1[var20_12] != 62) {
                        ++var20_12;
                    }
                    var24_16 = var20_12;
                    while (var1_1[var24_16] != 60) {
                        --var24_16;
                    }
                    var25_17 = var24_16 - var23_15;
                    while (var1_1[var20_12] != 60) {
                        ++var20_12;
                    }
                    switch (var22_14) {
                        case 0x447374: {
                            var26_18 = this.safeUTF8ToString(var1_1, var23_15, var25_17);
                            this.destination = var4_4.createDestination(var26_18);
                            break;
                        }
                        case 5533043: {
                            this.timestamp = this.utf8ToLong(var1_1, var23_15, var25_17);
                            break;
                        }
                        case 4552816: {
                            this.expiration = this.utf8ToLong(var1_1, var23_15, var25_17);
                            break;
                        }
                        case 5272169: {
                            break;
                        }
                        case 4484214: {
                            if (var5_5) continue block17;
                            this.deliveryMode = this.utf8ToInt(var1_1, var23_15, var25_17);
                            break;
                        }
                        case 4417892: {
                            var27_19 = this.unsafeUTF8ToString(var1_1, var23_15, var25_17);
                            this.setJMSCorrelationID(var27_19);
                            break;
                        }
                        case 5403759: {
                            var28_20 = this.safeUTF8ToString(var1_1, var23_15, var25_17);
                            this.replyTo = var4_4.createDestination(var28_20);
                            break;
                        }
                        case 4680036: {
                            var29_21 = this.safeUTF8ToString(var1_1, var23_15, var25_17);
                            this.setObjectProperty("JMSXGroupID", var29_21);
                            break;
                        }
                        case 5465457: {
                            var30_22 = this.utf8ToInt(var1_1, var23_15, var25_17);
                            this.setObjectProperty("JMSXGroupSeq", new Integer(var30_22));
                            break;
                        }
                        default: {
                            var31_23 = "unknown element name in jms folder: " + Integer.toHexString(var22_14);
                            if (JMSMessage.trace == null) continue block17;
                            JMSMessage.trace.trace(this, var31_23);
                        }
                    }
lbl90:
                    // 13 sources

                } while (var20_12 < var21_13);
            }
        }
        catch (ArrayIndexOutOfBoundsException var6_7) {
            if (JMSMessage.trace != null) {
                JMSMessage.trace.trace(3, this, "" + var6_7);
            }
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "_parseJmsFolderUtf8 (via exception)");
            }
            throw this.newMessageFormatException(1012);
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "_parseJmsFolderUtf8");
        }
    }

    private String safeUTF8ToString(byte[] byArray, int n, int n2) throws JMSException {
        if (trace != null) {
            trace.entry(this, "safeUTF8ToString");
        }
        char[] cArray = new char[n2];
        int n3 = n;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        while (n3 - n < n2) {
            byte by = byArray[n3];
            if (bl) {
                if (by == 59) {
                    bl = false;
                    switch (n5) {
                        case 6385008: {
                            cArray[n4] = 38;
                            break;
                        }
                        case 26484: {
                            cArray[n4] = 62;
                            break;
                        }
                        case 27764: {
                            cArray[n4] = 60;
                            break;
                        }
                        case 1634758515: {
                            cArray[n4] = 39;
                            break;
                        }
                        case 1903521652: {
                            cArray[n4] = 34;
                            break;
                        }
                        default: {
                            if (trace != null) {
                                trace.exit(this, "safeUTF8ToString (via exception)");
                            }
                            throw this.newMessageFormatException(1012);
                        }
                    }
                    ++n4;
                } else {
                    if (by < 0) {
                        by = (byte)(by + 256);
                    }
                    n5 <<= 8;
                    n5 += by;
                }
            } else if (by == 38) {
                bl = true;
                n5 = 0;
            } else {
                cArray[n4] = (char)byArray[n3];
                ++n4;
            }
            ++n3;
        }
        if (trace != null) {
            trace.exit(this, "safeUTF8ToString");
        }
        return new String(cArray, 0, n4);
    }

    private String unsafeUTF8ToString(byte[] byArray, int n, int n2) throws JMSException {
        try {
            if (trace != null) {
                trace.entry(this, "unsafeUTF8ToString");
            }
            int n3 = 0;
            while (n3 < n2) {
                if (byArray[n3] < 0) {
                    if (trace != null) {
                        trace.exit(this, "unsafeUTF8ToString");
                    }
                    return this.expandRefs(new String(byArray, n, n2, "UTF8"));
                }
                ++n3;
            }
            if (trace != null) {
                trace.exit(this, "unsafeUTF8ToString");
            }
            return this.safeUTF8ToString(byArray, n, n2);
        }
        catch (JMSException jMSException) {
            trace.exit(this, "unsafeUTF8ToString (via exception)");
            throw jMSException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (trace != null) {
                trace.exit(this, "unsafeUTF8ToString (via exception)");
            }
            throw this.newMessageFormatException(1012);
        }
    }

    private int utf8ToInt(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)byArray[n + n3];
            ++n3;
        }
        String string = new String(cArray);
        return Integer.parseInt(string);
    }

    private long utf8ToLong(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)byArray[n + n3];
            ++n3;
        }
        String string = new String(cArray);
        return Long.parseLong(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JMSMessage _parseMcdFolder(Session session, JMSStringResources jMSStringResources, String string, String string2) throws JMSException {
        StringTokenizer stringTokenizer;
        JMSMessage jMSMessage = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (trace != null) {
            trace.entry("com.ibm.jms.JMSMessage", "_parseMcdFolder");
        }
        if (!(stringTokenizer = new StringTokenizer(string, "<>")).nextToken().equals("mcd")) {
            jMSMessage = new JMSNullMessage(jMSStringResources);
            throw jMSMessage.newMessageFormatException(1012);
        }
        String string7 = stringTokenizer.nextToken();
        while (!string7.equals("/mcd")) {
            String string8;
            boolean bl;
            block35: {
                block36: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        bl = false;
                                        string8 = stringTokenizer.nextToken();
                                        if (!string7.equals("Msd")) break block36;
                                        if (!string8.equals(CLASS_NONE)) break block37;
                                        jMSMessage = (JMSMessage)session.createMessage();
                                        break block35;
                                    }
                                    if (!string8.equals(CLASS_TEXT)) break block38;
                                    jMSMessage = (JMSMessage)session.createTextMessage();
                                    break block35;
                                }
                                if (!string8.equals(CLASS_BYTES)) break block39;
                                jMSMessage = (JMSMessage)session.createBytesMessage();
                                break block35;
                            }
                            if (!string8.equals(CLASS_MAP)) break block40;
                            jMSMessage = (JMSMessage)session.createMapMessage();
                            break block35;
                        }
                        if (!string8.equals(CLASS_STREAM)) break block41;
                        jMSMessage = (JMSMessage)session.createStreamMessage();
                        break block35;
                    }
                    if (string8.equals(CLASS_OBJECT)) {
                        jMSMessage = (JMSMessage)session.createObjectMessage();
                        break block35;
                    } else {
                        string4 = string8;
                        if (string2 == CLASS_TEXT) {
                            jMSMessage = (JMSMessage)session.createTextMessage();
                            break block35;
                        } else {
                            if (string2 != CLASS_BYTES) {
                                jMSMessage = new JMSNullMessage(jMSStringResources);
                                throw jMSMessage.newMessageFormatException(1014);
                            }
                            jMSMessage = (JMSMessage)session.createBytesMessage();
                        }
                    }
                    break block35;
                }
                if (string7.equals("Type")) {
                    if (string8.equals("/Type")) {
                        string3 = "";
                        bl = true;
                    } else {
                        string3 = string8;
                    }
                } else if (string7.equals("Set")) {
                    if (string8.equals("/Set")) {
                        string5 = "";
                        bl = true;
                    } else {
                        string5 = string8;
                    }
                } else if (string7.equals("Fmt")) {
                    if (string8.equals("/Fmt")) {
                        string6 = "";
                        bl = true;
                    } else {
                        string6 = string8;
                    }
                }
            }
            String string9 = stringTokenizer.nextToken();
            if (bl) {
                if (string9.equals("/Type") || string9.equals("/Set") || string9.equals("/Fmt")) {
                    if (string9.equals("/Type")) {
                        string3 = string8;
                    } else if (string9.equals("/Set")) {
                        string5 = string8;
                    } else if (string9.equals("/Fmt")) {
                        string6 = string8;
                    }
                    string7 = stringTokenizer.nextToken();
                    continue;
                }
                string7 = string9;
                continue;
            }
            if (string9.charAt(0) != '/') {
                jMSMessage = new JMSNullMessage(jMSStringResources);
                throw jMSMessage.newMessageFormatException(1012);
            }
            string7 = stringTokenizer.nextToken();
        }
        if (string4 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("mcd://");
            stringBuffer.append(string4);
            if (string5 != null) {
                stringBuffer.append('/');
                stringBuffer.append(string5);
            }
            if (string3 != null) {
                if (string5 == null) {
                    stringBuffer.append('/');
                }
                stringBuffer.append('/');
                stringBuffer.append(string3);
            }
            if (string6 != null) {
                stringBuffer.append("?format=");
                stringBuffer.append(string6);
            }
            jMSMessage.setJMSType(stringBuffer.toString());
        } else if (string3 != null) {
            jMSMessage.setJMSType((String)jMSMessage.deformatElement("'string'", string3));
        }
        if (trace != null) {
            trace.exit("com.ibm.jms.JMSMessage", "_parseMcdFolder");
        }
        return jMSMessage;
    }

    public static JMSMessage _parseMcdFolderUtf8(Session session, JMSStringResources jMSStringResources, String string, byte[] byArray, int n, int n2) throws JMSException {
        int n3;
        if (trace != null) {
            trace.entry("com.ibm.jms.JMSMessage", "_parseMcdFolderUtf8");
        }
        boolean bl = false;
        JMSMessage jMSMessage = null;
        while (byArray[n + (n2 - 1)] != 62) {
            --n2;
        }
        int n4 = OPEN_MCDMSD.length - 1;
        while (n4 >= 0 && !bl) {
            bl = byArray[n + n4] != OPEN_MCDMSD[n4];
            --n4;
        }
        int n5 = 0;
        while (n5 < CLOSE_MSDMCD.length && !bl) {
            bl = byArray[n5 + n + n2 - CLOSE_MSDMCD.length] != CLOSE_MSDMCD[n5];
            ++n5;
        }
        if (!bl) {
            int n6 = OPEN_MCDMSD.length + CLOSE_MSDMCD.length;
            boolean bl2 = n2 == BYTES_NONE.length + n6;
            n3 = n2 == BYTES_TEXT.length + n6 ? 1 : 0;
            boolean bl3 = n2 == BYTES_BYTES.length + n6;
            boolean bl4 = n2 == BYTES_MAP.length + n6;
            boolean bl5 = n2 == BYTES_STREAM.length + n6;
            boolean bl6 = n2 == BYTES_OBJECT.length + n6;
            int n7 = 0;
            while (n7 < n2 - (OPEN_MCDMSD.length + CLOSE_MSDMCD.length) && (bl2 || n3 != 0 || bl3 || bl5 || bl4 || bl6)) {
                byte by = byArray[n + OPEN_MCDMSD.length + n7];
                if (bl2) {
                    boolean bl7 = bl2 = by == BYTES_NONE[n7];
                }
                if (n3 != 0) {
                    int n8 = n3 = by == BYTES_TEXT[n7] ? 1 : 0;
                }
                if (bl3) {
                    boolean bl8 = bl3 = by == BYTES_BYTES[n7];
                }
                if (bl4) {
                    boolean bl9 = bl4 = by == BYTES_MAP[n7];
                }
                if (bl5) {
                    boolean bl10 = bl5 = by == BYTES_STREAM[n7];
                }
                if (bl6) {
                    bl6 = by == BYTES_OBJECT[n7];
                }
                ++n7;
            }
            if (bl2) {
                jMSMessage = (JMSMessage)session.createMessage();
            } else if (n3 != 0) {
                jMSMessage = (JMSMessage)session.createTextMessage();
            } else if (bl3) {
                jMSMessage = (JMSMessage)session.createBytesMessage();
            } else if (bl4) {
                jMSMessage = (JMSMessage)session.createMapMessage();
            } else if (bl5) {
                jMSMessage = (JMSMessage)session.createStreamMessage();
            } else if (bl6) {
                jMSMessage = (JMSMessage)session.createObjectMessage();
            } else {
                bl = true;
            }
        }
        if (bl) {
            String string2 = null;
            try {
                string2 = new String(byArray, n, n2, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (trace != null) {
                    trace.exit("com.ibm.jms.JMSMessage", "_parseMcdFolderUtf8 (via exception)");
                }
                n3 = 1012;
                throw new MessageFormatException(jMSStringResources.getErrorMessage(n3), jMSStringResources.getNativeKey(n3));
            }
            jMSMessage = JMSMessage._parseMcdFolder(session, jMSStringResources, string2, string);
        }
        if (trace != null) {
            trace.exit("com.ibm.jms.JMSMessage", "_parseMcdFolderUtf8");
        }
        return jMSMessage;
    }

    public void _parseUsrFolder(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_parseUsrFolder");
        }
        try {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
                if (!stringTokenizer.nextToken().equals("usr")) {
                    throw this.newJMSException(1001);
                }
                String string2 = stringTokenizer.nextToken();
                while (!string2.equals("/usr")) {
                    String string3;
                    boolean bl = false;
                    int n = 0;
                    try {
                        n = string2.indexOf(" xsi:nil");
                        bl = n != -1;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (bl) {
                        this.setObjectProperty(string2.substring(0, n), null);
                        if (string2.charAt(string2.length() - 1) != '/') {
                            string3 = stringTokenizer.nextToken();
                            if (string3.charAt(0) != '/') {
                                string3 = stringTokenizer.nextToken();
                            }
                            if (string3.charAt(0) != '/') {
                                throw this.newMessageFormatException(1012);
                            }
                        }
                    } else if (!bl) {
                        String string4;
                        int n2 = string2.indexOf(" dt=");
                        if (n2 != -1) {
                            string4 = string2.substring(n2 + 4);
                            string2 = string2.substring(0, n2);
                        } else {
                            string4 = "'string'";
                        }
                        if (string2.charAt(string2.length() - 1) == '/' && string4.equals("'string'")) {
                            this.setObjectProperty(string2, this.deformatElement(string4, ""));
                        } else if (string2.charAt(string2.length() - 1) == '/' && string4.equals("'bin.hex'")) {
                            this.setObjectProperty(string2, this.deformatElement(string4, ""));
                        } else {
                            string3 = stringTokenizer.nextToken();
                            if (string3.startsWith('/' + string2)) {
                                this.setObjectProperty(string2, this.deformatElement(string4, ""));
                            } else {
                                this.setObjectProperty(string2, this.deformatElement(string4, string3));
                                String string5 = stringTokenizer.nextToken();
                                if (string5.charAt(0) != '/') {
                                    throw this.newMessageFormatException(1012);
                                }
                            }
                        }
                    }
                    string2 = stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                JMSException jMSException = this.newMessageFormatException(1012);
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            Object var12_13 = null;
            if (trace != null) {
                trace.exit(this, "_parseUsrFolder");
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (trace != null) {
                trace.exit(this, "_parseUsrFolder");
            }
            throw throwable;
        }
    }

    public void _setJMSMessageIDAsBytes(byte[] byArray) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_setJMSMessageIDAsBytes");
        }
        this.messageId = JMSMessage._idToString(byArray);
        if (trace != null) {
            trace.exit(this, "_setJMSMessageIDAsBytes");
        }
    }

    public void _setJMSXObjectProperty(String string, Object object) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_setJMSXObjectProperty");
        }
        this.properties.put(string, object);
        if (trace != null) {
            trace.exit(this, "_setJMSXObjectProperty");
        }
    }

    public void _setReadOnly() {
        this.propertiesReadOnly = true;
        this._setBodyReadOnly();
    }

    abstract void _setBodyReadOnly();

    public void _setSession(JMSAcknowledgePoint jMSAcknowledgePoint) {
        if (trace != null) {
            trace.entry(this, "MQMessage setSession");
        }
        this.session = jMSAcknowledgePoint;
        if (trace != null) {
            trace.exit(this, "MQMessage setSession");
        }
    }

    public void _setTimeToLive(long l, long l2) {
        if (trace != null) {
            trace.entry(this, "_setTimeToLive");
        }
        this.expiration = l2 == 0L ? 0L : l2 + l;
        this.timeToLive = l2;
        if (trace != null) {
            trace.exit(this, "_setTimeToLive");
        }
    }

    public static void _setTrace(JMSTrace jMSTrace) {
        trace = jMSTrace;
    }

    public byte[] _stringToId(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_stringToId");
        }
        try {
            byte[] byArray = this.hexToBin(string, 3);
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "_stringToId");
            }
            return byArray;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (trace == null) break block4;
                trace.exit(this, "_stringToId");
            }
            throw throwable;
        }
    }

    public void acknowledge() throws JMSException {
        if (trace != null) {
            trace.entry(this, "acknowledge");
        }
        if (this.session == null) {
            String string = "MQJMS1057";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (trace != null) {
                trace.exit(this, "acknowledge");
            }
            throw illegalStateException;
        }
        this.session._acknowledge();
        if (trace != null) {
            trace.exit(this, "acknowledge");
        }
    }

    String backReference(String string) throws JMSException {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 12 / 10);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ('<' == c) {
                stringBuffer.append("&lt;");
            } else if ('>' == c) {
                stringBuffer.append("&gt;");
            } else if ('&' == c) {
                stringBuffer.append("&amp;");
            } else if ('\ud800' <= c && c < '\udc00') {
                int n2;
                if (n + 1 >= string.length()) {
                    String string2 = Integer.toHexString(c) + " ?";
                    throw this.newJMSException(1015, string2);
                }
                if (56320 > (n2 = string.charAt(++n)) || n2 >= 57344) {
                    String string3 = Integer.toHexString(c) + " " + Integer.toHexString(n2);
                    throw this.newJMSException(1015, string3);
                }
                n2 = (c - 55296 << 10) + n2 - 56320 + 65536;
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(n2));
                stringBuffer.append(";");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static int binToHex(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            int n5 = byArray[n4];
            if (n5 < 0) {
                n5 += 256;
            }
            n3 += n5;
            stringBuffer.append(BIN2HEX[n5 / 16]);
            stringBuffer.append(BIN2HEX[n5 % 16]);
            ++n4;
        }
        return n3;
    }

    public abstract void clearBody() throws JMSException;

    public void clearProperties() throws JMSException {
        if (trace != null) {
            trace.entry(this, "clearProperties");
        }
        this.propertiesReadOnly = false;
        this.properties.clear();
        if (trace != null) {
            trace.exit(this, "clearProperties");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object deformatElement(String string, String string2) throws JMSException {
        Character c;
        block31: {
            Boolean bl;
            block30: {
                Boolean bl2;
                block29: {
                    byte[] byArray;
                    block28: {
                        byte[] byArray2;
                        block27: {
                            Double d;
                            block26: {
                                Float f;
                                block25: {
                                    Byte by;
                                    block24: {
                                        Long l;
                                        block23: {
                                            Short s;
                                            block22: {
                                                Integer n;
                                                block21: {
                                                    String string3;
                                                    block20: {
                                                        if (trace != null) {
                                                            trace.entry(this, "deformatElement");
                                                            if (string2 == null) {
                                                                trace.trace(this, "type is " + string + " value is " + string2);
                                                            } else if (string2.length() <= 50) {
                                                                trace.trace(this, "type is " + string + " value is " + string2);
                                                            } else {
                                                                trace.trace(this, "type is " + string + " value starts " + string2.substring(0, 50));
                                                            }
                                                        }
                                                        try {
                                                            char c2 = string.charAt(0);
                                                            if (c2 != '\'' && c2 != '\"') {
                                                                throw this.newMessageFormatException();
                                                            }
                                                            String string4 = string.substring(1, string.indexOf(c2, 1));
                                                            if (string4.equals("string")) {
                                                                if (string2 == null) {
                                                                    Object var5_5 = null;
                                                                    Object var14_8 = null;
                                                                    if (trace == null) return var5_5;
                                                                    trace.exit(this, "deformatElement");
                                                                    return var5_5;
                                                                }
                                                                string3 = this.expandRefs(string2);
                                                                break block20;
                                                            }
                                                            if (string4.equals("i4")) {
                                                                n = new Integer(string2);
                                                                break block21;
                                                            }
                                                            if (string4.equals("i2")) {
                                                                s = new Short(string2);
                                                                break block22;
                                                            }
                                                            if (string4.equals("i8")) {
                                                                l = new Long(string2);
                                                                break block23;
                                                            }
                                                            if (string4.equals("i1")) {
                                                                by = new Byte(string2);
                                                                break block24;
                                                            }
                                                            if (string4.equals("r4")) {
                                                                f = new Float(string2);
                                                                break block25;
                                                            }
                                                            if (string4.equals("r8")) {
                                                                d = new Double(string2);
                                                                break block26;
                                                            }
                                                            if (string4.equals("bin.hex")) {
                                                                if (string2.equals("")) {
                                                                    byArray2 = new byte[]{};
                                                                    break block27;
                                                                }
                                                                byArray = this.hexToBin(string2, 0);
                                                                break block28;
                                                            }
                                                            if (string4.equals("boolean")) {
                                                                if (string2.equals("1")) {
                                                                    bl2 = new Boolean(true);
                                                                    break block29;
                                                                }
                                                                if (!string2.equals("0")) throw this.newMessageFormatException();
                                                                bl = new Boolean(false);
                                                                break block30;
                                                            }
                                                            if (!string4.equals("char")) throw this.newMessageFormatException(1018, string4);
                                                            c = new Character(this.expandRefs(string2).charAt(0));
                                                            break block31;
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var14_21 = null;
                                                            if (trace == null) throw throwable;
                                                            trace.exit(this, "deformatElement");
                                                            throw throwable;
                                                        }
                                                    }
                                                    Object var14_9 = null;
                                                    if (trace == null) return string3;
                                                    trace.exit(this, "deformatElement");
                                                    return string3;
                                                }
                                                Object var14_10 = null;
                                                if (trace == null) return n;
                                                trace.exit(this, "deformatElement");
                                                return n;
                                            }
                                            Object var14_11 = null;
                                            if (trace == null) return s;
                                            trace.exit(this, "deformatElement");
                                            return s;
                                        }
                                        Object var14_12 = null;
                                        if (trace == null) return l;
                                        trace.exit(this, "deformatElement");
                                        return l;
                                    }
                                    Object var14_13 = null;
                                    if (trace == null) return by;
                                    trace.exit(this, "deformatElement");
                                    return by;
                                }
                                Object var14_14 = null;
                                if (trace == null) return f;
                                trace.exit(this, "deformatElement");
                                return f;
                            }
                            Object var14_15 = null;
                            if (trace == null) return d;
                            trace.exit(this, "deformatElement");
                            return d;
                        }
                        Object var14_16 = null;
                        if (trace == null) return byArray2;
                        trace.exit(this, "deformatElement");
                        return byArray2;
                    }
                    Object var14_17 = null;
                    if (trace == null) return byArray;
                    trace.exit(this, "deformatElement");
                    return byArray;
                }
                Object var14_18 = null;
                if (trace == null) return bl2;
                trace.exit(this, "deformatElement");
                return bl2;
            }
            Object var14_19 = null;
            if (trace == null) return bl;
            trace.exit(this, "deformatElement");
            return bl;
        }
        Object var14_20 = null;
        if (trace == null) return c;
        trace.exit(this, "deformatElement");
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String expandRefs(String string) throws JMSException {
        if (string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ('&' == c) {
                String string2 = string.substring(n + 1, n + 4);
                if (string2.equals("lt;")) {
                    stringBuffer.append('<');
                    n += 3;
                } else if (string2.equals("gt;")) {
                    stringBuffer.append('>');
                    n += 3;
                } else {
                    if (!string.substring(n + 1, n + 5).equals("amp;")) throw this.newMessageFormatException(1016, "&" + string2);
                    stringBuffer.append("&");
                    n += 4;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void formatElement(String string, Object object, StringBuffer stringBuffer) throws JMSException {
        if (trace != null) {
            trace.entry(this, "formatElement");
        }
        try {
            stringBuffer.append("<");
            stringBuffer.append(string);
            if (object instanceof String) {
                stringBuffer.append(">");
                object = this.backReference((String)object);
            } else if (object instanceof Integer) {
                stringBuffer.append(" dt='i4'>");
            } else if (object instanceof Short) {
                stringBuffer.append(" dt='i2'>");
            } else if (object instanceof Byte) {
                stringBuffer.append(" dt='i1'>");
            } else if (object instanceof Long) {
                stringBuffer.append(" dt='i8'>");
            } else if (object instanceof Float) {
                stringBuffer.append(" dt='r4'>");
            } else if (object instanceof Double) {
                stringBuffer.append(" dt='r8'>");
            } else if (object instanceof byte[]) {
                stringBuffer.append(" dt='bin.hex'>");
                JMSMessage.binToHex((byte[])object, 0, ((byte[])object).length, stringBuffer);
            } else if (object instanceof Boolean) {
                stringBuffer.append(" dt='boolean'>");
                object = ((Boolean)object).booleanValue() ? "1" : "0";
            } else if (object instanceof Character) {
                stringBuffer.append(" dt='char'>");
                object = this.backReference(((Character)object).toString());
            } else if (object == null || object == NULL) {
                stringBuffer.append(" xsi:nil='true'>");
                stringBuffer.append("</");
                stringBuffer.append(string);
                stringBuffer.append(">");
                Object var5_4 = null;
                if (trace != null) {
                    trace.exit(this, "formatElement");
                }
                return;
            }
            if (!(object instanceof byte[])) {
                stringBuffer.append(object.toString());
            }
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (trace != null) {
                trace.exit(this, "formatElement");
            }
            throw throwable;
        }
        Object var5_5 = null;
        if (trace != null) {
            trace.exit(this, "formatElement");
        }
    }

    void formatElement(String string, String string2, String string3, StringBuffer stringBuffer) throws JMSException {
        if (trace != null) {
            trace.entry(this, "formatElement");
        }
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (string2 != "") {
            stringBuffer.append(" dt=" + string2);
        }
        stringBuffer.append(">");
        stringBuffer.append(string3);
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        if (trace != null) {
            trace.exit(this, "formatElement");
        }
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getBooleanProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            boolean bl = this.toBoolean(this._getProperty(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getBooleanProperty");
            }
            return bl;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getBooleanProperty");
            }
            throw throwable;
        }
    }

    public byte getByteProperty(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getByteProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            byte by = this.toByte(this._getProperty(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getByteProperty");
            }
            return by;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getByteProperty");
            }
            throw throwable;
        }
    }

    public double getDoubleProperty(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getDoubleProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            double d = this.toDouble(this._getProperty(string));
            Object var5_3 = null;
            if (trace != null) {
                trace.exit(this, "getDoubleProperty");
            }
            return d;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getDoubleProperty");
            }
            throw throwable;
        }
    }

    public float getFloatProperty(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getFloatProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            float f = this.toFloat(this._getProperty(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getFloatProperty");
            }
            return f;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getFloatProperty");
            }
            throw throwable;
        }
    }

    public int getIntProperty(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getIntProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            int n = this.toInt(this._getProperty(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getIntProperty");
            }
            return n;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getIntProperty");
            }
            throw throwable;
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSCorrelationID");
        }
        if (this.correlIdisNative && this.correlationId == "") {
            this.correlationId = JMSMessage._idToString(this.nativeCorrelId);
        }
        if (trace != null) {
            trace.exit(this, "getJMSCorrelationID");
        }
        return this.correlationId;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSCorrelationID");
        }
        if (trace != null) {
            trace.exit(this, "getJMSCorrelationID");
        }
        return this.nativeCorrelId;
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSDeliveryMode");
            trace.exit(this, "getJMSDeliveryMode");
        }
        return this.deliveryMode;
    }

    public Destination getJMSDestination() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSDestination");
            trace.exit(this, "getJMSDestination");
        }
        return this.destination;
    }

    public long getJMSExpiration() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSExpiration");
            trace.exit(this, "getJMSExpiration");
        }
        return this.expiration;
    }

    public String getJMSMessageID() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSMessageID");
            trace.exit(this, "getJMSMessageID");
        }
        return this.messageId;
    }

    public int getJMSPriority() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSPriority");
            trace.exit(this, "getJMSPriority");
        }
        return this.priority;
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSRedelivered");
            trace.exit(this, "getJMSRedelivered");
        }
        return this.redelivered;
    }

    public Destination getJMSReplyTo() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSReplyTo");
            trace.exit(this, "getJMSReplyTo");
        }
        return this.replyTo;
    }

    public long getJMSTimestamp() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSTimestamp");
            trace.exit(this, "getJMSTimestamp");
        }
        return this.timestamp;
    }

    public String getJMSType() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getJMSType");
            trace.exit(this, "getJMSType");
        }
        return this.type;
    }

    public long getLongProperty(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getLongProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            long l = this.toLong(this._getProperty(string));
            Object var5_3 = null;
            if (trace != null) {
                trace.exit(this, "getLongProperty");
            }
            return l;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getLongProperty");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObjectProperty(String string) throws JMSException {
        Object object;
        if (trace != null) {
            trace.entry(this, "getObjectProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            Object object2 = this._getProperty(string);
            if (object2 == null || object2 == NULL) {
                Object var3_3 = null;
                Object var6_4 = null;
                if (trace == null) return var3_3;
                trace.exit(this, "getObjectProperty");
                return var3_3;
            }
            object = object2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (trace == null) throw throwable;
            trace.exit(this, "getObjectProperty");
            throw throwable;
        }
        Object var6_5 = null;
        if (trace == null) return object;
        trace.exit(this, "getObjectProperty");
        return object;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getPropertyNames");
            trace.exit(this, "getPropertyNames");
        }
        return this.properties.keys();
    }

    public short getShortProperty(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getShortProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            short s = this.toShort(this._getProperty(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getShortProperty");
            }
            return s;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getShortProperty");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStringProperty(String string) throws JMSException {
        String string2;
        if (trace != null) {
            trace.entry(this, "getStringProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            Object object = this._getProperty(string);
            if (object == null || object == NULL) {
                String string3 = null;
                Object var6_4 = null;
                if (trace == null) return string3;
                trace.exit(this, "getStringProperty");
                return string3;
            }
            string2 = object.toString();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (trace == null) throw throwable;
            trace.exit(this, "getStringProperty");
            throw throwable;
        }
        Object var6_5 = null;
        if (trace == null) return string2;
        trace.exit(this, "getStringProperty");
        return string2;
    }

    byte[] hexToBin(String string, int n) throws JMSException {
        int n2 = string.length() - n;
        if (trace != null) {
            trace.trace(3, "JMSMessage", "Converting hex to Binary " + string.substring(n));
        }
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 < 0 || n2 % 2 != 0) {
            throw this.newJMSException(1006, string.substring(n));
        }
        byte[] byArray = new byte[n2 /= 2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Character.digit(string.charAt(2 * n3 + n), 16) << 4;
            int n5 = Character.digit(string.charAt(2 * n3 + n + 1), 16);
            if (n4 < 0 || n5 < 0) {
                throw this.newJMSException(1006, string.substring(n));
            }
            byArray[n3] = (byte)(n4 + n5);
            ++n3;
        }
        return byArray;
    }

    private boolean isSettablePropertyName(String string) {
        if (trace != null) {
            trace.trace(this, "Checking property name " + string + "for validity");
        }
        if (string == null) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        if (string.startsWith("JMS")) {
            return this.jmsStrings.getJMS_IBM_names().containsKey(string) || string.equals("JMSXGroupID") || string.equals("JMSXGroupSeq");
        }
        return true;
    }

    JMSException newJMSException(int n) {
        String string = this.jmsStrings.getErrorMessage(n);
        if (trace != null) {
            trace.trace(0, this, "Throwing JMS Exception " + string);
        }
        return new JMSException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newJMSException(int n, Object object) {
        String string = this.jmsStrings.getErrorMessage(n, object);
        if (trace != null) {
            trace.trace(0, this, "Throwing JMS Exception " + string);
        }
        return new JMSException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newJMSException(int n, Object object, Object object2) {
        String string = this.jmsStrings.getErrorMessage(n, object, object2);
        if (trace != null) {
            trace.trace(0, this, "Throwing JMS Exception " + string);
        }
        return new JMSException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageEOFException() {
        int n = 5;
        String string = this.jmsStrings.getErrorMessage(n);
        if (trace != null) {
            trace.trace(0, this, "Throwing MessageEOFException " + string);
        }
        return new MessageEOFException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageFormatException() {
        int n = 6;
        String string = this.jmsStrings.getErrorMessage(n);
        if (trace != null) {
            trace.trace(0, this, "Throwing MessageFormatException " + string);
        }
        return new MessageFormatException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageFormatException(int n) {
        String string = this.jmsStrings.getErrorMessage(n);
        if (trace != null) {
            trace.trace(0, this, "Throwing MessageFormatException " + string);
        }
        return new MessageFormatException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageFormatException(int n, Object object) {
        String string = this.jmsStrings.getErrorMessage(n, object);
        if (trace != null) {
            trace.trace(0, this, "Throwing MessageFormatException " + string);
        }
        return new MessageFormatException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageNotReadableException() {
        int n = 7;
        String string = this.jmsStrings.getErrorMessage(n);
        if (trace != null) {
            trace.trace(0, this, "Throwing MessageNotReadable Exception " + string);
        }
        return new MessageNotReadableException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageNotWriteableException() {
        int n = 8;
        String string = this.jmsStrings.getErrorMessage(n);
        if (trace != null) {
            trace.trace(0, this, "Throwing MessageNotWriteableException " + string);
        }
        return new MessageNotWriteableException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newResourceAllocationException() {
        int n = 9;
        String string = this.jmsStrings.getErrorMessage(n);
        if (trace != null) {
            trace.trace(0, this, "Throwing ResourceAllocationException " + string);
        }
        return new ResourceAllocationException(string, this.jmsStrings.getNativeKey(n));
    }

    public boolean propertyExists(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "propertyExists");
        }
        if (string == null) {
            if (trace != null) {
                trace.exit(this, "propertyExists (via Exception)");
            }
            throw this.newJMSException(1003, string);
        }
        boolean bl = this.properties.containsKey(string);
        if (trace != null) {
            trace.exit(this, "propertyExists");
        }
        return bl;
    }

    void removeProperty(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "removeProperty");
        }
        try {
            this.properties.remove(string);
            Object var3_2 = null;
            if (trace != null) {
                trace.exit(this, "removeProperty");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (trace != null) {
                trace.exit(this, "removeProperty");
            }
            throw throwable;
        }
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setBooleanProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setBooleanProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setBooleanProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Boolean(bl));
        if (trace != null) {
            trace.exit(this, "setBooleanProperty");
        }
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setByteProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setByteProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setByteProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Byte(by));
        if (trace != null) {
            trace.exit(this, "setByteProperty");
        }
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setDoubleProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setDoubleProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setDoubleProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Double(d));
        if (trace != null) {
            trace.exit(this, "setDoubleProperty");
        }
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setFloatProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setFloatProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setFloatProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Float(f));
        if (trace != null) {
            trace.exit(this, "setFloatProperty");
        }
    }

    public void setIntProperty(String string, int n) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setIntProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setIntProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setIntProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Integer(n));
        if (trace != null) {
            trace.exit(this, "setIntProperty");
        }
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSCorrelationID");
        }
        try {
            try {
                if (string == null) {
                    this.nativeCorrelId = null;
                    this.correlIdisNative = false;
                } else if (string.startsWith("ID:")) {
                    this.nativeCorrelId = this._stringToId(string);
                    this.correlIdisNative = true;
                } else {
                    this.nativeCorrelId = string.getBytes("UTF8");
                    this.correlIdisNative = false;
                }
                this.correlationId = string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = this.newJMSException(1022);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                if (trace != null) {
                    trace.exit(this, "setJMSCorrelationID, via Exception");
                }
                throw jMSException;
            }
            Object var5_2 = null;
            if (trace != null) {
                trace.exit(this, "setJMSCorrelationID");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (trace != null) {
                trace.exit(this, "setJMSCorrelationID");
            }
            throw throwable;
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSCorrelationIDAsBytes");
        }
        if (byArray == null) {
            this.nativeCorrelId = null;
            this.correlationId = null;
            this.correlIdisNative = false;
        } else {
            this.nativeCorrelId = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.nativeCorrelId, 0, byArray.length);
            this.correlationId = "";
            this.correlIdisNative = true;
        }
        if (trace != null) {
            trace.exit(this, "setJMSCorrelationIDAsBytes");
        }
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSDeliveryMode");
        }
        if (n == -2) {
            this.deliveryMode = 2;
            this.hideDeliveryMode = true;
        } else if (n == -3) {
            this.deliveryMode = -2;
            this.hideDeliveryMode = true;
        } else {
            this.deliveryMode = n;
            this.hideDeliveryMode = false;
        }
        if (trace != null) {
            trace.exit(this, "setJMSDeliveryMode");
        }
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSDestination");
        }
        if (destination instanceof JMSDestination) {
            this.destString = ((JMSDestination)destination).getStringFromDestination();
        }
        this.destination = destination;
        if (trace != null) {
            trace.exit(this, "setJMSDestination");
        }
    }

    public void setJMSExpiration(long l) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSExpiration");
        }
        this.expiration = l;
        if (trace != null) {
            trace.exit(this, "setJMSExpiration");
        }
    }

    public void setJMSMessageID(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSMessageID");
        }
        this.messageId = string;
        if (trace != null) {
            trace.exit(this, "setJMSMessageID");
        }
    }

    public void setJMSPriority(int n) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSPriority");
        }
        this.priority = n;
        if (trace != null) {
            trace.exit(this, "setJMSPriority");
        }
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSRedelivered");
        }
        this.redelivered = bl;
        if (trace != null) {
            trace.exit(this, "setJMSRedelivered");
        }
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSReplyTo");
        }
        if (destination instanceof JMSDestination) {
            this.replyToString = ((JMSDestination)destination).getStringFromDestination();
        }
        this.replyTo = destination;
        if (trace != null) {
            trace.exit(this, "setJMSReplyTo");
        }
    }

    public void setJMSTimestamp(long l) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSTimestamp");
        }
        this.timestamp = l;
        if (trace != null) {
            trace.exit(this, "setJMSTimestamp");
        }
    }

    public void setJMSType(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setJMSType");
        }
        try {
            if (string == null || !string.startsWith("mcd://")) {
                this.type = string;
                this.msDomain = null;
                this.msSet = null;
                this.msType = null;
                this.msFormat = null;
                Object var11_2 = null;
                if (trace != null) {
                    trace.exit(this, "setJMSType");
                }
                return;
            }
            if (this.messageClass != CLASS_TEXT && this.messageClass != CLASS_BYTES) {
                throw this.newJMSException(1028, "JMSType", string);
            }
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = 6;
            int n2 = string.indexOf(63, n);
            String string6 = n2 == -1 ? string : string.substring(0, n2);
            int n3 = string6.indexOf(47, n);
            if (n3 == -1) {
                if (string6.length() <= 6) {
                    throw this.newJMSException(1028, "JMSType", string);
                }
                string2 = string6.substring(n);
            } else {
                if (n3 == n) {
                    throw this.newJMSException(1028, "JMSType", string);
                }
                string2 = string6.substring(n, n3);
                n = n3 + 1;
                if ((n3 = string6.indexOf(47, n)) == -1) {
                    string3 = string6.substring(n);
                } else {
                    string3 = string6.substring(n, n3);
                    n = n3 + 1;
                    if ((n3 = string6.indexOf(47, n)) != -1) {
                        throw this.newJMSException(1028, "JMSType", string);
                    }
                    string4 = string6.substring(n);
                }
            }
            if (n2 > 0) {
                if (string.regionMatches(true, n2, "?format=", 0, 8)) {
                    string5 = string.substring(n2 + 8);
                    if (string5.indexOf(38) != -1) {
                        throw this.newJMSException(1028, "JMSType", string);
                    }
                } else {
                    throw this.newJMSException(1028, "JMSType", string);
                }
            }
            this.type = string;
            this.msDomain = string2;
            this.msSet = string3;
            this.msType = string4;
            this.msFormat = string5;
        }
        catch (Throwable throwable) {
            Object var11_4 = null;
            if (trace != null) {
                trace.exit(this, "setJMSType");
            }
            throw throwable;
        }
        Object var11_3 = null;
        if (trace != null) {
            trace.exit(this, "setJMSType");
        }
    }

    public void setLongProperty(String string, long l) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setLongProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setLongProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setLongProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Long(l));
        if (trace != null) {
            trace.exit(this, "setLongProperty");
        }
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setObjectProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setObjectProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setObjectProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        if (object == null) {
            this.properties.put(string, NULL);
        } else if (object instanceof byte[]) {
            this.properties.put(string, "");
        } else {
            if (!(object instanceof String || object instanceof Number || object instanceof Boolean)) {
                if (trace != null) {
                    trace.exit(this, "setObjectProperty (via Exception)");
                }
                throw new MessageFormatException("Invalid Object type");
            }
            this.properties.put(string, object);
        }
        if (trace != null) {
            trace.exit(this, "setObjectProperty");
        }
    }

    public void setShortProperty(String string, short s) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setShortProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setShortProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setShortProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Short(s));
        if (trace != null) {
            trace.exit(this, "setShortProperty");
        }
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setStringProperty");
        }
        if (this.propertiesReadOnly) {
            if (trace != null) {
                trace.exit(this, "setStringProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (!this.isSettablePropertyName(string)) {
            if (trace != null) {
                trace.exit(this, "setStringProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        if (string2 == null) {
            this.properties.put(string, NULL);
        } else {
            this.properties.put(string, string2);
        }
        if (trace != null) {
            trace.exit(this, "setStringProperty");
        }
    }

    private Object _getProperty(String string) throws JMSException {
        Object object;
        if (trace != null) {
            trace.entry(this, "_getProperty");
        }
        if ((object = this.properties.get(string)) == HELD_INTERNAL) {
            object = this.getInternalPropForName(string);
        }
        if (trace != null) {
            trace.exit(this, "_getProperty");
        }
        return object;
    }

    boolean toBoolean(Object object) throws JMSException {
        if (object == null || object == NULL) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    byte toByte(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NumberFormatException();
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof String) {
            return Byte.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    byte[] toBytes(Object object) throws JMSException {
        if (object == null || object == NULL) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    char toChar(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NullPointerException();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    double toDouble(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NullPointerException();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    float toFloat(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NullPointerException();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof String) {
            return Float.valueOf((String)object).floatValue();
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    int toInt(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NumberFormatException();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).intValue();
        }
        if (object instanceof String) {
            return Integer.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    long toLong(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NumberFormatException();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).longValue();
        }
        if (object instanceof String) {
            return Long.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    short toShort(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NumberFormatException();
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Byte) {
            return ((Byte)object).shortValue();
        }
        if (object instanceof String) {
            return Short.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("\n" + this.jmsStrings.getMessage(1013) + ": " + this.messageClass);
            stringBuffer.append("\n  JMSType:         " + this.type);
            stringBuffer.append("\n  JMSDeliveryMode: " + this.deliveryMode);
            stringBuffer.append("\n  JMSExpiration:   " + this.expiration);
            stringBuffer.append("\n  JMSPriority:     " + this.priority);
            stringBuffer.append("\n  JMSMessageID:    " + this.messageId);
            stringBuffer.append("\n  JMSTimestamp:    " + this.timestamp);
            stringBuffer.append("\n  JMSCorrelationID:" + this.getJMSCorrelationID());
            stringBuffer.append("\n  JMSDestination:  " + this.destination);
            stringBuffer.append("\n  JMSReplyTo:      " + this.replyTo);
            stringBuffer.append("\n  JMSRedelivered:  " + this.redelivered);
            Enumeration enumeration = this.getPropertyNames();
            int n = 999;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n  " + string + ":" + this.getObjectProperty(string));
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.jmsStrings != null) {
            this.jmsStringResourcesClassName = this.jmsStrings.getClass().getName();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.jmsStringResourcesClassName != null) {
            try {
                Class<?> clazz = Class.forName(this.jmsStringResourcesClassName);
                this.jmsStrings = (JMSStringResources)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("unable to recreate JMSStringResources from " + this.jmsStringResourcesClassName);
            }
        }
    }

    public void setPSCTopic(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setPSCTopic");
        }
        this.psTopic = string;
        if (trace != null) {
            trace.exit(this, "setPSCTopic");
        }
    }

    public void setPSCConnID(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setPSCConnID");
        }
        this.psConnID = string;
        if (trace != null) {
            trace.exit(this, "setPSCConnID");
        }
    }
}

