/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.MapMessage;

public class JMSMapMessage
extends JMSMessage
implements MapMessage {
    static final long serialVersionUID = 3908796707964271920L;
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2001     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/jms/JMSMapMessage.java, jms, j521, j521-L020126 02/01/25 15:37:25 @(#) 1.13.1.1";
    private Hashtable mapdata = new Hashtable();
    boolean readOnly = false;

    public JMSMapMessage(JMSStringResources jMSStringResources) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "constructor");
            JMSMessage.trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_map";
        this.jmsStrings = jMSStringResources;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "constructor");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_exportBody");
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            try {
                Enumeration enumeration = this.getMapNames();
                stringBuffer.append("<map>");
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Object object = this.getObject(string2);
                    this.formatElement(string2, object, stringBuffer);
                }
                stringBuffer.append("</map>");
                byte[] byArray = stringBuffer.toString().getBytes(string);
                Object var10_9 = null;
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.exit(this, "_exportBody");
                }
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = this.newJMSException(1008, string);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.exit(this, "_exportBody (via Exception)");
                }
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            block8: {
                Object var10_10 = null;
                if (JMSMessage.trace == null) break block8;
                JMSMessage.trace.exit(this, "_exportBody");
            }
            throw throwable;
        }
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_importBody");
        }
        try {
            try {
                String string2 = new String(byArray, n, byArray.length - n, string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "<>");
                if (!stringTokenizer.nextToken().equals("map")) {
                    throw this.newMessageFormatException(1009);
                }
                String string3 = stringTokenizer.nextToken();
                while (!string3.equals("/map")) {
                    String string4;
                    String string5;
                    int n3 = 0;
                    boolean bl = false;
                    try {
                        n3 = string3.indexOf(" xsi:nil");
                        bl = n3 != -1;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (string3.charAt(string3.length() - 1) == '/') {
                        bl2 = true;
                    }
                    if (bl) {
                        int n4 = 0;
                        n4 = string3.indexOf(" ");
                        string5 = "'string'";
                        string3 = string3.substring(0, n4);
                        if (!bl2) {
                            string4 = stringTokenizer.nextToken();
                            if (string4.charAt(0) != '/') {
                                string4 = stringTokenizer.nextToken();
                            }
                            if (string4.charAt(0) != '/') {
                                throw this.newMessageFormatException(1012);
                            }
                        }
                        this.setObjectProperty(string3, this.deformatElement(string5, null));
                    } else {
                        int n5 = string3.indexOf(" dt=");
                        if (n5 != -1) {
                            string5 = string3.substring(n5 + 4);
                            string3 = string3.substring(0, n5);
                            if (bl2) {
                                string5 = string5.substring(0, string5.length() - 1);
                            }
                        } else {
                            string5 = "'string'";
                            if (bl2) {
                                string3 = string3.substring(0, string3.length() - 1);
                            }
                        }
                        if (bl2) {
                            this.setObjectProperty(string3, this.deformatElement(string5, ""));
                        } else {
                            String string6 = stringTokenizer.nextToken();
                            if (string6.charAt(0) == '/') {
                                this.setObject(string3, this.deformatElement(string5, ""));
                            } else {
                                this.setObject(string3, this.deformatElement(string5, string6));
                                string4 = stringTokenizer.nextToken();
                                if (string4.charAt(0) != '/') {
                                    throw this.newMessageFormatException(1009);
                                }
                            }
                        }
                    }
                    string3 = stringTokenizer.nextToken();
                }
                this.propertiesReadOnly = true;
                this.readOnly = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = this.newJMSException(1008, string);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                throw jMSException;
            }
            catch (Exception exception) {
                JMSException jMSException = this.newMessageFormatException(1009);
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            Object var18_22 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "_importBody");
            }
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "_importBody");
            }
            throw throwable;
        }
    }

    public void clearBody() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.mapdata.clear();
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "clearBody");
        }
    }

    public boolean getBoolean(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getBoolean");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            boolean bl = this.toBoolean(this.mapdata.get(string));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getBoolean");
            }
            return bl;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getBoolean");
            }
            throw throwable;
        }
    }

    public byte getByte(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getByte");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            byte by = this.toByte(this.mapdata.get(string));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getByte");
            }
            return by;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getByte");
            }
            throw throwable;
        }
    }

    public byte[] getBytes(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getBytes");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            byte[] byArray = this.toBytes(this.mapdata.get(string));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getBytes");
            }
            return byArray;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getBytes");
            }
            throw throwable;
        }
    }

    public char getChar(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getChar");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            char c = this.toChar(this.mapdata.get(string));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getChar");
            }
            return c;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getChar");
            }
            throw throwable;
        }
    }

    public double getDouble(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getDouble");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            double d = this.toDouble(this.mapdata.get(string));
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getDouble");
            }
            return d;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getDouble");
            }
            throw throwable;
        }
    }

    public float getFloat(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getFloat");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            float f = this.toFloat(this.mapdata.get(string));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getFloat");
            }
            return f;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getFloat");
            }
            throw throwable;
        }
    }

    public int getInt(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getInt");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            int n = this.toInt(this.mapdata.get(string));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getInt");
            }
            return n;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getInt");
            }
            throw throwable;
        }
    }

    public long getLong(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getLong");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            long l = this.toLong(this.mapdata.get(string));
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getLong");
            }
            return l;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getLong");
            }
            throw throwable;
        }
    }

    public Enumeration getMapNames() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getMapNames");
            JMSMessage.trace.exit(this, "getMapNames");
        }
        return this.mapdata.keys();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject(String string) throws JMSException {
        Object v;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getObject");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            Object v2 = this.mapdata.get(string);
            if (v2 == null || v2 == JMSMessage.NULL) {
                Object var3_3 = null;
                Object var5_5 = null;
                if (JMSMessage.trace == null) return var3_3;
                JMSMessage.trace.exit(this, "getObject");
                return var3_3;
            }
            v = v2;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "getObject");
            throw throwable;
        }
        Object var5_6 = null;
        if (JMSMessage.trace == null) return v;
        JMSMessage.trace.exit(this, "getObject");
        return v;
    }

    public short getShort(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getShort");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            short s = this.toShort(this.mapdata.get(string));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getShort");
            }
            return s;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block5;
                JMSMessage.trace.exit(this, "getShort");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString(String string) throws JMSException {
        String string2;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getString");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            Object v = this.mapdata.get(string);
            if (v == null || v == JMSMessage.NULL) {
                String string3 = null;
                Object var6_4 = null;
                if (JMSMessage.trace == null) return string3;
                JMSMessage.trace.exit(this, "getString");
                return string3;
            }
            if (v instanceof byte[]) {
                throw this.newMessageFormatException(1011);
            }
            string2 = v.toString();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "getString");
            throw throwable;
        }
        Object var6_5 = null;
        if (JMSMessage.trace == null) return string2;
        JMSMessage.trace.exit(this, "getString");
        return string2;
    }

    private boolean isSettableMapName(String string) {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.trace(this, "Checking element name " + string + "for validity");
        }
        if (string == null) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean itemExists(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "itemExists");
        }
        if (string == null) {
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "itemExists (via Exception)");
            }
            throw this.newJMSException(1003);
        }
        boolean bl = this.mapdata.containsKey(string);
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "itemExists");
        }
        return bl;
    }

    public void setBoolean(String string, boolean bl) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setBoolean");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Boolean(bl));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setBoolean");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setBoolean");
            }
            throw throwable;
        }
    }

    public void setByte(String string, byte by) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setByte");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Byte(by));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setByte");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setByte");
            }
            throw throwable;
        }
    }

    public void setBytes(String string, byte[] byArray) throws JMSException {
        if (byArray == null) {
            this.setObject(string, byArray);
        } else if (byArray.length == 0) {
            this.setObject(string, byArray);
        } else {
            this.setBytes(string, byArray, 0, byArray.length);
        }
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setBytes");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            if (byArray.length == 0) {
                this.mapdata.put(string, new byte[0]);
            } else {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                this.mapdata.put(string, byArray2);
            }
            Object var7_6 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setBytes");
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setBytes");
            }
            throw throwable;
        }
    }

    public void setChar(String string, char c) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setChar");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Character(c));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setChar");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setChar");
            }
            throw throwable;
        }
    }

    public void setDouble(String string, double d) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setDouble");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Double(d));
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setDouble");
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setDouble");
            }
            throw throwable;
        }
    }

    public void setFloat(String string, float f) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setFloat");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Float(f));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setFloat");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setFloat");
            }
            throw throwable;
        }
    }

    public void setInt(String string, int n) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setInt");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Integer(n));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setInt");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setInt");
            }
            throw throwable;
        }
    }

    public void setLong(String string, long l) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setLong");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Long(l));
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setLong");
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setLong");
            }
            throw throwable;
        }
    }

    public void setObject(String string, Object object) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setObject");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            if (object == null) {
                this.mapdata.put(string, JMSMessage.NULL);
            } else {
                if (!(object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof byte[])) {
                    throw this.newMessageFormatException(1018, object.getClass());
                }
                this.mapdata.put(string, object);
            }
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setObject");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setObject");
            }
            throw throwable;
        }
    }

    public void setShort(String string, short s) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setShort");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Short(s));
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setShort");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setShort");
            }
            throw throwable;
        }
    }

    public void setString(String string, String string2) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setString");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            if (string2 == null) {
                this.mapdata.put(string, JMSMessage.NULL);
            } else {
                this.mapdata.put(string, string2);
            }
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setString");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "setString");
            }
            throw throwable;
        }
    }

    public String toString() {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        stringBuffer.append(this.mapdata.toString());
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "toString");
        }
        return stringBuffer.toString();
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }
}

