/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMS390FloatSupport;
import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public class JMSBytesMessage
extends JMSMessage
implements BytesMessage {
    static final long serialVersionUID = -8017520360760128818L;
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2001    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/jms/JMSBytesMessage.java, jms, j521, j521-L020306 02/03/05 11:31:12 @(#) 1.19.2.2";
    public static final int ENC_INTEGER_MASK = 15;
    public static final int ENC_FLOAT_MASK = 3840;
    public static final int ENC_INTEGER_UNDEFINED = 0;
    public static final int ENC_INTEGER_NORMAL = 1;
    public static final int ENC_INTEGER_REVERSED = 2;
    public static final int ENC_FLOAT_UNDEFINED = 0;
    public static final int ENC_FLOAT_IEEE_NORMAL = 256;
    public static final int ENC_FLOAT_IEEE_REVERSED = 512;
    public static final int ENC_FLOAT_S390 = 768;
    private transient ByteArrayOutputStream _writeBytes;
    private transient DataOutputStream writeStream;
    private static final int ARRAY_SIZE = 20;
    private int integer_count;
    private int[] integer_offsets;
    private int[] integer_sizes;
    private Vector integers = new Vector();
    private Vector float_offsets = new Vector();
    private Vector float_values = new Vector();
    private boolean populated_by_client = true;
    private byte[] dataBuffer;
    private int dataStart;
    private int integerEncoding = 1;
    private int floatEncoding = 256;
    private transient ByteArrayInputStream readStream;
    private boolean markInUse = false;
    boolean readOnly = false;

    public JMSBytesMessage(JMSStringResources jMSStringResources) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "constructor");
            JMSMessage.trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_bytes";
        this.jmsStrings = jMSStringResources;
        this.clearBody();
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "constructor");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] _exportBody(int n, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_exportBody");
        }
        try {
            try {
                int n2;
                Object object;
                this.reset();
                if (!this.populated_by_client) {
                    byte[] byArray = new byte[this.dataBuffer.length - this.dataStart];
                    System.arraycopy(this.dataBuffer, this.dataStart, byArray, 0, this.dataBuffer.length - this.dataStart);
                    byte[] byArray2 = byArray;
                    Object var14_22 = null;
                    if (JMSMessage.trace == null) return byArray2;
                    JMSMessage.trace.exit(this, "_exportBody");
                    return byArray2;
                }
                int n3 = n & 0xF;
                int n4 = n & 0xF00;
                if (this.integerEncoding <= 1 && n3 == 2 || this.integerEncoding == 2 && n3 <= 1) {
                    int n5 = 0;
                    while (n5 < this.integers.size()) {
                        int[] nArray = (int[])this.integers.elementAt(n5);
                        object = (int[])this.integers.elementAt(n5 + 1);
                        n2 = 0;
                        while (n2 < 20) {
                            this.reverse(this.dataBuffer, nArray[n2], (int)object[n2]);
                            ++n2;
                        }
                        n5 += 2;
                    }
                    int n6 = 0;
                    while (n6 < this.integer_count) {
                        this.reverse(this.dataBuffer, this.integer_offsets[n6], this.integer_sizes[n6]);
                        ++n6;
                    }
                    this.integerEncoding = n3;
                }
                if (this.floatEncoding != n4) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
                    object = new DataOutputStream(byteArrayOutputStream);
                    n2 = 0;
                    while (n2 < this.float_offsets.size()) {
                        byteArrayOutputStream.reset();
                        Object e = this.float_values.elementAt(n2);
                        int n7 = (Integer)this.float_offsets.elementAt(n2);
                        if (e instanceof Float) {
                            float f = ((Float)e).floatValue();
                            switch (n4) {
                                case 256: 
                                case 512: {
                                    ((DataOutputStream)object).writeInt(Float.floatToIntBits(f));
                                    break;
                                }
                                case 768: {
                                    ((DataOutputStream)object).writeInt(JMS390FloatSupport.floatToS390IntBits(f));
                                    break;
                                }
                                default: {
                                    if (JMSMessage.trace == null) throw this.newJMSException(1005);
                                    JMSMessage.trace.trace(2, this, "Invalid encoding : " + n4);
                                    throw this.newJMSException(1005);
                                }
                            }
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            if (n4 == 512) {
                                this.reverse(byArray, 0, 4);
                            }
                            System.arraycopy(byArray, 0, this.dataBuffer, n7, 4);
                        } else if (e instanceof Double) {
                            double d = (Double)e;
                            switch (n4) {
                                case 256: 
                                case 512: {
                                    ((DataOutputStream)object).writeLong(Double.doubleToLongBits(d));
                                    break;
                                }
                                case 768: {
                                    ((DataOutputStream)object).writeLong(JMS390FloatSupport.doubleToS390LongBits(d));
                                    break;
                                }
                                default: {
                                    if (JMSMessage.trace == null) throw this.newJMSException(1005);
                                    JMSMessage.trace.trace(2, this, "Invalid encoding : " + n4);
                                    throw this.newJMSException(1005);
                                }
                            }
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            if (n4 == 512) {
                                this.reverse(byArray, 0, 8);
                            }
                            System.arraycopy(byArray, 0, this.dataBuffer, n7, 8);
                        }
                        ++n2;
                    }
                    this.floatEncoding = n4;
                }
                byte[] byArray = this.dataBuffer;
                Object var14_23 = null;
                if (JMSMessage.trace == null) return byArray;
                JMSMessage.trace.exit(this, "_exportBody");
                return byArray;
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "_exportBody");
            throw throwable;
        }
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_importBody");
        }
        try {
            this.dataBuffer = byArray;
            this.dataStart = n;
            this.integerEncoding = n2 & 0xF;
            this.floatEncoding = n2 & 0xF00;
            this.populated_by_client = false;
            this._setJMSXObjectProperty("JMS_IBM_Encoding", new Integer(n2));
            String string2 = string;
            if (string.startsWith("Cp")) {
                try {
                    string2 = Integer.toString(Integer.parseInt(string.substring(2)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._setJMSXObjectProperty("JMS_IBM_Character_Set", string2);
            this.readOnly = true;
            this.reset();
            Object var8_7 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "_importBody");
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "_importBody");
            }
            throw throwable;
        }
    }

    public void clearBody() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.dataBuffer = null;
        this.dataStart = 0;
        this.readStream = null;
        this._writeBytes = new ByteArrayOutputStream();
        this.writeStream = new DataOutputStream(this._writeBytes);
        this.populated_by_client = true;
        this.removeProperty("JMS_IBM_Encoding");
        this.removeProperty("JMS_IBM_Character_Set");
        this.integerEncoding = 1;
        this.floatEncoding = 256;
        this.integer_count = 0;
        this.integer_offsets = new int[20];
        this.integer_sizes = new int[20];
        this.integers.removeAllElements();
        this.float_offsets.removeAllElements();
        this.float_values.removeAllElements();
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "clearBody");
        }
    }

    public boolean readBoolean() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readBoolean");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            int n = this.readStream.read();
            if (n < 0) {
                throw this.newMessageEOFException();
            }
            boolean bl = n != 0;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readBoolean");
            }
            return bl;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block6;
                JMSMessage.trace.exit(this, "readBoolean");
            }
            throw throwable;
        }
    }

    public byte readByte() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readByte");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            int n = this.readStream.read();
            if (n < 0) {
                throw this.newMessageEOFException();
            }
            byte by = (byte)n;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readByte");
            }
            return by;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block6;
                JMSMessage.trace.exit(this, "readByte");
            }
            throw throwable;
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        return this.readBytes(byArray, byArray.length);
    }

    public int readBytes(byte[] byArray, int n) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readBytes");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            if (byArray.length < n || n < 0) {
                throw new IndexOutOfBoundsException();
            }
            int n2 = this.readStream.read(byArray, 0, n);
            Object var6_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readBytes");
            }
            return n2;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_5 = null;
                if (JMSMessage.trace == null) break block6;
                JMSMessage.trace.exit(this, "readBytes");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char readChar() throws JMSException {
        char c;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readChar");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            if (!this.markInUse) {
                this.readStream.mark(2);
            }
            int n = this.readStream.read();
            int n2 = this.readStream.read();
            if (n2 < 0) {
                this.readStream.reset();
                throw this.newMessageEOFException();
            }
            if (this.integerEncoding == 2) {
                char c2 = (char)((n2 << 8) + n);
                Object var6_4 = null;
                if (JMSMessage.trace == null) return c2;
                JMSMessage.trace.exit(this, "readChar");
                return c2;
            }
            c = (char)((n << 8) + n2);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "readChar");
            throw throwable;
        }
        Object var6_5 = null;
        if (JMSMessage.trace == null) return c;
        JMSMessage.trace.exit(this, "readChar");
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double readDouble() throws JMSException {
        double d;
        int n;
        block11: {
            double d2;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.entry(this, "readDouble");
            }
            n = this.integerEncoding;
            try {
                try {
                    switch (this.floatEncoding) {
                        case 256: {
                            this.integerEncoding = 1;
                            double d3 = Double.longBitsToDouble(this.readLong());
                            Object var9_4 = null;
                            this.integerEncoding = n;
                            if (JMSMessage.trace == null) return d3;
                            JMSMessage.trace.exit(this, "readDouble");
                            return d3;
                        }
                        case 512: {
                            this.integerEncoding = 2;
                            d2 = Double.longBitsToDouble(this.readLong());
                            break;
                        }
                        case 768: {
                            this.integerEncoding = 1;
                            d = JMS390FloatSupport.longS390BitsToDouble(this.readLong());
                            break block11;
                        }
                        default: {
                            if (JMSMessage.trace == null) throw this.newJMSException(1005);
                            JMSMessage.trace.trace(2, this, "Invalid encoding : " + this.floatEncoding);
                            throw this.newJMSException(1005);
                        }
                    }
                }
                catch (IOException iOException) {
                    JMSException jMSException = this.newMessageFormatException();
                    jMSException.setLinkedException((Exception)iOException);
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                this.integerEncoding = n;
                if (JMSMessage.trace == null) throw throwable;
                JMSMessage.trace.exit(this, "readDouble");
                throw throwable;
            }
            Object var9_5 = null;
            this.integerEncoding = n;
            if (JMSMessage.trace == null) return d2;
            JMSMessage.trace.exit(this, "readDouble");
            return d2;
        }
        Object var9_6 = null;
        this.integerEncoding = n;
        if (JMSMessage.trace == null) return d;
        JMSMessage.trace.exit(this, "readDouble");
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float readFloat() throws JMSException {
        float f;
        int n;
        block11: {
            float f2;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.entry(this, "readFloat");
            }
            n = this.integerEncoding;
            try {
                try {
                    switch (this.floatEncoding) {
                        case 256: {
                            this.integerEncoding = 1;
                            float f3 = Float.intBitsToFloat(this.readInt());
                            Object var6_4 = null;
                            this.integerEncoding = n;
                            if (JMSMessage.trace == null) return f3;
                            JMSMessage.trace.exit(this, "readFloat");
                            return f3;
                        }
                        case 512: {
                            this.integerEncoding = 2;
                            f2 = Float.intBitsToFloat(this.readInt());
                            break;
                        }
                        case 768: {
                            this.integerEncoding = 1;
                            f = JMS390FloatSupport.intS390BitsToFloat(this.readInt());
                            break block11;
                        }
                        default: {
                            if (JMSMessage.trace == null) throw this.newJMSException(1005);
                            JMSMessage.trace.trace(2, this, "Invalid encoding : " + this.floatEncoding);
                            throw this.newJMSException(1005);
                        }
                    }
                }
                catch (IOException iOException) {
                    JMSException jMSException = this.newMessageFormatException();
                    jMSException.setLinkedException((Exception)iOException);
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.integerEncoding = n;
                if (JMSMessage.trace == null) throw throwable;
                JMSMessage.trace.exit(this, "readFloat");
                throw throwable;
            }
            Object var6_5 = null;
            this.integerEncoding = n;
            if (JMSMessage.trace == null) return f2;
            JMSMessage.trace.exit(this, "readFloat");
            return f2;
        }
        Object var6_6 = null;
        this.integerEncoding = n;
        if (JMSMessage.trace == null) return f;
        JMSMessage.trace.exit(this, "readFloat");
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readInt() throws JMSException {
        int n;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readInt");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            if (!this.markInUse) {
                this.readStream.mark(4);
            }
            int n2 = this.readStream.read();
            int n3 = this.readStream.read();
            int n4 = this.readStream.read();
            int n5 = this.readStream.read();
            if (n5 < 0) {
                this.readStream.reset();
                throw this.newMessageEOFException();
            }
            if (this.integerEncoding == 2) {
                int n6 = (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
                Object var8_6 = null;
                if (JMSMessage.trace == null) return n6;
                JMSMessage.trace.exit(this, "readInt");
                return n6;
            }
            n = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "readInt");
            throw throwable;
        }
        Object var8_7 = null;
        if (JMSMessage.trace == null) return n;
        JMSMessage.trace.exit(this, "readInt");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long readLong() throws JMSException {
        long l;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readLong");
        }
        try {
            this.readStream.mark(8);
            this.markInUse = true;
            long l2 = (long)this.readInt() & 0xFFFFFFFFL;
            long l3 = (long)this.readInt() & 0xFFFFFFFFL;
            if (this.integerEncoding == 2) {
                long l4 = (l3 << 32) + l2;
                Object var10_4 = null;
                this.markInUse = false;
                if (JMSMessage.trace == null) return l4;
                JMSMessage.trace.exit(this, "readLong");
                return l4;
            }
            l = (l2 << 32) + l3;
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            this.markInUse = false;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "readLong");
            throw throwable;
        }
        Object var10_5 = null;
        this.markInUse = false;
        if (JMSMessage.trace == null) return l;
        JMSMessage.trace.exit(this, "readLong");
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short readShort() throws JMSException {
        short s;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readShort");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            if (!this.markInUse) {
                this.readStream.mark(2);
            }
            int n = this.readStream.read();
            int n2 = this.readStream.read();
            if (n2 < 0) {
                this.readStream.reset();
                throw this.newMessageEOFException();
            }
            if (this.integerEncoding == 2) {
                short s2 = (short)((n2 << 8) + n);
                Object var6_4 = null;
                if (JMSMessage.trace == null) return s2;
                JMSMessage.trace.exit(this, "readShort");
                return s2;
            }
            s = (short)((n << 8) + n2);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "readShort");
            throw throwable;
        }
        Object var6_5 = null;
        if (JMSMessage.trace == null) return s;
        JMSMessage.trace.exit(this, "readShort");
        return s;
    }

    public int readUnsignedByte() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readUnsignedByte");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            int n = this.readStream.read();
            if (n < 0) {
                throw this.newMessageEOFException();
            }
            int n2 = n;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readUnsignedByte");
            }
            return n2;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block6;
                JMSMessage.trace.exit(this, "readUnsignedByte");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readUnsignedShort() throws JMSException {
        int n;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readUnsignedShort");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            if (!this.markInUse) {
                this.readStream.mark(2);
            }
            int n2 = this.readStream.read();
            int n3 = this.readStream.read();
            if (n3 < 0) {
                this.readStream.reset();
                throw this.newMessageEOFException();
            }
            if (this.integerEncoding == 2) {
                int n4 = (n3 << 8) + n2;
                Object var6_4 = null;
                if (JMSMessage.trace == null) return n4;
                JMSMessage.trace.exit(this, "readUnsignedShort");
                return n4;
            }
            n = (n2 << 8) + n3;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "readUnsignedShort");
            throw throwable;
        }
        Object var6_5 = null;
        if (JMSMessage.trace == null) return n;
        JMSMessage.trace.exit(this, "readUnsignedShort");
        return n;
    }

    public String readUTF() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readUTF");
        }
        int n = this.integerEncoding;
        try {
            try {
                this.readStream.mark(8);
                this.markInUse = true;
                this.integerEncoding = 1;
                int n2 = this.readUnsignedShort();
                byte[] byArray = new byte[n2];
                if (this.readBytes(byArray, n2) != n2) {
                    this.readStream.reset();
                    throw this.newMessageEOFException();
                }
                String string = new String(byArray, 0, n2, "UTF8");
                Object var6_7 = null;
                this.integerEncoding = n;
                this.markInUse = false;
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.exit(this, "readUTF");
                }
                return string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = this.newMessageFormatException();
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            block7: {
                Object var6_8 = null;
                this.integerEncoding = n;
                this.markInUse = false;
                if (JMSMessage.trace == null) break block7;
                JMSMessage.trace.exit(this, "readUTF");
            }
            throw throwable;
        }
    }

    private void recordInteger(int n, int n2) {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "recordInteger");
        }
        if (this.integer_count == 20) {
            this.integers.addElement(this.integer_offsets);
            this.integers.addElement(this.integer_sizes);
            this.integer_offsets = new int[20];
            this.integer_sizes = new int[20];
            this.integer_count = 0;
        }
        this.integer_offsets[this.integer_count] = n;
        this.integer_sizes[this.integer_count++] = n2;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "recordInteger");
        }
    }

    public void reset() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "reset");
        }
        try {
            if (!this.readOnly) {
                this.dataBuffer = this._writeBytes.toByteArray();
                this.dataStart = 0;
                this.writeStream = null;
                this._writeBytes = null;
                this.readOnly = true;
            }
            if (this.dataBuffer == null) {
                this.dataBuffer = new byte[0];
            }
            this.readStream = new ByteArrayInputStream(this.dataBuffer);
            this.readStream.skip(this.dataStart);
            Object var2_1 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "reset");
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "reset");
            }
            throw throwable;
        }
    }

    private void reverse(byte[] byArray, int n, int n2) {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "reverse");
            JMSMessage.trace.trace(3, this, "length = " + n2 + " data follows: ");
            JMSMessage.trace.dataTrace(3, this, byArray);
        }
        int n3 = 0;
        while (n3 < n2 / 2) {
            byte by = byArray[n + n3];
            byArray[n + n3] = byArray[n + (n2 - 1) - n3];
            byArray[n + (n2 - 1) - n3] = by;
            ++n3;
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "reverse");
        }
    }

    public String toString() {
        int n = 10;
        int n2 = 40;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append(this.jmsStrings.getMessage(1027, new Integer(this.integerEncoding), new Integer(this.floatEncoding)));
        stringBuffer.append("\n");
        if (!this.readOnly) {
            this.dataBuffer = this._writeBytes.toByteArray();
        }
        if (this.dataBuffer != null) {
            int n3 = this.dataStart;
            int n4 = 0;
            while (n4 < n) {
                if (this.dataBuffer.length <= n3 + n2) {
                    JMSMessage.binToHex(this.dataBuffer, n3, this.dataBuffer.length - n3, stringBuffer);
                    n3 = this.dataBuffer.length;
                    stringBuffer.append("\n");
                    break;
                }
                JMSMessage.binToHex(this.dataBuffer, n3, n2, stringBuffer);
                stringBuffer.append("\n");
                n3 += n2;
                ++n4;
            }
            if (n3 != this.dataBuffer.length) {
                stringBuffer.append("...\n");
            }
        }
        return stringBuffer.toString();
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeBoolean");
        }
        try {
            this.writeByte(bl ? (byte)1 : 0);
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBoolean");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBoolean");
            }
            throw throwable;
        }
    }

    public void writeByte(byte by) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeByte");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeByte(by);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeByte");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeByte");
            }
            throw throwable;
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeBytes");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var7_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBytes");
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBytes");
            }
            throw throwable;
        }
    }

    public void writeChar(char c) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeChar");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeChar(c);
                this.recordInteger(this.writeStream.size() - 2, 2);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeChar");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeChar");
            }
            throw throwable;
        }
    }

    public void writeDouble(double d) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeDouble");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeLong(Double.doubleToLongBits(d));
                this.float_values.addElement(new Double(d));
                this.float_offsets.addElement(new Integer(this.writeStream.size() - 8));
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var6_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeDouble");
            }
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeDouble");
            }
            throw throwable;
        }
    }

    public void writeFloat(float f) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeFloat");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeInt(Float.floatToIntBits(f));
                this.float_values.addElement(new Float(f));
                this.float_offsets.addElement(new Integer(this.writeStream.size() - 4));
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeFloat");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeFloat");
            }
            throw throwable;
        }
    }

    public void writeInt(int n) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeInt");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeInt(n);
                this.recordInteger(this.writeStream.size() - 4, 4);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeInt");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeInt");
            }
            throw throwable;
        }
    }

    public void writeLong(long l) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeLong");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeLong(l);
                this.recordInteger(this.writeStream.size() - 8, 8);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var6_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeLong");
            }
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeLong");
            }
            throw throwable;
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeObject");
        }
        try {
            if (object instanceof byte[]) {
                this.writeBytes((byte[])object);
            } else if (object instanceof String) {
                this.writeUTF((String)object);
            } else if (object instanceof Integer) {
                this.writeInt((Integer)object);
            } else if (object instanceof Byte) {
                this.writeByte((Byte)object);
            } else if (object instanceof Short) {
                this.writeShort((Short)object);
            } else if (object instanceof Long) {
                this.writeLong((Long)object);
            } else if (object instanceof Float) {
                this.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Double) {
                this.writeDouble((Double)object);
            } else if (object instanceof Character) {
                this.writeChar(((Character)object).charValue());
            } else if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
            } else {
                if (object == null) {
                    if (JMSMessage.trace != null) {
                        JMSMessage.trace.trace(0, this, "Throwing NullPointerException");
                    }
                    throw new NullPointerException();
                }
                throw this.newMessageFormatException();
            }
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeObject");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeObject");
            }
            throw throwable;
        }
    }

    public void writeShort(short s) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeShort");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeShort(s);
                this.recordInteger(this.writeStream.size() - 2, 2);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeShort");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeShort");
            }
            throw throwable;
        }
    }

    public void writeUTF(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeUTF");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeUTF(string);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                JMSException jMSException = this.newMessageFormatException();
                jMSException.setLinkedException((Exception)uTFDataFormatException);
                throw jMSException;
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var6_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeUTF");
            }
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeUTF");
            }
            throw throwable;
        }
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            try {
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.entry(this, "writeObject");
                }
                try {
                    this.reset();
                }
                catch (JMSException jMSException) {
                    if (JMSMessage.trace != null) {
                        JMSMessage.trace.trace(this, "failed to reset message because of " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception != null) {
                            JMSMessage.trace.trace(this, "linked exception: " + exception);
                        }
                    }
                    throw new IOException("failed to reset BytesMessage for serialization");
                }
                objectOutputStream.defaultWriteObject();
            }
            catch (IOException iOException) {
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.trace(this, "throwing " + iOException);
                }
                throw iOException;
            }
            Object var5_5 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeObject");
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeObject");
            }
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            try {
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.entry(this, "readObject");
                }
                objectInputStream.defaultReadObject();
                try {
                    this.reset();
                }
                catch (JMSException jMSException) {
                    if (JMSMessage.trace != null) {
                        JMSMessage.trace.trace(this, "failed to reset message because of " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception != null) {
                            JMSMessage.trace.trace(this, "linked exception: " + exception);
                        }
                    }
                    throw new IOException("failed to reset BytesMessage for serialisation");
                }
                Object var5_5 = null;
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.exit(this, "readObject");
                }
            }
            catch (IOException iOException) {
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.trace(this, "throwing " + iOException);
                }
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readObject");
            }
            throw throwable;
        }
    }
}

