/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.spi;

import com.ibm.disthubmq.spi.IllegalParameterException;
import com.ibm.disthubmq.spi.Service;
import com.ibm.disthubmq.spi.ServiceNotStartedException;
import com.ibm.disthubmq.spi.ServiceNotStoppedException;
import com.ibm.disthubmq.spi.ServiceNotSuspendedException;
import com.ibm.disthubmq.spi.ServiceStartupException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class StandardServiceImpl
implements Service {
    protected static final int ST_REGISTERED = 1;
    protected static final int ST_STOPPED = 2;
    protected static final int ST_RUNNING = 3;
    protected static final int ST_SUSPENDED = 4;
    protected int state = 1;
    protected boolean lockError = false;
    protected Properties paramSettings = new Properties();

    public void deregister() {
    }

    public synchronized void locked() {
        this.state = 2;
    }

    public synchronized void reset() {
        if (this.lockError) {
            throw new RuntimeException("Illegal reset: service started previously");
        }
        this.state = 1;
    }

    public synchronized void start() throws ServiceNotStoppedException, ServiceStartupException {
        if (this.state != 2) {
            throw new ServiceNotStoppedException();
        }
        this.lockError = true;
        this.state = 3;
    }

    public synchronized void stop() throws ServiceNotStartedException {
        if (this.state == 2) {
            throw new ServiceNotStartedException();
        }
        this.state = 2;
    }

    public synchronized void suspend() throws ServiceNotStartedException {
        if (this.state == 2) {
            throw new ServiceNotStartedException();
        }
        this.state = 4;
    }

    public synchronized void resume() throws ServiceNotSuspendedException {
        if (this.state != 4) {
            throw new ServiceNotSuspendedException();
        }
        this.state = 3;
    }

    protected void verify(Properties properties2, boolean bl) throws IllegalParameterException {
        if (bl) {
            Enumeration enumeration = ((Hashtable)properties2).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (((Hashtable)this.paramSettings).containsKey(string)) continue;
                throw new IllegalParameterException("Unknown parameter: " + string);
            }
        }
    }

    public void setParameter(String string, String string2, boolean bl) throws IllegalParameterException {
        Properties properties2 = this.paramSettings;
        synchronized (properties2) {
            Properties properties3 = (Properties)((Hashtable)this.paramSettings).clone();
            ((Hashtable)properties3).put(string, string2);
            this.verify(properties3, bl);
            ((Hashtable)this.paramSettings).put(string, string2);
        }
    }

    public final void setParameter(String string, String string2) throws IllegalParameterException {
        this.setParameter(string, string2, true);
    }

    public void setParameter(Properties properties2, boolean bl) throws IllegalParameterException {
        Properties properties3 = this.paramSettings;
        synchronized (properties3) {
            String string;
            Object object;
            Properties properties4 = (Properties)((Hashtable)this.paramSettings).clone();
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                string = properties2.getProperty((String)object);
                ((Hashtable)properties4).put(object, string);
            }
            this.verify(properties4, bl);
            object = properties2.propertyNames();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                String string2 = properties2.getProperty(string);
                ((Hashtable)this.paramSettings).put(string, string2);
            }
        }
    }

    public final void setParameter(Properties properties2) throws IllegalParameterException {
        this.setParameter(properties2, true);
    }

    public synchronized String getParameter(String string) throws IllegalParameterException {
        String string2 = this.paramSettings.getProperty(string);
        if (string2 == null) {
            throw new IllegalParameterException("Unknown property: " + string);
        }
        return string2;
    }

    public Properties getParameter() {
        return (Properties)((Hashtable)this.paramSettings).clone();
    }
}

