/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.ReaderReadyI;
import com.ibm.disthubmq.impl.util.SocketThreadPoolClient;
import com.ibm.disthubmq.impl.util.SocketThreadPoolException;
import com.ibm.disthubmq.impl.util.WriterReadyI;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.IOException;
import java.net.Socket;

public abstract class SocketThreadPoolClientHndl
implements ReaderReadyI,
WriterReadyI,
LogConstants,
ExceptionConstants {
    private static final DebugObject debug = new DebugObject("SocketThreadPoolClientHndl");
    public volatile boolean inCulledBlock = false;
    public long activeStamp = -1L;
    protected volatile Socket sock;
    public volatile SocketThreadPoolClient stpc;
    protected DebugObject dbg;
    protected volatile boolean die = false;
    protected volatile boolean deadRead = false;
    protected volatile boolean deadWrite = false;
    protected volatile int inReadIO = 0;
    protected volatile int inWriteIO = 0;
    protected volatile Thread readThread = null;
    protected volatile Thread writeThread = null;

    public abstract void readyToRead() throws SocketThreadPoolException;

    public abstract void readyToWrite() throws SocketThreadPoolException;

    public void enterCulledBlock() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "enterCulledBlock");
        }
        this.inCulledBlock = true;
        this.activeStamp = -1L;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "enterCulledBlock");
        }
    }

    public void exitCulledBlock() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "exitCulledBlock");
        }
        this.inCulledBlock = false;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "exitCulledBlock");
        }
    }

    public SocketThreadPoolClientHndl(Socket socket, SocketThreadPoolClient socketThreadPoolClient, DebugObject debugObject) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SocketThreadPoolClientHndl", socket, socketThreadPoolClient, debugObject);
        }
        this.sock = socket;
        this.stpc = socketThreadPoolClient;
        this.dbg = debugObject;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SocketThreadPoolClientHndl");
        }
    }

    public synchronized void beginRead() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "beingRead");
        }
        if (this.die) {
            throw new IOException(ExceptionBuilder.buildReasonString(1150, null));
        }
        ++this.inReadIO;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "beginRead");
        }
    }

    public synchronized void endRead() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "endRead");
        }
        --this.inReadIO;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "endRead");
        }
    }

    public synchronized void beginWrite() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "endRead");
        }
        if (this.die) {
            throw new IOException(ExceptionBuilder.buildReasonString(1150, null));
        }
        ++this.inWriteIO;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "beginWrite");
        }
    }

    public synchronized void endWrite() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "endWrite");
        }
        --this.inWriteIO;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "endWrite");
        }
    }

    public synchronized void beginRead(Thread thread) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "beginRead", thread);
        }
        if (this.die) {
            throw new IOException(ExceptionBuilder.buildReasonString(1150, null));
        }
        if (this.readThread != null) {
            if (this.readThread != thread) {
                throw new Error(ExceptionBuilder.buildReasonString(1151, new Object[]{thread, this.readThread, this.sock}));
            }
        } else {
            this.readThread = thread;
        }
        ++this.inReadIO;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "beginRead");
        }
    }

    public synchronized void endRead(Thread thread) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "endRead", thread);
        }
        if (this.readThread != thread) {
            throw new Error(ExceptionBuilder.buildReasonString(1151, new Object[]{thread, this.readThread, this.sock}));
        }
        if (--this.inReadIO == 0) {
            this.readThread = null;
            if (this.die) {
                this.deadRead = true;
                this.notifyAll();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "endRead");
        }
    }

    public synchronized void beginWrite(Thread thread) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "beginWrite", thread);
        }
        if (this.die) {
            throw new IOException(ExceptionBuilder.buildReasonString(1150, null));
        }
        if (this.writeThread != null) {
            if (this.writeThread != thread) {
                throw new Error(ExceptionBuilder.buildReasonString(1151, new Object[]{thread, this.writeThread, this.sock}));
            }
        } else {
            this.writeThread = thread;
        }
        ++this.inWriteIO;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "beginWrite");
        }
    }

    public synchronized void endWrite(Thread thread) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "endWrite", thread);
        }
        if (this.writeThread != thread) {
            throw new Error(ExceptionBuilder.buildReasonString(1151, new Object[]{thread, this.writeThread, this.sock}));
        }
        if (--this.inWriteIO == 0) {
            this.writeThread = null;
            if (this.die) {
                this.deadWrite = true;
                this.notifyAll();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "endWrite");
        }
    }

    public synchronized void deregisterClient() throws SocketThreadPoolException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "deregisterClient");
        }
        if (this.die) {
            throw new SocketThreadPoolException(ExceptionBuilder.buildReasonString(1152, null));
        }
        this.die = true;
        boolean bl = false;
        boolean bl2 = false;
        if (!this.deadRead && this.readThread != null && Thread.currentThread() != this.readThread) {
            if (this.inReadIO > 0) {
                try {
                    this.readThread.stop(new IOException(ExceptionBuilder.buildReasonString(1150, null)));
                }
                catch (SecurityException securityException) {
                    this.readThread.stop();
                }
            }
            bl = true;
        }
        if (!this.deadWrite && this.writeThread != null && Thread.currentThread() != this.writeThread) {
            if (this.inWriteIO > 0) {
                try {
                    this.writeThread.stop(new IOException(ExceptionBuilder.buildReasonString(1150, null)));
                }
                catch (SecurityException securityException) {
                    this.writeThread.stop();
                }
            }
            bl2 = true;
        }
        if (this.dbg.debugIt(8)) {
            this.dbg.debug(-175921860444057L, "readKiller=", String.valueOf(bl), "writeKiller=", String.valueOf(bl2));
        }
        if (bl || bl2) {
            long l = 1000L;
            long l2 = System.currentTimeMillis() + l;
            while (bl && !this.deadRead || bl2 && !this.deadWrite) {
                l = l2 - System.currentTimeMillis();
                if (l > 0L) {
                    try {
                        this.wait(l);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                SocketThreadPoolException socketThreadPoolException = new SocketThreadPoolException((bl && !this.deadRead ? "doRead() did not die. " : "") + (bl2 && !this.deadWrite ? "doWrite() did not die. " : ""));
                if (this.dbg.debugIt(2)) {
                    this.dbg.debug(-175921860444059L, socketThreadPoolException);
                }
                throw socketThreadPoolException;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "deregisterClient");
        }
    }
}

