/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.SegmentLengthException;
import com.ibm.disthubmq.impl.util.SegmentReader;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SimplestSegmentReader
extends SegmentReader
implements LogConstants,
ExceptionConstants {
    private static final DebugObject debug = new DebugObject("SimplestSegmentReader");
    InputStream ins;
    byte[] b;

    public SimplestSegmentReader(InputStream inputStream, int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SimplestSegmentReader", inputStream, new Integer(n));
        }
        this.ins = inputStream;
        this.segpay = n;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SimplestSegmentReader");
        }
    }

    public SimplestSegmentReader(InputStream inputStream) {
        this(inputStream, 100);
    }

    public void prepGet(byte[] byArray) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "prepGet", byArray);
        }
        this.b = byArray;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "prepGet");
        }
    }

    public byte[] get() throws IOException {
        int n;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "get");
        }
        if (this.b == null || this.b.length < this.segpay + 6) {
            this.b = new byte[this.segpay + 6];
        }
        try {
            this.readFully(this.b, 0, 6);
        }
        catch (EOFException eOFException) {
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "get", null);
            }
            return null;
        }
        if (this.magic != 0 && (n = (int)(((0xFF & this.b[0]) << 8) + (0xFF & this.b[1]))) != this.magic) {
            throw new IOException(ExceptionBuilder.buildReasonString(1146, new Object[]{Integer.toHexString(n), Integer.toHexString(this.magic)}));
        }
        n = ((0xFF & this.b[2]) << 24) + ((0xFF & this.b[3]) << 16) + ((0xFF & this.b[4]) << 8) + (0xFF & this.b[5]);
        if (n > this.segmax || n < 0) {
            SegmentLengthException segmentLengthException = new SegmentLengthException(ExceptionBuilder.buildReasonString(1147, new Object[]{new Integer(n), new Integer(this.segmax)}));
            segmentLengthException.setSegmentSize(n);
            segmentLengthException.setSegmentMaximum(this.segmax);
            throw segmentLengthException;
        }
        if (this.b.length < n + 6) {
            byte[] byArray = new byte[n + 6];
            System.arraycopy(this.b, 0, byArray, 0, 6);
            this.b = byArray;
        }
        try {
            this.readFully(this.b, 6, n);
        }
        catch (EOFException eOFException) {
            throw new IOException(ExceptionBuilder.buildReasonString(1148, new Object[]{eOFException}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "get", this.b);
        }
        return this.b;
    }

    private final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readFully", byArray, new Integer(n), new Integer(n2));
        }
        while (n2 > 0) {
            int n3 = this.ins.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException(ExceptionBuilder.buildReasonString(1149, null));
            }
            n += n3;
            n2 -= n3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readFully");
        }
    }

    public void close() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close");
        }
        this.ins.close();
        this.b = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }
}

