/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.Queue;
import com.ibm.disthubmq.impl.util.RealDispatcher;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;

public class SafeDispatchQueue
implements Runnable,
LogConstants,
ExceptionConstants {
    private static final DebugObject debug = new DebugObject("SafeDispatchQueue");
    RealDispatcher dispatcher;
    private Thread theThread;
    private volatile boolean blocked;
    private transient boolean alive;
    private Queue q;

    public SafeDispatchQueue(RealDispatcher realDispatcher) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SafeDispatchQueue", realDispatcher);
        }
        this.dispatcher = realDispatcher;
        this.theThread = null;
        this.blocked = false;
        this.alive = true;
        this.q = new Queue();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SafeDispatchQueue");
        }
    }

    public synchronized void enqueue(Object object) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "enqueue", object);
        }
        this.q.enqueue(object);
        this.notify();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "enqueue");
        }
    }

    private synchronized Object dequeue() throws InterruptedException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "dequeue");
        }
        while (this.q.isEmpty()) {
            Object var2_1;
            if (!this.alive) {
                throw new InterruptedException(ExceptionBuilder.buildReasonString(1140, null));
            }
            this.blocked = true;
            try {
                this.wait();
                var2_1 = null;
                this.blocked = false;
            }
            catch (Throwable throwable) {
                var2_1 = null;
                this.blocked = false;
                throw throwable;
            }
        }
        Object object = null;
        if (!this.q.isEmpty()) {
            object = this.q.dequeue();
        } else {
            Assert.failure();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "dequeue", object);
        }
        return object;
    }

    public void run() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "run");
        }
        try {
            this.theThread = Thread.currentThread();
            while (this.alive) {
                try {
                    Object object = this.dequeue();
                    try {
                        this.dispatcher.dispatch(object);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "run");
        }
    }

    public synchronized void close() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close");
        }
        this.alive = false;
        if (this.blocked) {
            if (this.theThread != null) {
                this.theThread.interrupt();
            }
            this.theThread = null;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }
}

