/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import java.util.NoSuchElementException;

public class Queue
implements ExceptionConstants {
    public String name = null;
    public int dump_limit = 4;
    private static int ic = 0;
    protected volatile Object[] m_array;
    protected volatile int m_head = 0;
    protected volatile int m_tail = 0;
    private static final DebugObject debug = new DebugObject("Queue");

    public Queue() {
        this.m_array = new Object[4];
    }

    public Queue(int n) {
        if (n < 1) {
            n = 3;
        }
        this.m_array = new Object[n + 1];
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = "Queue_" + ++ic;
        return this.name;
    }

    public Queue(int n, String string) {
        this(n);
        this.name = string;
    }

    public final boolean isEmpty() {
        return this.m_head == this.m_tail;
    }

    public final void makeEmpty() {
        this.m_head = this.m_tail;
    }

    public final int size() {
        return this.m_tail >= this.m_head ? this.m_tail - this.m_head : this.m_array.length - this.m_head + this.m_tail;
    }

    public final Object enqueue(Object object) {
        this.m_array[this.m_tail++] = object;
        if (this.m_tail == this.m_array.length) {
            this.m_tail = 0;
        }
        if (this.m_head == this.m_tail) {
            this.expand_array();
        }
        return object;
    }

    public final boolean enqueueWasEmpty(Object object) {
        boolean bl = this.m_head == this.m_tail;
        this.m_array[this.m_tail++] = object;
        if (this.m_tail == this.m_array.length) {
            this.m_tail = 0;
        }
        if (this.m_head == this.m_tail) {
            this.expand_array();
        }
        return bl;
    }

    public final Object dequeue() throws NoSuchElementException {
        if (this.m_head == this.m_tail) {
            throw new NoSuchElementException(ExceptionBuilder.buildReasonString(1139, null));
        }
        Object object = this.m_array[this.m_head];
        this.m_array[this.m_head++] = null;
        if (this.m_head == this.m_array.length) {
            this.m_head = 0;
        }
        return object;
    }

    public final Object dequeueOrNull() {
        if (this.m_head == this.m_tail) {
            return null;
        }
        Object object = this.m_array[this.m_head];
        this.m_array[this.m_head++] = null;
        if (this.m_head == this.m_array.length) {
            this.m_head = 0;
        }
        return object;
    }

    public final Object enqueueAndDequeue(Object object) {
        if (this.m_head == this.m_tail) {
            return object;
        }
        Object object2 = this.m_array[this.m_head];
        this.m_array[this.m_head++] = null;
        if (this.m_head == this.m_array.length) {
            this.m_head = 0;
        }
        this.m_array[this.m_tail++] = object;
        if (this.m_tail == this.m_array.length) {
            this.m_tail = 0;
        }
        return object2;
    }

    public final Object pop() throws NoSuchElementException {
        if (this.m_head == this.m_tail) {
            throw new NoSuchElementException(ExceptionBuilder.buildReasonString(1139, null));
        }
        if (this.m_tail == 0) {
            this.m_tail = this.m_array.length;
        }
        --this.m_tail;
        Object object = this.m_array[this.m_tail];
        this.m_array[this.m_tail] = null;
        return object;
    }

    public final Object popOrNull() {
        if (this.m_head == this.m_tail) {
            return null;
        }
        if (this.m_tail == 0) {
            this.m_tail = this.m_array.length;
        }
        --this.m_tail;
        Object object = this.m_array[this.m_tail];
        this.m_array[this.m_tail] = null;
        return object;
    }

    public final Object peek() throws NoSuchElementException {
        if (this.m_head == this.m_tail) {
            throw new NoSuchElementException(ExceptionBuilder.buildReasonString(1139, null));
        }
        return this.m_array[this.m_head];
    }

    public String toString() {
        Object object = null;
        int n = this.m_head;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.m_head <= this.m_tail ? this.m_tail : this.m_array.length;
        String string = "[" + this.getName() + ' ' + this.size() + ':';
        while (n < n4) {
            if (n3++ > this.dump_limit) {
                return string + " ...]";
            }
            object = this.m_array[n++];
            string = string + " " + (object == null ? "null" : object.toString());
        }
        if (n4 == this.m_array.length) {
            while (n2 < this.m_tail) {
                if (n3++ > this.dump_limit) {
                    return string + " ...]";
                }
                object = this.m_array[n2++];
                string = string + " " + (object == null ? "null" : object.toString());
            }
        }
        if (this.m_head != this.m_tail) {
            string = string + " ";
        }
        return string + "]";
    }

    private final void expand_array() {
        int n = this.m_array.length;
        Object[] objectArray = new Object[n * 2];
        System.arraycopy(this.m_array, this.m_head, objectArray, this.m_head, n - this.m_head);
        System.arraycopy(this.m_array, 0, objectArray, n, this.m_tail);
        this.m_tail += n;
        this.m_array = objectArray;
    }
}

