/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.EnumList;
import com.ibm.disthubmq.impl.util.ListItem;
import java.util.Dictionary;
import java.util.Enumeration;

public class LongHashTable
extends Dictionary
implements Cloneable {
    private static final DebugObject debug = new DebugObject("LongHashTable");
    private static final int INITIAL_CAPACITY = 101;
    private static final float LOAD_FACTOR = 0.75f;
    private static int m_init_capacity;
    public int m_capacity;
    private float m_loadfactor;
    private int m_ceiling;
    private int size = 0;
    public ListItem[] HTab;
    private ListItem recycle_bin;
    private int recycle_length = 0;

    public LongHashTable() {
        this(101, 0.75f);
    }

    public LongHashTable(int n) {
        this(n, 0.75f);
    }

    public LongHashTable(int n, float f) {
        m_init_capacity = this.m_capacity = this.findPower(n);
        this.m_loadfactor = f;
        this.m_ceiling = (int)((float)this.m_capacity * this.m_loadfactor);
        this.HTab = new ListItem[this.m_capacity];
    }

    public void clear() {
        ListItem[] listItemArray = this.HTab;
        int n = 0;
        while (n < this.m_capacity) {
            listItemArray[n] = null;
            ++n;
        }
        this.HTab = listItemArray;
        this.size = 0;
    }

    public Object clone() {
        LongHashTable longHashTable = new LongHashTable(this.m_capacity, this.m_loadfactor);
        ListItem[] listItemArray = new ListItem[this.m_capacity];
        int n = 0;
        while (n < this.m_capacity) {
            ListItem listItem = this.HTab[n];
            listItemArray[n] = (ListItem)(listItem != null ? listItem.clone() : null);
            ++n;
        }
        longHashTable.HTab = listItemArray;
        longHashTable.size = this.size;
        return longHashTable;
    }

    public boolean contains(Object object) {
        int n = 0;
        while (n < this.m_capacity) {
            ListItem listItem;
            ListItem listItem2 = listItem = this.HTab[n];
            while (listItem2 != null) {
                if (listItem2.data.equals(object)) {
                    return true;
                }
                listItem2 = listItem2.next;
            }
            ++n;
        }
        return false;
    }

    public boolean containsKey(long l) {
        return this.get(l) != null;
    }

    public boolean containsKey(int n) {
        return this.containsKey((long)n);
    }

    public boolean containsKey(Object object) {
        return this.containsKey(object.hashCode());
    }

    public Enumeration elements() {
        return new EnumList(this, false);
    }

    public Object get(long l) {
        int n = (int)((l >>> 32 ^ l) & (long)(this.m_capacity - 1));
        ListItem listItem = this.HTab[n];
        listItem = this.HTab[n];
        while (listItem != null) {
            if (listItem.keysMatch(l)) {
                return listItem.data;
            }
            listItem = listItem.next;
        }
        return null;
    }

    public Object get(int n) {
        return this.get((long)n);
    }

    public Object get(Object object) {
        return this.get(object.hashCode());
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration keys() {
        return new EnumList(this, true);
    }

    public Object put(long l, Object object) {
        if (this.size > this.m_ceiling) {
            int n = this.m_capacity;
            this.m_capacity <<= 1;
            this.m_ceiling = (int)((float)this.m_capacity * this.m_loadfactor);
            this.rehash(n);
            return this.put(l, object);
        }
        int n = (int)((l >>> 32 ^ l) & (long)(this.m_capacity - 1));
        ListItem listItem = this.HTab[n];
        if (listItem == null) {
            this.HTab[n] = this.recycleCreate(l, null, object);
            ++this.size;
            return null;
        }
        ListItem listItem2 = listItem;
        while (listItem2 != null) {
            if (listItem2.keysMatch(l)) {
                Object object2 = listItem2.data;
                listItem2.data = object;
                return object2;
            }
            listItem2 = listItem2.next;
        }
        this.HTab[n] = this.recycleCreate(l, listItem, object);
        ++this.size;
        return null;
    }

    public Object put(int n, Object object) {
        return this.put((long)n, object);
    }

    public Object put(Object object, Object object2) {
        return this.put(object.hashCode(), object2);
    }

    public Object remove(long l) {
        if (this.size < this.m_ceiling / 4 && this.size >= m_init_capacity << 1) {
            int n = this.m_capacity;
            this.m_capacity >>= 1;
            this.m_ceiling = (int)((float)this.m_capacity * this.m_loadfactor);
            this.rehash(n);
            return this.remove(l);
        }
        int n = (int)((l >>> 32 ^ l) & (long)(this.m_capacity - 1));
        ListItem listItem = null;
        ListItem listItem2 = this.HTab[n];
        while (listItem2 != null) {
            if (listItem2.keysMatch(l)) {
                if (listItem == null) {
                    this.HTab[n] = listItem2.next;
                } else {
                    listItem.next = listItem2.next;
                }
                --this.size;
                if (this.recycle_length < this.size / 8) {
                    listItem2.next = this.recycle_bin;
                    this.recycle_bin = listItem2;
                    ++this.recycle_length;
                }
                return listItem2.data;
            }
            listItem = listItem2;
            listItem2 = listItem2.next;
        }
        return null;
    }

    public Object remove(int n) {
        return this.remove((long)n);
    }

    public Object remove(Object object) {
        return this.remove(object.hashCode());
    }

    public final void view() {
        int n = 0;
        while (n < this.m_capacity) {
            System.out.print("\nBucket " + n + ":");
            ListItem listItem = this.HTab[n];
            while (listItem != null) {
                System.out.print(" " + listItem.key);
                listItem = listItem.next;
            }
            ++n;
        }
        System.out.println("\nSize = " + this.size + "\n");
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        EnumList enumList = (EnumList)this.keys();
        EnumList enumList2 = (EnumList)this.elements();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < this.size()) {
            stringBuffer.append(enumList.nextElement());
            stringBuffer.append("=");
            stringBuffer.append(enumList2.nextElement());
            stringBuffer.append(n == this.size() - 1 ? "}" : ", ");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void rehash(int n) {
        ListItem[] listItemArray = this.HTab;
        ListItem[] listItemArray2 = new ListItem[this.m_capacity];
        this.HTab = listItemArray2;
        int n2 = 0;
        while (n2 < n) {
            ListItem listItem = listItemArray[n2];
            while (listItem != null) {
                ListItem listItem2 = listItem;
                listItem = listItem.next;
                long l = listItem2.key;
                int n3 = (int)((l >>> 32 ^ l) & (long)(this.m_capacity - 1));
                listItem2.next = listItemArray2[n3];
                listItemArray2[n3] = listItem2;
            }
            ++n2;
        }
    }

    private int findPower(int n) {
        int n2 = 2;
        while ((n2 *= 2) < n) {
        }
        return n2;
    }

    private ListItem recycleCreate(long l, ListItem listItem, Object object) {
        if (this.recycle_bin != null) {
            ListItem listItem2 = this.recycle_bin;
            this.recycle_bin = this.recycle_bin.next;
            --this.recycle_length;
            listItem2.key = l;
            listItem2.next = listItem;
            listItem2.data = object;
            return listItem2;
        }
        return new ListItem(l, listItem, object);
    }
}

