/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.DebugObject;

public class FloatTable {
    private static final DebugObject debug = new DebugObject("FloatTable");
    double delta;
    Node head = null;
    int listSize = 0;

    public FloatTable(double d) {
        this.delta = d;
        this.listSize = 0;
    }

    public void put(double d, Object object) {
        if (this.head == null) {
            this.head = new Node();
            this.head.value = d;
            this.head.obj = object;
            this.head.next = null;
            ++this.listSize;
            return;
        }
        Node node = this.head;
        while (node != null) {
            if (this.compare(d, node.value)) {
                node.obj = object;
                return;
            }
            node = node.next;
        }
        node = new Node();
        node.value = d;
        node.obj = object;
        node.next = this.head;
        ++this.listSize;
        this.head = node;
    }

    public Object get(double d) {
        Node node = this.head;
        while (node != null) {
            if (this.compare(d, node.value)) {
                return node.obj;
            }
            node = node.next;
        }
        return null;
    }

    public Object remove(double d) {
        Node node = null;
        if (this.head == null) {
            return null;
        }
        if (this.compare(d, this.head.value)) {
            node = this.head;
            this.head = this.head.next;
            node.next = null;
            --this.listSize;
            return node.obj;
        }
        node = this.head;
        while (node.next != null) {
            if (this.compare(d, node.next.value)) {
                Node node2 = node.next;
                node.next = node2.next;
                node2.next = null;
                --this.listSize;
                return node2.obj;
            }
            node = node.next;
        }
        return null;
    }

    public int size() {
        return this.listSize;
    }

    public boolean compare(double d, double d2) {
        return Math.abs(d - d2) <= Math.abs(this.delta * d);
    }

    class Node {
        double value;
        Object obj;
        Node next;

        Node() {
        }
    }
}

