/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.TypeSafeVector;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class FastVector
implements Cloneable,
Serializable,
ExceptionConstants {
    private static final DebugObject debug = new DebugObject("FastVector");
    public Object[] m_data;
    public int m_count;

    public FastVector(int n) {
        this.m_data = new Object[n];
    }

    public FastVector() {
        this(8);
    }

    public FastVector(Vector vector) {
        try {
            this.m_data = new Object[vector.size()];
            vector.copyInto(this.m_data);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.m_count = vector.size();
    }

    public void addElement(Object object) {
        if (this.m_data.length == this.m_count) {
            Object[] objectArray = new Object[this.m_data.length << 1];
            System.arraycopy(this.m_data, 0, objectArray, 0, this.m_count);
            this.m_data = objectArray;
        }
        this.m_data[this.m_count++] = object;
    }

    public int addElementI(Object object) {
        if (this.m_data.length == this.m_count) {
            Object[] objectArray = new Object[this.m_data.length << 1];
            System.arraycopy(this.m_data, 0, objectArray, 0, this.m_count);
            this.m_data = objectArray;
        }
        this.m_data[this.m_count] = object;
        return this.m_count++;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.m_count];
        System.arraycopy(this.m_data, 0, objectArray, 0, this.m_count);
        return objectArray;
    }

    public Object clone() {
        FastVector fastVector = null;
        try {
            fastVector = (FastVector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        fastVector.m_data = new Object[this.m_count];
        System.arraycopy(this.m_data, 0, fastVector.m_data, 0, this.m_count);
        return fastVector;
    }

    public Vector makeVector() {
        Vector<Object> vector = new Vector<Object>(this.m_count);
        try {
            int n = 0;
            while (n < this.m_count) {
                vector.addElement(this.m_data[n]);
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
        return vector;
    }

    public TypeSafeVector makeTypeSafeVector(String string) {
        TypeSafeVector typeSafeVector = new TypeSafeVector(string, this.m_count);
        try {
            int n = 0;
            while (n < this.m_count) {
                typeSafeVector.setElementAt(this.m_data[n], n);
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return typeSafeVector;
    }

    public void append(FastVector fastVector) {
        if (fastVector.m_count == 0) {
            return;
        }
        int n = this.m_data.length;
        while (fastVector.m_count + this.m_count >= n) {
            n <<= 1;
        }
        if (n != this.m_data.length) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.m_data, 0, objectArray, 0, this.m_count);
            this.m_data = objectArray;
        }
        System.arraycopy(fastVector.m_data, 0, this.m_data, this.m_count, fastVector.m_count);
        this.m_count += fastVector.m_count;
    }

    public void removeElementAt(int n) {
        System.arraycopy(this.m_data, n + 1, this.m_data, n, this.m_count - n - 1);
        --this.m_count;
    }

    public Object dropElementAt(int n) {
        int n2 = this.m_count - 1;
        this.m_data[n] = this.m_data[n2];
        this.m_data[n2] = null;
        this.m_count = n2;
        return this.m_data[n];
    }

    public void reset() {
        this.m_count = 0;
    }

    public final int indexOf(Object object) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_count) {
            if (this.m_data[n2].equals(object)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public final Object elementAt(int n) throws ArrayIndexOutOfBoundsException {
        if (n >= this.m_count) {
            throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1309, new Object[]{new Integer(n)}));
        }
        return this.m_data[n];
    }

    public final int size() {
        return this.m_count;
    }

    public final boolean contains(Object object) {
        boolean bl = this.indexOf(object) != -1;
        return bl;
    }

    public final Enumeration elements() {
        return new FastVectorEnumeration(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        if (this.m_count >= 1) {
            stringBuffer.append(this.m_data[0].toString());
        }
        int n = 1;
        while (n < this.m_count) {
            stringBuffer.append(", " + this.m_data[n].toString());
            ++n;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public class FastVectorEnumeration
    implements Enumeration {
        FastVector v;
        int index = 0;

        public FastVectorEnumeration(FastVector fastVector2) {
            this.v = (FastVector)fastVector2.clone();
        }

        public boolean hasMoreElements() {
            return this.index < this.v.m_count;
        }

        public Object nextElement() {
            Object object = this.v.elementAt(this.index);
            ++this.index;
            return object;
        }
    }
}

