/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.FastHashtableEntry;
import com.ibm.disthubmq.impl.util.FastHashtableEnumerator;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;

public class FastHashtable
extends Dictionary
implements Cloneable,
Serializable,
ExceptionConstants {
    private transient FastHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private RehashFilter filter;
    private static final long serialVersionUID = 1421746759512286392L;

    public FastHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1136, new Object[]{new Integer(n), new Float(f)}));
        }
        this.loadFactor = f;
        this.table = new FastHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public FastHashtable(int n) {
        this(n, 0.75f);
    }

    public FastHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new FastHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new FastHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException(ExceptionBuilder.buildReasonString(1130, new Object[]{"value"}));
        }
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = fastHashtableEntryArray.length;
        while (n-- > 0) {
            FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n];
            while (fastHashtableEntry != null) {
                if (fastHashtableEntry.value.equals(object)) {
                    return true;
                }
                fastHashtableEntry = fastHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.hash == n && fastHashtableEntry.key.equals(object)) {
                return true;
            }
            fastHashtableEntry = fastHashtableEntry.next;
        }
        return false;
    }

    public Object get(Object object) {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.hash == n && fastHashtableEntry.key.equals(object)) {
                return fastHashtableEntry.value;
            }
            fastHashtableEntry = fastHashtableEntry.next;
        }
        return null;
    }

    public Object get(Object object, int n) {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.hash == n && fastHashtableEntry.key.equals(object)) {
                return fastHashtableEntry.value;
            }
            fastHashtableEntry = fastHashtableEntry.next;
        }
        return null;
    }

    public void setRehashFilter(RehashFilter rehashFilter) {
        this.filter = rehashFilter;
    }

    private boolean ableToFilter() {
        if (this.filter == null) {
            return false;
        }
        int n = this.table.length;
        while (n-- > 0) {
            FastHashtableEntry fastHashtableEntry = null;
            FastHashtableEntry fastHashtableEntry2 = null;
            FastHashtableEntry fastHashtableEntry3 = this.table[n];
            while (fastHashtableEntry3 != null) {
                fastHashtableEntry2 = fastHashtableEntry3.next;
                if (this.filter.shouldRetain(fastHashtableEntry3.key, fastHashtableEntry3.value)) {
                    fastHashtableEntry3.next = fastHashtableEntry;
                    fastHashtableEntry = fastHashtableEntry3;
                } else {
                    --this.count;
                }
                fastHashtableEntry3 = fastHashtableEntry2;
            }
            this.table[n] = fastHashtableEntry;
        }
        return this.count < this.threshold;
    }

    protected void rehash() {
        if (this.ableToFilter()) {
            return;
        }
        int n = this.table.length;
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        FastHashtableEntry[] fastHashtableEntryArray2 = new FastHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        int n3 = n;
        while (n3-- > 0) {
            FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n3];
            while (fastHashtableEntry != null) {
                FastHashtableEntry fastHashtableEntry2 = fastHashtableEntry;
                fastHashtableEntry = fastHashtableEntry.next;
                int n4 = (fastHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                fastHashtableEntry2.next = fastHashtableEntryArray2[n4];
                fastHashtableEntryArray2[n4] = fastHashtableEntry2;
            }
        }
        this.table = fastHashtableEntryArray2;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException(ExceptionBuilder.buildReasonString(1130, new Object[]{"value"}));
        }
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.hash == n && fastHashtableEntry.key.equals(object)) {
                Object object3 = fastHashtableEntry.value;
                fastHashtableEntry.value = object2;
                return object3;
            }
            fastHashtableEntry = fastHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        FastHashtableEntry fastHashtableEntry2 = new FastHashtableEntry();
        fastHashtableEntry2.hash = n;
        fastHashtableEntry2.key = object;
        fastHashtableEntry2.value = object2;
        fastHashtableEntry2.next = fastHashtableEntryArray[n2];
        fastHashtableEntryArray[n2] = fastHashtableEntry2;
        ++this.count;
        return null;
    }

    public Object put(Object object, int n, Object object2) {
        if (object2 == null) {
            throw new NullPointerException(ExceptionBuilder.buildReasonString(1130, new Object[]{"value"}));
        }
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.hash == n && fastHashtableEntry.key.equals(object)) {
                Object object3 = fastHashtableEntry.value;
                fastHashtableEntry.value = object2;
                return object3;
            }
            fastHashtableEntry = fastHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        FastHashtableEntry fastHashtableEntry2 = new FastHashtableEntry();
        fastHashtableEntry2.hash = n;
        fastHashtableEntry2.key = object;
        fastHashtableEntry2.value = object2;
        fastHashtableEntry2.next = fastHashtableEntryArray[n2];
        fastHashtableEntryArray[n2] = fastHashtableEntry2;
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        FastHashtableEntry fastHashtableEntry2 = null;
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.hash == n && fastHashtableEntry.key.equals(object)) {
                if (fastHashtableEntry2 != null) {
                    fastHashtableEntry2.next = fastHashtableEntry.next;
                } else {
                    fastHashtableEntryArray[n2] = fastHashtableEntry.next;
                }
                --this.count;
                return fastHashtableEntry.value;
            }
            fastHashtableEntry2 = fastHashtableEntry;
            fastHashtableEntry = fastHashtableEntry.next;
        }
        return null;
    }

    public void clear() {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = fastHashtableEntryArray.length;
        while (--n >= 0) {
            fastHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            FastHashtable fastHashtable = (FastHashtable)super.clone();
            fastHashtable.table = new FastHashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                FastHashtableEntry fastHashtableEntry = fastHashtable.table[n] = this.table[n] != null ? (FastHashtableEntry)this.table[n].clone() : null;
            }
            return fastHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Assert.failureError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            FastHashtableEntry fastHashtableEntry = this.table[n];
            while (fastHashtableEntry != null) {
                objectOutputStream.writeObject(fastHashtableEntry.key);
                objectOutputStream.writeObject(fastHashtableEntry.value);
                fastHashtableEntry = fastHashtableEntry.next;
            }
            --n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new FastHashtableEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    public static interface RehashFilter {
        public boolean shouldRetain(Object var1, Object var2);
    }
}

