/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.DebugHandle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DebugState {
    private static Hashtable debug_tab = new Hashtable();
    private static Hashtable debugRegistry = new Hashtable();

    public static int register(DebugHandle debugHandle) {
        return DebugState.registerPrivate(debugHandle);
    }

    public static int register(DebugObject debugObject) {
        return DebugState.registerPrivate(debugObject);
    }

    private static int registerPrivate(Object object) {
        Hashtable hashtable = debugRegistry;
        synchronized (hashtable) {
            String string = DebugState.getFirstToken(object.toString());
            if (!debugRegistry.containsKey(string)) {
                debugRegistry.put(string, new Hashtable());
            }
            ((Hashtable)debugRegistry.get(string)).put(object, object);
            if (debug_tab.containsKey(string) || debug_tab.containsKey("*")) {
                int n = BaseConfig.DEBUG_LEVEL;
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public static void deregister(DebugHandle debugHandle) {
        DebugState.deregisterPrivate(debugHandle);
    }

    public static void deregister(DebugObject debugObject) {
        DebugState.deregisterPrivate(debugObject);
    }

    private static void deregisterPrivate(Object object) {
        Hashtable hashtable = debugRegistry;
        synchronized (hashtable) {
            String string = DebugState.getFirstToken(object.toString());
            if (debugRegistry.containsKey(string)) {
                Hashtable hashtable2 = (Hashtable)debugRegistry.get(string);
                hashtable2.remove(object);
                if (hashtable2.size() == 0) {
                    debugRegistry.remove(string);
                }
            }
        }
    }

    public static synchronized void update() {
        Hashtable hashtable = debugRegistry;
        synchronized (hashtable) {
            DebugState.setAllMask(0);
            Assert.condition(BaseConfig.DEBUG_NAME != null);
            String string = BaseConfig.DEBUG_NAME;
            debug_tab = new Hashtable();
            if (string.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    debug_tab.put(string2, string2);
                }
            }
            DebugState.setAllMask(BaseConfig.DEBUG_LEVEL);
        }
    }

    private static void setAllMask(int n) {
        if (debug_tab.containsKey("*")) {
            Enumeration enumeration = debugRegistry.keys();
            while (enumeration.hasMoreElements()) {
                DebugState.setElementsMask((Hashtable)debugRegistry.get(enumeration.nextElement()), n);
            }
        } else {
            Enumeration enumeration = debug_tab.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (!debugRegistry.containsKey(k)) continue;
                DebugState.setElementsMask((Hashtable)debugRegistry.get(k), n);
            }
        }
    }

    private static void setElementsMask(Hashtable hashtable, int n) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof DebugHandle) {
                ((DebugHandle)v).setMask(n);
                continue;
            }
            if (v instanceof DebugObject) {
                ((DebugObject)v).setMask(n);
                continue;
            }
            Assert.condition(false);
        }
    }

    private static String getFirstToken(String string) {
        int n = string.indexOf(32);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }
}

