/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.util;

import com.ibm.disthubmq.impl.client.DebugObject;

public class ArrayUtil {
    private static final int ZEROES_LEN = 500;
    private static byte[] zeroes = new byte[500];
    private static final DebugObject debug = new DebugObject("ArrayUtil");

    private ArrayUtil() {
    }

    public static void clear(byte[] byArray) {
        ArrayUtil.clear(byArray, 0, byArray.length);
    }

    public static void clear(byte[] byArray, int n, int n2) {
        if (n2 <= 500) {
            System.arraycopy(zeroes, 0, byArray, n, n2);
        } else {
            System.arraycopy(zeroes, 0, byArray, n, 500);
            int n3 = n2 / 2;
            int n4 = 500;
            while (n4 < n2) {
                System.arraycopy(byArray, n, byArray, n + n4, n4 <= n3 ? n4 : n2 - n4);
                n4 += n4;
            }
        }
    }

    public static long readLong(byte[] byArray, int n) {
        long l = ((long)byArray[n++] & 0xFFL) << 56;
        l |= ((long)byArray[n++] & 0xFFL) << 48;
        l |= ((long)byArray[n++] & 0xFFL) << 40;
        l |= ((long)byArray[n++] & 0xFFL) << 32;
        l |= ((long)byArray[n++] & 0xFFL) << 24;
        l |= ((long)byArray[n++] & 0xFFL) << 16;
        l |= ((long)byArray[n++] & 0xFFL) << 8;
        return l |= (long)byArray[n] & 0xFFL;
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >>> 56);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 8);
        byArray[n] = (byte)l;
    }

    public static int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 24;
        n2 |= (byArray[n++] & 0xFF) << 16;
        n2 |= (byArray[n++] & 0xFF) << 8;
        return n2 |= byArray[n] & 0xFF;
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >>> 24);
        byArray[n++] = (byte)(n2 >>> 16);
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n] = (byte)n2;
    }

    public static short readShort(byte[] byArray, int n) {
        int n2 = byArray[n++] << 8;
        return (short)(n2 |= byArray[n] & 0xFF);
    }

    public static void writeShort(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)(s >>> 8);
        byArray[n] = (byte)s;
    }

    public static String getString(byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        return new String(byArray, n + 1, n2);
    }

    public static int toInt(short s, short s2) {
        return s & 0xFFFF | s2 << 16;
    }

    public static short toShort(byte by, byte by2) {
        return (short)(by & 0xFF | by2 << 8);
    }

    public static byte[] toBytes(int n) {
        byte[] byArray = new byte[4];
        ArrayUtil.writeInt(byArray, 0, n);
        return byArray;
    }

    public static byte[] toBytes(short[] sArray, int n, int n2) {
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            byArray[n3++] = (byte)(sArray[n4] >>> 8 & 0xFF);
            byArray[n3++] = (byte)(sArray[n4] & 0xFF);
            ++n4;
        }
        return byArray;
    }

    public static byte[] toBytes(short[] sArray) {
        return ArrayUtil.toBytes(sArray, 0, sArray.length);
    }

    public static short[] toShorts(byte[] byArray, int n, int n2) {
        short[] sArray = new short[n2 / 2];
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2 - 1) {
            sArray[n3++] = (short)((byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF);
            n4 += 2;
        }
        return sArray;
    }

    public static short[] toShorts(byte[] byArray) {
        return ArrayUtil.toShorts(byArray, 0, byArray.length);
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (n != nArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int compared(byte[] byArray, byte[] byArray2, boolean bl) {
        int n = byArray.length;
        if (n < byArray2.length) {
            return -1;
        }
        if (n > byArray2.length) {
            return 1;
        }
        if (bl) {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = byArray[n2] & 0xFF;
                int n4 = byArray2[n2] & 0xFF;
                if (n3 < n4) {
                    return -1;
                }
                if (n3 > n4) {
                    return 1;
                }
                --n2;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                int n6 = byArray[n5] & 0xFF;
                int n7 = byArray2[n5] & 0xFF;
                if (n6 < n7) {
                    return -1;
                }
                if (n6 > n7) {
                    return 1;
                }
                ++n5;
            }
        }
        return 0;
    }

    public static boolean isText(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 < 32 || n3 > 127) {
                switch (n3) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 26: 
                    case 27: 
                    case 155: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ++n2;
        }
        return true;
    }
}

