/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.security;

import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.security.CryptoInstantiationException;
import com.ibm.disthubmq.impl.security.MessageProtection;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.Hex;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.LogConstants;
import com.ibm.disthubmq.spi.Principal;

public class SecurityContext
implements Cloneable,
LogConstants,
ClientExceptionConstants {
    private static final DebugObject debug = new DebugObject("SecurityContext");
    public boolean useQOP;
    private Principal m_principal;
    private int m_clientId;
    private boolean m_isClientIdValid;
    private byte[] m_masterSecret;
    private int[][] serverMACKey = null;
    private int[][] clientMACKey = null;
    private Object serverEDKey = null;
    private Object clientEDKey = null;
    private MessageProtection mp;
    private static final byte[] serverMAC_KM = "Auth-Server".getBytes();
    private static final byte[] clientMAC_KM = "Auth-Client".getBytes();
    private static final byte[] serverED_KM = "Encrypt-Server".getBytes();
    private static final byte[] clientED_KM = "Encrypt-Client".getBytes();
    private long sendIntegrityCounter = 1L;
    private long receiveIntegrityCounter = 1L;
    private byte[] encryptIV;
    private byte[] decryptIV;

    public SecurityContext(Principal principal, byte[] byArray, boolean bl) throws CryptoInstantiationException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SecurityContext", principal, byArray, new Boolean(bl));
        }
        this.m_principal = principal;
        this.m_isClientIdValid = false;
        this.useQOP = bl;
        if (bl) {
            if (byArray == null) {
                throw new CryptoInstantiationException(ExceptionBuilder.buildReasonString(1223, null));
            }
            this.buildKeySet(byArray);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SecurityContext");
        }
    }

    private void buildKeySet(byte[] byArray) throws CryptoInstantiationException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "buildKeySet", byArray);
        }
        this.m_masterSecret = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.m_masterSecret, 0, byArray.length);
        if (this.useQOP) {
            MessageProtection messageProtection = MessageProtection.instantiateLibrary(BaseConfig.QOP_KEYSETUP_LIBRARY, BaseConfig.QOP_KEYSETUP_OPTIONS);
            byte[] byArray2 = new byte[messageProtection.digestLength()];
            byte[] byArray3 = new byte[messageProtection.digestLength()];
            byte[] byArray4 = new byte[messageProtection.digestLength()];
            byte[] byArray5 = new byte[messageProtection.digestLength()];
            int[][] nArray = messageProtection.hmacPrepareKey(byArray);
            messageProtection.hmac(nArray, serverED_KM, 0, serverED_KM.length, byArray4, 0);
            messageProtection.hmac(nArray, clientED_KM, 0, clientED_KM.length, byArray5, 0);
            messageProtection.hmac(nArray, serverMAC_KM, 0, serverMAC_KM.length, byArray2, 0);
            messageProtection.hmac(nArray, clientMAC_KM, 0, clientMAC_KM.length, byArray3, 0);
            this.mp = MessageProtection.instantiateLibrary(BaseConfig.QOP_MSGHANDLER_LIBRARY, BaseConfig.QOP_MSGHANDLER_OPTIONS);
            this.serverMACKey = this.mp.hmacPrepareKey(byArray2);
            this.clientMACKey = this.mp.hmacPrepareKey(byArray3);
            int n = this.mp.keySize();
            if (n > byArray4.length) {
                n = byArray4.length;
            }
            this.serverEDKey = this.mp.generateKey(byArray4, 0, n);
            this.clientEDKey = this.mp.generateKey(byArray5, 0, n);
            this.encryptIV = new byte[this.mp.blockSize()];
            this.decryptIV = new byte[this.mp.blockSize()];
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "buildKeySet", "mKey=", Hex.toString(byArray));
                debug.debug(-175921860444056L, "buildKeySet", "serverkeys=", Hex.toString(byArray4, 0, n), Hex.toString(byArray2));
                debug.debug(-175921860444056L, "buildKeySet", "clientkeys=", Hex.toString(byArray5, 0, n), Hex.toString(byArray3));
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "buildKeySet");
        }
    }

    public synchronized void setClientId(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setClientId", new Integer(n));
        }
        Assert.condition(!this.m_isClientIdValid);
        this.m_clientId = n;
        this.m_isClientIdValid = true;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setClientId");
        }
    }

    public MessageProtection getMP() {
        return this.mp;
    }

    public boolean isClientIdValid() {
        return this.m_isClientIdValid;
    }

    public Principal getPrincipal() {
        return this.m_principal;
    }

    public int getClientId() {
        return this.m_clientId;
    }

    public long getNextSendCount() {
        return this.sendIntegrityCounter++;
    }

    public long getNextRcvCount() {
        return this.receiveIntegrityCounter++;
    }

    public int[][] getServerMAC() {
        return this.serverMACKey;
    }

    public int[][] getClientMAC() {
        return this.clientMACKey;
    }

    public Object getServerKey() {
        return this.serverEDKey;
    }

    public Object getClientKey() {
        return this.clientEDKey;
    }

    public final byte[] getEncryptIV() {
        return this.encryptIV;
    }

    public final byte[] getDecryptIV() {
        return this.decryptIV;
    }

    public synchronized SecurityContext copy() {
        SecurityContext securityContext = null;
        try {
            securityContext = new SecurityContext(this.m_principal, this.m_masterSecret, this.useQOP);
        }
        catch (CryptoInstantiationException cryptoInstantiationException) {
            Assert.condition(false);
        }
        securityContext.m_clientId = this.m_clientId;
        securityContext.m_isClientIdValid = this.m_isClientIdValid;
        securityContext.sendIntegrityCounter = this.sendIntegrityCounter;
        securityContext.receiveIntegrityCounter = this.receiveIntegrityCounter;
        return securityContext;
    }
}

