/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.security;

import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.client.Security;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.Framing;
import com.ibm.disthubmq.impl.formats.MessageEncrypter;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.net.ISocket;
import com.ibm.disthubmq.impl.security.AuthProtocol;
import com.ibm.disthubmq.impl.security.CryptoInstantiationException;
import com.ibm.disthubmq.impl.security.MessageProtection;
import com.ibm.disthubmq.impl.security.MinCrypto;
import com.ibm.disthubmq.impl.security.Qop;
import com.ibm.disthubmq.impl.security.SecurityContext;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.Principal;
import java.io.IOException;
import java.util.Hashtable;

public final class RealSecurity
implements Security,
ClientExceptionConstants,
ClientLogConstants {
    private static final DebugObject debug = new DebugObject("RealSecurity");
    private static final MinCrypto crypto = new MinCrypto();
    private String user;
    private String passwd;
    private SecurityContext sc;
    private Hashtable qopCache;
    private static final Byte QOP_MINTEGRITY = new Byte(6);
    private static final Byte QOP_PRIVACY = new Byte(14);

    public RealSecurity(String string, String string2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "RealSecurity", string, "********");
        }
        this.user = string == null ? "" : string;
        String string3 = this.passwd = string2 == null ? "" : string2;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "RealSecurity");
        }
    }

    public int authorize(ISocket iSocket) throws IOException {
        int n;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "authorize", iSocket);
        }
        try {
            if (BaseConfig.authProtocols == null) {
                BaseConfig.authProtocols = AuthProtocol.parseAuthProtocols(BaseConfig.AUTH_PROTOCOLS);
            }
            AuthProtocol authProtocol = new AuthProtocol(this.user, this.passwd, iSocket, null, crypto);
            authProtocol.cfgProtos = BaseConfig.authProtocols;
            authProtocol.runClient();
            n = authProtocol.getRemoteRelease();
            if (authProtocol.getRequireQOP()) {
                BaseConfig.ENABLE_QOP_SECURITY = true;
            }
            this.sc = new SecurityContext(new RealSecUsername(this.user), authProtocol.sessionSecret, authProtocol.getRequireQOP());
        }
        catch (CryptoInstantiationException cryptoInstantiationException) {
            throw new IOException(ExceptionBuilder.buildReasonString(1222, new Object[]{cryptoInstantiationException}));
        }
        catch (Exception exception) {
            throw new IOException(ExceptionBuilder.buildReasonString(1228, new Object[]{exception}));
        }
        if (BaseConfig.ENABLE_QOP_SECURITY) {
            this.qopCache = new Hashtable();
            this.qopCache.put(BaseConfig.getClientToServerControlMessageTopic("subscribe"), QOP_PRIVACY);
            this.qopCache.put(BaseConfig.getClientToServerControlMessageTopic("unsubscribe"), QOP_MINTEGRITY);
            this.qopCache.put(BaseConfig.getClientToServerControlMessageTopic("startDelivery"), QOP_MINTEGRITY);
            this.qopCache.put(BaseConfig.getClientToServerControlMessageTopic("stopDelivery"), QOP_MINTEGRITY);
            this.qopCache.put(BaseConfig.getClientToServerControlMessageTopic("disconnect"), QOP_MINTEGRITY);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "authorize", new Integer(n));
        }
        return n;
    }

    public MessageEncrypter incoming(byte[] byArray) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "incoming", byArray);
        }
        MessageProtection messageProtection = null;
        if (BaseConfig.ENABLE_QOP_SECURITY) {
            Qop.checkIntegrity(byArray, this.sc, false);
            if (Framing.qop(byArray) == 14) {
                MessageProtection messageProtection2 = this.sc.getMP();
                Qop.sessionDecrypt(byArray, messageProtection2, this.sc.getServerKey(), this.sc.getDecryptIV());
                messageProtection = messageProtection2;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "incoming", messageProtection);
        }
        return messageProtection;
    }

    public byte[] outgoing(SchemaCursor schemaCursor, byte by) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "outgoing", schemaCursor, new Byte(by));
        }
        if (!BaseConfig.ENABLE_QOP_SECURITY && by != 1) {
            throw new IOException(ExceptionBuilder.buildReasonString(1229, null));
        }
        ByteSequence byteSequence = new ByteSequence();
        int n = 0;
        if (by == 14) {
            n = schemaCursor.encode(byteSequence, 0, this.sc.getMP());
        } else {
            schemaCursor.encode(byteSequence, 0, null);
        }
        byte[] byArray = null;
        if (by == 1) {
            byArray = Framing.frameMessage(byteSequence, schemaCursor.getInterpreterId(), schemaCursor.getEncodingSchema().getId());
        } else {
            byte[] byArray2 = null;
            if ((by & 6) == 6) {
                byArray2 = Qop.computeDigest(byteSequence.linearize(), n, byteSequence.length - n, this.sc.getMP());
            }
            byArray = Qop.frameMessage(byteSequence, schemaCursor.getInterpreterId(), schemaCursor.getEncodingSchema().getId(), by, by == 14 ? n : -1, this.sc, byArray2, true);
            Qop.channelProtect(byArray, this.sc.getMP(), this.sc.getNextSendCount(), this.sc.getClientMAC());
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "outgoing", byArray);
        }
        return byArray;
    }

    public byte[] framePropagationMessage(ByteSequence byteSequence) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "framePropagationMessage", byteSequence);
        }
        byte[] byArray = null;
        byArray = BaseConfig.ENABLE_QOP_SECURITY ? Qop.framePropagationMessage(byteSequence, this.sc, true) : Framing.framePropagationMessage(byteSequence);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "framePropagationMessage", byArray);
        }
        return byArray;
    }

    public byte getQop(SchemaCursor schemaCursor) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getQop", schemaCursor);
        }
        int n = 1;
        if (BaseConfig.ENABLE_QOP_SECURITY) {
            TupleCursor tupleCursor = schemaCursor.getContents();
            int n2 = tupleCursor.getChoice(7);
            if (n2 == 10) {
                n = Qop.getSingleHopControlRequiredQop(tupleCursor.getContents(7).getChoice(1));
            } else if (n2 != 1) {
                n = Qop.getPayloadRequiredQop(n2);
            } else {
                String string = tupleCursor.getString(5);
                Byte by = (Byte)this.qopCache.get(string);
                if (by != null) {
                    n = by.byteValue();
                } else {
                    tupleCursor.setBoolean(1, true);
                    n = 14;
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "qopUpdate", new Byte((byte)n));
        }
        return (byte)n;
    }

    public void qopUpdate(SchemaCursor schemaCursor) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "qopUpdate", schemaCursor);
        }
        if (this.qopCache == null) {
            throw new IOException(ExceptionBuilder.buildReasonString(1229, null));
        }
        TupleCursor tupleCursor = schemaCursor.getContents().getContents(7);
        this.qopCache.put(tupleCursor.getString(1), new Byte(tupleCursor.getByte(0)));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "qopUpdate");
        }
    }

    public class RealSecUsername
    implements Principal {
        protected String m_login;

        public RealSecUsername(String string) {
            this.m_login = string;
        }

        public String toString() {
            return this.m_login;
        }

        public int hashCode() {
            return this.m_login.hashCode();
        }

        public String getName() {
            return this.m_login;
        }

        public boolean equals(Object object) {
            try {
                RealSecUsername realSecUsername = (RealSecUsername)object;
                return this.m_login.equals(realSecUsername.m_login);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

