/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.security;

import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.Framing;
import com.ibm.disthubmq.impl.security.IntegrityCompromisedException;
import com.ibm.disthubmq.impl.security.MessageProtection;
import com.ibm.disthubmq.impl.security.SecurityContext;
import com.ibm.disthubmq.impl.security.SecurityGeneralException;
import com.ibm.disthubmq.impl.util.ArrayUtil;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.Hex;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;

public class Qop
implements ClientLogConstants,
ClientExceptionConstants {
    private static final DebugObject debug = new DebugObject("Qop");

    protected Qop() {
    }

    public static byte getPayloadRequiredQop(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getPayloadRequiredQop", new Integer(n));
        }
        byte by = 1;
        switch (n) {
            case 2: 
            case 3: {
                by = 2;
                break;
            }
            case 5: 
            case 6: {
                by = 6;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                by = 14;
                break;
            }
            case 1: 
            case 10: {
                Assert.failure("Qop.getPayloadRequiredQop(): invalid payload type");
            }
            default: {
                by = 1;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getPayloadRequiredQop", new Byte(by));
        }
        return by;
    }

    public static byte getSingleHopControlRequiredQop(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getSingleHopControlRequiredQop", new Integer(n));
        }
        byte by = 1;
        switch (n) {
            case 1: 
            case 2: 
            case 11: {
                by = 14;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                by = 6;
                break;
            }
            default: {
                Assert.failure("Qop.getSingleHopControlRequiredQop: SingleHopControl with unknown body type - are we in compatibility mode?");
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getSingleHopControlRequiredQop", new Byte(by));
        }
        return by;
    }

    public static boolean isPrivate(byte by) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isPrivate", new Byte(by));
        }
        boolean bl2 = bl = (by & 0xE) == 14;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isNoProtection", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isMessageIntegrity(byte by) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isMessageIntegrity", new Byte(by));
        }
        boolean bl2 = bl = (by & 6) == 6;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isNoProtection", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isChannelIntegrity(byte by) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isChannelIntegrity", new Byte(by));
        }
        boolean bl2 = bl = (by & 2) == 2;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isNoProtection", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isNoProtection(byte by) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isNoProtection", new Byte(by));
        }
        boolean bl2 = bl = by == 1;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isNoProtection", new Boolean(bl));
        }
        return bl;
    }

    public static void checkIntegrity(byte[] byArray, SecurityContext securityContext, boolean bl) throws IntegrityCompromisedException, SecurityGeneralException {
        int[][] nArray;
        byte by;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "checkIntegrity", byArray, securityContext, new Boolean(bl));
        }
        if ((by = byArray[6]) != 1 && by != 2 && by != 6 && by != 14) {
            throw new IntegrityCompromisedException(ExceptionBuilder.buildReasonString(1225, new Object[]{new Byte(by)}));
        }
        if (by != 1 && !BaseConfig.ENABLE_QOP_SECURITY) {
            throw new IntegrityCompromisedException(ExceptionBuilder.buildReasonString(1226, new Object[]{new Byte(by)}));
        }
        if ((by & 1) != 0) {
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "checkIntegrity", "No QOP on message, skipping integrity check");
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "checkIntegrity");
            }
            return;
        }
        if (!securityContext.useQOP) {
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "checkIntegrity", "QOP > SA_NONE but QOP disabled, throwing exception");
            }
            throw new SecurityGeneralException(ExceptionBuilder.buildReasonString(1226, new Object[]{new Byte(by)}));
        }
        MessageProtection messageProtection = securityContext.getMP();
        int n = Framing.fullLength(byArray);
        int n2 = byArray[7];
        int n3 = Framing.computeDigestOffset(byArray);
        byte[] byArray2 = new byte[n3 + 8];
        System.arraycopy(byArray, 0, byArray2, 8, n3);
        if ((by & 6) == 6) {
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "checkIntegrity", "Testing digest on frame: " + Hex.toString(byArray, n3, n - n3));
            }
            byte[] byArray3 = Qop.extractDigest(byArray, messageProtection);
            System.arraycopy(byArray3, 0, byArray2, 16, byArray3.length);
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "checkIntegrity", "QOP = MINTEGRITY, computed hash: " + Hex.toString(byArray2, 16, n2));
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                byArray2[n4 + 8 + 8] = 0;
                ++n4;
            }
        }
        long l = securityContext.getNextRcvCount();
        ArrayUtil.writeLong(byArray2, 0, l);
        int[][] nArray2 = nArray = bl ? securityContext.getClientMAC() : securityContext.getServerMAC();
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "checkIntegrity", "QOP = CINTEGRITY, pre-mac frame: " + Hex.toString(byArray2));
        }
        messageProtection.hmac(nArray, byArray2, 0, byArray2.length, byArray2, 16);
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "checkIntegrity", "QOP = CINTEGRITY, seq: " + l + " computed mac: " + Hex.toString(byArray2, 16, messageProtection.digestLength()) + " hash region length: " + byArray2.length + " inner key: " + Hex.toString(nArray[0]) + " outer key: " + Hex.toString(nArray[1]));
        }
        if (!MessageProtection.compareBuffers(byArray, 8, byArray2, 16, n2)) {
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "checkIntegrity", "Channel and/or message integrity compromised, throwing exception");
            }
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "checkIntegrity", "Msg QOP: " + by + " msg type: " + ArrayUtil.readLong(byArray, Framing.bodyOffset(byArray)));
            }
            throw new IntegrityCompromisedException(ExceptionBuilder.buildReasonString(1227, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "checkIntegrity");
        }
    }

    public static void sessionEncrypt(ByteSequence byteSequence, int n, MessageProtection messageProtection, Object object, byte[] byArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "sessionEncrypt", byteSequence, new Integer(n), messageProtection, object, byArray);
        }
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "sessionEncrypt", "Session encrypting message with sksl: " + n);
        }
        byte[] byArray2 = byteSequence.linearize();
        messageProtection.encrypt(object, byArray, byArray2, 0, n, byArray2, 0);
        byte[] byArray3 = new byte[4];
        ArrayUtil.writeInt(byArray3, 0, n);
        byteSequence.insert(new ByteSequence(byArray3, 0, 4), 0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "sessionEncrypt");
        }
    }

    public static void sessionDecrypt(byte[] byArray, MessageProtection messageProtection, Object object, byte[] byArray2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "sessionDecrypt", byArray, messageProtection, object, byArray2);
        }
        Assert.condition(Framing.qop(byArray) == 14);
        int n = Framing.sksl(byArray) + 10;
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "sessionEncrypt", "Session decrypting message with sksl: " + n);
        }
        int n2 = byArray[7] + 8 + 4;
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "sessionEncrypt", "Pre decryption frame: " + Hex.toString(byArray, n2, n));
        }
        messageProtection.decrypt(object, byArray2, byArray, n2, n, byArray, n2);
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "sessionEncrypt", "Post decryption frame: " + Hex.toString(byArray, n2, n));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "sessionDecrypt");
        }
    }

    public static void channelProtect(byte[] byArray, MessageProtection messageProtection, long l, int[][] nArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "channelProtect", byArray, messageProtection, new Long(l), nArray);
        }
        byte by = Framing.qop(byArray);
        int n = messageProtection.digestLength();
        int n2 = Framing.computeDigestOffset(byArray);
        byte[] byArray2 = new byte[n2 + 8];
        System.arraycopy(byArray, 0, byArray2, 8, n2);
        ArrayUtil.writeLong(byArray2, 0, l);
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "channelProtect", "pre-mac frame: " + Hex.toString(byArray2));
        }
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "channelProtect", "Attaching channel protection -> count: " + l + " to hash: " + Hex.toString(byArray2, 0, byArray2.length) + " hash region length: " + byArray2.length + " inner key: " + Hex.toString(nArray[0]) + " outer key: " + Hex.toString(nArray[1]));
        }
        messageProtection.hmac(nArray, byArray2, 0, byArray2.length, byArray, 8);
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "channelProtect", "Attached channel protection -> count: " + l + " hash: " + Hex.toString(byArray, 8, messageProtection.digestLength()) + " hash region length: " + byArray2.length + " inner key: " + Hex.toString(nArray[0]) + " outer key: " + Hex.toString(nArray[1]));
            debug.debug(-175921860444056L, "channelProtect", "Final frame: " + Hex.toString(byArray));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "channelProtect");
        }
    }

    public static byte[] computeDigest(byte[] byArray, int n, int n2, MessageProtection messageProtection) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "computeDigest", byArray, new Integer(n), new Integer(n2), messageProtection);
        }
        byte[] byArray2 = new byte[messageProtection.digestLength()];
        messageProtection.digest(null, byArray, n, n2, byArray2, 0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "computeDigest", byArray2);
        }
        return byArray2;
    }

    public static byte[] extractDigest(byte[] byArray, MessageProtection messageProtection) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "extractDigest", byArray, messageProtection);
        }
        byte[] byArray2 = new byte[messageProtection.digestLength()];
        byte by = byArray[6];
        Assert.condition((by & 6) == 6);
        int n = Framing.fullLength(byArray);
        int n2 = Framing.computeDigestOffset(byArray);
        messageProtection.digest(null, byArray, n2, n - n2, byArray2, 0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "extractDigest", byArray2);
        }
        return byArray2;
    }

    public static byte[] framePropagationMessage(ByteSequence byteSequence, SecurityContext securityContext, boolean bl) {
        Object object;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "framePropagationMessage", byteSequence, securityContext, new Boolean(bl));
        }
        ByteSequence byteSequence2 = new ByteSequence();
        byteSequence2.writeShort(0, (short)-1);
        byteSequence2.append(byteSequence);
        if (debug.debugIt(16)) {
            object = byteSequence2.linearize();
            debug.debug(-175921860444056L, "framePropagationMessage", "Propagation frame contents: " + Hex.toString(object, 0, ((byte[])object).length));
        }
        object = securityContext.getMP();
        Object object2 = bl ? securityContext.getClientKey() : securityContext.getServerKey();
        Qop.sessionEncrypt(byteSequence2, byteSequence2.length, (MessageProtection)object, object2, securityContext.getEncryptIV());
        Framing.attachDigest(byteSequence2, Qop.computeDigest(byteSequence2.linearize(), 0, 0, (MessageProtection)object));
        byte[] byArray = Framing.frame(byteSequence2, (byte)14);
        Qop.channelProtect(byArray, securityContext.getMP(), securityContext.getNextSendCount(), bl ? securityContext.getClientMAC() : securityContext.getServerMAC());
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "framePropagationMessage", byArray);
        }
        return byArray;
    }

    public static byte[] frameMessage(ByteSequence byteSequence, short s, long l, byte by, int n, SecurityContext securityContext, byte[] byArray, boolean bl) throws SecurityGeneralException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "frameMessage", new Object[]{byteSequence, new Short(s), new Long(l), new Byte(by), new Integer(n), securityContext, byArray, new Boolean(bl)});
        }
        ByteSequence byteSequence2 = new ByteSequence();
        byteSequence2.writeShort(0, s);
        byteSequence2.writeLong(2, l);
        byteSequence2.append(byteSequence);
        n += 10;
        MessageProtection messageProtection = securityContext.getMP();
        Object object = bl ? securityContext.getClientKey() : securityContext.getServerKey();
        switch (by) {
            case 14: {
                Qop.sessionEncrypt(byteSequence2, n, messageProtection, object, securityContext.getEncryptIV());
            }
            case 6: {
                Assert.condition(byArray.length == messageProtection.digestLength());
                Framing.attachDigest(byteSequence2, byArray);
                break;
            }
            case 2: {
                Framing.attachDigest(byteSequence2, new byte[messageProtection.digestLength()]);
            }
        }
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "frameMessage", "QOP: " + by);
        }
        byte[] byArray2 = Framing.frame(byteSequence2, by);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "frameMessage", byArray2);
        }
        return byArray2;
    }

    public static String debugPrint(byte by) {
        String string = "flags[ ";
        if (Qop.isPrivate(by)) {
            string = string + "SA_PRIVACY ";
        }
        if (Qop.isMessageIntegrity(by)) {
            string = string + "SA_MINTEGRITY ";
        }
        if (Qop.isChannelIntegrity(by)) {
            string = string + "SA_CINTEGRITY ";
        }
        if (Qop.isNoProtection(by)) {
            string = string + "SA_NONE ";
        }
        return string + "]";
    }
}

