/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.security;

import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.client.Logger;
import com.ibm.disthubmq.impl.security.CryptoInstantiationException;
import com.ibm.disthubmq.impl.security.ICrypto;
import com.ibm.disthubmq.impl.security.MessageProtection;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;

public class MinCrypto
implements ICrypto,
ClientLogConstants,
ClientExceptionConstants {
    private static final DebugObject debug = new DebugObject("MinCrypto");
    private static MessageProtection s_mp = null;

    private static synchronized void init() {
        try {
            if (s_mp == null) {
                try {
                    s_mp = MessageProtection.instantiateLibrary(BaseConfig.QOP_KEYSETUP_LIBRARY, BaseConfig.QOP_KEYSETUP_OPTIONS);
                }
                catch (Exception exception) {
                    if (Logger.logIt(1196268651025296L)) {
                        Logger.log(1196268651025296L, "MinCrypto", exception);
                    }
                    s_mp = MessageProtection.instantiateLibrary("cryptolite-export", "");
                }
            }
        }
        catch (CryptoInstantiationException cryptoInstantiationException) {
            if (Logger.logIt(1161084278936465L)) {
                Logger.log(1161084278936465L, "MinCrypto", cryptoInstantiationException);
            }
            throw new Error(ExceptionBuilder.buildReasonString(1220, new Object[]{cryptoInstantiationException}));
        }
    }

    public MinCrypto() {
        if (s_mp == null) {
            MinCrypto.init();
        }
    }

    public byte[] random(int n) {
        byte[] byArray = new byte[n];
        s_mp.random(byArray, 0, n);
        return byArray;
    }

    public byte[] hmac(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[s_mp.digestLength()];
        s_mp.hmac(byArray, 0, byArray.length, byArray2, 0, byArray2.length, byArray3, 0);
        return byArray3;
    }
}

