/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.security;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.MessageEncrypter;
import com.ibm.disthubmq.impl.security.CryptoInstantiationException;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import java.util.Hashtable;

public abstract class MessageProtection
implements MessageEncrypter,
ClientExceptionConstants {
    private static final DebugObject debug = new DebugObject("MessageProtection");
    private int blocksize;
    private static final String[][] availLibs = new String[][]{{"cryptolite-export", "com.ibm.disthubmq.impl.crypto.export.CryptoLiteWrapper"}, {"cryptolite-nonexport", "com.ibm.disthubmq.impl.crypto.nonexport.CryptoLiteWrapper"}};
    static final Hashtable instantiatedLibraries = new Hashtable();

    public void init() {
        this.blocksize = this.blockSize();
    }

    protected abstract void initLibraryInstance(String var1) throws CryptoInstantiationException;

    public static final MessageProtection instantiateLibrary(String string, String string2) throws CryptoInstantiationException {
        String string3 = string + string2;
        if (instantiatedLibraries.containsKey(string3)) {
            return (MessageProtection)instantiatedLibraries.get(string3);
        }
        int n = 0;
        while (n < availLibs.length) {
            if (availLibs[n][0].equals(string)) break;
            ++n;
        }
        if (n == availLibs.length) {
            throw new CryptoInstantiationException(ExceptionBuilder.buildReasonString(1221, new Object[]{string}));
        }
        try {
            Class<?> clazz = Class.forName(availLibs[n][1]);
            MessageProtection messageProtection = (MessageProtection)clazz.newInstance();
            messageProtection.initLibraryInstance(string2);
            messageProtection.init();
            instantiatedLibraries.put(string3, messageProtection);
            return messageProtection;
        }
        catch (Exception exception) {
            if (exception instanceof CryptoInstantiationException) {
                throw (CryptoInstantiationException)exception;
            }
            throw new CryptoInstantiationException(ExceptionBuilder.buildReasonString(1222, new Object[]{exception}));
        }
    }

    public abstract int digestLength();

    public abstract int[] digestInitState(int[] var1);

    public abstract void digest(int[] var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    public final void hmac(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5) {
        this.hmac(this.hmacPrepareKey(byArray, n, n2), byArray2, n3, n4, byArray3, n5);
    }

    public final int[][] hmacPrepareKey(byte[] byArray) {
        return this.hmacPrepareKey(byArray, 0, byArray.length);
    }

    public final int[][] hmacPrepareKey(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[64];
        if (n2 > byArray2.length) {
            this.digest(null, byArray, n, n2, byArray2, 0);
        } else {
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        int n3 = 0;
        while (n3 < byArray2.length) {
            int n4 = n3++;
            byArray2[n4] = (byte)(byArray2[n4] ^ 0x36);
        }
        int[] nArray = this.digestInitState(null);
        this.digest(nArray, byArray2, 0, byArray2.length, null, 0);
        int[] nArray2 = this.digestInitState(null);
        n3 = 0;
        while (n3 < byArray2.length) {
            int n5 = n3++;
            byArray2[n5] = (byte)(byArray2[n5] ^ 0x6A);
        }
        this.digest(nArray2, byArray2, 0, byArray2.length, null, 0);
        return new int[][]{nArray, nArray2};
    }

    public final void hmac(int[][] nArray, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.digest(nArray[0], byArray, n, n2, byArray2, n3);
        this.digest(nArray[1], byArray2, n3, this.digestLength(), byArray2, n3);
    }

    public abstract void random(byte[] var1, int var2, int var3);

    public abstract int keySize();

    public abstract Object generateKey(byte[] var1, int var2, int var3);

    public abstract void encryptCBC(Object var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7);

    public final void encrypt(Object object, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.encrypt(object, null, byArray, n, n2, byArray2, n3);
    }

    public void encrypt(Object object, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        if (n2 <= 0) {
            return;
        }
        byte[] byArray4 = byArray;
        if (byArray4 == null) {
            byArray4 = new byte[this.blocksize];
        }
        if (n2 < this.blocksize) {
            this.encryptCBC(object, null, byArray4, 0, this.blocksize, byArray4, 0);
            int n4 = 0;
            while (n4 < n2) {
                byArray3[n3++] = byArray4[n4] = (byte)(byArray4[n4] ^ byArray2[n++]);
                ++n4;
            }
            return;
        }
        int n5 = n2 % this.blocksize;
        int n6 = n2 - n5;
        this.encryptCBC(object, byArray4, byArray2, n, n6, byArray3, n3);
        if (n5 == 0) {
            return;
        }
        int n7 = 0;
        while (n7 < n5) {
            int n8 = n7;
            byArray4[n8] = (byte)(byArray4[n8] ^ byArray2[n + n6 + n7]);
            byArray3[n3 + n6 + n7] = byArray3[n3 + n6 + n7 - this.blocksize];
            ++n7;
        }
        this.encryptCBC(object, null, byArray4, 0, this.blocksize, byArray3, n3 + n6 - this.blocksize);
        if (byArray != null) {
            System.arraycopy(byArray3, n3 + n6 - this.blocksize, byArray, 0, this.blocksize);
        }
    }

    public abstract void decryptCBC(Object var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7);

    public final void decrypt(Object object, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.decrypt(object, null, byArray, n, n2, byArray2, n3);
    }

    public void decrypt(Object object, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        if (n2 <= 0) {
            return;
        }
        byte[] byArray4 = byArray;
        if (byArray4 == null) {
            byArray4 = new byte[this.blocksize];
        }
        if (n2 < this.blocksize) {
            this.encryptCBC(object, null, byArray4, 0, this.blocksize, byArray4, 0);
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n3++;
                byte by = byArray2[n++];
                byArray3[n5] = (byte)(byArray4[n4] ^ by);
                byArray4[n4] = by;
                ++n4;
            }
            return;
        }
        int n6 = n2 % this.blocksize;
        if (n6 == 0) {
            this.decryptCBC(object, byArray4, byArray2, n, n2, byArray3, n3);
            return;
        }
        int n7 = n2 - n6;
        int n8 = n7 - this.blocksize;
        this.decryptCBC(object, byArray4, byArray2, n, n8, byArray3, n3);
        byte[] byArray5 = null;
        if (byArray != null) {
            byArray5 = new byte[this.blocksize];
            System.arraycopy(byArray2, n + n8, byArray5, 0, this.blocksize);
        }
        this.decryptCBC(object, null, byArray2, n + n8, this.blocksize, byArray3, n3 + n8);
        int n9 = 0;
        while (n9 < n6) {
            byte by = byArray2[n + n7 + n9];
            byArray3[n3 + n7 + n9] = (byte)(byArray3[n3 + n8 + n9] ^ by);
            byArray3[n3 + n8 + n9] = by;
            ++n9;
        }
        this.decryptCBC(object, byArray4, byArray3, n3 + n8, this.blocksize, byArray3, n3 + n8);
        if (byArray5 != null) {
            System.arraycopy(byArray5, 0, byArray, 0, this.blocksize);
        }
    }

    public abstract int blockSize();

    public static final boolean compareBuffers(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }
}

