/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.security;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.client.Logger;
import com.ibm.disthubmq.impl.net.IMBSocket;
import com.ibm.disthubmq.impl.net.ISocket;
import com.ibm.disthubmq.impl.security.AuthProtocolException;
import com.ibm.disthubmq.impl.security.HeadRequestException;
import com.ibm.disthubmq.impl.security.ICrypto;
import com.ibm.disthubmq.impl.security.ISSL;
import com.ibm.disthubmq.impl.security.MsgUtil;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.Hex;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.PrincipalDirectory;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class AuthProtocol
implements ClientLogConstants,
ClientExceptionConstants {
    private static final DebugObject debug = new DebugObject("AuthProtocol");
    public static final short DUMMY = 0;
    static MsgBase xDummy = new AuthProtocol().new MsgBase();
    public short[] cfgProtos;
    public short defProto = (short)99;
    public String selfId;
    private String selfXid;
    private boolean requireQOP = false;
    public String selfPassword;
    public ISocket sock;
    public ICrypto crypto;
    public ISSL xssl;
    public ISSL xsslpure;
    public PrincipalDirectory directory;
    DataInputStream istr;
    DataOutputStream ostr;
    Socket ssock;
    static final boolean AS_CLIENT = false;
    static final boolean AS_SERVER = true;
    byte[] macServ;
    byte[] macClnt;
    public static final int N_RANDOM = 20;
    public short whichProto = 0;
    public boolean success = false;
    public String otherId = null;
    public String otherXid = null;
    public boolean isClientIdValid = false;
    public int clientId = -1;
    public byte[] sessionSecret = null;
    static final int VERSION_MAGIC = 122605;
    static final short HELLO_old = 72;
    static final short HELLO = 22600;
    public static final int EC_IOEXCEPTION = 94;
    public static final int EC_WRONG_CONFIG = 95;
    public static final int EC_FORMAT = 91;
    public static final int EC_UNKNOWN = 92;
    public static final int EC_WRONG_MSG = 93;
    public static final int EC_SERVER_FAILED_COUNTER_CHALLENGE = 96;
    public static final int EC_CLIENT_FAILED_CHALLENGE = 97;
    public static final int EC_CLIENT_WRONG_PASSWORD = 98;
    public static final int EC_SSL_NI = 101;
    public static final int EC_SSL_EXC = 102;
    static final String HTTP_HEAD_RESPONSE_STRING = "ResponseToRequest\r\n\r\n";
    final int DEATH_THRESHHOLD = 60;
    static final int HEAD_WORD = 1212498244;
    static final short HEAD_REQUEST = 17480;
    static final short HEAD_RESPONSE = 21064;
    static final short AUTH_EXCEPTION = 88;
    static final short REPLY_UP = 85;
    static final short OKAY_UP = 111;
    static final short OKAY_UP_pxid = 79;
    static final short RESPONSE_COUNTER = 19797;
    static final short OKAY_RESPONSE = 19791;
    static final String CLIENT = "Client";
    static final String SERVER = "Server";
    static final String SESSION_KEY = "SessionKey";
    private byte[] sslMS;
    static final short REPLY_SSL_UP = 21333;
    static final short OKAY_SSL_UP = 21327;
    static final short REPLY_SSL_PURE = 21077;
    static final short OKAY_SSL_PURE = 21071;

    AuthProtocol() {
    }

    public AuthProtocol(String string, String string2, ISocket iSocket, PrincipalDirectory principalDirectory, ICrypto iCrypto) {
        this();
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "AuthProtocol", string, "********", iSocket, principalDirectory, iCrypto);
        }
        this.selfId = string;
        this.selfPassword = string2;
        this.sock = iSocket;
        this.directory = principalDirectory;
        this.crypto = iCrypto;
        this.selfXid = "[release=1.1]";
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "AuthProtocol");
        }
    }

    public AuthProtocol(String string, String string2, ISocket iSocket, PrincipalDirectory principalDirectory, ICrypto iCrypto, boolean bl) {
        this(string, string2, iSocket, principalDirectory, iCrypto);
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "AuthProtocol", string, "********", iSocket, principalDirectory, iCrypto, new Boolean(bl));
        }
        this.requireQOP = bl;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "AuthProtocol");
        }
    }

    public static boolean passwordsRequired(short[] sArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "passwordsRequired", sArray);
        }
        int n = sArray.length;
        int n2 = 0;
        while (n2 < n) {
            switch (sArray[n2]) {
                case 19779: 
                case 21315: {
                    if (debug.debugIt(64)) {
                        debug.debug(-175921860444054L, "passwordsRequired", new Boolean(true));
                    }
                    return true;
                }
            }
            ++n2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "passwordsRequired", new Boolean(false));
        }
        return false;
    }

    public static boolean SSLrequired(short[] sArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SSLrequired", sArray);
        }
        int n = 0;
        while (n < sArray.length) {
            switch (sArray[n]) {
                case 21059: 
                case 21315: {
                    if (debug.debugIt(64)) {
                        debug.debug(-175921860444054L, "SSLrequired", new Boolean(true));
                    }
                    return true;
                }
            }
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SSLrequired", new Boolean(false));
        }
        return false;
    }

    public String getXid() {
        return this.selfXid;
    }

    public int getRemoteRelease() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getRemoteRelease");
        }
        if (this.otherXid == null) {
            return 65536;
        }
        int n = this.otherXid.indexOf("[release=");
        if (n < 0) {
            return 65536;
        }
        int n2 = this.otherXid.indexOf(46, n += "[release=".length());
        int n3 = Integer.parseInt(this.otherXid.substring(n, n2));
        n = n2 + 1;
        n2 = this.otherXid.indexOf(93, n);
        int n4 = Integer.parseInt(this.otherXid.substring(n, n2));
        int n5 = n3 << 16 | n4;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getRemoteRelease", new Integer(n5));
        }
        return n5;
    }

    public boolean getRequireQOP() {
        return this.requireQOP;
    }

    public void setXid(String string) {
        this.selfXid = string;
    }

    void init() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "init");
        }
        this.istr = new DataInputStream(this.sock.getInputStream());
        this.ostr = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), 1024));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "init");
        }
    }

    public boolean runClient() throws AuthProtocolException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "runClient");
        }
        try {
            this.init();
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "runClient", "Starting client auth protocol...");
                int n = 0;
                while (n < this.cfgProtos.length) {
                    debug.debug(-175921860444056L, "runClient", "Client proto: " + n + " " + this.cfgProtos[n] + " (" + (char)(this.cfgProtos[n] >> 8) + ")");
                    ++n;
                }
            }
            new Hello(this.cfgProtos).writeMsg(this.ostr);
            MsgBase msgBase = xDummy.readMsg(this.istr);
            short s = msgBase.getType();
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "runClient", "Server requests proto (" + msgBase.getClass() + ") : " + s + " (" + (char)(s >> 8) + ")");
            }
            short s2 = 0;
            if (this.cfgProtos != null) {
                int n = 0;
                while (n < this.cfgProtos.length) {
                    if (s == this.cfgProtos[n]) {
                        s2 = s;
                        break;
                    }
                    ++n;
                }
            }
            this.whichProto = s2;
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "runClient", "Running client with protocol: " + s2 + " (" + (char)(s2 >> 8) + ")");
            }
            boolean bl = false;
            switch (s2) {
                case 99: {
                    bl = this.clntChallengeUP(msgBase);
                    break;
                }
                case 19779: {
                    bl = this.clntChallengeMPR(msgBase);
                    break;
                }
                case 21315: {
                    bl = this.clntChallengeSSLUP(msgBase);
                    break;
                }
                case 21059: {
                    bl = this.clntChallengeSSLPure(msgBase);
                    break;
                }
                case 67: {
                    bl = this.clntChallengeUP(msgBase);
                    break;
                }
                default: {
                    this.termException(ExceptionBuilder.buildReasonString(1208, new Object[]{new Short(s2)}), 95);
                }
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "runClient", new Boolean(bl));
            }
            return bl;
        }
        catch (AuthException authException) {
            this.termException(authException);
        }
        catch (IOException iOException) {
            this.termException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "runClient", new Boolean(this.success));
        }
        return this.success;
    }

    public boolean runServer() throws AuthProtocolException, HeadRequestException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "runServer");
        }
        try {
            int n;
            this.init();
            MsgBase msgBase = xDummy.readMsg(this.istr);
            if (msgBase.getType() == 17480) {
                this.ostr.writeBytes(HTTP_HEAD_RESPONSE_STRING);
                this.ostr.flush();
                throw new HeadRequestException(ExceptionBuilder.buildReasonString(1204, null));
            }
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "runServer", "Client hello type: " + msgBase.getClass());
            }
            if (this.requireQOP) {
                this.selfXid = this.selfXid + "[qop=true]";
            }
            if (msgBase.getType() != 22600) {
                this.termWrongMsg(msgBase);
            }
            Hello hello = (Hello)msgBase;
            short s = 0;
            if (this.cfgProtos != null) {
                n = 0;
                block11: while (n < this.cfgProtos.length) {
                    int n2 = 0;
                    while (n2 < hello.protos.length) {
                        if (this.cfgProtos[n] == hello.protos[n2]) {
                            s = this.cfgProtos[n];
                            break block11;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            this.whichProto = s;
            n = 0;
            switch (s) {
                case 99: {
                    if (debug.debugIt(16)) {
                        debug.debug(-175921860444056L, "runServer", "Running server with protocol: CHALLENGE_UP");
                    }
                    n = this.servChallengeUP() ? 1 : 0;
                    break;
                }
                case 67: {
                    if (debug.debugIt(16)) {
                        debug.debug(-175921860444056L, "runServer", "Running server with protocol: CHALLENGE_UP_pxid");
                    }
                    n = this.servChallengeUP() ? 1 : 0;
                    break;
                }
                case 19779: {
                    if (debug.debugIt(16)) {
                        debug.debug(-175921860444056L, "runServer", "Running server with protocol: CHALLENGE_MPR");
                    }
                    n = this.servChallengeMPR() ? 1 : 0;
                    break;
                }
                case 21315: {
                    if (debug.debugIt(16)) {
                        debug.debug(-175921860444056L, "runServer", "Running server with protocol: CHALLENGE_SSL_UP");
                    }
                    n = this.servChallengeSSLUP() ? 1 : 0;
                    break;
                }
                case 21059: {
                    if (debug.debugIt(16)) {
                        debug.debug(-175921860444056L, "runServer", "Running server with protocol: CHALLENGE_SSL_PURE");
                    }
                    n = this.servChallengeSSLPure() ? 1 : 0;
                    break;
                }
                default: {
                    if (debug.debugIt(16)) {
                        debug.debug(-175921860444056L, "runServer", "Client specified unknown protocol: " + s);
                    }
                    this.termException(ExceptionBuilder.buildReasonString(1208, new Object[]{new Short(s)}), 95);
                }
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "runServer", new Boolean(n != 0));
            }
            return n != 0;
        }
        catch (HeadRequestException headRequestException) {
            throw headRequestException;
        }
        catch (AuthException authException) {
            this.termException(authException);
        }
        catch (IOException iOException) {
            this.termException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "runServer", new Boolean(this.success));
        }
        return this.success;
    }

    void close_ostr() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close_ostr");
        }
        if (this.ostr != null) {
            this.ostr.flush();
        }
        this.ostr = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close_ostr");
        }
    }

    void cleanup() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "cleanup");
        }
        this.istr = null;
        if (this.ostr != null) {
            try {
                this.close_ostr();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.ssock != null) {
            try {
                this.sslMS = null;
                this.ssock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ssock = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "cleanup");
        }
    }

    void termException(String string, int n) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "termException", string, new Integer(n));
        }
        this.termException(new AuthException(n, string));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "termException");
        }
    }

    void termException(IOException iOException) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "termException", iOException);
        }
        this.termException(new AuthException(94, ExceptionBuilder.buildReasonString(1206, new Object[]{iOException})));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "termException");
        }
    }

    void termException(AuthExceptionMsg authExceptionMsg) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "termException", authExceptionMsg);
        }
        if (debug.debugIt(2)) {
            debug.debug(-175921860444059L, "termException", "Terminating with exception: " + authExceptionMsg.getMessage());
        }
        try {
            this.close_ostr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.termException(new AuthException(ExceptionBuilder.buildReasonString(1207, new Object[]{authExceptionMsg}), authExceptionMsg));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "termException");
        }
    }

    void termException(AuthException authException) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "termException", authException);
        }
        if (this.ostr != null) {
            try {
                new AuthExceptionMsg(authException).writeMsg(this.ostr);
                this.close_ostr();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cleanup();
        throw authException;
    }

    void termWrongMsg(MsgBase msgBase) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "termWrongMessage", msgBase);
        }
        if (msgBase instanceof AuthExceptionMsg) {
            this.termException((AuthExceptionMsg)msgBase);
        }
        this.termException(ExceptionBuilder.buildReasonString(1211, new Object[]{new Short(msgBase.getType())}), 93);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "termWrongMsg");
        }
    }

    private boolean clntChallengeUP(MsgBase msgBase) throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clntChallengeUP", msgBase);
        }
        new ReplyUP(this.selfId, this.selfPassword, this.selfXid).writeMsg(this.ostr);
        this.close_ostr();
        MsgBase msgBase2 = xDummy.readMsg(this.istr);
        if (msgBase2.getType() != 111 && msgBase2.getType() != 79) {
            this.termWrongMsg(msgBase2);
        }
        OkayUP okayUP = (OkayUP)msgBase2;
        this.otherId = okayUP.serverId;
        this.otherXid = okayUP.serverXid;
        this.success = true;
        this.requireQOP = false;
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clntChallengeUP", new Boolean(this.success));
        }
        return this.success;
    }

    private boolean servChallengeUP() throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "servChallengeUP");
        }
        if (this.requireQOP) {
            if (Logger.logIt(1196268651025299L)) {
                Logger.log(1196268651025299L, "AuthProtocol.servChallengeUP");
            }
            throw new AuthException(95, ExceptionBuilder.buildReasonString(1209, new Object[]{new Short(99)}));
        }
        if (this.whichProto == 99) {
            new ChallengeUP().writeMsg(this.ostr);
        } else {
            new ChallengeUP_pxid().writeMsg(this.ostr);
        }
        MsgBase msgBase = xDummy.readMsg(this.istr);
        if (msgBase.getType() != 85) {
            this.termWrongMsg(msgBase);
        }
        ReplyUP replyUP = (ReplyUP)msgBase;
        this.otherId = replyUP.userid;
        this.otherXid = replyUP.xid;
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "servChallengeUP", "CHALLENGE_UP: received uid: \"" + this.otherId + "\" pwd: \"" + replyUP.password + "\"");
        }
        if (!this.directory.checkPassword(this.otherId, replyUP.password)) {
            this.termException(ExceptionBuilder.buildReasonString(1215, new Object[]{this.otherId}), 98);
        }
        if (this.whichProto == 99) {
            new OkayUP(this.selfId, this.selfXid).writeMsg(this.ostr);
        } else {
            new OkayUP_pxid().writeMsg(this.ostr);
        }
        this.success = true;
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "servChallengeUP", new Boolean(this.success));
        }
        return this.success;
    }

    private boolean clntChallengeMPR(MsgBase msgBase) throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clntChallengeMPR", msgBase);
        }
        ChallengeMPR challengeMPR = (ChallengeMPR)msgBase;
        this.otherId = challengeMPR.serverId;
        this.otherXid = challengeMPR.serverXid;
        byte[] byArray = this.crypto.random(20);
        this.mutualPasswordMacs(this.selfPassword, this.otherId, this.otherXid, challengeMPR.Rs, this.selfId, this.selfXid, byArray);
        new ResponseAndCounter(this.selfId, this.selfXid, byArray, this.macClnt).writeMsg(this.ostr);
        this.close_ostr();
        MsgBase msgBase2 = xDummy.readMsg(this.istr);
        if (msgBase2.getType() != 19791) {
            this.termWrongMsg(msgBase2);
        }
        OkayResponse okayResponse = (OkayResponse)msgBase2;
        if (!AuthProtocol.baEquals(okayResponse.MacS, this.macServ)) {
            this.termException(ExceptionBuilder.buildReasonString(1212, null), 96);
        }
        this.success = true;
        this.requireQOP = this.otherXid.indexOf("[qop=true]") != -1;
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clntChallengeMPR", new Boolean(this.success));
        }
        return this.success;
    }

    private boolean servChallengeMPR() throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "servChallengeMPR");
        }
        byte[] byArray = this.crypto.random(20);
        new ChallengeMPR(this.selfId, this.selfXid, byArray).writeMsg(this.ostr);
        MsgBase msgBase = xDummy.readMsg(this.istr);
        if (msgBase.getType() != 19797) {
            this.termWrongMsg(msgBase);
        }
        ResponseAndCounter responseAndCounter = (ResponseAndCounter)msgBase;
        this.otherId = responseAndCounter.userid;
        this.otherXid = responseAndCounter.xid;
        String string = this.directory.getPassword(this.otherId);
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "servChallengeMPR", "Expected password for client is " + string);
        }
        if (string == null) {
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "servChallengeMPR", "Password is null.");
            }
            this.termException(ExceptionBuilder.buildReasonString(1213, new Object[]{this.otherId}), 97);
        }
        this.mutualPasswordMacs(string, this.selfId, this.selfXid, byArray, this.otherId, this.otherXid, responseAndCounter.Rc);
        if (!AuthProtocol.baEquals(responseAndCounter.MacC, this.macClnt)) {
            this.termException(ExceptionBuilder.buildReasonString(1214, null), 97);
        }
        new OkayResponse(this.macServ).writeMsg(this.ostr);
        this.success = true;
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "servChallengeMPR", new Boolean(this.success));
        }
        return this.success;
    }

    private void mutualPasswordMacs(String string, String string2, String string3, byte[] byArray, String string4, String string5, byte[] byArray2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "mutualPasswordMacs", "********", string2, string3, byArray, string4, string5, byArray2);
        }
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "mutualPasswordMacs", "MutualPasswordMacs w/ pw = " + string + ",\n\t servId = " + string2 + ", servXid = " + string3 + ", servRndm = " + byArray + ",\n\t clientId = " + string4 + ", clntXid = " + string5 + ", clntRndm = " + byArray2);
        }
        byte[] byArray3 = AuthProtocol.bafString(string2);
        byte[] byArray4 = AuthProtocol.bafString(string3);
        byte[] byArray5 = AuthProtocol.bafString(string4);
        byte[] byArray6 = AuthProtocol.bafString(string5);
        byte[] byArray7 = AuthProtocol.bafString(CLIENT);
        byte[] byArray8 = AuthProtocol.bac7(byArray3, byArray4, byArray, byArray5, byArray6, byArray2, byArray7);
        byte[] byArray9 = AuthProtocol.bafString(string);
        this.macClnt = this.crypto.hmac(byArray9, byArray8);
        byte[] byArray10 = AuthProtocol.bafString(SERVER);
        byte[] byArray11 = AuthProtocol.bac7(byArray3, byArray4, byArray, byArray5, byArray6, byArray2, byArray10);
        this.macServ = this.crypto.hmac(byArray9, byArray11);
        byte[] byArray12 = AuthProtocol.bafString(SESSION_KEY);
        byte[] byArray13 = AuthProtocol.bac7(byArray3, byArray4, byArray, byArray5, byArray6, byArray2, byArray12);
        this.sessionSecret = this.crypto.hmac(byArray9, byArray13);
        if (debug.debugIt(16)) {
            debug.debug(-175921860444056L, "mutualPasswordMacs", "Result, macClnt: " + Hex.toString(this.macClnt) + " macServ: " + Hex.toString(this.macServ) + " sessionSecret: " + Hex.toString(this.sessionSecret));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "mutualPasswordMacs");
        }
    }

    void sslStart(boolean bl, short s) throws IOException, AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "sslStart", new Boolean(bl), new Short(s));
        }
        if (bl) {
            if (s == 21059) {
                this.xssl = this.xsslpure;
            }
        } else if (s == 21059 && this.xsslpure != null) {
            this.xssl = this.xsslpure;
        }
        if (this.xssl == null) {
            throw new AuthException(101, ExceptionBuilder.buildReasonString(1216, null));
        }
        this.xssl.setRequireClientAuthentication(s == 21059);
        try {
            this.ssock = this.xssl.createSSLSocket(((IMBSocket)this.sock).getSocket(), bl);
        }
        catch (Exception exception) {
            if (debug.debugIt(2)) {
                debug.debug(-175921860444059L, "sslStart", "Implementation specific exception:", this.xssl.translateException(exception), debug.debugX(exception));
            }
            throw new AuthException(102, ExceptionBuilder.buildReasonString(1217, new Object[]{exception}));
        }
        this.istr = new DataInputStream(this.ssock.getInputStream());
        this.ostr = new DataOutputStream(new BufferedOutputStream(this.ssock.getOutputStream(), 1024));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "sslStart");
        }
    }

    private void sslDeriveSessionKey(byte[] byArray, byte[] byArray2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "sslDeriveSessionKey", byArray, byArray2);
        }
        byte[] byArray3 = AuthProtocol.bafString(SESSION_KEY);
        byte[] byArray4 = AuthProtocol.bac3(byArray, byArray2, byArray3);
        byte[] byArray5 = this.xssl.getMasterSecret();
        if (byArray5 == null) {
            byte[] byArray6 = new byte[]{1, 2, 3, 4, 5};
            byArray5 = byArray6;
        }
        this.sessionSecret = this.crypto.hmac(byArray5, byArray4);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "sslDeriveSessionKey");
        }
    }

    static final byte[] bafString(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.condition(false);
            return null;
        }
    }

    static final byte[] bac7(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) {
        byte[] byArray8 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length + byArray6.length + byArray7.length];
        System.arraycopy(byArray, 0, byArray8, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray8, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray8, byArray.length + byArray2.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray8, byArray.length + byArray2.length + byArray3.length, byArray4.length);
        System.arraycopy(byArray5, 0, byArray8, byArray.length + byArray2.length + byArray3.length + byArray4.length, byArray5.length);
        System.arraycopy(byArray6, 0, byArray8, byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length, byArray6.length);
        System.arraycopy(byArray7, 0, byArray8, byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length + byArray6.length, byArray7.length);
        return byArray8;
    }

    static final byte[] bac3(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        return byArray4;
    }

    static final boolean baEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean servChallengeSSLUP() throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "servChallengeSSLUP");
        }
        new ChallengeSSLUP().writeMsg(this.ostr);
        this.close_ostr();
        this.sslStart(true, (short)21315);
        MsgBase msgBase = xDummy.readMsg(this.istr);
        if (msgBase.getType() != 21333) {
            this.termWrongMsg(msgBase);
        }
        ReplySSLUP replySSLUP = (ReplySSLUP)msgBase;
        this.otherId = replySSLUP.userid;
        this.otherXid = replySSLUP.xid;
        if (!this.directory.checkPassword(this.otherId, replySSLUP.password)) {
            this.termException(ExceptionBuilder.buildReasonString(1215, new Object[]{this.otherId}), 98);
        }
        byte[] byArray = this.crypto.random(20);
        new OkaySSLUP(byArray, this.selfId, this.selfXid).writeMsg(this.ostr);
        this.sslDeriveSessionKey(byArray, replySSLUP.Rc);
        this.success = true;
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "servChallengeSSLUP", new Boolean(this.success));
        }
        return this.success;
    }

    private boolean clntChallengeSSLUP(MsgBase msgBase) throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clntChallengeSSLUP", msgBase);
        }
        ChallengeSSLUP challengeSSLUP = (ChallengeSSLUP)msgBase;
        this.sslStart(false, (short)21315);
        byte[] byArray = this.crypto.random(20);
        new ReplySSLUP(this.selfId, this.selfPassword, this.selfXid, byArray).writeMsg(this.ostr);
        this.close_ostr();
        MsgBase msgBase2 = xDummy.readMsg(this.istr);
        if (msgBase2.getType() != 21327) {
            this.termWrongMsg(msgBase2);
        }
        OkaySSLUP okaySSLUP = (OkaySSLUP)msgBase2;
        this.sslDeriveSessionKey(okaySSLUP.Rs, byArray);
        this.otherId = okaySSLUP.serverId;
        this.otherXid = okaySSLUP.serverXid;
        this.setOtherIdViaCert();
        this.success = true;
        this.requireQOP = this.otherXid.indexOf("[qop=true]") != -1;
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clntChallengeSSLUP", new Boolean(this.success));
        }
        return this.success;
    }

    private boolean servChallengeSSLPure() throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "servChallengeSSLPure");
        }
        new ChallengeSSLPure().writeMsg(this.ostr);
        this.close_ostr();
        this.sslStart(true, (short)21059);
        MsgBase msgBase = xDummy.readMsg(this.istr);
        if (msgBase.getType() != 21077) {
            this.termWrongMsg(msgBase);
        }
        ReplySSLPure replySSLPure = (ReplySSLPure)msgBase;
        this.otherId = replySSLPure.userid;
        this.otherXid = replySSLPure.xid;
        this.setOtherIdViaCert();
        byte[] byArray = this.crypto.random(20);
        new OkaySSLPure(byArray, this.selfId, this.selfXid).writeMsg(this.ostr);
        this.sslDeriveSessionKey(byArray, replySSLPure.Rc);
        this.success = true;
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "servChallengeSSLPure", new Boolean(this.success));
        }
        return this.success;
    }

    private void setOtherIdViaCert() {
        Object object;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setOtherIdViaCert");
        }
        if ((object = this.xssl.getPeerCertificate()) != null) {
            this.otherId = this.xssl.extractUseridFromCertificate(object);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setOtherIdViaCert");
        }
    }

    private boolean clntChallengeSSLPure(MsgBase msgBase) throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clntChallengeSSLPure", msgBase);
        }
        ChallengeSSLPure challengeSSLPure = (ChallengeSSLPure)msgBase;
        this.sslStart(false, (short)21059);
        byte[] byArray = this.crypto.random(20);
        new ReplySSLPure(this.selfId, "", this.selfXid, byArray).writeMsg(this.ostr);
        this.close_ostr();
        MsgBase msgBase2 = xDummy.readMsg(this.istr);
        if (msgBase2.getType() != 21071) {
            this.termWrongMsg(msgBase2);
        }
        OkaySSLPure okaySSLPure = (OkaySSLPure)msgBase2;
        this.sslDeriveSessionKey(okaySSLPure.Rs, byArray);
        this.otherId = okaySSLPure.serverId;
        this.otherXid = okaySSLPure.serverXid;
        this.setOtherIdViaCert();
        this.success = true;
        this.requireQOP = this.otherXid.indexOf("[qop=true]") != -1;
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clntChallengeSSLPure", new Boolean(this.success));
        }
        return this.success;
    }

    public static final void writeSBA(byte[] byArray, DataOutput dataOutput) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeSBA", byArray, dataOutput);
        }
        dataOutput.writeShort(byArray.length);
        dataOutput.write(byArray);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeSBA");
        }
    }

    public static final byte[] readSBA(DataInputStream dataInputStream) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readSBA", dataInputStream);
        }
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readSBA", byArray);
        }
        return byArray;
    }

    public static short[] parseAuthProtocols(String string) throws IllegalArgumentException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "parseAuthProtocols", string);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1001, null));
        }
        int n = string.length();
        short[] sArray = new short[n + 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            switch (string.charAt(n3)) {
                case 'M': {
                    sArray[n3] = 19779;
                    break;
                }
                case 'S': {
                    sArray[n3] = 21315;
                    break;
                }
                case 'R': {
                    sArray[n3] = 21059;
                    break;
                }
                case 'P': {
                    sArray[n3] = 99;
                    n2 = 67;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1002, new Object[]{new Character(string.charAt(n3))}));
                }
            }
            ++n3;
        }
        sArray[n] = n2;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "parseAuthProtocols", sArray);
        }
        return sArray;
    }

    class OkaySSLPure
    extends OkaySSLUP {
        short getType() {
            return 21071;
        }

        OkaySSLPure(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkaySSLPure(byte[] byArray, String string, String string2) {
            super(byArray, string, string2);
        }
    }

    class ReplySSLPure
    extends ReplySSLUP {
        short getType() {
            return 21077;
        }

        ReplySSLPure(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ReplySSLPure(String string, String string2, String string3, byte[] byArray) {
            super(string, string2, string3, byArray);
        }
    }

    class ChallengeSSLPure
    extends ChallengeUP {
        short getType() {
            return 21059;
        }

        ChallengeSSLPure(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeSSLPure() {
        }
    }

    class OkaySSLUP
    extends MsgBase {
        byte[] Rs;
        String serverId;
        String serverXid;

        short getType() {
            return 21327;
        }

        OkaySSLUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkaySSLUP(byte[] byArray, String string, String string2) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "OkaySSLUP", byArray, string, string2);
            }
            this.Rs = byArray;
            this.serverId = string;
            this.serverXid = string2;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "OkaySSLUP");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            AuthProtocol.writeSBA(this.Rs, dataOutput);
            dataOutput.writeUTF(this.serverId);
            dataOutput.writeUTF(this.serverXid);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            this.Rs = AuthProtocol.readSBA(dataInputStream);
            this.serverId = dataInputStream.readUTF();
            this.serverXid = dataInputStream.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class ReplySSLUP
    extends MsgBase {
        String userid;
        String password;
        String xid;
        byte[] Rc;

        short getType() {
            return 21333;
        }

        ReplySSLUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ReplySSLUP(String string, String string2, String string3, byte[] byArray) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "ReplySSLUP", string, "********", string3, byArray);
            }
            this.userid = string;
            this.password = string2;
            this.xid = string3;
            this.Rc = byArray;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "ReplySSLUP");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            dataOutput.writeUTF(this.userid);
            dataOutput.writeUTF(this.password);
            dataOutput.writeUTF(this.xid);
            AuthProtocol.writeSBA(this.Rc, dataOutput);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            this.userid = dataInputStream.readUTF();
            this.password = dataInputStream.readUTF();
            this.xid = dataInputStream.readUTF();
            this.Rc = AuthProtocol.readSBA(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class ChallengeSSLUP
    extends ChallengeUP {
        short getType() {
            return 21315;
        }

        ChallengeSSLUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeSSLUP() {
        }
    }

    class OkayResponse
    extends MsgBase {
        byte[] MacS;

        short getType() {
            return 19791;
        }

        OkayResponse(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkayResponse(byte[] byArray) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "OkayResponse", byArray);
            }
            this.MacS = byArray;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "OkayResponse");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            AuthProtocol.writeSBA(this.MacS, dataOutput);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            this.MacS = AuthProtocol.readSBA(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }

        public byte[] getMacBytes() {
            return this.MacS;
        }
    }

    class ResponseAndCounter
    extends MsgBase {
        String userid;
        String xid;
        byte[] Rc;
        byte[] MacC;

        short getType() {
            return 19797;
        }

        ResponseAndCounter(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ResponseAndCounter(String string, String string2, byte[] byArray, byte[] byArray2) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "ResponseAndCounter", string, string2, byArray, byArray2);
            }
            this.userid = string;
            this.xid = string2;
            this.Rc = byArray;
            this.MacC = byArray2;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "ResponseAndCounter");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            dataOutput.writeUTF(this.userid);
            dataOutput.writeUTF(this.xid);
            AuthProtocol.writeSBA(this.Rc, dataOutput);
            AuthProtocol.writeSBA(this.MacC, dataOutput);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            this.userid = dataInputStream.readUTF();
            this.xid = dataInputStream.readUTF();
            this.Rc = AuthProtocol.readSBA(dataInputStream);
            this.MacC = AuthProtocol.readSBA(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class ChallengeMPR
    extends MsgBase {
        String serverId;
        String serverXid;
        byte[] Rs;

        short getType() {
            return 19779;
        }

        ChallengeMPR(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeMPR(String string, String string2, byte[] byArray) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "ChallengeMPR", string, string2, byArray);
            }
            this.serverId = string;
            this.serverXid = string2;
            this.Rs = byArray;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "ChallengeMPR");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            dataOutput.writeUTF(this.serverId);
            dataOutput.writeUTF(this.serverXid);
            AuthProtocol.writeSBA(this.Rs, dataOutput);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            this.serverId = dataInputStream.readUTF();
            this.serverXid = dataInputStream.readUTF();
            this.Rs = AuthProtocol.readSBA(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class OkayUP_pxid
    extends OkayUP {
        short getType() {
            return 79;
        }

        OkayUP_pxid(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkayUP_pxid() {
            super(null, null);
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
        }
    }

    class OkayUP
    extends MsgBase {
        String serverId;
        String serverXid;

        short getType() {
            return 111;
        }

        OkayUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkayUP(String string, String string2) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "OkayUP", string, string2);
            }
            this.serverId = string;
            this.serverXid = string2;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "OkayUP");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            dataOutput.writeUTF(this.serverId);
            dataOutput.writeUTF(this.serverXid);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            this.serverId = dataInputStream.readUTF();
            this.serverXid = dataInputStream.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class ReplyUP
    extends MsgBase {
        String userid;
        String password;
        String xid;

        short getType() {
            return 85;
        }

        ReplyUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ReplyUP(String string, String string2, String string3) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "ReplyUP", string, "********", string3);
            }
            this.userid = string;
            this.password = string2;
            this.xid = string3;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "ReplyUP");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            dataOutput.writeUTF(this.userid);
            dataOutput.writeUTF(this.password);
            dataOutput.writeUTF(this.xid);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            this.userid = dataInputStream.readUTF();
            this.password = dataInputStream.readUTF();
            this.xid = dataInputStream.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class ChallengeUP_pxid
    extends MsgBase {
        short getType() {
            return 67;
        }

        ChallengeUP_pxid(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeUP_pxid() {
        }
    }

    class ChallengeUP
    extends MsgBase {
        short getType() {
            return 99;
        }

        ChallengeUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeUP() {
        }
    }

    class AuthException
    extends AuthProtocolException {
        AuthException(int n, String string) {
            super(n, string);
        }

        AuthException(String string, AuthExceptionMsg authExceptionMsg) {
            super(-authExceptionMsg.getCode(), string);
        }
    }

    class HeadRequest
    extends MsgBase {
        short getType() {
            return 17480;
        }

        HeadRequest(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            throw new IOException(ExceptionBuilder.buildReasonString(1218, null));
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            int n = 0;
            do {
                by4 = dataInputStream.readByte();
                if (n++ <= 60) continue;
                throw new IOException(ExceptionBuilder.buildReasonString(1219, null));
            } while (by4 != 13 || (by3 = dataInputStream.readByte()) != 10 || (by2 = dataInputStream.readByte()) != 13 || (by = dataInputStream.readByte()) != 10);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class AuthExceptionMsg
    extends MsgBase {
        int code;
        String reason;

        short getType() {
            return 88;
        }

        AuthExceptionMsg(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        String getMessage() {
            return this.reason;
        }

        int getCode() {
            return this.code;
        }

        AuthExceptionMsg(int n, String string) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "AuthExceptionMsg", new Integer(n), string);
            }
            this.code = n;
            this.reason = string;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "AuthExceptionMsg");
            }
        }

        AuthExceptionMsg(AuthException authException) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "AuthExceptionMsg", authException);
            }
            this.code = authException.getCode();
            this.reason = authException.getMessage();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "AuthExceptionMsg");
            }
        }

        public String toString() {
            return "code=" + this.code + ", reason=" + this.reason;
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            dataOutput.writeInt(this.code);
            dataOutput.writeUTF(this.reason);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            this.code = dataInputStream.readInt();
            this.reason = dataInputStream.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class Hello
    extends MsgBase {
        short[] protos;

        short getType() {
            return 22600;
        }

        Hello(DataInputStream dataInputStream, short s) throws IOException, AuthException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "Hello", dataInputStream, new Short(s));
            }
            this.protos = new short[]{s};
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "Hello");
            }
        }

        Hello(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        Hello(short[] sArray) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "Hello", sArray);
            }
            this.protos = sArray != null ? sArray : new short[]{AuthProtocol.this.defProto};
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "Hello");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            dataOutput.writeShort(this.protos.length);
            int n = 0;
            while (n < this.protos.length) {
                dataOutput.writeShort(this.protos[n]);
                ++n;
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            int n = dataInputStream.readUnsignedShort();
            this.protos = new short[n];
            int n2 = 0;
            while (n2 < n) {
                this.protos[n2] = dataInputStream.readShort();
                ++n2;
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }

    class MsgBase {
        short getType() {
            return 0;
        }

        MsgBase() {
        }

        protected MsgBase(DataInputStream dataInputStream) throws IOException, AuthException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "MsgBase", dataInputStream);
            }
            this.readBody(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "MsgBase");
            }
        }

        MsgBase readMsg(DataInputStream dataInputStream) throws IOException, AuthException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readMsg", dataInputStream);
            }
            int n = dataInputStream.readInt();
            MsgBase msgBase = null;
            if (122605 != n) {
                if (n == 1212498244) {
                    msgBase = new HeadRequest(dataInputStream);
                    if (debug.debugIt(64)) {
                        debug.debug(-175921860444054L, "readMsg", msgBase);
                    }
                    return msgBase;
                }
                byte[] byArray = new byte[60];
                byArray[0] = (byte)(n >> 24);
                byArray[1] = (byte)(n >> 16);
                byArray[2] = (byte)(n >> 8);
                byArray[3] = (byte)n;
                int n2 = 4;
                try {
                    if (dataInputStream.available() > 0) {
                        n2 += dataInputStream.read(byArray, n2, byArray.length - n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new AuthException(91, ExceptionBuilder.buildReasonString(1205, new Object[]{MsgUtil.hexify(byArray, 0, n2)}));
            }
            short s = dataInputStream.readShort();
            if (debug.debugIt(16)) {
                debug.debug(-175921860444056L, "readMsg", "Received msg type: " + s);
            }
            switch (s) {
                case 88: {
                    msgBase = new AuthExceptionMsg(dataInputStream);
                    break;
                }
                case 72: {
                    msgBase = new Hello(dataInputStream, 67);
                    break;
                }
                case 22600: {
                    msgBase = new Hello(dataInputStream);
                    break;
                }
                case 99: {
                    msgBase = new ChallengeUP(dataInputStream);
                    break;
                }
                case 67: {
                    msgBase = new ChallengeUP_pxid(dataInputStream);
                    break;
                }
                case 85: {
                    msgBase = new ReplyUP(dataInputStream);
                    break;
                }
                case 111: {
                    msgBase = new OkayUP(dataInputStream);
                    break;
                }
                case 79: {
                    msgBase = new OkayUP_pxid(dataInputStream);
                    break;
                }
                case 19779: {
                    msgBase = new ChallengeMPR(dataInputStream);
                    break;
                }
                case 19797: {
                    msgBase = new ResponseAndCounter(dataInputStream);
                    break;
                }
                case 19791: {
                    msgBase = new OkayResponse(dataInputStream);
                    break;
                }
                case 21315: {
                    msgBase = new ChallengeSSLUP(dataInputStream);
                    break;
                }
                case 21333: {
                    msgBase = new ReplySSLUP(dataInputStream);
                    break;
                }
                case 21327: {
                    msgBase = new OkaySSLUP(dataInputStream);
                    break;
                }
                case 21059: {
                    msgBase = new ChallengeSSLPure(dataInputStream);
                    break;
                }
                case 21077: {
                    msgBase = new ReplySSLPure(dataInputStream);
                    break;
                }
                case 21071: {
                    msgBase = new OkaySSLPure(dataInputStream);
                    break;
                }
                default: {
                    throw new AuthException(92, ExceptionBuilder.buildReasonString(1210, new Object[]{new Short(s)}));
                }
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readMsg", msgBase);
            }
            return msgBase;
        }

        public void writeMsg(DataOutputStream dataOutputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeMsg", dataOutputStream);
            }
            dataOutputStream.writeInt(122605);
            dataOutputStream.writeShort(this.getType());
            this.writeBody(dataOutputStream);
            dataOutputStream.flush();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeMsg");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "writeBody", dataOutput);
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException, AuthException {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "readBody", dataInputStream);
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "readBody");
            }
        }
    }
}

