/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.net;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.net.IMBServerSocket;
import com.ibm.disthubmq.impl.net.IMBServerSocketFactory;
import com.ibm.disthubmq.impl.net.IMBSocket;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.IOException;

public abstract class IMBSocketFactory
implements ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("IMBSocketFactory");
    private static String[] publicNames = new String[]{"tcp", "http", "connect-via-proxy"};
    private static String[] fullNames = new String[]{"tcp.IMBTcp", "http.IMBHttp", "proxy.IMBConnect"};
    private static IMBSocketFactory[] factories = new IMBSocketFactory[fullNames.length];
    private static IMBServerSocketFactory[] serverFactories = new IMBServerSocketFactory[fullNames.length];

    private static int findIndex(String string) {
        int n = 0;
        while (n < publicNames.length) {
            if (string.equalsIgnoreCase(publicNames[n])) {
                return n;
            }
            ++n;
        }
        throw Assert.failureError(ExceptionBuilder.buildReasonString(1040, new Object[]{string}));
    }

    private static Object load(String string, String string2) {
        String string3 = "";
        try {
            string3 = "com.ibm.disthubmq.impl.net." + string + string2;
            return Class.forName(string3).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Assert.failureError(classNotFoundException, ExceptionBuilder.buildReasonString(1041, new Object[]{string3, classNotFoundException}));
        }
        catch (InstantiationException instantiationException) {
            throw Assert.failureError(instantiationException, ExceptionBuilder.buildReasonString(1041, new Object[]{string3, instantiationException}));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Assert.failureError(illegalAccessException, ExceptionBuilder.buildReasonString(1041, new Object[]{string3, illegalAccessException}));
        }
    }

    public static IMBSocket createSocket(String string, String string2, int n) throws IOException {
        int n2;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createSocket", string, string2, new Integer(n));
        }
        if (factories[n2 = IMBSocketFactory.findIndex(string)] == null) {
            IMBSocketFactory[] iMBSocketFactoryArray = factories;
            synchronized (iMBSocketFactoryArray) {
                IMBSocketFactory.factories[n2] = (IMBSocketFactory)IMBSocketFactory.load(fullNames[n2], "SocketFactory");
            }
        }
        IMBSocket iMBSocket = factories[n2].createIMBSocket(string2, n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createSocket", iMBSocket);
        }
        return iMBSocket;
    }

    public static IMBServerSocket createServerSocket(String string, int n) throws IOException {
        int n2;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createServerSocket", string, new Integer(n));
        }
        if (serverFactories[n2 = IMBSocketFactory.findIndex(string)] == null) {
            IMBServerSocketFactory[] iMBServerSocketFactoryArray = serverFactories;
            synchronized (iMBServerSocketFactoryArray) {
                IMBSocketFactory.serverFactories[n2] = (IMBServerSocketFactory)IMBSocketFactory.load(fullNames[n2], "ServerSocketFactory");
            }
        }
        IMBServerSocket iMBServerSocket = serverFactories[n2].createIMBServerSocket(n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createServerSocket", iMBServerSocket);
        }
        return iMBServerSocket;
    }

    public abstract IMBSocket createIMBSocket(String var1, int var2) throws IOException;
}

