/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching.parser;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.parser.Environment;
import com.ibm.disthubmq.impl.matching.parser.MatchParser;
import com.ibm.disthubmq.impl.matching.parser.MatchParserTreeConstants;
import com.ibm.disthubmq.impl.matching.parser.Node;
import com.ibm.disthubmq.impl.matching.parser.TypeCheckException;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import java.util.Hashtable;

public abstract class SimpleNode
implements Node,
ClientExceptionConstants {
    private static final DebugObject debug = new DebugObject("SimpleNode");
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected MatchParser parser;
    protected static int nextUniqueId = 0;
    protected int uniqueId;
    protected int refCount = 1;
    protected int h_code = 0;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(MatchParser matchParser, int n) {
        this(n);
        this.parser = matchParser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return MatchParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }

    public int typeCheck(Environment environment, int n) throws TypeCheckException {
        throw new TypeCheckException(ExceptionBuilder.buildReasonString(1277, null));
    }

    public int hashCode() {
        if (this.h_code == 0) {
            int n = this.jjtGetNumChildren();
            this.h_code = 0;
            int n2 = 0;
            while (n2 < n) {
                this.h_code += this.jjtGetChild(n2).hashCode();
                ++n2;
            }
            this.h_code = this.h_code * 64 % 0x1FFFFFF + this.id;
        }
        return this.h_code;
    }

    public SimpleNode buildTable(Hashtable hashtable) {
        SimpleNode simpleNode;
        int n = this.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            simpleNode = (SimpleNode)this.jjtGetChild(n2);
            SimpleNode simpleNode2 = simpleNode.buildTable(hashtable);
            if (simpleNode2 != simpleNode) {
                this.jjtAddChild(simpleNode2, n2);
            }
            ++n2;
        }
        simpleNode = (SimpleNode)hashtable.get(this);
        if (simpleNode != null) {
            ++simpleNode.refCount;
            return simpleNode;
        }
        this.uniqueId = nextUniqueId++;
        EvalCache.incrementMinSize();
        hashtable.put(this, this);
        return this;
    }

    public final Object getValue(FormattedMessage formattedMessage, EvalCache evalCache) throws TypeCheckException, BadMessageFormatMatchingException {
        if (evalCache == null) {
            return this.eval(formattedMessage, evalCache);
        }
        Object object = evalCache.get(this.uniqueId);
        if (object != null) {
            return object;
        }
        object = this.eval(formattedMessage, evalCache);
        evalCache.put(this.uniqueId, object);
        return object;
    }

    public abstract Object eval(FormattedMessage var1, EvalCache var2) throws TypeCheckException, BadMessageFormatMatchingException;

    public void remove(Hashtable hashtable) {
        --this.refCount;
        Assert.condition(this.refCount >= 0);
        if (this.refCount == 0) {
            Object object;
            int n = this.jjtGetNumChildren();
            int n2 = 0;
            while (n2 < n) {
                object = (SimpleNode)this.jjtGetChild(n2);
                ((SimpleNode)object).remove(hashtable);
                ++n2;
            }
            object = hashtable.remove(this);
            Assert.condition(object != null);
        }
    }
}

