/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching.parser;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.BooleanResult;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.NoSuchFieldNameException;
import com.ibm.disthubmq.impl.matching.parser.Environment;
import com.ibm.disthubmq.impl.matching.parser.MatchParser;
import com.ibm.disthubmq.impl.matching.parser.NullValueException;
import com.ibm.disthubmq.impl.matching.parser.SimpleNode;
import com.ibm.disthubmq.impl.matching.parser.TypeCheckException;
import com.ibm.disthubmq.spi.ExceptionBuilder;

public class MatchIdentifier
extends SimpleNode {
    private static final DebugObject debug = new DebugObject("MatchIdentifier");
    private boolean headerDetermined;
    private boolean isHeaderField;
    public String m_name;
    public int m_type = 0;
    public boolean m_negative;
    boolean quoted;

    public MatchIdentifier(int n) {
        super(n);
    }

    public MatchIdentifier(MatchParser matchParser, int n) {
        super(matchParser, n);
    }

    public String toString() {
        if (this.quoted) {
            return "\"" + this.m_name + "\"";
        }
        return this.m_name;
    }

    public int typeCheck(Environment environment, int n) throws TypeCheckException {
        int n2 = environment.lookup(this.m_name);
        if (n2 == n || n == 0) {
            return n2;
        }
        switch (n2) {
            case 0: {
                if (n != 0) {
                    environment.bind(this.m_name, n);
                }
                return n;
            }
            case 5: {
                if (n == 2) {
                    environment.bind(this.m_name, n);
                }
                if (n != 2 && n != 3) break;
                return n;
            }
            case 2: {
                if (n != 3 && n != 5) break;
                return n;
            }
            case 3: {
                if (n != 5) break;
                return n;
            }
        }
        throw new TypeCheckException(ExceptionBuilder.buildReasonString(1272, new Object[]{this.m_name, Environment.typeName[n2], Environment.typeName[n]}));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MatchIdentifier)) {
            return false;
        }
        MatchIdentifier matchIdentifier = (MatchIdentifier)object;
        return this.m_name.equals(matchIdentifier.m_name) && this.m_negative == matchIdentifier.m_negative;
    }

    public Object eval(FormattedMessage formattedMessage, EvalCache evalCache) throws TypeCheckException, BadMessageFormatMatchingException {
        Object object = null;
        try {
            if (!this.headerDetermined) {
                this.isHeaderField = formattedMessage.isValidHeaderValue(this.m_name);
                this.headerDetermined = true;
            }
            object = this.isHeaderField ? formattedMessage.getHeaderValue(this.m_name) : formattedMessage.getFieldValue(this.m_name);
        }
        catch (NoSuchFieldNameException noSuchFieldNameException) {
            object = null;
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            throw new BadMessageFormatMatchingException();
        }
        catch (Exception exception) {
            throw new TypeCheckException(ExceptionBuilder.buildReasonString(1273, new Object[]{exception}));
        }
        if (object == null) {
            if (this.m_type == 1) {
                return BooleanResult.create(true, true);
            }
            throw new NullValueException(ExceptionBuilder.buildReasonString(1274, new Object[]{this.m_name}));
        }
        if (object instanceof Boolean) {
            return BooleanResult.create(false, (Boolean)object);
        }
        if (this.m_negative) {
            if (object instanceof Double || object instanceof Float) {
                return new Double(-((Number)object).doubleValue());
            }
            if (object instanceof Number) {
                return new Long(-((Number)object).longValue());
            }
            return null;
        }
        return object;
    }
}

