/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.AdminSpace;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.CacheingSearchResults;
import com.ibm.disthubmq.impl.matching.ContentCheck;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.Factory;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.MatchSpace;
import com.ibm.disthubmq.impl.matching.MatchTarget;
import com.ibm.disthubmq.impl.matching.Matcher;
import com.ibm.disthubmq.impl.matching.MatchingException;
import com.ibm.disthubmq.impl.matching.QuerySyntaxException;
import com.ibm.disthubmq.impl.matching.SearchResults;
import com.ibm.disthubmq.impl.matching.SubjectMatcher;
import com.ibm.disthubmq.impl.matching.parser.CharStream;
import com.ibm.disthubmq.impl.matching.parser.Environment;
import com.ibm.disthubmq.impl.matching.parser.FieldProcessor;
import com.ibm.disthubmq.impl.matching.parser.SimpleNode;
import com.ibm.disthubmq.impl.matching.parser.TokenMgrError;
import com.ibm.disthubmq.impl.matching.parser.TypeCheckException;
import com.ibm.disthubmq.impl.util.FastHashtable;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.SessionConfig;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

final class SubscriptionSpace
implements ClientExceptionConstants,
ClientLogConstants,
FastHashtable.RehashFilter {
    private static final DebugObject debug = new DebugObject("SubscriptionSpace");
    FastHashtable matchCache;
    volatile long wildGeneration = 0L;
    Matcher root;
    AdminSpace admin;
    MatchSpace lock;
    Parser parser;
    private int exactPuts;
    private int wildPuts;
    private int resultCacheHitGets;
    private int wildCacheHitGets;
    private int wildCacheMissGets;
    private int exactMatches;
    private int resultsCached;
    private int removals;
    private int cacheCreates;
    private int cacheRemoves;
    private int optimisticGets;
    private int pessimisticGets;
    private int puntsDueToCache;

    SubscriptionSpace(MatchSpace matchSpace, AdminSpace adminSpace) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SubscriptionSpace", matchSpace, adminSpace);
        }
        this.lock = matchSpace;
        this.admin = adminSpace;
        this.matchCache = new FastHashtable(SessionConfig.MATCH_CACHE_INITIAL_CAPACITY);
        this.matchCache.setRehashFilter(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SubscriptionSpace");
        }
    }

    ContentCheck[] put(String string, boolean bl, String string2, MatchTarget matchTarget, MatchTarget[] matchTargetArray, Environment environment, FieldProcessor fieldProcessor, Hashtable hashtable) throws QuerySyntaxException, MatchingException {
        ContentCheck[] contentCheckArray;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", new Object[]{string, new Boolean(bl), string2, matchTarget, matchTargetArray, environment, fieldProcessor, hashtable});
        }
        SimpleNode simpleNode = null;
        if (string2 != null && string2.length() != 0) {
            contentCheckArray = new CharStream(new StringReader(string2), 1, 1);
            try {
                if (this.parser == null) {
                    this.parser = new Parser();
                }
                simpleNode = this.parser.parse((CharStream)contentCheckArray, environment, fieldProcessor);
            }
            catch (RuntimeException runtimeException) {
                throw new QuerySyntaxException(ExceptionBuilder.buildReasonString(1233, new Object[]{runtimeException}));
            }
            catch (TypeCheckException typeCheckException) {
                throw new QuerySyntaxException(ExceptionBuilder.buildReasonString(1233, new Object[]{typeCheckException}));
            }
            catch (Error error2) {
                throw new QuerySyntaxException(ExceptionBuilder.buildReasonString(1233, new Object[]{error2}));
            }
        }
        ContentCheck[] contentCheckArray2 = contentCheckArray = simpleNode == null ? null : Factory.preprocess(simpleNode);
        if (!bl) {
            CacheEntry cacheEntry = this.getCacheEntry(string, true);
            ++cacheEntry.exactGeneration;
            Matcher matcher = cacheEntry.exactMatcher;
            if (matcher == null) {
                cacheEntry.exactMatcher = matcher = Factory.createMatcher(0, string, contentCheckArray);
            }
            cacheEntry.noResultCache = cacheEntry.noResultCache | simpleNode != null;
            cacheEntry.cachedResults = null;
            try {
                try {
                    matcher.put(string, contentCheckArray, matchTarget, hashtable, matchTargetArray);
                }
                catch (RuntimeException runtimeException) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{runtimeException}));
                }
                catch (Error error3) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{error3}));
                }
                Object var16_19 = null;
                ++cacheEntry.exactGeneration;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                ++cacheEntry.exactGeneration;
                throw throwable;
            }
            ++this.exactPuts;
        } else {
            ++this.wildGeneration;
            if (this.root == null) {
                this.root = new SubjectMatcher(true, false);
            }
            try {
                try {
                    this.root.put(string, contentCheckArray, matchTarget, hashtable, matchTargetArray);
                }
                catch (RuntimeException runtimeException) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{runtimeException}));
                }
                catch (Error error4) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{error4}));
                }
                Object var18_23 = null;
                ++this.wildGeneration;
            }
            catch (Throwable throwable) {
                Object var18_24 = null;
                ++this.wildGeneration;
                throw throwable;
            }
            ++this.wildPuts;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put", contentCheckArray);
        }
        return contentCheckArray;
    }

    CacheEntry getCacheEntry(String string, boolean bl) throws MatchingException {
        CacheEntry cacheEntry;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getCacheEntry", string, new Boolean(bl));
        }
        if ((cacheEntry = (CacheEntry)this.matchCache.get(string)) == null && bl) {
            cacheEntry = new CacheEntry();
            cacheEntry.admins = this.admin.getLocked(string);
            ++cacheEntry.admins.refCount;
            this.matchCache.put(string, cacheEntry);
            ++this.cacheCreates;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getCacheEntry", cacheEntry);
        }
        return cacheEntry;
    }

    public boolean shouldRetain(Object object, Object object2) {
        CacheEntry cacheEntry = (CacheEntry)object2;
        if (cacheEntry.exactMatcher != null) {
            return true;
        }
        --cacheEntry.admins.refCount;
        if (cacheEntry.admins.refCount == 0) {
            this.admin.unCache((String)object, cacheEntry.admins);
        }
        ++this.cacheRemoves;
        return false;
    }

    void get(String string, FormattedMessage formattedMessage, SearchResults searchResults, EvalCache evalCache) throws MatchingException, BadMessageFormatMatchingException {
        CacheEntry cacheEntry;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "get", string, formattedMessage, searchResults, evalCache);
        }
        if (evalCache != null) {
            evalCache.prepareCache();
        }
        if ((cacheEntry = this.getCacheEntry(string, false)) == null) {
            ++this.puntsDueToCache;
            this.pessimisticGet(string, formattedMessage, searchResults, evalCache);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "get");
            }
            return;
        }
        long l = this.wildGeneration;
        long l2 = cacheEntry.exactGeneration;
        long l3 = this.admin.wildGeneration;
        long l4 = cacheEntry.admins.exactGeneration;
        if ((l & 1L) == 1L || (l2 & 1L) == 1L || (l3 & 1L) == 1L || (l4 & 1L) == 1L) {
            this.pessimisticGet(string, formattedMessage, searchResults, evalCache);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "get");
            }
            return;
        }
        if (l != cacheEntry.wildGeneration || !cacheEntry.noResultCache && cacheEntry.cachedResults == null || l3 != cacheEntry.admins.wildGeneration || cacheEntry.admins.consolidated == null) {
            ++this.puntsDueToCache;
            this.pessimisticGet(string, formattedMessage, searchResults, evalCache);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "get");
            }
            return;
        }
        SearchResults searchResults2 = searchResults;
        synchronized (searchResults2) {
        }
        Throwable throwable = null;
        try {
            if (cacheEntry.cachedResults != null && searchResults.acceptCacheable(cacheEntry.cachedResults)) {
                ++this.resultCacheHitGets;
            } else {
                if (cacheEntry.wildMatchers != null) {
                    int n = 0;
                    while (n < cacheEntry.wildMatchers.length) {
                        cacheEntry.wildMatchers[n].get(null, formattedMessage, searchResults, evalCache);
                        ++n;
                    }
                    ++this.wildCacheHitGets;
                }
                if (cacheEntry.exactMatcher != null) {
                    cacheEntry.exactMatcher.get(null, formattedMessage, searchResults, evalCache);
                    ++this.exactMatches;
                }
            }
            cacheEntry.admins.consolidated.get(null, null, searchResults, null);
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (Error error2) {
            throwable = error2;
        }
        if (l != this.wildGeneration || l2 != cacheEntry.exactGeneration || l3 != this.admin.wildGeneration || l4 != cacheEntry.admins.exactGeneration) {
            searchResults.reset();
            this.pessimisticGet(string, formattedMessage, searchResults, evalCache);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "get");
            }
            return;
        }
        if (throwable != null) {
            throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{throwable}));
        }
        ++this.optimisticGets;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "get");
        }
    }

    private void pessimisticGet(String string, FormattedMessage formattedMessage, SearchResults searchResults, EvalCache evalCache) throws MatchingException, BadMessageFormatMatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "pessimisticGet", string, formattedMessage, searchResults, evalCache);
        }
        MatchSpace matchSpace = this.lock;
        synchronized (matchSpace) {
            CacheEntry cacheEntry = this.getCacheEntry(string, true);
            if (cacheEntry.wildGeneration != this.wildGeneration || cacheEntry.admins.wildGeneration != this.admin.wildGeneration) {
                cacheEntry.cachedResults = null;
                cacheEntry.wildMatchers = null;
            }
            if (cacheEntry.cachedResults != null && searchResults.acceptCacheable(cacheEntry.cachedResults)) {
                ++this.resultCacheHitGets;
                ++this.pessimisticGets;
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "pessimisticGet");
                }
                return;
            }
            if (cacheEntry.wildMatchers != null) {
                int n = 0;
                while (n < cacheEntry.wildMatchers.length) {
                    try {
                        cacheEntry.wildMatchers[n].get(null, formattedMessage, searchResults, evalCache);
                    }
                    catch (RuntimeException runtimeException) {
                        throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{runtimeException}));
                    }
                    catch (Error error2) {
                        throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{error2}));
                    }
                    ++n;
                }
                ++this.wildCacheHitGets;
            } else if (this.root != null) {
                CacheingSearchResults cacheingSearchResults = new CacheingSearchResults(searchResults);
                try {
                    this.root.get(string, formattedMessage, cacheingSearchResults, evalCache);
                }
                catch (RuntimeException runtimeException) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{runtimeException}));
                }
                catch (Error error3) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{error3}));
                }
                cacheEntry.wildMatchers = cacheingSearchResults.getMatchers();
                cacheEntry.wildGeneration = this.wildGeneration;
                cacheEntry.noResultCache |= cacheingSearchResults.hasContent;
                ++this.wildCacheMissGets;
            }
            if (cacheEntry.exactMatcher != null) {
                try {
                    cacheEntry.exactMatcher.get(null, formattedMessage, searchResults, evalCache);
                }
                catch (RuntimeException runtimeException) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{runtimeException}));
                }
                catch (Error error4) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{error4}));
                }
                ++this.exactMatches;
            }
            cacheEntry.admins = this.admin.getLocked(string);
            cacheEntry.admins.consolidated.get(null, null, searchResults, null);
            if (!cacheEntry.noResultCache) {
                cacheEntry.cachedResults = searchResults.provideCacheable(string);
                if (cacheEntry.cachedResults != null) {
                    ++this.resultsCached;
                }
            }
            ++this.pessimisticGets;
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "pessimisticGet");
            }
            return;
        }
    }

    void remove(String string, boolean bl, ContentCheck[] contentCheckArray, MatchTarget matchTarget, Hashtable hashtable) throws MatchingException {
        block17: {
            boolean bl2;
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "remove", string, new Boolean(bl), contentCheckArray, matchTarget, hashtable);
            }
            if (bl) {
                if (this.root == null) {
                    throw new MatchingException(ExceptionBuilder.buildReasonString(1234, new Object[]{string, matchTarget}));
                }
                ++this.wildGeneration;
                try {
                    block16: {
                        try {
                            boolean bl3 = this.root.remove(string, contentCheckArray, matchTarget, hashtable);
                            if (!bl3) break block16;
                            this.root = null;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{runtimeException}));
                        }
                        catch (Error error2) {
                            throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{error2}));
                        }
                    }
                    Object var9_9 = null;
                    ++this.wildGeneration;
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    ++this.wildGeneration;
                    throw throwable;
                }
            }
            CacheEntry cacheEntry = (CacheEntry)this.matchCache.get(string);
            if (cacheEntry == null || cacheEntry.exactMatcher == null) {
                throw new MatchingException(ExceptionBuilder.buildReasonString(1235, new Object[]{string, matchTarget}));
            }
            ++cacheEntry.exactGeneration;
            try {
                bl2 = cacheEntry.exactMatcher.remove(string, contentCheckArray, matchTarget, hashtable);
            }
            catch (RuntimeException runtimeException) {
                ++cacheEntry.exactGeneration;
                throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{runtimeException}));
            }
            catch (Error error3) {
                ++cacheEntry.exactGeneration;
                throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{error3}));
            }
            if (bl2) {
                cacheEntry.exactMatcher = null;
                if (cacheEntry.wildMatchers == null || cacheEntry.wildGeneration != this.wildGeneration || cacheEntry.wildMatchers.length == 0) {
                    this.matchCache.remove(string);
                    --cacheEntry.admins.refCount;
                    if (cacheEntry.admins.refCount == 0) {
                        this.admin.unCache(string, cacheEntry.admins);
                    }
                    ++this.cacheRemoves;
                }
            }
            cacheEntry.cachedResults = null;
            ++cacheEntry.exactGeneration;
        }
        ++this.removals;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "remove");
        }
    }

    void statistics() {
        int n = this.pessimisticGets - this.puntsDueToCache;
        System.err.println("Exact puts: " + this.exactPuts + ", Wildcard generation: " + this.wildGeneration + ", Wildcard puts: " + this.wildPuts + ", Wildcard-Cache-hit gets: " + this.wildCacheHitGets + ", Wildcard-Cache-miss gets: " + this.wildCacheMissGets + ", Result-Cache-hit gets: " + this.resultCacheHitGets + ", Exact matches: " + this.exactMatches + ", Results cached: " + this.resultsCached + ", Removals:" + this.removals + ", Cache entries created:" + this.cacheCreates + ", Cache entries removed:" + this.cacheRemoves + ", Optimistic gets:" + this.optimisticGets + ", True Pessimistic gets:" + n + ", Mutating gets:" + this.puntsDueToCache);
    }

    void clear() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clear");
        }
        this.root = null;
        this.wildGeneration = 0L;
        this.matchCache = new FastHashtable(SessionConfig.MATCH_CACHE_INITIAL_CAPACITY);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clear");
        }
    }

    private static class Parser {
        private Method reInit;
        private Method getExpr;
        private Object parser;
        static /* synthetic */ Class class$com$ibm$disthubmq$impl$matching$parser$CharStream;
        static /* synthetic */ Class class$com$ibm$disthubmq$impl$matching$parser$Environment;
        static /* synthetic */ Class class$com$ibm$disthubmq$impl$matching$parser$FieldProcessor;

        private Parser() {
        }

        SimpleNode parse(CharStream charStream, Environment environment, FieldProcessor fieldProcessor) throws QuerySyntaxException, MatchingException {
            try {
                if (this.parser == null) {
                    Class<?> clazz = Class.forName("com.ibm.disthubmq.impl.matching.parser.MatchParser");
                    Constructor<?> constructor = clazz.getConstructor(class$com$ibm$disthubmq$impl$matching$parser$CharStream == null ? (class$com$ibm$disthubmq$impl$matching$parser$CharStream = Parser.class$("com.ibm.disthubmq.impl.matching.parser.CharStream")) : class$com$ibm$disthubmq$impl$matching$parser$CharStream);
                    this.reInit = clazz.getMethod("ReInit", class$com$ibm$disthubmq$impl$matching$parser$CharStream == null ? (class$com$ibm$disthubmq$impl$matching$parser$CharStream = Parser.class$("com.ibm.disthubmq.impl.matching.parser.CharStream")) : class$com$ibm$disthubmq$impl$matching$parser$CharStream);
                    this.getExpr = clazz.getMethod("QueryExpr", class$com$ibm$disthubmq$impl$matching$parser$Environment == null ? (class$com$ibm$disthubmq$impl$matching$parser$Environment = Parser.class$("com.ibm.disthubmq.impl.matching.parser.Environment")) : class$com$ibm$disthubmq$impl$matching$parser$Environment, class$com$ibm$disthubmq$impl$matching$parser$FieldProcessor == null ? (class$com$ibm$disthubmq$impl$matching$parser$FieldProcessor = Parser.class$("com.ibm.disthubmq.impl.matching.parser.FieldProcessor")) : class$com$ibm$disthubmq$impl$matching$parser$FieldProcessor);
                    this.parser = constructor.newInstance(charStream);
                } else {
                    this.reInit.invoke(this.parser, charStream);
                }
                if (environment == null) {
                    environment = new Environment();
                }
                return (SimpleNode)this.getExpr.invoke(this.parser, environment, fieldProcessor);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof InvocationTargetException) {
                    throwable2 = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable2 instanceof QuerySyntaxException) {
                    throw (QuerySyntaxException)throwable2;
                }
                if (throwable2 instanceof TypeCheckException) {
                    throw new QuerySyntaxException(ExceptionBuilder.buildReasonString(1249, new Object[]{throwable2}));
                }
                if (throwable2 instanceof TokenMgrError) {
                    throw new QuerySyntaxException(ExceptionBuilder.buildReasonString(1249, new Object[]{throwable2}));
                }
                if (debug.debugIt(16)) {
                    debug.debug(-175921860444056L, "parse", "caught a general throwable: " + throwable2);
                }
                throw new MatchingException(ExceptionBuilder.buildReasonString(1248, null));
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class CacheEntry {
        Matcher exactMatcher;
        volatile long exactGeneration;
        Matcher[] wildMatchers;
        long wildGeneration;
        Object cachedResults;
        boolean noResultCache;
        AdminSpace.CacheEntry admins;

        private CacheEntry() {
        }
    }
}

