/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.CacheingMatcher;
import com.ibm.disthubmq.impl.matching.ContentCheck;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.Factory;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.InverseSubjectMatcher;
import com.ibm.disthubmq.impl.matching.LeafMatcher;
import com.ibm.disthubmq.impl.matching.MatchTarget;
import com.ibm.disthubmq.impl.matching.Matcher;
import com.ibm.disthubmq.impl.matching.MatchingException;
import com.ibm.disthubmq.impl.matching.PartialMatch;
import com.ibm.disthubmq.impl.matching.SearchResults;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.FastHashtable;
import com.ibm.disthubmq.spi.ClientLogConstants;
import java.util.Enumeration;
import java.util.Hashtable;

final class SubjectMatcher
extends Matcher
implements ClientLogConstants {
    private static final DebugObject debug = new DebugObject("AdminSpace");
    private FastHashtable exactMatches;
    private PartialMatch partMatches;
    private boolean noContent;

    SubjectMatcher(boolean bl, boolean bl2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SubjectMatcher", new Boolean(bl), new Boolean(bl2));
        }
        if (!bl) {
            this.exactMatches = new FastHashtable();
        }
        this.noContent = bl2;
        this.partMatches = new PartialMatch();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SubjectMatcher");
        }
    }

    public void put(String string, ContentCheck[] contentCheckArray, MatchTarget matchTarget, Hashtable hashtable, MatchTarget[] matchTargetArray) throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", string, contentCheckArray, matchTarget, hashtable, matchTargetArray);
        }
        int n = string.indexOf(43);
        int n2 = string.indexOf(35);
        Matcher matcher = null;
        if (n == -1 && n2 == -1) {
            matcher = (Matcher)this.exactMatches.get(string);
            if (matcher == null) {
                matcher = new CacheingMatcher(this.noContent ? new LeafMatcher() : Factory.createMatcher(0, string, contentCheckArray));
                this.exactMatches.put(string, matcher);
            }
            string = "";
        } else if (n == -1 || n2 != -1 && n2 < n) {
            PartialMatch partialMatch = this.partMatches.get(string.substring(0, n2 > 0 ? n2 - 1 : 0));
            string = string.length() - n2 > 2 ? string.substring(n2 + 2) : "";
            matcher = partialMatch.hashChild;
            if (matcher == null) {
                partialMatch.hashChild = matcher = new InverseSubjectMatcher(this.noContent);
            }
        } else {
            PartialMatch partialMatch = this.partMatches.get(string.substring(0, n > 0 ? n - 1 : 0));
            string = string.length() - n > 2 ? string.substring(n + 2) : "";
            matcher = partialMatch.starChild;
            if (matcher == null) {
                partialMatch.starChild = matcher = new SubjectMatcher(false, this.noContent);
            }
        }
        matcher.put(string, contentCheckArray, matchTarget, hashtable, matchTargetArray);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put");
        }
    }

    public void get(String string, FormattedMessage formattedMessage, SearchResults searchResults, EvalCache evalCache) throws MatchingException, BadMessageFormatMatchingException {
        Matcher matcher;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "get", string, formattedMessage, searchResults, evalCache);
        }
        int n = string.length();
        PartialMatch partialMatch = this.partMatches;
        while (partialMatch != null && partialMatch.keylen <= n) {
            block10: {
                String string2;
                int n2;
                block11: {
                    if (partialMatch.keylen != 0 && !string.startsWith(partialMatch.key) || partialMatch.starChild == null && partialMatch.hashChild == null) break block10;
                    n2 = partialMatch.keylen;
                    if (n2 >= n || n2 <= 0) break block11;
                    if (string.charAt(n2) != '/') break block10;
                    ++n2;
                }
                if ((string2 = string.substring(n2)).length() <= 0 || string2.charAt(0) != '\u0001') {
                    if (partialMatch.hashChild != null) {
                        partialMatch.hashChild.get(string2, formattedMessage, searchResults, evalCache);
                    }
                    if (partialMatch.starChild != null && n != n2) {
                        int n3 = string2.indexOf("/");
                        string2 = n3 != -1 ? string2.substring(n3 + 1) : "";
                        partialMatch.starChild.get(string2, formattedMessage, searchResults, evalCache);
                    }
                }
            }
            partialMatch = partialMatch.next;
        }
        if (this.exactMatches != null && (matcher = (Matcher)this.exactMatches.get(string)) != null) {
            matcher.get(string, formattedMessage, searchResults, evalCache);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "get");
        }
    }

    public boolean remove(String string, ContentCheck[] contentCheckArray, MatchTarget matchTarget, Hashtable hashtable) throws MatchingException {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "remove", string, contentCheckArray, matchTarget, hashtable);
        }
        int n = string.indexOf(43);
        int n2 = string.indexOf(35);
        PartialMatch partialMatch = null;
        if (n == -1 && n2 == -1) {
            Matcher matcher = (Matcher)this.exactMatches.get(string);
            Assert.condition(matcher != null);
            if (matcher.remove(null, contentCheckArray, matchTarget, hashtable)) {
                this.exactMatches.remove(string);
            }
        } else if (n == -1 || n2 != -1 && n2 < n) {
            partialMatch = this.partMatches.get(string.substring(0, n2 > 0 ? n2 - 1 : 0));
            Assert.condition(partialMatch != null);
            string = string.length() - n2 > 2 ? string.substring(n2 + 2) : "";
            Assert.condition(partialMatch.hashChild != null);
            if (partialMatch.hashChild.remove(string, contentCheckArray, matchTarget, hashtable)) {
                partialMatch.hashChild = null;
            }
        } else {
            partialMatch = this.partMatches.get(string.substring(0, n > 0 ? n - 1 : 0));
            string = string.length() - n > 2 ? string.substring(n + 2) : "";
            Assert.condition(partialMatch.starChild != null);
            if (partialMatch.starChild.remove(string, contentCheckArray, matchTarget, hashtable)) {
                partialMatch.starChild = null;
            }
        }
        if (partialMatch != null && partialMatch.isEmpty()) {
            this.partMatches.remove(partialMatch);
        }
        boolean bl2 = bl = (this.exactMatches == null || this.exactMatches.isEmpty()) && this.partMatches.isEmptyChain();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "remove", new Boolean(bl));
        }
        return bl;
    }

    public void dump() {
        System.err.println("Exact:");
        if (this.exactMatches != null) {
            Enumeration enumeration = this.exactMatches.keys();
            while (enumeration.hasMoreElements()) {
                System.err.println(enumeration.nextElement());
            }
        }
        System.err.println("Partial:");
        PartialMatch partialMatch = this.partMatches;
        while (partialMatch != null) {
            if (partialMatch.hashChild != null) {
                System.err.println(partialMatch.key + (partialMatch.keylen == 0 ? "" : "/") + "#" + " ... Contents:");
                ((InverseSubjectMatcher)partialMatch.hashChild).dump();
                System.err.println("...end contents");
            }
            if (partialMatch.starChild != null) {
                System.err.println(partialMatch.key + (partialMatch.keylen == 0 ? "" : "/") + "+" + " ... Contents:");
                ((SubjectMatcher)partialMatch.starChild).dump();
                System.err.println("...end contents");
            }
            partialMatch = partialMatch.next;
        }
    }
}

