/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.ContentCheck;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.Factory;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.MatchTarget;
import com.ibm.disthubmq.impl.matching.Matcher;
import com.ibm.disthubmq.impl.matching.MatchingException;
import com.ibm.disthubmq.impl.matching.NoSuchFieldNameException;
import com.ibm.disthubmq.impl.matching.SearchResults;
import com.ibm.disthubmq.impl.matching.StringEqualityCheck;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import java.util.Hashtable;

public class StringMatcher
extends Matcher
implements ClientExceptionConstants,
ClientLogConstants {
    private static final DebugObject debug = new DebugObject("StringMatcher");
    int attribute;
    String attributeName;
    private boolean headerDetermined;
    private boolean isHeaderField;
    private static final int INITIAL_CHILDREN_CAPACITY = 10;
    private Hashtable children;
    private Matcher vacantChild;

    public StringMatcher(int n, String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "StringMatcher", new Integer(n), string);
        }
        this.attribute = n;
        this.attributeName = string;
        this.children = new Hashtable(10);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "StringMatcher");
        }
    }

    public void put(String string, ContentCheck[] contentCheckArray, MatchTarget matchTarget, Hashtable hashtable, MatchTarget[] matchTargetArray) throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", string, contentCheckArray, matchTarget, hashtable, matchTargetArray);
        }
        int n = 0;
        Matcher matcher = null;
        if (contentCheckArray != null) {
            n = 0;
            while (n < contentCheckArray.length && contentCheckArray[n].getAttribute() < this.attribute) {
                ++n;
            }
        }
        if (contentCheckArray == null || n == contentCheckArray.length || contentCheckArray[n].getAttribute() != this.attribute) {
            if (this.vacantChild == null) {
                this.vacantChild = Factory.createMatcher(this.attribute, string, contentCheckArray);
            }
            matcher = this.vacantChild;
        } else if (contentCheckArray[n] instanceof StringEqualityCheck) {
            String string2 = ((StringEqualityCheck)contentCheckArray[n]).getTest();
            matcher = (Matcher)this.children.get(string2);
            if (matcher == null) {
                matcher = Factory.createMatcher(this.attribute, string, contentCheckArray);
                this.children.put(string2, matcher);
            }
        } else {
            throw new RuntimeException(ExceptionBuilder.buildReasonString(1236, new Object[]{contentCheckArray[n].getClass()}));
        }
        matcher.put(string, contentCheckArray, matchTarget, hashtable, matchTargetArray);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put");
        }
    }

    public void get(String string, FormattedMessage formattedMessage, SearchResults searchResults, EvalCache evalCache) throws MatchingException, BadMessageFormatMatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "get", string, formattedMessage, searchResults, evalCache);
        }
        if (formattedMessage != null) {
            try {
                Matcher matcher;
                Object object;
                if (!this.headerDetermined) {
                    this.isHeaderField = formattedMessage.isValidHeaderValue(this.attributeName);
                    this.headerDetermined = true;
                }
                if ((object = this.isHeaderField ? formattedMessage.getHeaderStringValue(this.attributeName) : formattedMessage.getFieldValue(this.attributeName)) != null && (matcher = (Matcher)this.children.get(object)) != null) {
                    matcher.get(string, formattedMessage, searchResults, evalCache);
                }
            }
            catch (NoSuchFieldNameException noSuchFieldNameException) {
                // empty catch block
            }
        }
        if (this.vacantChild != null) {
            this.vacantChild.get(string, formattedMessage, searchResults, evalCache);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "get");
        }
    }

    public boolean remove(String string, ContentCheck[] contentCheckArray, MatchTarget matchTarget, Hashtable hashtable) throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "remove", string, contentCheckArray, matchTarget, hashtable);
        }
        int n = 0;
        Matcher matcher = null;
        boolean bl = false;
        if (contentCheckArray != null) {
            n = 0;
            while (n < contentCheckArray.length && contentCheckArray[n].getAttribute() != this.attribute) {
                ++n;
            }
        }
        String string2 = null;
        if (contentCheckArray != null && n < contentCheckArray.length && contentCheckArray[n] != null) {
            string2 = ((StringEqualityCheck)contentCheckArray[n]).getTest();
        }
        if (string2 == null || n == contentCheckArray.length) {
            if (this.vacantChild != null && (bl = this.vacantChild.remove(string, contentCheckArray, matchTarget, hashtable))) {
                this.vacantChild = null;
            }
        } else if (contentCheckArray[n] instanceof StringEqualityCheck) {
            matcher = (Matcher)this.children.get(string2);
            Assert.condition(matcher != null);
            bl = matcher.remove(string, contentCheckArray, matchTarget, hashtable);
            if (bl) {
                this.children.remove(string2);
            }
        } else {
            Assert.failure("(StringMatcher.remove) Unknown check type.");
        }
        boolean bl2 = false;
        if (bl && this.children.size() == 0 && this.vacantChild == null) {
            bl2 = true;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "remove", new Boolean(bl2));
        }
        return bl2;
    }
}

