/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.AdminSpace;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.ContentCheck;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.InvalidTopicSyntaxException;
import com.ibm.disthubmq.impl.matching.MatchTarget;
import com.ibm.disthubmq.impl.matching.MatchingException;
import com.ibm.disthubmq.impl.matching.QuerySyntaxException;
import com.ibm.disthubmq.impl.matching.SearchResults;
import com.ibm.disthubmq.impl.matching.SubscriptionSpace;
import com.ibm.disthubmq.impl.matching.parser.Environment;
import com.ibm.disthubmq.impl.matching.parser.FieldProcessor;
import com.ibm.disthubmq.impl.util.FastHashtable;
import com.ibm.disthubmq.impl.util.FastVector;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import java.util.Enumeration;
import java.util.Hashtable;

public final class MatchSpace
implements ClientExceptionConstants,
ClientLogConstants {
    private static final DebugObject debug = new DebugObject("MatchSpace");
    AdminSpace admin = new AdminSpace();
    FastHashtable adminSubs = new FastHashtable();
    SubscriptionPoint defaultSubPoint = new SubscriptionPoint(this, this.admin);
    FastHashtable subPoints = new FastHashtable();
    Hashtable subExpr = new Hashtable();

    public MatchSpace() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MatchSpace");
        }
        this.subPoints.put("", this.defaultSubPoint);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MatchSpace");
        }
    }

    public synchronized void put(String string, String string2, String string3, MatchTarget matchTarget, MatchTarget[] matchTargetArray, Environment environment, FieldProcessor fieldProcessor) throws MatchingException, InvalidTopicSyntaxException, QuerySyntaxException {
        SubscriptionPoint subscriptionPoint;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", string, string2, string3, matchTarget, matchTargetArray, environment, fieldProcessor);
        }
        if (string == null || string.length() == 0) {
            subscriptionPoint = this.defaultSubPoint;
        } else {
            subscriptionPoint = (SubscriptionPoint)this.subPoints.get(string);
            if (subscriptionPoint == null) {
                subscriptionPoint = new SubscriptionPoint(this, this.admin);
                this.subPoints.put(string, subscriptionPoint);
            }
        }
        this.putInternal(subscriptionPoint, string2, string3, matchTarget, matchTargetArray, environment, fieldProcessor);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put");
        }
    }

    public synchronized void put(String string, String string2, MatchTarget matchTarget, MatchTarget[] matchTargetArray, Environment environment, FieldProcessor fieldProcessor) throws MatchingException, InvalidTopicSyntaxException, QuerySyntaxException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", string, string2, matchTarget, matchTargetArray, environment, fieldProcessor);
        }
        this.putInternal(this.defaultSubPoint, string, string2, matchTarget, matchTargetArray, environment, fieldProcessor);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put");
        }
    }

    public void put(String string, String string2, String string3, MatchTarget matchTarget, MatchTarget[] matchTargetArray) throws MatchingException, InvalidTopicSyntaxException, QuerySyntaxException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", string, string2, string3, matchTarget, matchTargetArray);
        }
        this.put(string, string2, string3, matchTarget, matchTargetArray, null, null);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put");
        }
    }

    public void put(String string, String string2, MatchTarget matchTarget, MatchTarget[] matchTargetArray) throws MatchingException, InvalidTopicSyntaxException, QuerySyntaxException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", string, string2, matchTarget, matchTargetArray);
        }
        this.put(string, string2, matchTarget, matchTargetArray, null, null);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put");
        }
    }

    private void putInternal(SubscriptionPoint subscriptionPoint, String string, String string2, MatchTarget matchTarget, MatchTarget[] matchTargetArray, Environment environment, FieldProcessor fieldProcessor) throws QuerySyntaxException, MatchingException, InvalidTopicSyntaxException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "putInternal", subscriptionPoint, string, string2, matchTarget, matchTargetArray, environment, fieldProcessor);
        }
        boolean bl = MatchSpace.checkTopicSyntax(string);
        ContentCheck[] contentCheckArray = subscriptionPoint.subSpace.put(string, bl, string2, matchTarget, matchTargetArray, environment, fieldProcessor, this.subExpr);
        try {
            this.storeSubscription(string, contentCheckArray, bl, matchTarget, subscriptionPoint.subscriptions);
        }
        catch (MatchingException matchingException) {
            try {
                subscriptionPoint.subSpace.remove(string, bl, contentCheckArray, matchTarget, this.subExpr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw matchingException;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "putInternal");
        }
    }

    private void storeSubscription(String string, ContentCheck[] contentCheckArray, boolean bl, MatchTarget matchTarget, FastHashtable fastHashtable) throws MatchingException {
        FastHashtable fastHashtable2;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "storeSubscription", string, contentCheckArray, new Boolean(bl), matchTarget, fastHashtable);
        }
        Subscription subscription = new Subscription(string, contentCheckArray, bl, matchTarget);
        String string2 = matchTarget.getTargetName();
        if (string2 == null) {
            string2 = string;
        }
        if ((fastHashtable2 = (FastHashtable)fastHashtable.get(string2)) == null) {
            fastHashtable2 = new FastHashtable();
            fastHashtable.put(string2, fastHashtable2);
        }
        if (fastHashtable2.containsKey(matchTarget)) {
            throw new MatchingException(ExceptionBuilder.buildReasonString(1242, null));
        }
        fastHashtable2.put(matchTarget, subscription);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "storeSubscription");
        }
    }

    public void putAdmin(String string, MatchTarget matchTarget) throws MatchingException, InvalidTopicSyntaxException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "putAdmin", string, matchTarget);
        }
        boolean bl = MatchSpace.checkTopicSyntax(string);
        this.storeSubscription(string, null, bl, matchTarget, this.adminSubs);
        this.admin.put(string, bl, matchTarget, this.subExpr);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "putAdmin");
        }
    }

    public void get(String string, String string2, FormattedMessage formattedMessage, SearchResults searchResults, EvalCache evalCache) throws MatchingException, BadMessageFormatMatchingException {
        SubscriptionPoint subscriptionPoint;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "get", string, string2, formattedMessage, searchResults, evalCache);
        }
        if ((subscriptionPoint = this.getSubPoint(string)) != null) {
            subscriptionPoint.subSpace.get(string2, formattedMessage, searchResults, evalCache);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "get");
        }
    }

    private SubscriptionPoint getSubPoint(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getSubPoint", string);
        }
        SubscriptionPoint subscriptionPoint = this.defaultSubPoint;
        if (string != null && string.length() > 0) {
            subscriptionPoint = (SubscriptionPoint)this.subPoints.get(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getSubPoint", subscriptionPoint);
        }
        return subscriptionPoint;
    }

    public void get(String string, FormattedMessage formattedMessage, SearchResults searchResults, EvalCache evalCache) throws MatchingException, BadMessageFormatMatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "get", string, formattedMessage, searchResults, evalCache);
        }
        this.defaultSubPoint.subSpace.get(string, formattedMessage, searchResults, evalCache);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "get");
        }
    }

    public void getAdmin(String string, SearchResults searchResults) throws MatchingException {
        AdminSpace.CacheEntry cacheEntry;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAdmin", string, searchResults);
        }
        if ((cacheEntry = this.admin.get(string)) == null) {
            this.pessimisticGetAdmin(string, searchResults);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "getAdmin");
            }
            return;
        }
        long l = this.admin.wildGeneration;
        long l2 = cacheEntry.exactGeneration;
        if ((l & 1L) == 1L || (l2 & 1L) == 1L) {
            this.pessimisticGetAdmin(string, searchResults);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "getAdmin");
            }
            return;
        }
        if (l != cacheEntry.wildGeneration || cacheEntry.consolidated == null) {
            this.pessimisticGetAdmin(string, searchResults);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "getAdmin");
            }
            return;
        }
        SearchResults searchResults2 = searchResults;
        synchronized (searchResults2) {
        }
        Throwable throwable = null;
        try {
            cacheEntry.consolidated.get(string, null, searchResults, null);
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{badMessageFormatMatchingException}));
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (Error error2) {
            throwable = error2;
        }
        if (l != this.admin.wildGeneration || l2 != cacheEntry.exactGeneration) {
            searchResults.reset();
            this.pessimisticGetAdmin(string, searchResults);
        }
        if (throwable != null) {
            throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{throwable}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAdmin");
        }
    }

    private synchronized void pessimisticGetAdmin(String string, SearchResults searchResults) throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "pessimisticGetAdmin", string, searchResults);
        }
        try {
            AdminSpace.CacheEntry cacheEntry = this.admin.getLocked(string);
            cacheEntry.consolidated.get(string, null, searchResults, null);
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            throw new MatchingException(ExceptionBuilder.buildReasonString(1233, new Object[]{badMessageFormatMatchingException}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "pessimisticGetAdmin");
        }
    }

    public synchronized void remove(MatchTarget matchTarget) throws MatchingException {
        String string;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "remove", matchTarget);
        }
        if ((string = matchTarget.getTargetName()) == null) {
            throw new MatchingException(ExceptionBuilder.buildReasonString(1243, new Object[]{matchTarget}));
        }
        this.removeInternal(this.defaultSubPoint, string, matchTarget);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "remove");
        }
    }

    public synchronized void remove(String string, MatchTarget matchTarget) throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "remove", string, matchTarget);
        }
        this.removeInternal(this.defaultSubPoint, string, matchTarget);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "remove");
        }
    }

    public synchronized void remove(String string, String string2, MatchTarget matchTarget) throws MatchingException {
        SubscriptionPoint subscriptionPoint;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "remove", string, string2, matchTarget);
        }
        if ((subscriptionPoint = this.getSubPoint(string)) == null) {
            throw new MatchingException(ExceptionBuilder.buildReasonString(1244, new Object[]{string2, matchTarget}));
        }
        this.removeInternal(subscriptionPoint, string2, matchTarget);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "remove");
        }
    }

    private void removeInternal(SubscriptionPoint subscriptionPoint, String string, MatchTarget matchTarget) throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "removeInternal", subscriptionPoint, string, matchTarget);
        }
        Subscription subscription = this.removeSubscription(subscriptionPoint.subscriptions, string, matchTarget);
        subscriptionPoint.subSpace.remove(subscription.topic, subscription.hasWilds, subscription.expr, subscription.origTarget, this.subExpr);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "removeInternal");
        }
    }

    private Subscription removeSubscription(FastHashtable fastHashtable, String string, MatchTarget matchTarget) throws MatchingException {
        String string2;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "removeSubscription", fastHashtable, string, matchTarget);
        }
        if ((string2 = matchTarget.getTargetName()) == null) {
            string2 = string;
        }
        Subscription subscription = null;
        FastHashtable fastHashtable2 = (FastHashtable)fastHashtable.get(string2);
        if (fastHashtable2 != null) {
            subscription = (Subscription)fastHashtable2.remove(matchTarget);
        }
        if (subscription == null) {
            throw new MatchingException(ExceptionBuilder.buildReasonString(1244, new Object[]{string, matchTarget}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "removeSubscription", subscription);
        }
        return subscription;
    }

    public synchronized void removeAdmin(String string, MatchTarget matchTarget) throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "removeAdmin", string, matchTarget);
        }
        Subscription subscription = this.removeSubscription(this.adminSubs, string, matchTarget);
        this.admin.remove(subscription.topic, subscription.hasWilds, subscription.origTarget, this.subExpr);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "removeAdmin");
        }
    }

    public static boolean checkTopicSyntax(String string) throws InvalidTopicSyntaxException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "checkTopicSyntax", string);
        }
        if (string == null) {
            throw new InvalidTopicSyntaxException(ExceptionBuilder.buildReasonString(1245, null));
        }
        char[] cArray = string.toCharArray();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        char c = '?';
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '+': {
                    if (bl2) {
                        bl4 = true;
                        bl3 = false;
                        bl2 = false;
                        c = cArray[n];
                        break;
                    }
                    throw new InvalidTopicSyntaxException(ExceptionBuilder.buildReasonString(1246, new Object[]{"+"}));
                }
                case '#': {
                    if (bl2 && bl) {
                        if (n != 0 && n != cArray.length - 1) {
                            throw new InvalidTopicSyntaxException(ExceptionBuilder.buildReasonString(1246, new Object[]{"#"}));
                        }
                        bl4 = true;
                        bl3 = false;
                        bl = false;
                        bl2 = false;
                        c = cArray[n];
                        break;
                    }
                    throw new InvalidTopicSyntaxException(ExceptionBuilder.buildReasonString(1246, new Object[]{"#"}));
                }
                case '/': {
                    if (bl2) {
                        throw new InvalidTopicSyntaxException(ExceptionBuilder.buildReasonString(1247, new Object[]{"/"}));
                    }
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                default: {
                    if (!bl3) {
                        throw new InvalidTopicSyntaxException(ExceptionBuilder.buildReasonString(1246, new Object[]{new Character(c)}));
                    }
                    bl2 = false;
                }
            }
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "checkTopicSyntax", new Boolean(bl4));
        }
        return bl4;
    }

    public synchronized Enumeration getAllMatchTargets(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllMatchTargets", string);
        }
        FastVector fastVector = new FastVector();
        SubscriptionPoint subscriptionPoint = this.getSubPoint(string);
        if (subscriptionPoint != null) {
            this.getAllMatchTargetsInternal(subscriptionPoint.subscriptions, fastVector);
        }
        Enumeration enumeration = fastVector.elements();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllMatchTargets", enumeration);
        }
        return enumeration;
    }

    public synchronized Enumeration getAllMatchTargets() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllMatchTargets");
        }
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.subPoints.elements();
        while (enumeration.hasMoreElements()) {
            this.getAllMatchTargetsInternal(((SubscriptionPoint)enumeration.nextElement()).subscriptions, fastVector);
        }
        Enumeration enumeration2 = fastVector.elements();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllMatchTargets", enumeration2);
        }
        return enumeration2;
    }

    public synchronized Enumeration getAllSubscriptionPoints() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllSubscriptionPoints");
        }
        Enumeration enumeration = this.subPoints.keys();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllSubscriptionPoints", enumeration);
        }
        return enumeration;
    }

    public synchronized Enumeration getAllAdminMatchTargets() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllAdminMatchTargets");
        }
        FastVector fastVector = new FastVector();
        this.getAllMatchTargetsInternal(this.adminSubs, fastVector);
        Enumeration enumeration = fastVector.elements();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllAdminMatchTargets", enumeration);
        }
        return enumeration;
    }

    private void getAllMatchTargetsInternal(FastHashtable fastHashtable, FastVector fastVector) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllMatchTargetsInternal", fastHashtable, fastVector);
        }
        Enumeration enumeration = fastHashtable.elements();
        while (enumeration.hasMoreElements()) {
            FastHashtable fastHashtable2 = (FastHashtable)enumeration.nextElement();
            Enumeration enumeration2 = fastHashtable2.keys();
            while (enumeration2.hasMoreElements()) {
                MatchTarget matchTarget = (MatchTarget)enumeration2.nextElement();
                fastVector.addElement(matchTarget);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllMatchTargetsInternal");
        }
    }

    public synchronized int getNumberOfMatchTargets(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getNumberOfMatchTargets", string);
        }
        SubscriptionPoint subscriptionPoint = this.getSubPoint(string);
        int n = 0;
        if (subscriptionPoint != null) {
            n = this.getNumberOfMatchTargetsInternal(subscriptionPoint.subscriptions);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getNumberOfMatchTargets", new Integer(n));
        }
        return n;
    }

    public synchronized int getNumberOfAdminMatchTargets() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getNumberOfAdminMatchTargets");
        }
        int n = this.getNumberOfMatchTargetsInternal(this.adminSubs);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getNumberOfAdminMatchTargets", new Integer(n));
        }
        return n;
    }

    private int getNumberOfMatchTargetsInternal(FastHashtable fastHashtable) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getNumberOfMatchTargetsInternal", fastHashtable);
        }
        int n = 0;
        Enumeration enumeration = fastHashtable.elements();
        while (enumeration.hasMoreElements()) {
            FastHashtable fastHashtable2 = (FastHashtable)enumeration.nextElement();
            n += fastHashtable2.size();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getNumberOfMatchTargetsInternal", new Integer(n));
        }
        return n;
    }

    public synchronized FastVector getAllMatchTargetsForTopic(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllMatchTargetsForTopic", string);
        }
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.subPoints.elements();
        while (enumeration.hasMoreElements()) {
            this.getAllMatchTargetsForTopicInternal(((SubscriptionPoint)enumeration.nextElement()).subscriptions, string, fastVector);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllMatchTargetsForTopic", fastVector);
        }
        return fastVector;
    }

    public synchronized FastVector getAllMatchTargetsForTopic(String string, String string2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllMatchTargetsForTopic", string, string2);
        }
        FastVector fastVector = new FastVector();
        SubscriptionPoint subscriptionPoint = this.getSubPoint(string);
        if (subscriptionPoint != null) {
            this.getAllMatchTargetsForTopicInternal(subscriptionPoint.subscriptions, string2, fastVector);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllMatchTargetsForTopic", fastVector);
        }
        return fastVector;
    }

    public synchronized FastVector getAllAdminMatchTargetsForTopic(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllAdminMatchTargetsForTopic", string);
        }
        FastVector fastVector = new FastVector();
        this.getAllMatchTargetsForTopicInternal(this.adminSubs, string, fastVector);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllAdminMatchTargetsForTopic", fastVector);
        }
        return fastVector;
    }

    private void getAllMatchTargetsForTopicInternal(FastHashtable fastHashtable, String string, FastVector fastVector) {
        FastHashtable fastHashtable2;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAllMatchTargetsForTopicInternal", fastHashtable, string, fastVector);
        }
        if ((fastHashtable2 = (FastHashtable)fastHashtable.get(string)) != null) {
            Enumeration enumeration = fastHashtable2.keys();
            while (enumeration.hasMoreElements()) {
                MatchTarget matchTarget = (MatchTarget)enumeration.nextElement();
                fastVector.addElement(matchTarget);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAllMatchTargetsForTopicInternal");
        }
    }

    public synchronized void clear(String string) throws MatchingException {
        SubscriptionPoint subscriptionPoint;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clear", string);
        }
        if ((subscriptionPoint = this.getSubPoint(string)) != null) {
            subscriptionPoint.subSpace.clear();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clear");
        }
    }

    public synchronized void clearAdmin() throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clearAdmin");
        }
        this.admin.clear();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clearAdmin");
        }
    }

    public void statistics() {
        this.defaultSubPoint.subSpace.statistics();
    }

    private static class SubscriptionPoint {
        FastHashtable subscriptions = new FastHashtable();
        SubscriptionSpace subSpace;

        SubscriptionPoint(MatchSpace matchSpace, AdminSpace adminSpace) {
            this.subSpace = new SubscriptionSpace(matchSpace, adminSpace);
        }
    }

    private static class Subscription {
        String topic;
        ContentCheck[] expr;
        boolean hasWilds;
        MatchTarget origTarget;

        Subscription(String string, ContentCheck[] contentCheckArray, boolean bl, MatchTarget matchTarget) {
            this.topic = string;
            this.expr = contentCheckArray;
            this.hasWilds = bl;
            this.origTarget = matchTarget;
        }
    }
}

