/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.BooleanEqualityCheck;
import com.ibm.disthubmq.impl.matching.BooleanMatcher;
import com.ibm.disthubmq.impl.matching.ContentCheck;
import com.ibm.disthubmq.impl.matching.DifficultCheck;
import com.ibm.disthubmq.impl.matching.DifficultMatcher;
import com.ibm.disthubmq.impl.matching.FloatEqualityCheck;
import com.ibm.disthubmq.impl.matching.FloatMatcher;
import com.ibm.disthubmq.impl.matching.IntEqualityCheck;
import com.ibm.disthubmq.impl.matching.IntMatcher;
import com.ibm.disthubmq.impl.matching.Matcher;
import com.ibm.disthubmq.impl.matching.Result;
import com.ibm.disthubmq.impl.matching.StringEqualityCheck;
import com.ibm.disthubmq.impl.matching.StringMatcher;
import com.ibm.disthubmq.impl.matching.SubjectMatcher;
import com.ibm.disthubmq.impl.matching.parser.Environment;
import com.ibm.disthubmq.impl.matching.parser.MatchBooleanAndExpr;
import com.ibm.disthubmq.impl.matching.parser.MatchBooleanConstant;
import com.ibm.disthubmq.impl.matching.parser.MatchComparisonPredicate;
import com.ibm.disthubmq.impl.matching.parser.MatchFloatConstant;
import com.ibm.disthubmq.impl.matching.parser.MatchIdentifier;
import com.ibm.disthubmq.impl.matching.parser.MatchIntegerConstant;
import com.ibm.disthubmq.impl.matching.parser.MatchStringConstant;
import com.ibm.disthubmq.impl.matching.parser.SimpleNode;
import com.ibm.disthubmq.impl.matching.parser.TypeCheckException;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import java.util.Hashtable;
import java.util.Vector;

class Factory
implements ClientExceptionConstants,
ClientLogConstants {
    private static final DebugObject debug = new DebugObject("Factory");
    public static final int ROOT_ATTRIBUTE = -1;
    public static final int INITIAL_SUBJECT_ATTRIBUTE = 0;
    public static final String SPECIAL_FINAL_NAME = "$$FINAL";
    public static final String SPECIAL_FORMAT_NAME = "$$FORMAT";
    private static final int INITIAL_NONSUBJECT_ATTRIBUTE = Integer.MIN_VALUE;
    private static final int ERROR_ATTRIBUTE = -3;
    private static final int INITIAL_TYPE_ARRAY_SIZE = 30;
    private static Factory fact = new Factory();
    private int nextAttribute = Integer.MIN_VALUE;
    private Hashtable attributes;
    private short[] attribTypes;
    private String[] attribNames;

    private Factory() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "Factory");
        }
        this.attributes = new Hashtable();
        this.attribTypes = new short[30];
        this.attribNames = new String[30];
        this.attributes.put("$$FINAL$$0", new Integer(-2));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "Factory");
        }
    }

    public static Matcher createMatcher(int n, String string, ContentCheck[] contentCheckArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createMatcher", new Integer(n), string, contentCheckArray);
        }
        Matcher matcher = fact.createMatcherInternal(n, string, contentCheckArray);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createMatcher", matcher);
        }
        return matcher;
    }

    public static ContentCheck[] preprocess(SimpleNode simpleNode) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "preprocess", simpleNode);
        }
        ContentCheck[] contentCheckArray = fact.preprocessInternal(simpleNode);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "preprocess", contentCheckArray);
        }
        return contentCheckArray;
    }

    private Matcher createMatcherInternal(int n, String string, ContentCheck[] contentCheckArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createMatcherInternal", new Integer(n), string, contentCheckArray);
        }
        if (n == -1) {
            SubjectMatcher subjectMatcher = new SubjectMatcher(true, false);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "createMatcherInternal", subjectMatcher);
            }
            return subjectMatcher;
        }
        if (n == -3) {
            throw new RuntimeException(ExceptionBuilder.buildReasonString(1241, null));
        }
        int n2 = n >= 0 ? Integer.MIN_VALUE : n + 1;
        Matcher matcher = null;
        if (this.legalAttribute(n2)) {
            switch (this.getAttributeType(n2)) {
                case 2: {
                    matcher = new IntMatcher(n2, this.getAttributeName(n2));
                    break;
                }
                case 4: {
                    matcher = new StringMatcher(n2, this.getAttributeName(n2));
                    break;
                }
                case 3: {
                    matcher = new FloatMatcher(n2, this.getAttributeName(n2));
                    break;
                }
                case 1: {
                    matcher = new BooleanMatcher(n2, this.getAttributeName(n2));
                    break;
                }
                default: {
                    Assert.failureError("(Factory.createInternal) Illegal type for attribute " + n2);
                    break;
                }
            }
        } else {
            matcher = new DifficultMatcher(n);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createMatcherInternal", matcher);
        }
        return matcher;
    }

    private ContentCheck[] preprocessInternal(SimpleNode simpleNode) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "preprocessInternal", simpleNode);
        }
        Vector<DifficultCheck> vector = new Vector<DifficultCheck>();
        simpleNode = this.findChecks(simpleNode, vector);
        vector.addElement(new DifficultCheck(this.getAttributeId(SPECIAL_FINAL_NAME, 0), simpleNode));
        ContentCheck[] contentCheckArray = this.sortCheckVector(vector);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "preprocessInternal", contentCheckArray);
        }
        return contentCheckArray;
    }

    private SimpleNode findChecks(SimpleNode simpleNode, Vector vector) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "findChecks", simpleNode, vector);
        }
        if (simpleNode instanceof MatchBooleanAndExpr) {
            SimpleNode simpleNode2;
            SimpleNode simpleNode3 = this.findChecks((SimpleNode)simpleNode.jjtGetChild(0), vector);
            SimpleNode simpleNode4 = this.findChecks((SimpleNode)simpleNode.jjtGetChild(1), vector);
            if (simpleNode3 == null && simpleNode4 == null) {
                simpleNode2 = null;
            } else if (simpleNode3 == null) {
                simpleNode2 = simpleNode4;
            } else if (simpleNode4 == null) {
                simpleNode2 = simpleNode3;
            } else {
                if (simpleNode3 != simpleNode.jjtGetChild(0)) {
                    simpleNode.jjtAddChild(simpleNode3, 0);
                }
                if (simpleNode4 != simpleNode.jjtGetChild(1)) {
                    simpleNode.jjtAddChild(simpleNode4, 1);
                }
                simpleNode2 = simpleNode;
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "findChecks", simpleNode2);
            }
            return simpleNode2;
        }
        if (simpleNode instanceof MatchComparisonPredicate && ((MatchComparisonPredicate)simpleNode).getOp() == 6) {
            SimpleNode simpleNode5 = (SimpleNode)simpleNode.jjtGetChild(0);
            SimpleNode simpleNode6 = (SimpleNode)simpleNode.jjtGetChild(1);
            int n = 0;
            try {
                n = simpleNode5.typeCheck(new Environment(), 0);
                n = simpleNode6.typeCheck(new Environment(), n);
            }
            catch (TypeCheckException typeCheckException) {
                try {
                    n = simpleNode6.typeCheck(new Environment(), 0);
                }
                catch (TypeCheckException typeCheckException2) {
                    if (debug.debugIt(64)) {
                        debug.debug(-175921860444054L, "findChecks", simpleNode);
                    }
                    return simpleNode;
                }
            }
            int n2 = -3;
            String string = null;
            Object object = null;
            boolean bl = false;
            if (simpleNode5 instanceof MatchIdentifier && (simpleNode6 instanceof MatchBooleanConstant || simpleNode6 instanceof MatchFloatConstant || simpleNode6 instanceof MatchIntegerConstant || simpleNode6 instanceof MatchStringConstant)) {
                string = ((MatchIdentifier)simpleNode5).m_name;
                bl = ((MatchIdentifier)simpleNode5).m_negative;
                try {
                    object = simpleNode6.getValue(null, null);
                }
                catch (TypeCheckException typeCheckException) {
                    string = null;
                }
                catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
                    string = null;
                }
            } else if (simpleNode6 instanceof MatchIdentifier && (simpleNode5 instanceof MatchBooleanConstant || simpleNode5 instanceof MatchFloatConstant || simpleNode5 instanceof MatchIntegerConstant || simpleNode5 instanceof MatchStringConstant)) {
                string = ((MatchIdentifier)simpleNode6).m_name;
                bl = ((MatchIdentifier)simpleNode6).m_negative;
                try {
                    object = simpleNode5.getValue(null, null);
                }
                catch (TypeCheckException typeCheckException) {
                    string = null;
                }
                catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
                    string = null;
                }
            }
            if (string != null) {
                try {
                    switch (n) {
                        case 2: {
                            n2 = this.getAttributeId(string, 2);
                            long l = Result.longValue(object);
                            if (bl) {
                                l = -l;
                            }
                            IntEqualityCheck intEqualityCheck = new IntEqualityCheck(n2, l);
                            vector.addElement(intEqualityCheck);
                            break;
                        }
                        case 4: {
                            if (bl) break;
                            n2 = this.getAttributeId(string, 4);
                            StringEqualityCheck stringEqualityCheck = new StringEqualityCheck(n2, Result.stringValue(object));
                            vector.addElement(stringEqualityCheck);
                            break;
                        }
                        case 3: {
                            n2 = this.getAttributeId(string, 3);
                            double d = Result.floatValue(object);
                            if (bl) {
                                d = -d;
                            }
                            FloatEqualityCheck floatEqualityCheck = new FloatEqualityCheck(n2, d);
                            vector.addElement(floatEqualityCheck);
                            break;
                        }
                        case 1: {
                            if (bl) break;
                            n2 = this.getAttributeId(string, 1);
                            BooleanEqualityCheck booleanEqualityCheck = new BooleanEqualityCheck(n2, Result.isMatch(object));
                            vector.addElement(booleanEqualityCheck);
                            break;
                        }
                        default: {
                            Assert.failureError("EQ comparison on unknown type: " + n);
                        }
                    }
                }
                catch (TypeCheckException typeCheckException) {
                    typeCheckException.printStackTrace();
                    Assert.failureError("Unexpected type exception: " + typeCheckException);
                }
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "findChecks", null);
                }
                return null;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "findChecks", simpleNode);
        }
        return simpleNode;
    }

    private ContentCheck[] sortCheckVector(Vector vector) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "sortCheckVector", vector);
        }
        int n = vector.size();
        ContentCheck[] contentCheckArray = new ContentCheck[n];
        int n2 = 0;
        while (n2 < n) {
            ContentCheck contentCheck = (ContentCheck)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < n2 && contentCheckArray[n3].getAttribute() <= contentCheck.getAttribute()) {
                ++n3;
            }
            int n4 = n2;
            while (n4 > n3) {
                contentCheckArray[n4] = contentCheckArray[n4 - 1];
                --n4;
            }
            contentCheckArray[n3] = contentCheck;
            ++n2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "sortCheckVector", contentCheckArray);
        }
        return contentCheckArray;
    }

    private int getAttributeId(String string, int n) {
        Integer n2;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAttributeId", string, new Integer(n));
        }
        if ((n2 = (Integer)this.attributes.get(string + "$$" + n)) == null) {
            int n3;
            int n4;
            if ((n4 = (n3 = this.nextAttribute++) - Integer.MIN_VALUE) == this.attribTypes.length) {
                short[] sArray = new short[n4 * 2];
                System.arraycopy(this.attribTypes, 0, sArray, 0, n4);
                this.attribTypes = sArray;
                String[] stringArray = new String[n4 * 2];
                System.arraycopy(this.attribNames, 0, stringArray, 0, n4);
                this.attribNames = stringArray;
            }
            this.attribTypes[n4] = (short)n;
            this.attribNames[n4] = string;
            n2 = new Integer(n3);
            this.attributes.put(string + "$$" + n, n2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAttributeId", n2);
        }
        return n2;
    }

    private int getAttributeType(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAttributeType", new Integer(n));
        }
        Assert.condition(this.legalAttribute(n));
        short s = this.attribTypes[n - Integer.MIN_VALUE];
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAttributeType", new Integer(s));
        }
        return s;
    }

    private String getAttributeName(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAttributeName", new Integer(n));
        }
        Assert.condition(this.legalAttribute(n));
        String string = this.attribNames[n - Integer.MIN_VALUE];
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAttributeName", string);
        }
        return string;
    }

    private boolean legalAttribute(int n) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "legalAttribute", new Integer(n));
        }
        boolean bl2 = bl = n >= Integer.MIN_VALUE && n < this.nextAttribute;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "legalAttribute", new Boolean(bl));
        }
        return bl;
    }
}

