/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.BooleanResult;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.FieldTypeException;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.Monitor;
import com.ibm.disthubmq.impl.matching.SyntaxException;
import com.ibm.disthubmq.impl.matching.parser.CharStream;
import com.ibm.disthubmq.impl.matching.parser.Environment;
import com.ibm.disthubmq.impl.matching.parser.MatchParser;
import com.ibm.disthubmq.impl.matching.parser.ParseException;
import com.ibm.disthubmq.impl.matching.parser.SimpleNode;
import com.ibm.disthubmq.impl.matching.parser.TypeCheckException;
import java.io.StringReader;

public class ExpressionParser {
    private static final String sccsid = "@(#) 1.4 common/jms/com/ibm/disthubmq/impl/matching/ExpressionParser.java, jms, j000 01/10/07 21:53:42 [10/16/01 14:11:27]";
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String ostrExpression = null;
    private SimpleNode onodeExpression = null;
    private MatchParser oparser = null;
    private EvalCache ocache = null;

    public boolean eval(FormattedMessage formattedMessage) throws FieldTypeException {
        boolean bl;
        if (this.onodeExpression == null) {
            bl = true;
        } else {
            try {
                Object object = this.onodeExpression.eval(formattedMessage, this.ocache);
                if (!(object instanceof BooleanResult)) {
                    throw new FieldTypeException(object.toString());
                }
                bl = ((BooleanResult)object).isMatch();
            }
            catch (TypeCheckException typeCheckException) {
                bl = false;
            }
            catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
                bl = false;
            }
        }
        return bl;
    }

    public String getExpression() {
        String string = this.ostrExpression == null ? null : new String(this.ostrExpression);
        return string;
    }

    public void setExpression(String string) throws SyntaxException {
        this.setExpression(string, null);
    }

    public void setExpression(String string, Monitor monitor) throws SyntaxException {
        if (string == null) {
            if (this.ostrExpression != null) {
                this.ostrExpression = null;
            }
            if (this.oparser != null) {
                this.oparser = null;
            }
            if (this.onodeExpression != null) {
                this.onodeExpression = null;
            }
        } else if (this.ostrExpression == null || !this.ostrExpression.equals(string)) {
            this.ostrExpression = string;
            StringReader stringReader = new StringReader(this.ostrExpression);
            CharStream charStream = new CharStream(stringReader, 0, 0);
            this.oparser = new MatchParser(charStream);
            if (monitor != null) {
                monitor.reset();
            }
            try {
                this.onodeExpression = this.oparser.QueryExpr(new Environment(), null);
            }
            catch (ParseException parseException) {
                throw new SyntaxException(parseException.toString());
            }
        }
    }
}

