/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;

public final class EvalCache
implements ClientExceptionConstants,
ClientLogConstants {
    private static final DebugObject debug = new DebugObject("EvalCache");
    static final int INIT_SIZE = 100;
    static int MIN_SIZE = 1;
    int generation = 1;
    int[] cacheTag;
    Object[] cacheValue;

    public static void incrementMinSize() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "incrementMinSize");
        }
        ++MIN_SIZE;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "incrementMinSize");
        }
    }

    public EvalCache() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "EvalCache");
        }
        int n = 100;
        this.prepareCache();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "EvalCache");
        }
    }

    public void prepareCache() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "prepareCache");
        }
        int n = 0;
        try {
            n = this.cacheTag.length;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (n > MIN_SIZE) {
            if (this.generation == Integer.MAX_VALUE) {
                this.generation = 1;
                int n2 = 0;
                while (n2 < n) {
                    this.cacheTag[n2] = 0;
                    ++n2;
                }
            } else {
                ++this.generation;
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "prepareCache");
            }
            return;
        }
        int n3 = 100 > MIN_SIZE * 2 ? 100 : MIN_SIZE * 2;
        this.cacheTag = new int[n3];
        this.cacheValue = new Object[n3];
        this.generation = 1;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "prepareCache");
        }
    }

    public Object get(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "get", new Integer(n));
        }
        Object object = null;
        try {
            if (this.cacheTag[n] == this.generation) {
                object = this.cacheValue[n];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n < MIN_SIZE) {
                throw new RuntimeException(ExceptionBuilder.buildReasonString(1239, null));
            }
            throw new RuntimeException(ExceptionBuilder.buildReasonString(1240, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "get", object);
        }
        return object;
    }

    public void put(int n, Object object) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", new Integer(n), object);
        }
        try {
            this.cacheTag[n] = this.generation;
            this.cacheValue[n] = object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n < MIN_SIZE) {
                throw new RuntimeException(ExceptionBuilder.buildReasonString(1239, null));
            }
            throw new RuntimeException(ExceptionBuilder.buildReasonString(1240, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put");
        }
    }
}

