/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.BooleanResult;
import com.ibm.disthubmq.impl.matching.ContentCheck;
import com.ibm.disthubmq.impl.matching.DifficultCheck;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.Factory;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.MatchTarget;
import com.ibm.disthubmq.impl.matching.Matcher;
import com.ibm.disthubmq.impl.matching.MatchingException;
import com.ibm.disthubmq.impl.matching.SearchResults;
import com.ibm.disthubmq.impl.matching.parser.NullValueException;
import com.ibm.disthubmq.impl.matching.parser.SimpleNode;
import com.ibm.disthubmq.impl.matching.parser.TypeCheckException;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.FastVector;
import com.ibm.disthubmq.spi.ClientLogConstants;
import java.util.Hashtable;
import java.util.Vector;

public class DifficultMatcher
extends Matcher
implements ClientLogConstants {
    private static final DebugObject debug = new DebugObject("DifficultMatcher");
    private static final int INIT_MTTL_SIZE = 0;
    Vector roots;
    Vector objs;
    MatchTargetTypeList alwaysMatch;
    private int parentId;
    private Matcher continueBranch = null;
    public static int totalDifficultEntries = 0;

    public DifficultMatcher(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "DifficultMatcher", new Integer(n));
        }
        this.roots = new Vector();
        this.objs = new Vector();
        this.alwaysMatch = new MatchTargetTypeList();
        this.parentId = n;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "DifficultMatcher");
        }
    }

    public void put(String string, ContentCheck[] contentCheckArray, MatchTarget matchTarget, Hashtable hashtable, MatchTarget[] matchTargetArray) throws MatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "put", string, contentCheckArray, matchTarget, hashtable, matchTargetArray);
        }
        if (contentCheckArray == null || this.allSelectorsExamined(contentCheckArray)) {
            FastVector fastVector;
            Object object;
            MatchTargetTypeList matchTargetTypeList;
            SimpleNode simpleNode;
            SimpleNode simpleNode2 = simpleNode = contentCheckArray == null ? null : ((DifficultCheck)contentCheckArray[contentCheckArray.length - 1]).getExpr();
            if (simpleNode == null) {
                matchTargetTypeList = this.alwaysMatch;
            } else {
                simpleNode = simpleNode.buildTable(hashtable);
                totalDifficultEntries = hashtable.size();
                int n = this.roots.indexOf(simpleNode);
                if (n == -1) {
                    object = new MatchTargetTypeList();
                    matchTargetTypeList = object;
                    this.objs.addElement(object);
                    this.roots.addElement(simpleNode);
                } else {
                    matchTargetTypeList = (MatchTargetTypeList)this.objs.elementAt(n);
                }
            }
            matchTargetTypeList.addTarget(matchTarget);
            if (matchTarget.type() == 4) {
                FastVector fastVector2 = matchTargetTypeList.getTypeList(3);
                if (fastVector2 != null) {
                    Assert.condition(fastVector2.m_count < 2);
                    if (fastVector2.m_count == 1) {
                        matchTargetArray[0] = (MatchTarget)fastVector2.m_data[0];
                    }
                    matchTarget.setISP(matchTargetArray[0]);
                }
            } else if (matchTarget.type() == 3 && (fastVector = matchTargetTypeList.getTypeList(4)) != null) {
                int n = 0;
                while (n < fastVector.m_count) {
                    object = (MatchTarget)fastVector.m_data[n];
                    ((MatchTarget)object).setISP(matchTarget);
                    ++n;
                }
            }
        } else {
            if (this.continueBranch == null) {
                this.continueBranch = Factory.createMatcher(this.parentId, string, contentCheckArray);
            }
            this.continueBranch.put(string, contentCheckArray, matchTarget, hashtable, matchTargetArray);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "put");
        }
    }

    private boolean allSelectorsExamined(ContentCheck[] contentCheckArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "allSelectorsExamined", contentCheckArray);
        }
        boolean bl = false;
        if (contentCheckArray.length <= 1) {
            bl = true;
        } else if (this.parentId < 0) {
            boolean bl2 = bl = contentCheckArray[contentCheckArray.length - 2].getAttribute() <= this.parentId;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "allSelectorsExamined", new Boolean(bl));
        }
        return bl;
    }

    public void get(String string, FormattedMessage formattedMessage, SearchResults searchResults, EvalCache evalCache) throws MatchingException, BadMessageFormatMatchingException {
        FastVector[] fastVectorArray;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "get", string, formattedMessage, searchResults, evalCache);
        }
        if ((fastVectorArray = this.alwaysMatch.lists).length > 0) {
            searchResults.addObjects(fastVectorArray);
        }
        if (formattedMessage != null) {
            int n = this.roots.size();
            int n2 = 0;
            while (n2 < n) {
                BooleanResult booleanResult = null;
                try {
                    booleanResult = (BooleanResult)((SimpleNode)this.roots.elementAt(n2)).getValue(formattedMessage, evalCache);
                    if (booleanResult.isMatch()) {
                        MatchTargetTypeList matchTargetTypeList = (MatchTargetTypeList)this.objs.elementAt(n2);
                        fastVectorArray = matchTargetTypeList.lists;
                        if (fastVectorArray.length > 0) {
                            searchResults.addObjects(fastVectorArray);
                        }
                    }
                }
                catch (NullValueException nullValueException) {
                    System.out.println("Unexpected NullValueException");
                    nullValueException.printStackTrace();
                }
                catch (TypeCheckException typeCheckException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        if (this.continueBranch != null) {
            this.continueBranch.get(string, formattedMessage, searchResults, evalCache);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "get");
        }
    }

    public boolean remove(String string, ContentCheck[] contentCheckArray, MatchTarget matchTarget, Hashtable hashtable) throws MatchingException {
        int n;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "remove", string, contentCheckArray, matchTarget, hashtable);
        }
        Assert.condition(this.objs != null);
        int n2 = matchTarget.type();
        if (contentCheckArray == null || this.allSelectorsExamined(contentCheckArray)) {
            n = this.objs.size();
            boolean bl = false;
            int n3 = 0;
            while (!bl && n3 < n) {
                MatchTargetTypeList matchTargetTypeList = (MatchTargetTypeList)this.objs.elementAt(n3);
                bl = matchTargetTypeList.deleteTarget(matchTarget);
                if (bl) {
                    SimpleNode simpleNode = (SimpleNode)this.roots.elementAt(n3);
                    Assert.condition(simpleNode != null);
                    simpleNode.remove(hashtable);
                    if (matchTargetTypeList.size() == 0) {
                        this.objs.removeElementAt(n3);
                        this.roots.removeElementAt(n3);
                    }
                }
                ++n3;
            }
            if (!bl) {
                bl = this.alwaysMatch.deleteTarget(matchTarget);
                Assert.condition(bl);
            }
            if (bl) {
                matchTarget.invalidate();
            }
        } else if (this.continueBranch.remove(string, contentCheckArray, matchTarget, hashtable)) {
            this.continueBranch = null;
        }
        n = 0;
        if (this.continueBranch == null && this.roots.size() == 0 && this.alwaysMatch.size() == 0) {
            n = 1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "remove", new Boolean(n != 0));
        }
        return n != 0;
    }

    private class MatchTargetTypeList {
        FastVector[] lists = new FastVector[0];

        MatchTargetTypeList() {
        }

        public void addTarget(MatchTarget matchTarget) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "MatchTargetTypeList.addTarget", matchTarget);
            }
            int n = matchTarget.type();
            this.resize(n);
            if (this.lists[n] == null) {
                this.lists[n] = new FastVector();
            }
            matchTarget.setIndex(this.lists[n].m_count);
            this.lists[n].addElement(matchTarget);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "MatchTargetTypeList.addTarget");
            }
        }

        public boolean deleteTarget(MatchTarget matchTarget) {
            int n;
            FastVector fastVector;
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "MatchTargetTypeList.deleteTarget", matchTarget);
            }
            int n2 = matchTarget.type();
            boolean bl = false;
            if (n2 < this.lists.length && (fastVector = this.lists[n2]) != null && (n = matchTarget.getIndex()) < fastVector.m_count && matchTarget == fastVector.m_data[n]) {
                if (fastVector.m_count == 1) {
                    fastVector.m_count = 0;
                } else {
                    MatchTarget matchTarget2 = (MatchTarget)fastVector.m_data[fastVector.m_count - 1];
                    matchTarget2.setIndex(n);
                    fastVector.m_data[n] = matchTarget2;
                    --fastVector.m_count;
                }
                if (fastVector.m_count == 0) {
                    this.lists[n2] = null;
                    if (n2 == this.lists.length - 1) {
                        int n3 = this.lists.length;
                        while (n3 > 0 && this.lists[n3 - 1] == null) {
                            --n3;
                        }
                        if (n3 > 0) {
                            FastVector[] fastVectorArray = new FastVector[n3];
                            System.arraycopy(this.lists, 0, fastVectorArray, 0, n3);
                            this.lists = fastVectorArray;
                        } else {
                            this.lists = new FastVector[0];
                        }
                    }
                }
                bl = true;
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "MatchTargetTypeList.deleteTarget", new Boolean(bl));
            }
            return bl;
        }

        public FastVector getTypeList(int n) {
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "MatchTargetTypeList.getTypeList", new Integer(n));
            }
            FastVector fastVector = null;
            if (n < this.lists.length) {
                fastVector = this.lists[n];
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "MatchTargetTypeList.getTypeList", fastVector);
            }
            return fastVector;
        }

        private void resize(int n) {
            int n2;
            if (debug.debugIt(32)) {
                debug.debug(-175921860444055L, "MatchTargetTypeList.resize", new Integer(n));
            }
            if ((n2 = this.lists.length) <= n) {
                FastVector[] fastVectorArray = new FastVector[n + 1];
                System.arraycopy(this.lists, 0, fastVectorArray, 0, n2);
                this.lists = fastVectorArray;
            }
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "MatchTargetTypeList.resize");
            }
        }

        public int size() {
            return this.lists.length;
        }
    }
}

