/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.FormattedMessage;
import com.ibm.disthubmq.impl.matching.NoSuchFieldNameException;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import java.util.Hashtable;

public class CursorWrapper
implements FormattedMessage,
ClientExceptionConstants,
ClientLogConstants {
    private static final DebugObject debug = new DebugObject("CursorWrapper");
    private static Hashtable headerFieldMap = new Hashtable();
    protected SchemaCursor cursor;
    private TupleCursor msgTuple;
    private TupleCursor payload;
    private TupleCursor body;
    private Hashtable properties;

    public CursorWrapper(SchemaCursor schemaCursor) {
        this.cursor = schemaCursor;
    }

    private void setCursors() throws BadMessageFormatMatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setCursors");
        }
        if (this.body != null) {
            return;
        }
        try {
            this.msgTuple = this.cursor.getContents();
            this.payload = this.msgTuple.getContents(7);
            this.body = this.payload.getContents(3);
        }
        catch (Exception exception) {
            this.msgTuple = null;
            this.payload = null;
            this.body = null;
            throw new BadMessageFormatMatchingException(ExceptionBuilder.buildReasonString(1238, new Object[]{exception}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setCursors");
        }
    }

    public Object getFieldValue(String string) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        Object object;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getFieldValue", string);
        }
        if (this.properties == null) {
            this.setCursors();
            this.properties = new Hashtable();
            try {
                if (this.body.getChoice(6) == 1) {
                    object = this.body.getContents(6).nextRow();
                    while (object != null) {
                        Object object2 = object.getContents(1).getValue(0);
                        if (object2 != null) {
                            this.properties.put("JMS." + object.getString(0), object2);
                        }
                        object = object.nextRow();
                    }
                }
            }
            catch (Exception exception) {
                this.properties = null;
                throw new BadMessageFormatMatchingException(ExceptionBuilder.buildReasonString(1238, new Object[]{exception}));
            }
        }
        if ((object = this.properties.get(string)) == null) {
            throw new NoSuchFieldNameException(ExceptionBuilder.buildReasonString(1237, new Object[]{string}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getFieldValue", object);
        }
        return object;
    }

    public boolean isValidHeaderValue(String string) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isValidHeaderValue", string);
        }
        boolean bl = headerFieldMap.containsKey(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isValidHeaderValue", new Boolean(bl));
        }
        return bl;
    }

    public Object getHeaderValue(String string) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        Accessor accessor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getHeaderValue", string);
        }
        if ((accessor = (Accessor)headerFieldMap.get(string)) == null) {
            throw new NoSuchFieldNameException(ExceptionBuilder.buildReasonString(1237, new Object[]{string}));
        }
        this.setCursors();
        Object object = null;
        try {
            object = accessor.getValue(this.msgTuple, this.payload, this.body);
        }
        catch (Exception exception) {
            throw new BadMessageFormatMatchingException(ExceptionBuilder.buildReasonString(1238, new Object[]{exception}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getHeaderValue", object);
        }
        return object;
    }

    public Object getHeaderStringValue(String string) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        Accessor accessor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getHeaderStringValue", string);
        }
        if ((accessor = (Accessor)headerFieldMap.get(string)) == null || accessor.numeric) {
            throw new NoSuchFieldNameException(ExceptionBuilder.buildReasonString(1237, new Object[]{string}));
        }
        this.setCursors();
        Object object = null;
        try {
            object = accessor.getValue(this.msgTuple, this.payload, this.body);
        }
        catch (Exception exception) {
            throw new BadMessageFormatMatchingException(ExceptionBuilder.buildReasonString(1238, new Object[]{exception}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getHeaderStringValue", object);
        }
        return object;
    }

    public Object getHeaderNumberValue(String string) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        Accessor accessor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getHeaderNumberValue", string);
        }
        if ((accessor = (Accessor)headerFieldMap.get(string)) == null || !accessor.numeric) {
            throw new NoSuchFieldNameException(ExceptionBuilder.buildReasonString(1237, new Object[]{string}));
        }
        this.setCursors();
        Object object = null;
        try {
            object = accessor.getValue(this.msgTuple, this.payload, this.body);
        }
        catch (Exception exception) {
            throw new BadMessageFormatMatchingException(ExceptionBuilder.buildReasonString(1238, new Object[]{exception}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getHeaderNumberValue", object);
        }
        return object;
    }

    public String getPropertiesTopic() throws BadMessageFormatMatchingException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getPropertiesTopic");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getPropertiesTopic", null);
        }
        return null;
    }

    static {
        headerFieldMap.put("JMS.JMSPriority", new Accessor(true){

            Object getValue(TupleCursor tupleCursor, TupleCursor tupleCursor2, TupleCursor tupleCursor3) {
                return new Integer(tupleCursor.getByte(3));
            }
        });
        headerFieldMap.put("JMS.JMSMessageID", new Accessor(false){

            Object getValue(TupleCursor tupleCursor, TupleCursor tupleCursor2, TupleCursor tupleCursor3) {
                return "ID:" + tupleCursor2.getLong(0);
            }
        });
        headerFieldMap.put("JMS.JMSTimestamp", new Accessor(true){

            Object getValue(TupleCursor tupleCursor, TupleCursor tupleCursor2, TupleCursor tupleCursor3) {
                if (tupleCursor3.getChoice(1) == 0) {
                    return new Long(0L);
                }
                return new Long(tupleCursor3.getContents(1).getLong(0));
            }
        });
        headerFieldMap.put("JMS.JMSCorrelationID", new Accessor(false){

            Object getValue(TupleCursor tupleCursor, TupleCursor tupleCursor2, TupleCursor tupleCursor3) {
                if (tupleCursor3.getChoice(0) == 0) {
                    return "ID" + tupleCursor2.getLong(0);
                }
                return tupleCursor3.getContents(0).getString(0);
            }
        });
        headerFieldMap.put("JMS.JMSType", new Accessor(false){

            Object getValue(TupleCursor tupleCursor, TupleCursor tupleCursor2, TupleCursor tupleCursor3) {
                if (tupleCursor3.getChoice(2) == 0) {
                    return null;
                }
                return tupleCursor3.getContents(2).getString(0);
            }
        });
        headerFieldMap.put("JMS.JMSDeliveryMode", new Accessor(true){

            Object getValue(TupleCursor tupleCursor, TupleCursor tupleCursor2, TupleCursor tupleCursor3) {
                if (tupleCursor3.getBoolean(3)) {
                    return new Integer(2);
                }
                return new Integer(1);
            }
        });
    }

    private static abstract class Accessor {
        boolean numeric;

        Accessor(boolean bl) {
            this.numeric = bl;
        }

        abstract Object getValue(TupleCursor var1, TupleCursor var2, TupleCursor var3);
    }
}

