/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.matching;

import com.ibm.disthubmq.impl.matching.parser.TypeCheckException;

public final class BooleanResult {
    static final BooleanResult TRUE = new BooleanResult(false, true);
    static final BooleanResult FALSE = new BooleanResult(false, false);
    static final BooleanResult NULL = new BooleanResult(true, true);
    static final BooleanResult[][] andTable = new BooleanResult[][]{{TRUE, FALSE, NULL}, {FALSE, FALSE, FALSE}, {NULL, FALSE, NULL}};
    static final BooleanResult[][] orTable = new BooleanResult[][]{{TRUE, TRUE, TRUE}, {TRUE, FALSE, NULL}, {TRUE, NULL, NULL}};
    boolean val;
    boolean unknown;

    private BooleanResult(boolean bl, boolean bl2) {
        this.val = bl2;
        this.unknown = bl;
    }

    public static BooleanResult create(boolean bl, boolean bl2) {
        if (bl) {
            return NULL;
        }
        if (bl2) {
            return TRUE;
        }
        return FALSE;
    }

    public boolean isMatch() throws TypeCheckException {
        if (this.unknown) {
            return false;
        }
        return this.val;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    private int getIndex() {
        if (this.unknown) {
            return 2;
        }
        return this.val ? 0 : 1;
    }

    public BooleanResult and(BooleanResult booleanResult) {
        return andTable[this.getIndex()][booleanResult.getIndex()];
    }

    public BooleanResult or(BooleanResult booleanResult) {
        return orTable[this.getIndex()][booleanResult.getIndex()];
    }

    public BooleanResult not() {
        return BooleanResult.create(this.unknown, !this.val);
    }

    public String stringValue() throws TypeCheckException {
        if (this.unknown) {
            return "Unknown";
        }
        return String.valueOf(this.val);
    }

    public boolean equals(Object object) {
        if (this.unknown) {
            return false;
        }
        if (object instanceof BooleanResult) {
            if (((BooleanResult)object).unknown) {
                return false;
            }
            if (((BooleanResult)object).val == this.val) {
                return true;
            }
        }
        return false;
    }
}

