/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnDef;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaCodes;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.SchemaViolationException;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.impl.formats.UninitializedAccessException;
import com.ibm.disthubmq.impl.formats.VacuousSchemaCursor;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;

public final class VacuousTupleCursor
implements TupleCursor,
SchemaCodes,
ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("VacuousTupleCursor");
    TupleDef def;
    Object[] cache;
    VacuousTupleCursor next;

    VacuousTupleCursor(TupleDef tupleDef) {
        this.def = tupleDef;
        this.cache = new Object[tupleDef.getColumnCount()];
    }

    public TupleDef getTupleDef() {
        return this.def;
    }

    public TupleCursor nextRow() {
        return this.next;
    }

    public boolean getBoolean(int n) {
        boolean bl = (Boolean)this.getCache((byte)1, n);
        return bl;
    }

    public byte getByte(int n) {
        byte by = (Byte)this.getCache((byte)2, n);
        return by;
    }

    public short getShort(int n) {
        short s = (Short)this.getCache((byte)3, n);
        return s;
    }

    public char getChar(int n) {
        char c = ((Character)this.getCache((byte)4, n)).charValue();
        return c;
    }

    public int getInt(int n) {
        int n2 = (Integer)this.getCache((byte)5, n);
        return n2;
    }

    public long getLong(int n) {
        long l = (Long)this.getCache((byte)6, n);
        return l;
    }

    public float getFloat(int n) {
        float f = ((Float)this.getCache((byte)7, n)).floatValue();
        return f;
    }

    public double getDouble(int n) {
        double d = (Double)this.getCache((byte)8, n);
        return d;
    }

    public String getString(int n) {
        String string = (String)this.getCache((byte)-2, n);
        return string;
    }

    public byte[] getObject(int n) {
        byte[] byArray = (byte[])this.getCache((byte)-3, n);
        return byArray;
    }

    public byte[] getByteArray(int n) {
        byte[] byArray = (byte[])this.getCache((byte)-4, n);
        return byArray;
    }

    public Object getValue(int n) {
        Object object = this.cache[n];
        return object;
    }

    public Schema getSchema(int n) {
        Schema schema = ((SchemaCursor)this.getCache((byte)-1, n)).getSchema();
        return schema;
    }

    public int getChoice(int n, Schema schema) {
        return this.getChoice(n);
    }

    public int getChoice(int n) {
        if (n < 0 || n >= this.cache.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        Object object = this.cache[n];
        int n2 = -1;
        if (object instanceof SchemaCursor) {
            n2 = ((SchemaCursor)object).getChoice();
        }
        return n2;
    }

    public TupleCursor getContents(int n, Schema schema) {
        return this.getContents(n);
    }

    public TupleCursor getContents(int n) {
        if (n < 0 || n >= this.cache.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        Object object = this.cache[n];
        TupleCursor tupleCursor = null;
        if (object instanceof SchemaCursor) {
            tupleCursor = ((SchemaCursor)object).getContents();
        }
        return tupleCursor;
    }

    public TupleCursor newRow() {
        this.next = new VacuousTupleCursor(this.def);
        return this.next;
    }

    public void truncateRows() {
        this.next = null;
    }

    public void setBoolean(int n, boolean bl) {
        this.validateType((byte)1, n);
        this.cache[n] = new Boolean(bl);
    }

    public void setByte(int n, byte by) {
        this.validateType((byte)2, n);
        this.cache[n] = new Byte(by);
    }

    public void setShort(int n, short s) {
        this.validateType((byte)3, n);
        this.cache[n] = new Short(s);
    }

    public void setChar(int n, char c) {
        this.validateType((byte)4, n);
        this.cache[n] = new Character(c);
    }

    public void setInt(int n, int n2) {
        this.validateType((byte)5, n);
        this.cache[n] = new Integer(n2);
    }

    public void setLong(int n, long l) {
        this.validateType((byte)6, n);
        this.cache[n] = new Long(l);
    }

    public void setFloat(int n, float f) {
        this.validateType((byte)7, n);
        this.cache[n] = new Float(f);
    }

    public void setDouble(int n, double d) {
        this.validateType((byte)8, n);
        this.cache[n] = new Double(d);
    }

    public void setString(int n, String string) {
        this.validateType((byte)-2, n);
        this.cache[n] = string;
    }

    public void setObject(int n, byte[] byArray) {
        this.validateType((byte)-3, n);
        this.cache[n] = byArray;
    }

    public void setByteArray(int n, byte[] byArray) {
        this.validateType((byte)-4, n);
        this.cache[n] = byArray;
    }

    public void setValue(int n, Object object) {
        if (n < 0 || n >= this.cache.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        byte by = this.def.getColumnDef(n).getTypeCode();
        switch (by) {
            case 1: {
                if (object instanceof Boolean) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"boolean", object.getClass()}));
            }
            case 2: {
                if (object instanceof Byte) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"byte", object.getClass()}));
            }
            case 3: {
                if (object instanceof Short) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"short", object.getClass()}));
            }
            case 4: {
                if (object instanceof Character) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"char", object.getClass()}));
            }
            case 5: {
                if (object instanceof Integer) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"int", object.getClass()}));
            }
            case 6: {
                if (object instanceof Long) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"long", object.getClass()}));
            }
            case 7: {
                if (object instanceof Float) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"float", object.getClass()}));
            }
            case 8: {
                if (object instanceof Double) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"double", object.getClass()}));
            }
            case -2: {
                if (object instanceof String) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"String", object.getClass()}));
            }
            case -4: 
            case -3: {
                if (object instanceof byte[]) break;
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"byte[]", object.getClass()}));
            }
            default: {
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1284, new Object[]{"ineligible", object.getClass()}));
            }
        }
        this.cache[n] = object;
    }

    public void setSchema(int n, Schema schema) {
        this.validateType((byte)-1, n);
        this.cache[n] = new VacuousSchemaCursor(schema);
    }

    public TupleCursor setChoice(int n, int n2) {
        Object object;
        if (n < 0 || n >= this.cache.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        SchemaCursor schemaCursor = (SchemaCursor)this.cache[n];
        if (schemaCursor == null) {
            object = this.def.getColumnDef(n);
            if (((ColumnDef)object).getTypeCode() == 0) {
                schemaCursor = new VacuousSchemaCursor(((ColumnDef)object).getSchema());
                this.cache[n] = schemaCursor;
            } else {
                if (((ColumnDef)object).getTypeCode() == -1) {
                    throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1285, new Object[]{((ColumnDef)object).getFullName()}));
                }
                this.schemaViolation((byte)0, ((ColumnDef)object).getTypeCode());
            }
        }
        object = schemaCursor.setChoice(n2);
        return object;
    }

    private Object getCache(byte by, int n) {
        this.validateType(by, n);
        Object object = this.cache[n];
        if (object == null && by != -2 && by != -4 && by != -3) {
            throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1285, new Object[]{this.def.getColumnDef(n).getFullName()}));
        }
        return object;
    }

    private void validateType(byte by, int n) {
        if (n < 0 || n >= this.cache.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        if (by != this.def.getColumnDef(n).getTypeCode()) {
            this.schemaViolation(by, this.def.getColumnDef(n).getTypeCode());
        }
    }

    private void schemaViolation(byte by, byte by2) {
        throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1286, new Object[]{new Byte(SchemaCodes.typeNames[by - -4]), new Byte(SchemaCodes.typeNames[by2 - -4])}));
    }
}

