/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.MessageEncrypter;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.formats.VacuousTupleCursor;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;

public final class VacuousSchemaCursor
implements SchemaCursor,
ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("VacuousSchemaCursor");
    private Schema schema;
    private int choiceIndex;
    private VacuousTupleCursor activeTuple;

    VacuousSchemaCursor(Schema schema) {
        this.schema = schema;
        this.clear();
    }

    public short getInterpreterId() {
        return 0;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Schema getEncodingSchema() {
        return this.getSchema();
    }

    public Schema[] getSchemata() {
        Schema[] schemaArray = new Schema[]{this.schema};
        return schemaArray;
    }

    public ByteSequence getRawMessage() {
        return null;
    }

    public void clear() {
        this.activeTuple = null;
        this.choiceIndex = this.schema.getChoiceCount() == 1 ? 0 : -1;
    }

    public int getChoice() {
        return this.choiceIndex;
    }

    public TupleCursor getContents() {
        TupleCursor tupleCursor = this.activeTuple;
        if (this.activeTuple == null) {
            tupleCursor = this.setChoice(this.choiceIndex);
        }
        return tupleCursor;
    }

    public TupleCursor setChoice(int n) {
        VacuousTupleCursor vacuousTupleCursor = null;
        if (n >= 0 && n < this.schema.getChoiceCount()) {
            this.choiceIndex = n;
            vacuousTupleCursor = this.activeTuple = new VacuousTupleCursor(this.schema.getTupleDef(n));
        }
        return vacuousTupleCursor;
    }

    public void decode(ByteSequence byteSequence, int n, int n2, MessageEncrypter messageEncrypter) {
        Assert.failure(ExceptionBuilder.buildReasonString(1304, null));
    }

    public boolean needsEncoding() {
        return false;
    }

    public int encode(ByteSequence byteSequence, int n, MessageEncrypter messageEncrypter) {
        throw Assert.failureError(ExceptionBuilder.buildReasonString(1304, null));
    }
}

