/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnDef;
import com.ibm.disthubmq.impl.formats.ColumnMap;
import com.ibm.disthubmq.impl.formats.FlatTupleMap;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaMap;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.FastVector;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.util.Stack;

public final class TupleMap
implements ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("TupleMap");
    public TupleDef def;
    public ColumnMap recurse;
    int choiceIndex;
    int uniqueIndex;
    ColumnMap[] columns;
    public TupleMap[][] distrib;
    public long[] multiChoiceCounts;

    TupleMap(TupleDef tupleDef, int n, SchemaMap schemaMap) {
        this.def = tupleDef;
        this.choiceIndex = n;
        this.uniqueIndex = schemaMap.tupleCounter++;
        int n2 = tupleDef.getColumnCount();
        FastVector fastVector = new FastVector();
        this.columns = new ColumnMap[n2];
        int n3 = 0;
        while (n3 < n2) {
            ColumnDef columnDef = tupleDef.getColumnDef(n3);
            Schema schema = columnDef.getSchema();
            if (schema != null) {
                TupleMap[] tupleMapArray = new TupleMap[schema.getChoiceCount()];
                int n4 = 0;
                while (n4 < tupleMapArray.length) {
                    TupleDef tupleDef2 = schema.getTupleDef(n4);
                    ColumnDef columnDef2 = tupleDef2.getNextDef();
                    if (columnDef2 == null) {
                        tupleMapArray[n4] = new TupleMap(schema.getTupleDef(n4), n4, schemaMap);
                    } else {
                        TupleMap tupleMap = new TupleMap(new TupleDef(), n4, schemaMap);
                        tupleMap.recurse = new ColumnMap(columnDef2, tupleMap, -1);
                        tupleMapArray[n4] = tupleMap;
                    }
                    ++n4;
                }
                fastVector.addElement(tupleMapArray);
            } else {
                this.columns[n3] = new ColumnMap(columnDef, this, n3);
            }
            ++n3;
        }
        if (fastVector.m_count > 0) {
            this.distrib = new TupleMap[fastVector.m_count][];
            System.arraycopy(fastVector.m_data, 0, this.distrib, 0, fastVector.m_count);
            this.multiChoiceCounts = new long[this.distrib.length];
            int n5 = 0;
            while (n5 < this.distrib.length) {
                int n6 = 0;
                while (n6 < this.distrib[n5].length) {
                    int n7 = n5;
                    this.multiChoiceCounts[n7] = this.multiChoiceCounts[n7] + this.distrib[n5][n6].getMultiChoiceCount();
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public int getDistribIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.columns[n3] == null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    int getColumnIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.columns.length) {
            if (this.columns[n3] == null) {
                if (n2 == n) {
                    return n3;
                }
                ++n2;
            }
            ++n3;
        }
        throw Assert.failureError(ExceptionBuilder.buildReasonString(1303, new Object[]{new Integer(n)}));
    }

    public long getMultiChoiceCount() {
        long l = 1L;
        if (this.multiChoiceCounts != null) {
            int n = 0;
            while (n < this.multiChoiceCounts.length) {
                l *= this.multiChoiceCounts[n];
                ++n;
            }
        }
        return l;
    }

    FlatTupleMap getFlatTupleMap(long l) {
        if (this.distrib == null) {
            FlatTupleMap flatTupleMap = new FlatTupleMap();
            flatTupleMap.addColumns(this.columns);
            if (this.recurse != null) {
                flatTupleMap.addCol(this.recurse);
            }
            return flatTupleMap;
        }
        TupleMap[] tupleMapArray = new TupleMap[this.distrib.length];
        long[] lArray = new long[this.distrib.length];
        int n = this.multiChoiceCounts.length - 1;
        while (n >= 0) {
            long l2 = l % this.multiChoiceCounts[n];
            TupleMap[] tupleMapArray2 = this.distrib[n];
            int n2 = 0;
            while (n2 < tupleMapArray2.length) {
                long l3 = tupleMapArray2[n2].getMultiChoiceCount();
                if (l3 > l2) {
                    tupleMapArray[n] = tupleMapArray2[n2];
                    lArray[n] = l2;
                    break;
                }
                l2 -= l3;
                ++n2;
            }
            l /= this.multiChoiceCounts[n];
            --n;
        }
        FlatTupleMap flatTupleMap = new FlatTupleMap();
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.columns.length) {
            if (this.columns[n4] != null) {
                flatTupleMap.addCol(this.columns[n4]);
            } else {
                flatTupleMap.merge(tupleMapArray[n3].getFlatTupleMap(lArray[n3]));
                ++n3;
            }
            ++n4;
        }
        if (this.recurse != null) {
            flatTupleMap.addCol(this.recurse);
        }
        return flatTupleMap;
    }

    public void dump(String string, Stack stack) {
        if (this.columns.length == 0) {
            if (this.recurse == null) {
                System.err.println(string + "(" + this.uniqueIndex + ")nil");
            } else {
                System.err.println(string + "(" + this.uniqueIndex + ")recursive");
            }
        } else {
            System.err.println(string + "(" + this.uniqueIndex + ")TupleMap");
            int n = 0;
            while (n < this.columns.length) {
                ColumnMap columnMap = this.columns[n];
                if (columnMap == null) {
                    System.err.println(string + " (subschema)");
                } else {
                    columnMap.dumpLogical(string + " ", stack);
                }
                ++n;
            }
            if (this.distrib != null) {
                int n2 = 0;
                while (n2 < this.distrib.length) {
                    TupleMap[] tupleMapArray = this.distrib[n2];
                    System.err.println(string + " Subschema " + n2 + ":");
                    int n3 = 0;
                    while (n3 < tupleMapArray.length) {
                        tupleMapArray[n3].dump(string + "  ", stack);
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
        if (this.recurse != null) {
            System.err.println(string + " recursing:");
            this.recurse.dumpLogical(string + " ", stack);
        }
    }
}

