/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnDef;
import com.ibm.disthubmq.impl.formats.Names;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.Serializable;

public final class TupleDef
implements Serializable,
LogConstants {
    private static final DebugObject debug = new DebugObject("TupleDef");
    private static final int INIT_COLUMNS = 8;
    private int nColumns;
    private ColumnDef[] columns;
    private ColumnDef nextDef;
    private String name;
    private ColumnDef parent;
    private boolean cppNullified;

    TupleDef(byte[] byArray, int[] nArray) {
        int n = Schema.getCount(byArray, nArray);
        if (n == -1) {
            this.setTable();
            this.nColumns = Schema.getCount(byArray, nArray);
        } else {
            this.nColumns = n;
        }
        this.columns = new ColumnDef[this.nColumns];
        int n2 = 0;
        while (n2 < this.nColumns) {
            this.columns[n2] = new ColumnDef(byArray, nArray);
            ++n2;
        }
        this.name = "";
    }

    public TupleDef() {
        this.columns = new ColumnDef[8];
        this.name = "";
    }

    public void setName(String string) {
        this.name = string == null ? "" : string;
    }

    public void setNames(Names names, ColumnDef columnDef) {
        this.setName(names.name);
        this.parent = columnDef;
        int n = 0;
        while (n < this.nColumns) {
            this.columns[n].setNames(names.subNames[n], this);
            ++n;
        }
        if (this.nextDef != null) {
            this.nextDef.setNames(new Names("", null), this);
        }
    }

    public String getShortName() {
        String string = this.name;
        if (this.name == null || this.name.length() == 0) {
            string = this.parent == null ? null : this.parent.getShortName();
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String string = this.name;
        if (this.parent != null) {
            string = this.parent.getFullName() + "." + this.name;
        }
        return string;
    }

    public String getCppFullName(boolean bl) {
        if (bl && this.nextDef != null) {
            return null;
        }
        String string = null;
        if (this.parent != null && this.parent.parent != null) {
            string = this.parent.parent.getCppFullName(bl);
        }
        if (string == null || string.length() == 0) {
            if (this.cppNullified) {
                return null;
            }
            return this.name;
        }
        if (this.cppNullified || this.name == null || this.name.length() == 0) {
            return string;
        }
        return string + "." + this.name;
    }

    public void nullifyCppName() {
        this.cppNullified = true;
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public ColumnDef getColumnDef(int n) {
        ColumnDef columnDef = null;
        if (n >= 0 && n < this.nColumns) {
            columnDef = this.columns[n];
        }
        return columnDef;
    }

    public void add(ColumnDef columnDef) {
        if (this.nColumns == this.columns.length) {
            ColumnDef[] columnDefArray = new ColumnDef[this.nColumns * 2];
            System.arraycopy(this.columns, 0, columnDefArray, 0, this.nColumns);
            this.columns = columnDefArray;
        }
        this.columns[this.nColumns++] = columnDef;
    }

    public void setTable() {
        Schema schema = new Schema();
        schema.add(new TupleDef());
        schema.add(this);
        this.nextDef = new ColumnDef(schema);
    }

    public ColumnDef getNextDef() {
        return this.nextDef;
    }

    TupleDef(byte[] byArray, int n, int n2) {
        this(byArray, new int[]{n, n + n2});
    }

    int encodedSize() {
        int n = 1;
        if (this.nextDef != null) {
            ++n;
        }
        int n2 = 0;
        while (n2 < this.nColumns) {
            n += this.columns[n2].encodedSize();
            ++n2;
        }
        return n;
    }

    void encode(byte[] byArray, int[] nArray) {
        if (this.nextDef != null) {
            Schema.setByte(byArray, nArray, (byte)-1);
        }
        Schema.setCount(byArray, nArray, this.nColumns);
        int n = 0;
        while (n < this.nColumns) {
            this.columns[n].encode(byArray, nArray);
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = this.name != null && this.name.length() > 0 ? new StringBuffer(this.name).append(" [ ") : new StringBuffer("[");
        int n = 0;
        while (n < this.nColumns) {
            stringBuffer.append(this.columns[n].toString());
            ++n;
        }
        if (this.nextDef != null) {
            stringBuffer.append("]* ");
        } else {
            stringBuffer.append("] ");
        }
        return stringBuffer.toString();
    }
}

