/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnMap;
import com.ibm.disthubmq.impl.formats.MessageVal;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaCodes;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.SchemaRegistry;
import com.ibm.disthubmq.impl.formats.SchemaViolationException;
import com.ibm.disthubmq.impl.formats.StandardSchemaCursor;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.impl.formats.TupleMap;
import com.ibm.disthubmq.impl.formats.UninitializedAccessException;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.UTF;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.UTFDataFormatException;

public final class StandardTupleCursor
implements TupleCursor,
SchemaCodes,
LogConstants,
ExceptionConstants {
    private static final DebugObject debug = new DebugObject("StandardTupleCursor");
    TupleMap map;
    int choiceIndex;
    long multiContrib;
    long[] multiChoices;
    int[] choiceIndices;
    long[] multiContribs;
    Object[] cache;
    boolean[] dirty;
    SchemaCursor next;
    boolean nextDirty;
    private MessageVal val;
    public static Object nullIndicator = new Object();

    StandardTupleCursor(TupleMap tupleMap, MessageVal messageVal, int n, long l) {
        this.map = tupleMap;
        this.val = messageVal;
        this.choiceIndex = n;
        this.multiContrib = l;
    }

    public TupleDef getTupleDef() {
        return this.map.def;
    }

    private void initSubChoices(long l) {
        long[] lArray;
        if (this.multiChoices == null && (lArray = this.map.multiChoiceCounts) != null) {
            this.multiChoices = new long[lArray.length];
            this.choiceIndices = new int[lArray.length];
            this.multiContribs = new long[lArray.length];
            if (l == -1L) {
                int n = 0;
                while (n < lArray.length) {
                    this.multiChoices[n] = -1L;
                    this.choiceIndices[n] = -1;
                    this.multiContribs[n] = -1L;
                    ++n;
                }
            } else {
                int n = lArray.length - 1;
                while (n >= 0) {
                    this.multiChoices[n] = l % lArray[n];
                    this.choiceIndices[n] = -1;
                    this.multiContribs[n] = -1L;
                    l /= lArray[n];
                    --n;
                }
                Assert.condition(l == 0L);
            }
        }
    }

    private void initOneSubChoice(int n) {
        long l = this.multiChoices[n];
        if (l == -1L) {
            this.choiceIndices[n] = -1;
            this.multiContribs[n] = -1L;
        } else if (this.choiceIndices[n] == -1) {
            TupleMap[] tupleMapArray = this.map.distrib[n];
            int n2 = 0;
            while (n2 < tupleMapArray.length) {
                long l2 = tupleMapArray[n2].getMultiChoiceCount();
                if (l2 > l) {
                    this.choiceIndices[n] = n2;
                    this.multiContribs[n] = l;
                    break;
                }
                l -= l2;
                ++n2;
            }
        }
    }

    long getMultiChoice() {
        this.initSubChoices(this.multiContrib);
        long l = 0L;
        if (this.multiChoices != null) {
            int n = 0;
            while (n < this.multiChoices.length) {
                int n2 = this.map.getColumnIndex(n);
                Object object = this.cache == null ? null : this.cache[n2];
                long l2 = this.multiChoices[n];
                if (object != null) {
                    this.multiChoices[n] = l2 = this.subSchemaMultiChoice(n, (StandardTupleCursor)object);
                } else if (this.multiChoices[n] == -1L) {
                    throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1290, new Object[]{this.map.def.getColumnDef(n2).getFullName()}));
                }
                l = this.map.multiChoiceCounts[n] * l + l2;
                ++n;
            }
        }
        return l;
    }

    private long subSchemaMultiChoice(int n, StandardTupleCursor standardTupleCursor) {
        long l;
        int n2;
        TupleMap[] tupleMapArray = this.map.distrib[n];
        long l2 = 0L;
        this.choiceIndices[n] = n2 = standardTupleCursor.choiceIndex;
        int n3 = 0;
        while (n3 < n2) {
            l2 += tupleMapArray[n3].getMultiChoiceCount();
            ++n3;
        }
        this.multiContribs[n] = l = standardTupleCursor.getMultiChoice();
        return l2 + l;
    }

    public TupleCursor nextRow() {
        TupleCursor tupleCursor = null;
        if (this.map.recurse != null) {
            if (this.next == null) {
                if (this.val.seq == null) {
                    return tupleCursor;
                }
                this.next = new StandardSchemaCursor(this.map.recurse.subMap, this);
                int n = this.map.recurse.getAbsoluteOffset(this.val);
                this.next.decode(this.val.seq, n += 4, -1, null);
            }
            if (this.next.getChoice() == 1) {
                tupleCursor = this.next.getContents();
            }
        }
        return tupleCursor;
    }

    private void setUpCache(boolean bl) {
        if (this.cache == null) {
            this.cache = new Object[this.map.columns.length];
        }
        if (bl) {
            if (this.dirty == null) {
                this.dirty = new boolean[this.cache.length];
            }
            this.val.registerCursor(this.map.uniqueIndex, this);
        }
    }

    public boolean getBoolean(int n) {
        boolean bl;
        Object object;
        this.validateType((byte)1, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            bl = (Boolean)object;
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            bl = this.val.seq.readByte(n2) != 0;
            this.cache[n] = new Boolean(bl);
        }
        return bl;
    }

    public byte getByte(int n) {
        byte by;
        Object object;
        this.validateType((byte)2, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            by = (Byte)object;
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            by = this.val.seq.readByte(n2);
            this.cache[n] = new Byte(by);
        }
        return by;
    }

    public short getShort(int n) {
        short s;
        Object object;
        this.validateType((byte)3, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            s = (Short)object;
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            s = this.val.seq.readShort(n2);
            this.cache[n] = new Short(s);
        }
        return s;
    }

    public char getChar(int n) {
        char c;
        Object object;
        this.validateType((byte)4, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            c = ((Character)object).charValue();
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            c = (char)this.val.seq.readShort(n2);
            this.cache[n] = new Character(c);
        }
        return c;
    }

    public int getInt(int n) {
        int n2;
        Object object;
        this.validateType((byte)5, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            n2 = (Integer)object;
        } else {
            n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            n2 = this.val.seq.readInt(n2);
            this.cache[n] = new Integer(n2);
        }
        return n2;
    }

    public long getLong(int n) {
        long l;
        Object object;
        this.validateType((byte)6, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            l = (Long)object;
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            l = this.val.seq.readLong(n2);
            this.cache[n] = new Long(l);
        }
        return l;
    }

    public float getFloat(int n) {
        float f;
        Object object;
        this.validateType((byte)7, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            f = ((Float)object).floatValue();
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            f = Float.intBitsToFloat(this.val.seq.readInt(n2));
            this.cache[n] = new Float(f);
        }
        return f;
    }

    public double getDouble(int n) {
        double d;
        Object object;
        this.validateType((byte)8, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            d = (Double)object;
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            d = Double.longBitsToDouble(this.val.seq.readLong(n2));
            this.cache[n] = new Double(d);
        }
        return d;
    }

    public String getString(int n) {
        Object object;
        String string = null;
        this.validateType((byte)-2, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            if (object != nullIndicator) {
                string = (String)object;
            }
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            int n3 = this.val.seq.readInt(n2);
            if (n3 == -1) {
                this.cache[n] = nullIndicator;
            } else {
                Assert.condition(n3 + (n2 += 4) <= this.val.seq.length);
                if (this.val.charbuf == null || this.val.charbuf.length < n3) {
                    this.val.charbuf = new char[n3];
                }
                try {
                    int n4 = UTF.UTFToChars(this.val.seq.linearize(), n2, this.val.charbuf, 0, n3);
                    string = new String(this.val.charbuf, 0, n4);
                    this.cache[n] = string;
                }
                catch (UTFDataFormatException uTFDataFormatException) {
                    throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1291, new Object[]{uTFDataFormatException}));
                }
            }
        }
        return string;
    }

    public byte[] getObject(int n) {
        Object object;
        byte[] byArray = null;
        this.validateType((byte)-3, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            if (object != nullIndicator) {
                byArray = (byte[])object;
            }
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            int n3 = this.val.seq.readInt(n2);
            if (n3 == -1) {
                this.cache[n] = nullIndicator;
            } else {
                Assert.condition(n3 + (n2 += 4) <= this.val.seq.length);
                byArray = new byte[n3];
                this.val.seq.read(n2, byArray, 0, n3);
                this.cache[n] = byArray;
            }
        }
        return byArray;
    }

    public byte[] getByteArray(int n) {
        Object object;
        byte[] byArray = null;
        this.validateType((byte)-4, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((object = this.cache[n]) != null) {
            if (object != nullIndicator) {
                byArray = (byte[])object;
            }
        } else {
            int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
            int n3 = this.val.seq.readInt(n2);
            if (n3 == -1) {
                this.cache[n] = nullIndicator;
            } else {
                Assert.condition(n3 + (n2 += 4) <= this.val.seq.length);
                byArray = new byte[n3];
                this.val.seq.read(n2, byArray, 0, n3);
                this.cache[n] = byArray;
            }
        }
        return byArray;
    }

    public Object getValue(int n) {
        Object object;
        if (this.cache != null && n >= 0 && n < this.cache.length && (object = this.cache[n]) != null) {
            if (object == nullIndicator) {
                object = null;
            }
            return object;
        }
        switch (this.map.columns[n].def.getTypeCode()) {
            case 1: {
                this.getBoolean(n);
                break;
            }
            case 2: {
                this.getByte(n);
                break;
            }
            case 3: {
                this.getShort(n);
                break;
            }
            case 4: {
                this.getChar(n);
                break;
            }
            case 5: {
                this.getInt(n);
                break;
            }
            case 6: {
                this.getLong(n);
                break;
            }
            case 7: {
                this.getFloat(n);
                break;
            }
            case 8: {
                this.getDouble(n);
                break;
            }
            case -2: {
                this.getString(n);
                break;
            }
            case -3: {
                this.getObject(n);
                break;
            }
            case -4: {
                this.getByteArray(n);
                break;
            }
            default: {
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1292, new Object[]{new Integer(n)}));
            }
        }
        object = this.cache[n];
        if (object == nullIndicator) {
            object = null;
        }
        return object;
    }

    public Schema getSchema(int n) {
        SchemaCursor schemaCursor;
        Schema schema = null;
        this.validateType((byte)-1, n);
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if ((schemaCursor = this.getSchemaCursor(n, null)) != null) {
            schema = schemaCursor.getSchema();
        }
        return schema;
    }

    private SchemaCursor getSchemaCursor(int n, Schema schema) {
        SchemaCursor schemaCursor = (SchemaCursor)this.cache[n];
        if (schemaCursor != null) {
            if (schema == null) {
                return schemaCursor;
            }
            if (schema.equals(schemaCursor.getSchema())) {
                return schemaCursor;
            }
        }
        int n2 = this.map.columns[n].getAbsoluteOffset(this.val);
        if (this.val.seq == null) {
            return null;
        }
        int n3 = this.val.seq.readInt(n2);
        short s = this.val.seq.readShort(n2 += 4);
        long l = this.val.seq.readLong(n2 + 2);
        schemaCursor = schema == null || l == schema.getId() ? SchemaRegistry.getSchemaCursor(s, l) : SchemaRegistry.getSchemaCursor(s, l, schema);
        if (schemaCursor == null) {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1293, null));
        }
        schemaCursor.decode(this.val.seq, n2 + 10, -1, null);
        return schemaCursor;
    }

    public int getChoice(int n) {
        return this.getChoice(n, null);
    }

    public int getChoice(int n, Schema schema) {
        int n2 = -1;
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if (n < 0 || n >= this.cache.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        if (this.map.columns[n] == null) {
            Object object = this.cache[n];
            if (object != null) {
                n2 = ((StandardTupleCursor)object).choiceIndex;
            } else {
                int n3 = this.map.getDistribIndex(n);
                this.initSubChoices(this.multiContrib);
                this.initOneSubChoice(n3);
                n2 = this.choiceIndices[n3];
            }
        } else if (this.map.columns[n].def.getTypeCode() == -1) {
            SchemaCursor schemaCursor = this.getSchemaCursor(n, schema);
            if (schemaCursor != null) {
                n2 = schemaCursor.getChoice();
            }
        } else {
            this.schemaViolation((byte)0, this.map.columns[n].def.getTypeCode());
        }
        return n2;
    }

    private StandardTupleCursor getDistribTupleCursor(int n) {
        StandardTupleCursor standardTupleCursor = null;
        Object object = this.cache[n];
        if (object != null) {
            standardTupleCursor = (StandardTupleCursor)object;
        } else {
            int n2 = this.map.getDistribIndex(n);
            this.initSubChoices(this.multiContrib);
            this.initOneSubChoice(n2);
            int n3 = this.choiceIndices[n2];
            if (n3 != -1) {
                standardTupleCursor = new StandardTupleCursor(this.map.distrib[n2][n3], this.val, n3, this.multiContribs[n2]);
                this.cache[n] = standardTupleCursor;
            }
        }
        return standardTupleCursor;
    }

    public TupleCursor getContents(int n) {
        return this.getContents(n, null);
    }

    public TupleCursor getContents(int n, Schema schema) {
        TupleCursor tupleCursor = null;
        if (this.cache == null) {
            this.setUpCache(false);
        }
        if (n < 0 || n >= this.cache.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        if (this.map.columns[n] == null) {
            tupleCursor = this.getDistribTupleCursor(n);
        } else if (this.map.columns[n].def.getTypeCode() == -1) {
            SchemaCursor schemaCursor = this.getSchemaCursor(n, schema);
            if (schemaCursor != null) {
                tupleCursor = schemaCursor.getContents();
            }
        } else {
            this.schemaViolation((byte)0, this.map.columns[n].def.getTypeCode());
        }
        return tupleCursor;
    }

    public TupleCursor newRow() {
        if (this.map.recurse == null) {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1280, null));
        }
        this.next = new StandardSchemaCursor(this.map.recurse.subMap, this);
        this.nextDirty = true;
        this.val.registerCursor(this.map.uniqueIndex, this);
        TupleCursor tupleCursor = this.next.setChoice(1);
        tupleCursor.truncateRows();
        return tupleCursor;
    }

    public void truncateRows() {
        if (this.map.recurse == null) {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1280, null));
        }
        this.next = new StandardSchemaCursor(this.map.recurse.subMap, this);
        this.nextDirty = true;
        this.val.registerCursor(this.map.uniqueIndex, this);
        this.next.setChoice(0);
    }

    public SchemaCursor getNextSchemaCursor() {
        return this.next;
    }

    public void recursivelyDirty() {
        this.nextDirty = true;
        this.val.registerCursor(this.map.uniqueIndex, this);
    }

    public void setBoolean(int n, boolean bl) {
        this.validateType((byte)1, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = new Boolean(bl);
        this.dirty[n] = true;
    }

    public void setByte(int n, byte by) {
        this.validateType((byte)2, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = new Byte(by);
        this.dirty[n] = true;
    }

    public void setShort(int n, short s) {
        this.validateType((byte)3, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = new Short(s);
        this.dirty[n] = true;
    }

    public void setChar(int n, char c) {
        this.validateType((byte)4, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = new Character(c);
        this.dirty[n] = true;
    }

    public void setInt(int n, int n2) {
        this.validateType((byte)5, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = new Integer(n2);
        this.dirty[n] = true;
    }

    public void setLong(int n, long l) {
        this.validateType((byte)6, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = new Long(l);
        this.dirty[n] = true;
    }

    public void setFloat(int n, float f) {
        this.validateType((byte)7, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = new Float(f);
        this.dirty[n] = true;
    }

    public void setDouble(int n, double d) {
        this.validateType((byte)8, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = new Double(d);
        this.dirty[n] = true;
    }

    public void setString(int n, String string) {
        this.validateType((byte)-2, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = string == null ? nullIndicator : string;
        this.dirty[n] = true;
    }

    public void setObject(int n, byte[] byArray) {
        this.validateType((byte)-3, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = byArray == null ? nullIndicator : (Object)byArray;
        this.dirty[n] = true;
    }

    public void setByteArray(int n, byte[] byArray) {
        this.validateType((byte)-4, n);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = byArray == null ? nullIndicator : (Object)byArray;
        this.dirty[n] = true;
    }

    public void setValue(int n, Object object) {
        ColumnMap[] columnMapArray = this.map.columns;
        if (n < 0 || n >= columnMapArray.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        if (object instanceof Boolean) {
            this.validateType((byte)1, columnMapArray[n]);
        } else if (object instanceof Byte) {
            this.validateType((byte)2, columnMapArray[n]);
        } else if (object instanceof Short) {
            this.validateType((byte)3, columnMapArray[n]);
        } else if (object instanceof Character) {
            this.validateType((byte)4, columnMapArray[n]);
        } else if (object instanceof Integer) {
            this.validateType((byte)5, columnMapArray[n]);
        } else if (object instanceof Long) {
            this.validateType((byte)6, columnMapArray[n]);
        } else if (object instanceof Float) {
            this.validateType((byte)7, columnMapArray[n]);
        } else if (object instanceof Double) {
            this.validateType((byte)8, columnMapArray[n]);
        } else if (object instanceof String) {
            this.validateType((byte)-2, columnMapArray[n]);
        } else if (object instanceof byte[]) {
            byte by = columnMapArray[n].def.getTypeCode();
            if (by != -3 && by != -4) {
                this.schemaViolation((byte)-4, by);
            }
        } else {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1294, new Object[]{object.getClass()}));
        }
        this.cache[n] = object;
        this.dirty[n] = true;
    }

    public void setSchema(int n, Schema schema) {
        this.validateType((byte)-1, n);
        SchemaCursor schemaCursor = SchemaRegistry.getInterp((short)0).interpret(schema);
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        this.cache[n] = schemaCursor;
        this.dirty[n] = true;
    }

    public TupleCursor setChoice(int n, int n2) {
        if (this.dirty == null) {
            this.setUpCache(true);
        }
        if (n < 0 || n >= this.cache.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        TupleCursor tupleCursor = null;
        if (this.map.columns[n] == null) {
            int n3 = this.map.getDistribIndex(n);
            this.initSubChoices(this.multiContrib);
            this.choiceIndices[n3] = n2;
            this.multiChoices[n3] = -1L;
            this.multiContribs[n3] = -1L;
            tupleCursor = new StandardTupleCursor(this.map.distrib[n3][n2], this.val, n2, -1L);
            this.cache[n] = tupleCursor;
        } else if (this.map.columns[n].def.getTypeCode() == -1) {
            SchemaCursor schemaCursor = this.getSchemaCursor(n, null);
            if (schemaCursor == null) {
                throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1285, new Object[]{this.map.columns[n].def.getFullName()}));
            }
            tupleCursor = schemaCursor.setChoice(n2);
        } else {
            this.schemaViolation((byte)0, this.map.columns[n].def.getTypeCode());
        }
        this.dirty[n] = true;
        return tupleCursor;
    }

    private void validateType(byte by, int n) {
        ColumnMap[] columnMapArray = this.map.columns;
        if (n < 0 || n >= columnMapArray.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        this.validateType(by, columnMapArray[n]);
    }

    private void validateType(byte by, ColumnMap columnMap) {
        if (by != columnMap.def.getTypeCode()) {
            this.schemaViolation(by, columnMap.def.getTypeCode());
        }
    }

    private void schemaViolation(byte by, byte by2) {
        throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1286, new Object[]{SchemaCodes.typeNames[by - -4], SchemaCodes.typeNames[by2 - -4]}));
    }
}

