/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.FlatTupleMap;
import com.ibm.disthubmq.impl.formats.MessageEncrypter;
import com.ibm.disthubmq.impl.formats.MessageVal;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.SchemaMap;
import com.ibm.disthubmq.impl.formats.StandardTupleCursor;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.formats.UninitializedAccessException;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.PrintStream;
import java.util.Stack;

public final class StandardSchemaCursor
implements SchemaCursor,
LogConstants,
ExceptionConstants {
    private SchemaMap map;
    private int choiceIndex = -1;
    private StandardTupleCursor activeTuple;
    private MessageVal val;
    private static final DebugObject debug = new DebugObject("StandardSchemaCursor");

    StandardSchemaCursor(SchemaMap schemaMap) {
        this(schemaMap, null);
    }

    StandardSchemaCursor(SchemaMap schemaMap, StandardTupleCursor standardTupleCursor) {
        this.map = schemaMap;
        this.val = new MessageVal(schemaMap.physMap, standardTupleCursor);
        if (schemaMap.choices.length == 1) {
            this.choiceIndex = 0;
        }
    }

    public short getInterpreterId() {
        return 0;
    }

    public Schema getSchema() {
        return this.map.schema;
    }

    public Schema getEncodingSchema() {
        return this.getSchema();
    }

    public Schema[] getSchemata() {
        return this.map.schemata;
    }

    public ByteSequence getRawMessage() {
        ByteSequence byteSequence = null;
        if (!this.needsEncoding()) {
            byteSequence = this.val.seq;
        }
        return byteSequence;
    }

    public void clear() {
        this.activeTuple = null;
        this.choiceIndex = this.map.choices.length == 1 ? 0 : -1;
        this.val.clear();
    }

    public int getChoice() {
        return this.choiceIndex;
    }

    public TupleCursor getContents() {
        TupleCursor tupleCursor = this.activeTuple != null ? this.activeTuple : this.setChoice(this.choiceIndex);
        return tupleCursor;
    }

    public TupleCursor setChoice(int n) {
        StandardTupleCursor standardTupleCursor = null;
        if (n >= 0 && n < this.map.choices.length) {
            this.choiceIndex = n;
            standardTupleCursor = this.activeTuple = new StandardTupleCursor(this.map.choices[n], this.val, n, -1L);
        }
        return standardTupleCursor;
    }

    public void decode(ByteSequence byteSequence, int n, int n2, MessageEncrypter messageEncrypter) {
        this.val.decode(byteSequence, n, n2, messageEncrypter);
        long l = this.setChoicesFromMultiChoice(this.val.flatTuple.multiChoice);
        this.activeTuple = new StandardTupleCursor(this.map.choices[this.choiceIndex], this.val, this.choiceIndex, l);
    }

    private long setChoicesFromMultiChoice(long l) {
        this.choiceIndex = 0;
        while (this.choiceIndex < this.map.choices.length) {
            long l2 = this.map.choices[this.choiceIndex].getMultiChoiceCount();
            if (l2 > l) {
                return l;
            }
            l -= l2;
            ++this.choiceIndex;
        }
        throw Assert.failureError(ExceptionBuilder.buildReasonString(1299, new Object[]{new Long(l)}));
    }

    private long getMultiChoice() {
        if (this.choiceIndex == -1) {
            throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1301, null));
        }
        long l = 0L;
        int n = 0;
        while (n < this.choiceIndex) {
            l += this.map.choices[n].getMultiChoiceCount();
            ++n;
        }
        return l += this.activeTuple.getMultiChoice();
    }

    public boolean needsEncoding() {
        boolean bl = this.val.cursorFinder != null || this.val.seq == null;
        return bl;
    }

    public int encode(ByteSequence byteSequence, int n, MessageEncrypter messageEncrypter) {
        if (this.activeTuple == null) {
            throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1302, null));
        }
        int n2 = this.val.encode(this.getMultiChoice(), this.activeTuple, byteSequence, n, messageEncrypter);
        return n2;
    }

    public FlatTupleMap getFlatTupleMap() {
        FlatTupleMap flatTupleMap = this.map.physMap.getFlatTupleMap(this.getMultiChoice());
        return flatTupleMap;
    }

    public void dumpVal(PrintStream printStream) {
        this.dumpVal(printStream, 0);
    }

    public void dumpVal(PrintStream printStream, int n) {
        this.val.dump(printStream, n);
    }

    public void dump() {
        this.map.dump("", new Stack());
    }
}

