/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.EvolvingSchemaCursor;
import com.ibm.disthubmq.impl.formats.EvolvingSchemaMap;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.SchemaInterpreter;
import com.ibm.disthubmq.impl.formats.StandardInterpreter;
import com.ibm.disthubmq.impl.util.ArrayUtil;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.FastHashtable;
import com.ibm.disthubmq.impl.util.UTF;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.UTFDataFormatException;

public final class SchemaRegistry
implements LogConstants,
ExceptionConstants {
    private static final DebugObject debug = new DebugObject("SchemaRegistry");
    private static FastHashtable idTab = new FastHashtable();
    private static FastHashtable evolvMaps = new FastHashtable();
    private static final int INTERP_INIT = 4;
    static SchemaInterpreter[] interpTab = new SchemaInterpreter[4];

    private SchemaRegistry() {
    }

    public static long register(Schema schema) {
        long l = schema.getId();
        Long l2 = new Long(l);
        Object object = idTab.get(l2);
        if (object != null) {
            Assert.condition(schema.equals(object));
        } else {
            FastHashtable fastHashtable = idTab;
            synchronized (fastHashtable) {
                idTab.put(l2, schema);
            }
        }
        return l;
    }

    public static Schema retrieve(long l) {
        Schema schema = (Schema)idTab.get(new Long(l));
        return schema;
    }

    public static void register(byte[] byArray, int n) throws UTFDataFormatException {
        Object object;
        String string;
        short s = ArrayUtil.readShort(byArray, n);
        n += 2;
        if (s == 0) {
            string = "";
        } else {
            object = new char[s];
            int n2 = UTF.UTFToChars(byArray, n, (char[])object, 0, s);
            n += s;
            string = new String((char[])object, 0, n2);
        }
        object = new Schema(byArray, n, byArray.length - n);
        ((Schema)object).setName(string);
        SchemaRegistry.register((Schema)object);
    }

    public static ByteSequence getPropagationMessage(Schema schema) {
        Object[] objectArray;
        ByteSequence byteSequence = new ByteSequence();
        String string = schema.getName();
        int n = 2;
        if (string == null || string.length() == 0) {
            byteSequence.writeShort(0, (short)0);
        } else {
            objectArray = string.toCharArray();
            int n2 = UTF.lengthUTF(objectArray, 0, objectArray.length);
            byteSequence.writeShort(0, (short)n2);
            byteSequence.writeUnicode(2, n2, (char[])objectArray, 0, objectArray.length);
            n = n2 + 2;
        }
        objectArray = schema.toEncodedForm();
        byteSequence.write(n, (byte[])objectArray, 0, objectArray.length);
        return byteSequence;
    }

    public static SchemaInterpreter getInterp(short s) {
        SchemaInterpreter schemaInterpreter = null;
        if (s >= 0 && s < interpTab.length) {
            schemaInterpreter = interpTab[s];
        }
        return schemaInterpreter;
    }

    public static synchronized void register(SchemaInterpreter schemaInterpreter, short s) {
        if (s < 0) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1300, new Object[]{new Short(s)}));
        }
        if (s >= interpTab.length) {
            int n = interpTab.length * 2;
            while (s >= n) {
                n *= 2;
            }
            SchemaInterpreter[] schemaInterpreterArray = new SchemaInterpreter[n];
            System.arraycopy(interpTab, 0, schemaInterpreterArray, 0, interpTab.length);
            interpTab = schemaInterpreterArray;
        }
        SchemaRegistry.interpTab[s] = schemaInterpreter;
    }

    public static SchemaCursor getSchemaCursor(short s, long l) {
        SchemaCursor schemaCursor = null;
        SchemaInterpreter schemaInterpreter = SchemaRegistry.getInterp(s);
        if (schemaInterpreter != null) {
            Schema schema = SchemaRegistry.retrieve(l);
            if (schema == null) {
                if (debug.debugIt(16)) {
                    debug.debug(-175921860444056L, "getSchemaCursor", "Current Id table = " + idTab.toString());
                }
            } else {
                schemaCursor = schemaInterpreter.interpret(schema);
            }
        }
        return schemaCursor;
    }

    public static SchemaCursor getSchemaCursor(short s, long l, Schema schema) {
        SchemaCursor schemaCursor = SchemaRegistry.getSchemaCursor(s, l);
        if (schemaCursor != null) {
            EvolvingSchemaMap evolvingSchemaMap = (EvolvingSchemaMap)evolvMaps.get(new EvolvingSchemaMap.Key(schema.getId(), l));
            if (evolvingSchemaMap == null) {
                evolvingSchemaMap = EvolvingSchemaMap.checkAdapt(schema, schemaCursor.getSchema(), true, true);
                FastHashtable fastHashtable = evolvMaps;
                synchronized (fastHashtable) {
                    evolvMaps.put(new EvolvingSchemaMap.Key(schema.getId(), l), evolvingSchemaMap);
                }
            }
            schemaCursor = new EvolvingSchemaCursor(evolvingSchemaMap, schemaCursor);
        }
        return schemaCursor;
    }

    static {
        SchemaRegistry.interpTab[0] = new StandardInterpreter();
    }
}

