/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnDef;
import com.ibm.disthubmq.impl.formats.ColumnMap;
import com.ibm.disthubmq.impl.formats.FlatTupleMap;
import com.ibm.disthubmq.impl.formats.MessageMap;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.impl.formats.TupleMap;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.util.Stack;

public final class SchemaMap
implements ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("SchemaMap");
    public TupleMap[] choices;
    Schema schema;
    public Schema[] schemata;
    MessageMap physMap;
    int tupleCounter;

    public SchemaMap(Schema schema, ColumnMap columnMap) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SchemaMap", schema, columnMap);
        }
        this.schema = schema;
        this.schemata = new Schema[]{schema};
        this.choices = new TupleMap[schema.getChoiceCount()];
        int n = 0;
        while (n < this.choices.length) {
            TupleMap tupleMap;
            TupleDef tupleDef = schema.getTupleDef(n);
            ColumnDef columnDef = tupleDef.getNextDef();
            if (columnDef != null) {
                if (columnMap == null) {
                    tupleMap = new TupleMap(new TupleDef(), n, this);
                    tupleMap.recurse = new ColumnMap(columnDef, tupleMap, -1);
                } else {
                    columnMap.parent = tupleMap = new TupleMap(tupleDef, n, this);
                    tupleMap.recurse = columnMap;
                }
            } else {
                tupleMap = new TupleMap(tupleDef, n, this);
            }
            this.choices[n] = tupleMap;
            ++n;
        }
        this.physMap = new MessageMap(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SchemaMap");
        }
    }

    long getMultiChoiceCount() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getMultiChoiceCount");
        }
        long l = 0L;
        int n = 0;
        while (n < this.choices.length) {
            l += this.choices[n].getMultiChoiceCount();
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getMultiChoiceCount", new Long(l));
        }
        return l;
    }

    FlatTupleMap getFlatTupleMap(long l) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getFlatTupleMap");
        }
        int n = 0;
        while (n < this.choices.length) {
            TupleMap tupleMap = this.choices[n];
            long l2 = tupleMap.getMultiChoiceCount();
            if (l < l2) {
                FlatTupleMap flatTupleMap = tupleMap.getFlatTupleMap(l);
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "getFlatTupleMap", flatTupleMap);
                }
                return flatTupleMap;
            }
            l -= l2;
            ++n;
        }
        throw Assert.failureError(ExceptionBuilder.buildReasonString(1299, new Object[]{new Long(l)}));
    }

    public void dump(String string, Stack stack) {
        System.err.println(string + "SchemaMap");
        int n = 0;
        while (n < this.choices.length) {
            this.choices[n].dump(string + " ", stack);
            ++n;
        }
    }
}

