/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.Names;
import com.ibm.disthubmq.impl.formats.SchemaRegistry;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.impl.util.CryptoHash;
import com.ibm.disthubmq.impl.util.UTF;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.Serializable;

public final class Schema
implements Serializable,
ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("Schema");
    private static final int INIT_CHOICES = 8;
    private int nChoices;
    private TupleDef[] choices;
    private String name;
    private byte[] encodedForm;
    private Object[] interpCache;
    private byte version;
    private long id;

    public Schema() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "Schema");
        }
        this.choices = new TupleDef[8];
        this.name = "";
        this.version = 1;
    }

    public Schema(byte[] byArray, int n, int n2) {
        this(byArray, new int[]{n, n + n2});
    }

    public Schema(byte[] byArray, Names names) {
        this(byArray, new int[]{0, byArray.length});
        this.setNames(names);
    }

    Schema(byte[] byArray, int[] nArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "Schema", byArray, nArray);
        }
        this.version = Schema.getByte(byArray, nArray);
        this.nChoices = Schema.getCount(byArray, nArray);
        this.choices = new TupleDef[this.nChoices];
        int n = 0;
        while (n < this.nChoices) {
            this.choices[n] = new TupleDef(byArray, nArray);
            ++n;
        }
        this.name = "";
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "Schema");
        }
    }

    public int getVersion() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getVersion");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getVersion", new Integer(this.version));
        }
        return this.version;
    }

    public void setName(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setName", string);
        }
        String string2 = this.name = string == null ? "" : string;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setName");
        }
    }

    public void setNames(Names names) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setNames", names);
        }
        this.setName(names.name);
        int n = 0;
        while (n < this.nChoices) {
            this.choices[n].setNames(names.subNames[n], null);
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setNames");
        }
    }

    public String getName() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getName");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getName", this.name);
        }
        return this.name;
    }

    public int getChoiceCount() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getChoiceCount");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getChoiceCount", new Integer(this.nChoices));
        }
        return this.nChoices;
    }

    public TupleDef getTupleDef(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTupleDef", new Integer(n));
        }
        TupleDef tupleDef = null;
        if (n >= 0 && n < this.nChoices) {
            return this.choices[n];
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTupleDef", tupleDef);
        }
        return tupleDef;
    }

    public void add(TupleDef tupleDef) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "add", tupleDef);
        }
        if (this.nChoices == this.choices.length) {
            TupleDef[] tupleDefArray = new TupleDef[this.nChoices * 2];
            System.arraycopy(this.choices, 0, tupleDefArray, 0, this.nChoices);
            this.choices = tupleDefArray;
        }
        this.choices[this.nChoices++] = tupleDef;
        this.encodedForm = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "add");
        }
    }

    public void setInterpreterCache(int n, Object object) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setIterpreterCache", new Integer(n), object);
        }
        if (this.interpCache == null) {
            this.interpCache = new Object[SchemaRegistry.interpTab.length];
        }
        this.interpCache[n] = object;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setInterpreterCache");
        }
    }

    public Object getInterpreterCache(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getIterpreterCache", new Integer(n));
        }
        Object object = null;
        if (this.interpCache != null && n < this.interpCache.length) {
            object = this.interpCache[n];
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getInterpreterCache", object);
        }
        return object;
    }

    static int getCount(byte[] byArray, int[] nArray) {
        int n;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getCount", byArray, nArray);
        }
        if ((n = Schema.getByte(byArray, nArray)) < -1) {
            if ((n & 0xC0) == 128) {
                n = (n & 0x3F) << 8 | Schema.getByte(byArray, nArray) & 0xFF;
            } else if ((n & 0xE0) == 192) {
                n = (n & 0x1F) << 16 | (Schema.getByte(byArray, nArray) & 0xFF) << 8 | Schema.getByte(byArray, nArray) & 0xFF;
            } else if ((n & 0xF0) == 224) {
                n = (n & 0xF) << 24 | (Schema.getByte(byArray, nArray) & 0xFF) << 16 | (Schema.getByte(byArray, nArray) & 0xFF) << 8 | Schema.getByte(byArray, nArray) & 0xFF;
            } else {
                throw new RuntimeException(ExceptionBuilder.buildReasonString(1295, null));
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getCount", new Integer(n));
        }
        return n;
    }

    static void setCount(byte[] byArray, int[] nArray, int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setCount", byArray, nArray, new Integer(n));
        }
        if (n < 0 || n > 0xFFFFFFF) {
            throw new RuntimeException(ExceptionBuilder.buildReasonString(1296, new Object[]{new Integer(n)}));
        }
        if (n < 128) {
            Schema.setByte(byArray, nArray, (byte)n);
        } else if (n < 16384) {
            Schema.setByte(byArray, nArray, (byte)((n |= 0x8000) >> 8));
            Schema.setByte(byArray, nArray, (byte)n);
        } else if (n < 0x200000) {
            Schema.setByte(byArray, nArray, (byte)((n |= 0xC00000) >> 16));
            Schema.setByte(byArray, nArray, (byte)(n >> 8));
            Schema.setByte(byArray, nArray, (byte)n);
        } else {
            Schema.setByte(byArray, nArray, (byte)((n |= 0xE0000000) >> 24));
            Schema.setByte(byArray, nArray, (byte)(n >> 16));
            Schema.setByte(byArray, nArray, (byte)(n >> 8));
            Schema.setByte(byArray, nArray, (byte)n);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setCount");
        }
    }

    static byte getByte(byte[] byArray, int[] nArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getByte", byArray, nArray);
        }
        if (nArray[0] >= nArray[1]) {
            throw new RuntimeException(ExceptionBuilder.buildReasonString(1297, null));
        }
        int n = nArray[0];
        nArray[0] = n + 1;
        byte by = byArray[n];
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getByte", new Byte(by));
        }
        return by;
    }

    static void setByte(byte[] byArray, int[] nArray, byte by) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setByte", byArray, nArray, new Byte(by));
        }
        if (nArray[0] >= nArray[1]) {
            throw new RuntimeException(ExceptionBuilder.buildReasonString(1298, null));
        }
        int n = nArray[0];
        nArray[0] = n + 1;
        byArray[n] = by;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setByte");
        }
    }

    int encodedSize() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "encodedSize");
        }
        int n = 2;
        int n2 = 0;
        while (n2 < this.nChoices) {
            n += this.choices[n2].encodedSize();
            ++n2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "encodedSize", new Integer(n));
        }
        return n;
    }

    public synchronized byte[] toEncodedForm() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "toEncodedForm");
        }
        if (this.encodedForm == null) {
            this.encodedForm = new byte[this.encodedSize()];
            this.encode(this.encodedForm, new int[]{0, this.encodedForm.length});
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "encodedForm", this.encodedForm);
        }
        return this.encodedForm;
    }

    void encode(byte[] byArray, int[] nArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "encode", byArray, nArray);
        }
        Schema.setByte(byArray, nArray, this.version);
        Schema.setCount(byArray, nArray, this.nChoices);
        int n = 0;
        while (n < this.nChoices) {
            this.choices[n].encode(byArray, nArray);
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "encode");
        }
    }

    public int hashCode() {
        if (this.encodedForm == null) {
            this.toEncodedForm();
        }
        return this.encodedForm.hashCode() + this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Schema) {
            byte[] byArray;
            Schema schema = (Schema)object;
            if (!this.name.equals(schema.name)) {
                return false;
            }
            byte[] byArray2 = this.toEncodedForm();
            if (byArray2.length != (byArray = schema.toEncodedForm()).length) {
                return false;
            }
            int n = 0;
            while (n < byArray2.length) {
                if (byArray2[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public synchronized long getId() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getId");
        }
        if (this.id != 0L) {
            return this.id;
        }
        if (this.encodedForm == null) {
            this.toEncodedForm();
        }
        int n = 0;
        char[] cArray = null;
        if (this.name.length() > 0) {
            cArray = this.name.toCharArray();
            n = UTF.lengthUTF(cArray, 0, cArray.length);
        }
        byte[] byArray = new byte[n + this.encodedForm.length];
        if (cArray != null) {
            UTF.charsToUTF(cArray, 0, byArray, 0, cArray.length);
        }
        System.arraycopy(this.encodedForm, 0, byArray, n, this.encodedForm.length);
        this.id = CryptoHash.hash(byArray);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getId", new Long(this.id));
        }
        return this.id;
    }

    public String toString() {
        StringBuffer stringBuffer = this.name != null && this.name.length() > 0 ? new StringBuffer(this.name).append(" { ") : new StringBuffer("{");
        int n = 0;
        while (n < this.nChoices) {
            stringBuffer.append(this.choices[n].toString());
            ++n;
        }
        return stringBuffer.append("}").toString();
    }
}

