/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.ColumnMap;
import com.ibm.disthubmq.impl.formats.FlatTupleMap;
import com.ibm.disthubmq.impl.formats.MessageEncrypter;
import com.ibm.disthubmq.impl.formats.MessageMap;
import com.ibm.disthubmq.impl.formats.SchemaCodes;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.StandardSchemaCursor;
import com.ibm.disthubmq.impl.formats.StandardTupleCursor;
import com.ibm.disthubmq.impl.formats.UninitializedAccessException;
import com.ibm.disthubmq.impl.util.ArrayUtil;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.Hex;
import com.ibm.disthubmq.impl.util.UTF;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

final class MessageVal
implements SchemaCodes,
LogConstants,
ExceptionConstants {
    MessageMap physMap;
    ByteSequence seq;
    int dataOffset = -1;
    long multiChoice = -1L;
    FlatTupleMap flatTuple;
    int[] oTable;
    StandardTupleCursor[] cursorFinder;
    char[] charbuf;
    StandardTupleCursor parent;
    private static final DebugObject debug = new DebugObject("MessageVal");

    MessageVal(MessageMap messageMap, StandardTupleCursor standardTupleCursor) {
        this.physMap = messageMap;
        this.parent = standardTupleCursor;
    }

    void decode(ByteSequence byteSequence, int n, int n2, MessageEncrypter messageEncrypter) {
        int n3;
        int n4;
        this.multiChoice = byteSequence.readLong(n);
        n += 8;
        byte[] byArray = null;
        if (messageEncrypter != null) {
            n4 = byteSequence.readShort(n);
            n += 2;
            if (n2 != -1) {
                byArray = new byte[n4];
                n3 = 0;
                while (n3 < n4) {
                    byArray[n3] = byteSequence.readByte(n);
                    ++n;
                    ++n3;
                }
            } else {
                n += n4 * 1;
            }
        }
        this.flatTuple = this.physMap.getFlatTupleMap(this.multiChoice);
        this.oTable = new int[this.flatTuple.offsetsNeeded];
        n4 = 0;
        while (n4 < this.oTable.length) {
            this.oTable[n4] = byteSequence.readInt(n);
            n += 4;
            ++n4;
        }
        if (n2 != -1) {
            Assert.condition(n2 >= n && n2 <= byteSequence.length);
            n3 = byteSequence.length - n2;
            if (n3 > 0) {
                byte[] byArray2 = new byte[n3];
                if (debug.debugIt(16)) {
                    debug.debug(-175921860444056L, "decode", "Decrypting " + n3 + " bytes");
                }
                messageEncrypter.decrypt(messageEncrypter.generateKey(byArray, 0, byArray.length), byteSequence.linearize(), n2, n3, byArray2, 0);
                byteSequence = new ByteSequence((byte[])byteSequence.linearize().clone(), 0, byteSequence.length);
                byteSequence.write(n2, byArray2, 0, n3);
            }
        }
        this.seq = byteSequence;
        this.dataOffset = n;
    }

    void clear() {
        this.seq = null;
        this.dataOffset = -1;
        this.flatTuple = null;
        this.multiChoice = -1L;
        this.oTable = null;
    }

    void registerCursor(int n, StandardTupleCursor standardTupleCursor) {
        if (this.cursorFinder == null) {
            this.cursorFinder = new StandardTupleCursor[this.physMap.schema.tupleCounter];
        }
        this.cursorFinder[n] = standardTupleCursor;
        if (this.parent != null) {
            this.parent.recursivelyDirty();
        }
    }

    int encode(long l, StandardTupleCursor standardTupleCursor, ByteSequence byteSequence, int n, MessageEncrypter messageEncrypter) {
        Object object;
        int n2;
        FlatTupleMap flatTupleMap = this.flatTuple;
        int n3 = this.dataOffset;
        int[] nArray = this.oTable;
        byte[] byArray = this.seq == null ? null : this.seq.linearize();
        this.seq = byteSequence;
        this.multiChoice = l;
        this.flatTuple = this.physMap.getFlatTupleMap(l);
        byteSequence.writeLong(n, this.multiChoice);
        n += 8;
        byte[] byArray2 = null;
        if (messageEncrypter != null) {
            byArray2 = new byte[messageEncrypter.keySize()];
            messageEncrypter.random(byArray2, 0, byArray2.length);
            byteSequence.writeShort(n, (short)byArray2.length);
            n += 2;
            n2 = 0;
            while (n2 < byArray2.length) {
                byteSequence.writeByte(n, byArray2[n2]);
                ++n;
                ++n2;
            }
        }
        this.oTable = new int[this.flatTuple.offsetsNeeded];
        n2 = n;
        this.dataOffset = n += this.oTable.length * 4;
        int n4 = 0;
        int n5 = n;
        int n6 = 0;
        while (n6 < this.flatTuple.columns.length) {
            ColumnMap columnMap;
            block46: {
                block45: {
                    boolean bl;
                    columnMap = this.flatTuple.columns[n6];
                    StandardTupleCursor standardTupleCursor2 = null;
                    if (this.cursorFinder != null) {
                        standardTupleCursor2 = this.cursorFinder[columnMap.parent.uniqueIndex];
                    }
                    if (standardTupleCursor2 != null) {
                        if (columnMap.pos < 0) {
                            bl = standardTupleCursor2.nextDirty;
                            object = standardTupleCursor2.next;
                        } else {
                            bl = standardTupleCursor2.dirty[columnMap.pos];
                            object = standardTupleCursor2.cache[columnMap.pos];
                        }
                    } else {
                        bl = false;
                        object = null;
                    }
                    if (!bl) break block45;
                    switch (columnMap.def.getTypeCode()) {
                        case 0: {
                            ByteSequence byteSequence2 = new ByteSequence();
                            SchemaCursor schemaCursor = (SchemaCursor)object;
                            schemaCursor.encode(byteSequence2, 0, null);
                            int n7 = byteSequence2.length;
                            byteSequence.writeInt(n, n7);
                            byteSequence.write(n += 4, byteSequence2.linearize(), 0, n7);
                            n += n7;
                            if (n4 < this.oTable.length) {
                                this.oTable[n4++] = n - this.dataOffset;
                                break;
                            }
                            break block46;
                        }
                        case -1: {
                            ByteSequence byteSequence3 = new ByteSequence();
                            SchemaCursor schemaCursor = (SchemaCursor)object;
                            schemaCursor.encode(byteSequence3, 0, null);
                            int n7 = byteSequence3.length + 10;
                            byteSequence.writeInt(n, n7);
                            byteSequence.writeShort(n += 4, schemaCursor.getInterpreterId());
                            byteSequence.writeLong(n + 2, schemaCursor.getSchema().getId());
                            byteSequence.write(n + 10, byteSequence3.linearize(), 0, byteSequence3.length);
                            n += n7;
                            if (n4 < this.oTable.length) {
                                this.oTable[n4++] = n - this.dataOffset;
                                break;
                            }
                            break block46;
                        }
                        case -2: {
                            Object object2;
                            int n7;
                            if (object == StandardTupleCursor.nullIndicator) {
                                byteSequence.writeInt(n, -1);
                                n += 4;
                            } else {
                                object2 = (String)object;
                                n7 = ((String)object2).length();
                                if (this.charbuf == null || this.charbuf.length < n7) {
                                    this.charbuf = new char[n7];
                                }
                                ((String)object2).getChars(0, n7, this.charbuf, 0);
                                int n8 = UTF.lengthUTF(this.charbuf, 0, n7);
                                byteSequence.writeInt(n, n8);
                                byteSequence.writeUnicode(n += 4, n8, this.charbuf, 0, n7);
                                n += n8;
                            }
                            if (n4 < this.oTable.length) {
                                this.oTable[n4++] = n - this.dataOffset;
                                break;
                            }
                            break block46;
                        }
                        case -4: 
                        case -3: {
                            Object object2;
                            int n7;
                            if (object == StandardTupleCursor.nullIndicator) {
                                byteSequence.writeInt(n, -1);
                                n += 4;
                            } else {
                                object2 = (byte[])object;
                                n7 = ((Object)object2).length;
                                byteSequence.writeInt(n, n7);
                                byteSequence.write(n += 4, (byte[])object2, 0, n7);
                                n += n7;
                            }
                            if (n4 < this.oTable.length) {
                                this.oTable[n4++] = n - this.dataOffset;
                                break;
                            }
                            break block46;
                        }
                        case 1: {
                            byteSequence.writeByte(n++, (Boolean)object != false ? (byte)1 : 0);
                            break;
                        }
                        case 2: {
                            byteSequence.writeByte(n++, (Byte)object);
                            break;
                        }
                        case 3: {
                            byteSequence.writeShort(n, (Short)object);
                            n += 2;
                            break;
                        }
                        case 4: {
                            byteSequence.writeShort(n, (short)((Character)object).charValue());
                            n += 2;
                            break;
                        }
                        case 5: {
                            byteSequence.writeInt(n, (Integer)object);
                            n += 4;
                            break;
                        }
                        case 6: {
                            byteSequence.writeLong(n, (Long)object);
                            n += 8;
                            break;
                        }
                        case 7: {
                            byteSequence.writeInt(n, Float.floatToIntBits(((Float)object).floatValue()));
                            n += 4;
                            break;
                        }
                        case 8: {
                            byteSequence.writeLong(n, Double.doubleToLongBits((Double)object));
                            n += 8;
                            break;
                        }
                        default: {
                            Assert.failure("Bad typeCode");
                            break;
                        }
                    }
                    break block46;
                }
                if (byArray == null) {
                    throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1285, new Object[]{columnMap.def.getFullName()}));
                }
                int n9 = columnMap.getAbsoluteOffset(flatTupleMap, nArray, n3);
                switch (columnMap.def.getTypeCode()) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 0: {
                        int n10 = ArrayUtil.readInt(byArray, n9);
                        n10 = (n10 == -1 ? 0 : n10) + 4;
                        Assert.condition(n10 + n9 <= byArray.length);
                        byteSequence.write(n, byArray, n9, n10);
                        n += n10;
                        if (n4 >= this.oTable.length) break;
                        this.oTable[n4++] = n - this.dataOffset;
                        break;
                    }
                    case 1: 
                    case 2: {
                        byteSequence.writeByte(n++, byArray[n9]);
                        break;
                    }
                    case 3: 
                    case 4: {
                        byteSequence.write(n, byArray, n9, 2);
                        n += 2;
                        break;
                    }
                    case 5: 
                    case 7: {
                        byteSequence.write(n, byArray, n9, 4);
                        n += 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        byteSequence.write(n, byArray, n9, 8);
                        n += 8;
                        break;
                    }
                    default: {
                        Assert.failure("Bad typeCode");
                    }
                }
            }
            if (columnMap.def.getAccess() == -100) {
                n5 = n;
            }
            ++n6;
        }
        int n11 = 0;
        while (n11 < this.oTable.length) {
            byteSequence.writeInt(n2, this.oTable[n11]);
            n2 += 4;
            ++n11;
        }
        if (messageEncrypter != null) {
            Assert.condition(n5 >= this.dataOffset && n5 <= byteSequence.length);
            int n12 = byteSequence.length - n5;
            byte[] byArray3 = byteSequence.linearize();
            object = (byte[])byArray3.clone();
            this.seq = new ByteSequence((byte[])object);
            messageEncrypter.encrypt(messageEncrypter.generateKey(byArray2, 0, byArray2.length), (byte[])object, n5, n12, byArray3, n5);
        }
        if (this.cursorFinder != null) {
            int n13 = 0;
            while (n13 < this.cursorFinder.length) {
                StandardTupleCursor standardTupleCursor3 = this.cursorFinder[n13];
                if (standardTupleCursor3 != null) {
                    standardTupleCursor3.dirty = null;
                    standardTupleCursor3.nextDirty = false;
                }
                ++n13;
            }
            this.cursorFinder = null;
        }
        return n5;
    }

    void dump(PrintStream printStream) {
        this.dump(printStream, 0);
    }

    void dump(PrintStream printStream, int n) {
        if (n > 0 && this.multiChoice == 0L) {
            System.out.println("<null schema>");
            return;
        }
        if (this.seq == null || this.flatTuple == null) {
            printStream.println("Message contents unavailable");
        } else {
            if (n > 0) {
                printStream.print("Subschema ");
            }
            printStream.println("Length=" + (this.seq.length - this.dataOffset) + ", multiChoice=" + this.multiChoice + ":");
            int n2 = 0;
            while (n2 < this.flatTuple.columns.length) {
                ColumnMap columnMap = this.flatTuple.columns[n2];
                FlatTupleMap.Remap remap = this.flatTuple.getRemap(columnMap);
                String string = "+" + remap.fixedIncr;
                if (remap.offsetIndex != -1) {
                    string = "[" + remap.offsetIndex + "]" + string;
                }
                int n3 = columnMap.getAbsoluteOffset(this.flatTuple, this.oTable, this.dataOffset);
                byte[] byArray = this.seq.linearize();
                int n4 = 0;
                switch (columnMap.def.getTypeCode()) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 0: {
                        n4 = ArrayUtil.readInt(byArray, n3);
                        n3 += 4;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n4 = 1;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n4 = 2;
                        break;
                    }
                    case 5: 
                    case 7: {
                        n4 = 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        n4 = 8;
                        break;
                    }
                    default: {
                        Assert.failure("Bad typeCode");
                    }
                }
                int n5 = 0;
                while (n5 < n) {
                    printStream.print("   ");
                    ++n5;
                }
                printStream.print(" " + columnMap.def.getFullName() + "(" + string + "): ");
                if (n4 > 0) {
                    if (columnMap.def.getTypeCode() == -2) {
                        try {
                            printStream.println(new String(byArray, n3, n4, "UTF8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    } else if (columnMap.def.getTypeCode() == 0) {
                        StandardSchemaCursor standardSchemaCursor = new StandardSchemaCursor(columnMap.subMap);
                        standardSchemaCursor.decode(new ByteSequence(byArray, 0, byArray.length), n3, -1, null);
                        standardSchemaCursor.dumpVal(printStream, n + 1);
                    } else {
                        printStream.println(Hex.toString(byArray, n3, n4));
                    }
                } else if (n4 == -1) {
                    printStream.println("<null>");
                } else {
                    printStream.println();
                }
                ++n2;
            }
            if (n == 0) {
                printStream.println();
            }
        }
    }
}

