/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.FlatTupleMap;
import com.ibm.disthubmq.impl.formats.SchemaMap;
import com.ibm.disthubmq.impl.util.LongHashTable;
import com.ibm.disthubmq.spi.LogConstants;

public final class MessageMap
implements LogConstants {
    private static final DebugObject debug = new DebugObject("MessageMap");
    public SchemaMap schema;
    private LongHashTable flatTuples;
    private long multiChoiceCount;

    MessageMap(SchemaMap schemaMap) {
        this.schema = schemaMap;
        this.multiChoiceCount = schemaMap.getMultiChoiceCount();
        this.flatTuples = new LongHashTable();
    }

    long getMultiChoiceCount() {
        return this.multiChoiceCount;
    }

    public FlatTupleMap getFlatTupleMap(long l) {
        FlatTupleMap flatTupleMap = (FlatTupleMap)this.flatTuples.get(l);
        if (flatTupleMap == null) {
            MessageMap messageMap = this;
            synchronized (messageMap) {
                flatTupleMap = (FlatTupleMap)this.flatTuples.get(l);
                if (flatTupleMap == null) {
                    flatTupleMap = this.schema.getFlatTupleMap(l);
                    flatTupleMap.computePhysicalMap(l);
                    this.flatTuples.put(l, (Object)flatTupleMap);
                }
            }
        }
        return flatTupleMap;
    }

    public void dump(String string) {
    }
}

