/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.util.ArrayUtil;
import com.ibm.disthubmq.spi.LogConstants;

public final class Framing
implements LogConstants {
    public static final DebugObject debug = new DebugObject("Framing");
    private static final int MSGLEN_POS = 2;
    private static final int SEGHDR_END = 6;
    public static final int QOP_POS = 6;
    public static final int QOP_HASH_SIZE = 7;
    public static final int QOP_HASH = 8;
    public static final int SKSL_POS = 8;
    public static final int INTERP_ID_POS = 7;
    private static final int SCHEMA_ID_POS = 9;
    private static final int MSG_POS = 17;
    public static final short PROPAGATION_INDICATOR = -1;

    private Framing() {
    }

    public static byte[] framePropagationMessage(ByteSequence byteSequence) {
        ByteSequence byteSequence2 = new ByteSequence();
        byteSequence2.writeShort(0, (short)-1);
        byteSequence2.append(byteSequence);
        byte[] byArray = Framing.frame(byteSequence2, (byte)1);
        return byArray;
    }

    public static byte[] frameMessage(ByteSequence byteSequence, short s, long l) {
        ByteSequence byteSequence2 = new ByteSequence();
        byteSequence2.writeShort(0, s);
        byteSequence2.writeLong(2, l);
        byteSequence2.append(byteSequence);
        byte[] byArray = Framing.frame(byteSequence2, (byte)1);
        return byArray;
    }

    public static int fullLength(byte[] byArray) {
        int n = ArrayUtil.readInt(byArray, 2) + 6;
        return n;
    }

    public static short interpId(byte[] byArray) {
        int n = 0;
        switch (byArray[6]) {
            case 14: {
                n += 4;
            }
            case 2: 
            case 6: {
                n += byArray[7] + 1;
            }
        }
        short s = ArrayUtil.readShort(byArray, 7 + n);
        return s;
    }

    public static long schemaId(byte[] byArray) {
        int n = 0;
        switch (byArray[6]) {
            case 14: {
                n += 4;
            }
            case 2: 
            case 6: {
                n += byArray[7] + 1;
            }
        }
        long l = ArrayUtil.readLong(byArray, 9 + n);
        return l;
    }

    public static int sksl(byte[] byArray) {
        int n = -1;
        if ((byArray[6] & 0xE) == 14) {
            n = ArrayUtil.readInt(byArray, 8 + byArray[7]) - 10;
        }
        return n;
    }

    public static int propagationBodyOffset(byte[] byArray) {
        int n = 0;
        if ((byArray[6] & 2) == 2) {
            n = byArray[7] + 1 + 4;
        }
        int n2 = 9 + n;
        return n2;
    }

    public static int bodyOffset(byte[] byArray) {
        int n = 0;
        switch (byArray[6]) {
            case 14: {
                n += 4;
            }
            case 2: 
            case 6: {
                n += byArray[7] + 1;
            }
        }
        int n2 = 17 + n;
        return n2;
    }

    public static byte qop(byte[] byArray) {
        byte by = byArray[6];
        return by;
    }

    public static void setLength(byte[] byArray, int n) {
        ArrayUtil.writeInt(byArray, 2, n - 6);
    }

    public static byte[] frame(ByteSequence byteSequence, byte by) {
        byte[] byArray = new byte[7 + byteSequence.length];
        ArrayUtil.writeShort(byArray, 0, (short)-13647);
        ArrayUtil.writeInt(byArray, 2, byteSequence.length + 1);
        byArray[6] = by;
        byteSequence.read(0, byArray, 7, byteSequence.length);
        return byArray;
    }

    public static void attachDigest(ByteSequence byteSequence, byte[] byArray) {
        byte[] byArray2 = new byte[1 + byArray.length];
        byArray2[0] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        byteSequence.insert(new ByteSequence(byArray2, 0, byArray2.length), 0);
    }

    public static int computeDigestOffset(byte[] byArray) {
        byte by = byArray[6];
        int n = Framing.fullLength(byArray);
        byte by2 = byArray[7];
        int n2 = 8 + by2;
        int n3 = Framing.sksl(byArray) + 10;
        int n4 = by == 14 ? n2 + n3 + 4 : n2 + 10;
        return n4;
    }
}

