/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnMap;
import com.ibm.disthubmq.impl.formats.SchemaCodes;
import com.ibm.disthubmq.impl.util.FastVector;
import com.ibm.disthubmq.spi.LogConstants;

public final class FlatTupleMap
implements LogConstants {
    private static final DebugObject debug = new DebugObject("FlatTupleMap");
    public ColumnMap[] columns;
    Remap[] remaps;
    public int offsetsNeeded;
    public long multiChoice;
    private FastVector cols = new FastVector();

    void addColumns(ColumnMap[] columnMapArray) {
        int n = 0;
        while (n < columnMapArray.length) {
            this.cols.addElement(columnMapArray[n]);
            ++n;
        }
    }

    void addCol(ColumnMap columnMap) {
        this.cols.addElement(columnMap);
    }

    void merge(FlatTupleMap flatTupleMap) {
        this.cols.append(flatTupleMap.cols);
    }

    void computePhysicalMap(long l) {
        this.multiChoice = l;
        this.columns = new ColumnMap[this.cols.m_count];
        System.arraycopy(this.cols.m_data, 0, this.columns, 0, this.cols.m_count);
        this.cols = null;
        this.remaps = new Remap[this.columns.length];
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.columns.length) {
            ColumnMap columnMap = this.columns[n3];
            byte by = columnMap.def.getTypeCode();
            this.remaps[n3] = new Remap(n, n2);
            if (by >= 1) {
                n2 += SchemaCodes.typeSizes[by - 1];
            } else if (n3 < this.columns.length - 1) {
                ++n;
                n2 = 0;
            }
            ++n3;
        }
        this.offsetsNeeded = n + 1;
    }

    public Remap getRemap(ColumnMap columnMap) {
        Remap remap = null;
        int n = 0;
        while (n < this.columns.length && remap == null) {
            if (this.columns[n] == columnMap) {
                remap = this.remaps[n];
            }
            ++n;
        }
        return remap;
    }

    public void dump(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(this.offsetsNeeded);
        int n = 0;
        while (n < this.columns.length) {
            stringBuffer.append("|").append(this.columns[n].dumpPhysical(this));
            ++n;
        }
        System.err.println(stringBuffer);
    }

    public static class Remap {
        public int offsetIndex;
        public int fixedIncr;

        Remap(int n, int n2) {
            this.offsetIndex = n;
            this.fixedIncr = n2;
        }
    }
}

