/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnDef;
import com.ibm.disthubmq.impl.formats.EvolvingSchemaMap;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaViolationException;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;

final class EvolvingTupleMap
implements ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("EvolvingTupleMap");
    TupleDef access;
    private TupleDef encoding;
    EvolvingSchemaMap[] map;
    boolean[] deletes;
    int maxAccess;
    int maxEncode;

    EvolvingTupleMap(TupleDef tupleDef, TupleDef tupleDef2, boolean bl, boolean bl2) {
        this.access = tupleDef;
        this.encoding = tupleDef2;
        this.maxAccess = tupleDef.getColumnCount() - 1;
        this.maxEncode = tupleDef2.getColumnCount() - 1;
        if (tupleDef.getNextDef() == null) {
            if (tupleDef2.getNextDef() != null) {
                EvolvingTupleMap.violation(tupleDef.getFullName() + "(not table)", tupleDef2.getFullName() + "(table)");
            }
        } else if (tupleDef2.getNextDef() == null) {
            EvolvingTupleMap.violation(tupleDef.getFullName() + "(table)", tupleDef2.getFullName() + "(not table)");
        }
        int n = this.maxAccess + 1;
        if (this.maxAccess > this.maxEncode) {
            EvolvingTupleMap.checkExtraColumns(tupleDef, this.maxEncode + 1, this.maxAccess + 1);
            n = this.maxEncode + 1;
        } else if (this.maxAccess < this.maxEncode) {
            EvolvingTupleMap.checkExtraColumns(tupleDef2, this.maxAccess + 1, this.maxEncode + 1);
        }
        this.map = new EvolvingSchemaMap[n];
        this.deletes = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            ColumnDef columnDef = tupleDef.getColumnDef(n2);
            ColumnDef columnDef2 = tupleDef2.getColumnDef(n2);
            byte by = columnDef.getTypeCode();
            byte by2 = columnDef2.getTypeCode();
            if (by == 0) {
                if (by2 == 0) {
                    this.map[n2] = EvolvingSchemaMap.canAdapt(columnDef.getSchema(), columnDef2.getSchema(), bl, bl2);
                    if (this.map[n2] == null) {
                        EvolvingTupleMap.violation(columnDef.getFullName(), columnDef2.getFullName());
                    }
                } else if (!EvolvingTupleMap.isDeleteSchema(by2, columnDef.getSchema())) {
                    EvolvingTupleMap.violation(columnDef.getFullName(), columnDef2.getFullName());
                } else {
                    this.deletes[n2] = true;
                }
            } else if (by2 == 0) {
                if (!EvolvingTupleMap.isDeleteSchema(by, columnDef2.getSchema())) {
                    EvolvingTupleMap.violation(columnDef.getFullName(), columnDef2.getFullName());
                } else {
                    this.deletes[n2] = true;
                }
            } else if (by != by2) {
                EvolvingTupleMap.violation(columnDef.getFullName(), columnDef2.getFullName());
            }
            ++n2;
        }
    }

    private static void checkExtraColumns(TupleDef tupleDef, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            ColumnDef columnDef = tupleDef.getColumnDef(n3);
            if (columnDef.getTypeCode() != 0 || !EvolvingSchemaMap.isEmpty(columnDef.getSchema().getTupleDef(0))) {
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1289, new Object[]{columnDef.getFullName()}));
            }
            ++n3;
        }
    }

    private static boolean isDeleteSchema(byte by, Schema schema) {
        boolean bl = false;
        if (schema.getChoiceCount() == 2) {
            TupleDef tupleDef = schema.getTupleDef(0);
            bl = tupleDef.getColumnCount() == 1 && tupleDef.getColumnDef(0).getTypeCode() == by && EvolvingSchemaMap.isEmpty(schema.getTupleDef(1));
        }
        return bl;
    }

    private static void violation(String string, String string2) {
        throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1288, new Object[]{string, string2}));
    }
}

