/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnDef;
import com.ibm.disthubmq.impl.formats.EvolvingSchemaCursor;
import com.ibm.disthubmq.impl.formats.EvolvingSchemaMap;
import com.ibm.disthubmq.impl.formats.EvolvingTupleMap;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaViolationException;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.impl.formats.VacuousTupleCursor;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;

final class EvolvingTupleCursor
implements TupleCursor,
ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("EvolvingTupleCursor");
    private EvolvingTupleMap map;
    private TupleCursor[] tupleCache;
    private TupleCursor encoding;
    private TupleCursor tableCache;

    EvolvingTupleCursor(EvolvingTupleMap evolvingTupleMap, TupleCursor tupleCursor) {
        this.map = evolvingTupleMap;
        this.tupleCache = new TupleCursor[evolvingTupleMap.map.length];
        this.encoding = tupleCursor;
    }

    public TupleDef getTupleDef() {
        return this.map.access;
    }

    public boolean getBoolean(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        boolean bl = tupleCursor != null ? tupleCursor.getBoolean(0) : this.encoding.getBoolean(n);
        return bl;
    }

    public byte getByte(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        byte by = tupleCursor != null ? tupleCursor.getByte(0) : this.encoding.getByte(n);
        return by;
    }

    public short getShort(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        short s = tupleCursor != null ? tupleCursor.getShort(0) : this.encoding.getShort(n);
        return s;
    }

    public char getChar(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        char c = tupleCursor != null ? tupleCursor.getChar(0) : this.encoding.getChar(n);
        return c;
    }

    public int getInt(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        int n2 = tupleCursor != null ? tupleCursor.getInt(0) : this.encoding.getInt(n);
        return n2;
    }

    public long getLong(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        long l = tupleCursor != null ? tupleCursor.getLong(0) : this.encoding.getLong(n);
        return l;
    }

    public float getFloat(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        float f = tupleCursor != null ? tupleCursor.getFloat(0) : this.encoding.getFloat(n);
        return f;
    }

    public double getDouble(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        double d = tupleCursor != null ? tupleCursor.getDouble(0) : this.encoding.getDouble(n);
        return d;
    }

    public String getString(int n) {
        TupleCursor tupleCursor = this.getDeleteCursor(n);
        String string = tupleCursor != null ? tupleCursor.getString(0) : this.encoding.getString(n);
        return string;
    }

    public byte[] getObject(int n) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getObject", new Integer(n));
        }
        byte[] byArray = (tupleCursor = this.getDeleteCursor(n)) != null ? tupleCursor.getObject(0) : this.encoding.getObject(n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getObject", byArray);
        }
        return byArray;
    }

    public byte[] getByteArray(int n) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getByteArray", new Integer(n));
        }
        byte[] byArray = (tupleCursor = this.getDeleteCursor(n)) != null ? tupleCursor.getByteArray(0) : this.encoding.getByteArray(n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getByteArray", byArray);
        }
        return byArray;
    }

    public Object getValue(int n) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getValue", new Integer(n));
        }
        Object object = (tupleCursor = this.getDeleteCursor(n)) != null ? tupleCursor.getValue(0) : this.encoding.getValue(n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getValue", object);
        }
        return object;
    }

    public Schema getSchema(int n) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getSchema", new Integer(n));
        }
        Schema schema = (tupleCursor = this.getDeleteCursor(n)) != null ? tupleCursor.getSchema(0) : this.encoding.getSchema(n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getSchema", schema);
        }
        return schema;
    }

    public void setBoolean(int n, boolean bl) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setBoolean", new Integer(n), new Boolean(bl));
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setBoolean(0, bl);
        } else {
            this.encoding.setBoolean(n, bl);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setBoolean");
        }
    }

    public void setByte(int n, byte by) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setByte", new Integer(n), new Byte(by));
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setByte(0, by);
        } else {
            this.encoding.setByte(n, by);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setByte");
        }
    }

    public void setShort(int n, short s) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setShort", new Integer(n), new Short(s));
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setShort(0, s);
        } else {
            this.encoding.setShort(n, s);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setShort");
        }
    }

    public void setChar(int n, char c) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setChar", new Integer(n), new Character(c));
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setChar(0, c);
        } else {
            this.encoding.setChar(n, c);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setChar");
        }
    }

    public void setInt(int n, int n2) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setInt", new Integer(n), new Integer(n2));
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setInt(0, n2);
        } else {
            this.encoding.setInt(n, n2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setInt");
        }
    }

    public void setLong(int n, long l) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setLong", new Integer(n), new Long(l));
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setLong(0, l);
        } else {
            this.encoding.setLong(n, l);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setLong");
        }
    }

    public void setFloat(int n, float f) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setFloat", new Integer(n), new Float(f));
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setFloat(0, f);
        } else {
            this.encoding.setFloat(n, f);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setFloat");
        }
    }

    public void setDouble(int n, double d) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setDouble", new Integer(n), new Double(d));
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setDouble(0, d);
        } else {
            this.encoding.setDouble(n, d);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setDouble");
        }
    }

    public void setString(int n, String string) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setString", new Integer(n), string);
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setString(0, string);
        } else {
            this.encoding.setString(n, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setString");
        }
    }

    public void setObject(int n, byte[] byArray) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setObject", new Integer(n), byArray);
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setObject(0, byArray);
        } else {
            this.encoding.setObject(n, byArray);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setObject");
        }
    }

    public void setByteArray(int n, byte[] byArray) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setByteArray", new Integer(n), byArray);
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setByteArray(0, byArray);
        } else {
            this.encoding.setByteArray(n, byArray);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setByteArray");
        }
    }

    public void setValue(int n, Object object) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setValue", new Integer(n), object);
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setValue(0, object);
        } else {
            this.encoding.setValue(n, object);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setValue");
        }
    }

    public void setSchema(int n, Schema schema) {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setSchema", new Integer(n), schema);
        }
        if ((tupleCursor = this.setDeleteCursor(n)) != null) {
            tupleCursor.setSchema(0, schema);
        } else {
            this.encoding.setSchema(n, schema);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setSchema");
        }
    }

    public int getChoice(int n) {
        return this.getChoice(n, null);
    }

    public int getChoice(int n, Schema schema) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getChoice", new Integer(n));
        }
        if (n < 0 || n > this.map.maxAccess) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        int n2 = 0;
        if (n <= this.map.maxEncode && !this.map.deletes[n]) {
            EvolvingSchemaMap evolvingSchemaMap = this.map.map[n];
            if (evolvingSchemaMap == null) {
                n2 = this.encoding.getChoice(n, schema);
            } else {
                int n3 = this.encoding.getChoice(n);
                if (n3 >= evolvingSchemaMap.map.length) {
                    if (evolvingSchemaMap.noDefault) {
                        throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1281, null));
                    }
                } else {
                    n2 = n3;
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getChoice", new Integer(n2));
        }
        return n2;
    }

    public TupleCursor getContents(int n) {
        return this.getContents(n, null);
    }

    public TupleCursor getContents(int n, Schema schema) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getContents", new Integer(n));
        }
        if (n < 0 || n > this.map.maxAccess) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        TupleCursor tupleCursor = null;
        if (n > this.map.maxEncode) {
            tupleCursor = EvolvingSchemaCursor.emptyTuple;
        } else if (this.map.deletes[n]) {
            tupleCursor = new OneColumnCursor(n, this.encoding);
        } else {
            EvolvingSchemaMap evolvingSchemaMap = this.map.map[n];
            if (evolvingSchemaMap == null) {
                tupleCursor = this.encoding.getContents(n, schema);
            } else if (this.tupleCache[n] != null) {
                tupleCursor = this.tupleCache[n];
            } else {
                int n2 = this.encoding.getChoice(n);
                if (n2 >= evolvingSchemaMap.map.length) {
                    if (evolvingSchemaMap.noDefault) {
                        throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1281, null));
                    }
                    tupleCursor = EvolvingSchemaCursor.emptyTuple;
                } else {
                    this.tupleCache[n] = new EvolvingTupleCursor(evolvingSchemaMap.map[n2], this.encoding.getContents(n));
                    tupleCursor = this.tupleCache[n];
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getContents", tupleCursor);
        }
        return tupleCursor;
    }

    public TupleCursor setChoice(int n, int n2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setChoice", new Integer(n), new Integer(n2));
        }
        if (n < 0 || n > this.map.maxAccess) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        TupleCursor tupleCursor = null;
        if (n > this.map.maxEncode) {
            tupleCursor = new VacuousTupleCursor(this.map.access.getColumnDef(n).getSchema().getTupleDef(n2));
        } else if (this.map.deletes[n]) {
            if (n2 != 0) {
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1282, new Object[]{this.map.access.getColumnDef(n).getFullName()}));
            }
            tupleCursor = new OneColumnCursor(n, this.encoding);
        } else {
            EvolvingSchemaMap evolvingSchemaMap = this.map.map[n];
            if (evolvingSchemaMap == null) {
                tupleCursor = this.encoding.setChoice(n, n2);
            } else {
                if (n2 >= evolvingSchemaMap.map.length) {
                    if (evolvingSchemaMap.noDefault) {
                        throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1281, null));
                    }
                    this.encoding.setChoice(n, 0);
                    this.tupleCache[n] = new VacuousTupleCursor(evolvingSchemaMap.access.getTupleDef(n2));
                } else {
                    this.tupleCache[n] = new EvolvingTupleCursor(evolvingSchemaMap.map[n2], this.encoding.setChoice(n, n2));
                }
                tupleCursor = this.tupleCache[n];
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setChoice", tupleCursor);
        }
        return tupleCursor;
    }

    public TupleCursor newRow() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "newRow");
        }
        this.tableCache = new EvolvingTupleCursor(this.map, this.encoding.newRow());
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "newRow", this.tableCache);
        }
        return this.tableCache;
    }

    public TupleCursor nextRow() {
        TupleCursor tupleCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "nextRow");
        }
        if (this.tableCache == null && (tupleCursor = this.encoding.nextRow()) != null) {
            this.tableCache = new EvolvingTupleCursor(this.map, tupleCursor);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "nextRow", this.tableCache);
        }
        return this.tableCache;
    }

    public void truncateRows() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "truncateRows");
        }
        this.tableCache = null;
        this.encoding.truncateRows();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "truncateRows");
        }
    }

    private TupleCursor getDeleteCursor(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getDeleteCursor", new Integer(n));
        }
        if (n < 0 || n >= this.map.deletes.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        TupleCursor tupleCursor = null;
        if (this.map.deletes[n]) {
            if (this.encoding.getChoice(n) != 0) {
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1282, new Object[]{this.map.access.getColumnDef(n).getFullName()}));
            }
            tupleCursor = this.encoding.getContents(n);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getDeleteCursor", tupleCursor);
        }
        return tupleCursor;
    }

    private TupleCursor setDeleteCursor(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setDeleteCursor", new Integer(n));
        }
        if (n < 0 || n >= this.map.deletes.length) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
        }
        TupleCursor tupleCursor = null;
        if (this.map.deletes[n]) {
            tupleCursor = this.encoding.setChoice(n, 0);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setDeleteCursor", tupleCursor);
        }
        return tupleCursor;
    }

    private static class OneColumnCursor
    implements TupleCursor {
        private int realCol;
        private TupleCursor encoding;
        private TupleDef def;

        public OneColumnCursor(int n, TupleCursor tupleCursor) {
            this.realCol = n;
            this.encoding = tupleCursor;
            this.def = new TupleDef();
            this.def.add(new ColumnDef(tupleCursor.getTupleDef().getColumnDef(n).getTypeCode()));
        }

        public TupleDef getTupleDef() {
            return this.def;
        }

        public TupleCursor newRow() {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1280, null));
        }

        public TupleCursor nextRow() {
            return null;
        }

        public void truncateRows() {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1280, null));
        }

        public boolean getBoolean(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getBoolean(this.realCol);
        }

        public byte getByte(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getByte(this.realCol);
        }

        public short getShort(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getShort(this.realCol);
        }

        public char getChar(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getChar(this.realCol);
        }

        public int getInt(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getInt(this.realCol);
        }

        public long getLong(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getLong(this.realCol);
        }

        public float getFloat(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getFloat(this.realCol);
        }

        public double getDouble(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getDouble(this.realCol);
        }

        public String getString(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getString(this.realCol);
        }

        public byte[] getObject(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getObject(this.realCol);
        }

        public byte[] getByteArray(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getByteArray(this.realCol);
        }

        public Object getValue(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getValue(this.realCol);
        }

        public Schema getSchema(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getSchema(this.realCol);
        }

        public int getChoice(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getChoice(this.realCol);
        }

        public int getChoice(int n, Schema schema) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getChoice(this.realCol, schema);
        }

        public TupleCursor getContents(int n) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getContents(this.realCol);
        }

        public TupleCursor getContents(int n, Schema schema) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.getContents(this.realCol, schema);
        }

        public void setBoolean(int n, boolean bl) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setBoolean(n, bl);
        }

        public void setByte(int n, byte by) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setByte(n, by);
        }

        public void setShort(int n, short s) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setShort(n, s);
        }

        public void setChar(int n, char c) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setChar(n, c);
        }

        public void setInt(int n, int n2) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setInt(n, n2);
        }

        public void setLong(int n, long l) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setLong(n, l);
        }

        public void setFloat(int n, float f) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setFloat(n, f);
        }

        public void setDouble(int n, double d) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setDouble(n, d);
        }

        public void setString(int n, String string) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setString(n, string);
        }

        public void setObject(int n, byte[] byArray) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setObject(n, byArray);
        }

        public void setByteArray(int n, byte[] byArray) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setByteArray(n, byArray);
        }

        public void setValue(int n, Object object) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setValue(n, object);
        }

        public void setSchema(int n, Schema schema) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            this.encoding.setSchema(n, schema);
        }

        public TupleCursor setChoice(int n, int n2) {
            if (n != 0) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1283, new Object[]{new Integer(n)}));
            }
            return this.encoding.setChoice(n, n2);
        }
    }
}

