/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.EvolvingTupleMap;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaViolationException;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;

public final class EvolvingSchemaMap
implements ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("EvolvingSchemaMap");
    Schema access;
    private Schema encoding;
    boolean noDefault;
    EvolvingTupleMap[] map;

    private EvolvingSchemaMap(Schema schema, Schema schema2, boolean bl, EvolvingTupleMap[] evolvingTupleMapArray) {
        this.access = schema;
        this.encoding = schema2;
        this.noDefault = bl;
        this.map = evolvingTupleMapArray;
    }

    public static EvolvingSchemaMap checkAdapt(Schema schema, Schema schema2, boolean bl, boolean bl2) {
        Assert.condition(bl || bl2);
        EvolvingSchemaMap evolvingSchemaMap = EvolvingSchemaMap.canAdapt(schema, schema2, bl, bl2);
        if (evolvingSchemaMap == null) {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1288, new Object[]{schema.getName(), schema2.getName()}));
        }
        return evolvingSchemaMap;
    }

    static EvolvingSchemaMap canAdapt(Schema schema, Schema schema2, boolean bl, boolean bl2) {
        EvolvingTupleMap[] evolvingTupleMapArray = null;
        if (schema.getChoiceCount() < schema2.getChoiceCount()) {
            if (!bl || EvolvingSchemaMap.isEmpty(schema.getTupleDef(0))) {
                evolvingTupleMapArray = new EvolvingTupleMap[schema.getChoiceCount()];
            }
        } else if (schema.getChoiceCount() > schema2.getChoiceCount()) {
            if (!bl2 || EvolvingSchemaMap.isEmpty(schema2.getTupleDef(0))) {
                evolvingTupleMapArray = new EvolvingTupleMap[schema2.getChoiceCount()];
            }
        } else {
            evolvingTupleMapArray = new EvolvingTupleMap[schema.getChoiceCount()];
        }
        EvolvingSchemaMap evolvingSchemaMap = null;
        if (evolvingTupleMapArray != null) {
            int n = 0;
            while (n < evolvingTupleMapArray.length) {
                evolvingTupleMapArray[n] = new EvolvingTupleMap(schema.getTupleDef(n), schema2.getTupleDef(n), bl, bl2);
                ++n;
            }
            evolvingSchemaMap = new EvolvingSchemaMap(schema, schema2, !EvolvingSchemaMap.isEmpty(schema.getTupleDef(0)), evolvingTupleMapArray);
        }
        return evolvingSchemaMap;
    }

    static boolean isEmpty(TupleDef tupleDef) {
        boolean bl = tupleDef.getColumnCount() == 0 && tupleDef.getNextDef() == null;
        return bl;
    }

    static class Key {
        long accessId;
        long encodingId;

        Key(long l, long l2) {
            this.accessId = l;
            this.encodingId = l2;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.accessId == key.accessId && this.encodingId == key.encodingId;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.accessId ^ this.accessId >> 32 ^ this.encodingId ^ this.encodingId >> 32);
        }
    }
}

